/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityJellyFish
extends MoCEntityTameableAquatic {
    public float pulsingSize;

    public MoCEntityJellyFish(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.5f);
        this.setMoCAge(50 + this.field_70146_Z.nextInt(50));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 20) {
                this.setType(1);
            } else if (typeChance <= 40) {
                this.setType(2);
            } else if (typeChance <= 65) {
                this.setType(3);
            } else if (typeChance <= 80) {
                this.setType(4);
            } else {
                this.setType(5);
            }
        }
    }

    @Override
    public float getMoveSpeed() {
        return 0.1f;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            if (item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw")) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                this.func_70691_i(5.0f);
                return true;
            }
        }
        return super.func_70085_c(entityPlayer);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("jellyfisha.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("jellyfishb.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("jellyfishc.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("jellyfishd.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("jellyfishe.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("jellyfishf.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("jellyfishg.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("jellyfishh.png");
            }
            case 9: {
                return MoCreatures.proxy.getTexture("jellyfishi.png");
            }
            case 10: {
                return MoCreatures.proxy.getTexture("jellyfishj.png");
            }
            case 11: {
                return MoCreatures.proxy.getTexture("jellyfishk.png");
            }
            case 12: {
                return MoCreatures.proxy.getTexture("jellyfishl.png");
            }
        }
        return MoCreatures.proxy.getTexture("jellyfisha.png");
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.pulsingSize += 0.01f;
        }
        if (this.pulsingSize > 0.4f) {
            this.pulsingSize = 0.0f;
        }
        super.func_70636_d();
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 100) {
                this.setAdult(true);
            }
        }
    }

    protected void func_82167_n(Entity entityThatThisEntityHasCollidedWith) {
        if (!(this.field_70170_p.field_73013_u.func_151525_a() <= 0 || entityThatThisEntityHasCollidedWith instanceof MoCEntityJellyFish || entityThatThisEntityHasCollidedWith instanceof MoCEntityShark || entityThatThisEntityHasCollidedWith instanceof MoCEntityRay || entityThatThisEntityHasCollidedWith instanceof EntityPlayer && entityThatThisEntityHasCollidedWith.field_70154_o != null && (entityThatThisEntityHasCollidedWith.field_70154_o instanceof EntityBoat || MoCreatures.isEtFuturumRequiemLoaded && (EntityList.func_75621_b((Entity)entityThatThisEntityHasCollidedWith.field_70154_o).equals("etfuturum.new_boat") || EntityList.func_75621_b((Entity)entityThatThisEntityHasCollidedWith.field_70154_o).equals("etfuturum.chest_boat"))))) {
            int secondsToApplyPoison = this.field_70170_p.field_73013_u.func_151525_a() * 3;
            if (entityThatThisEntityHasCollidedWith instanceof EntityLivingBase) {
                ((EntityLivingBase)entityThatThisEntityHasCollidedWith).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, secondsToApplyPoison * 20, 0));
            }
        }
        super.func_82167_n(entityThatThisEntityHasCollidedWith);
    }

    @Override
    public void moveVerticallyInWater() {
        float yDistanceToSurfaceOfWater = MoCTools.distanceToWaterSurface((Entity)this);
        if (this.field_70181_x < -0.004) {
            this.field_70181_x = -0.004;
        }
        if (yDistanceToSurfaceOfWater > 1.0f && this.pulsingSize == 0.0f) {
            this.field_70181_x += 0.15;
        }
    }

    @Override
    public int pitchRotationOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return 90;
        }
        return 0;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public int nameYOffset() {
        int yOffsetName = (int)((double)(this.getMoCAge() * -1) / 2.3);
        return yOffsetName;
    }

    @Override
    public float getAdjustedZOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.6f;
        }
        return 0.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.3f;
        }
        return 0.4f;
    }

    @Override
    public float getSizeFactor() {
        float pulseSize = 0.0f;
        if (this.func_70055_a(Material.field_151586_h) && (pulseSize = this.pulsingSize) > 0.2f) {
            pulseSize = 0.2f - (pulseSize - 0.2f);
        }
        return (float)this.getMoCAge() * 0.01f + pulseSize / 4.0f;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }

    protected void func_70628_a(boolean hasEntityBeenHitByPlayer, int levelOfLootingEnchantmentUsedToKillThisEntity) {
        if (MoCreatures.proxy.slimyInsectsAndJellyfishDropSlimeballs) {
            int randomAmount = this.field_70146_Z.nextInt(2);
            this.func_145779_a(Items.field_151123_aH, randomAmount);
        }
    }
}

