/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityDolphin
extends MoCEntityTameableAquatic {
    public int gestationTime;
    private boolean hasExecutedOneJump;

    public MoCEntityDolphin(World world) {
        super(world);
        this.func_70105_a(1.5f, 0.8f);
        this.setMoCAge(80 + this.field_70146_Z.nextInt(100));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 35) {
                this.setType(1);
            } else if (typeChance <= 60) {
                this.setType(2);
            } else if (typeChance <= 85) {
                this.setType(3);
            } else if (typeChance <= 96) {
                this.setType(4);
            } else if (typeChance <= 98) {
                this.setType(5);
            } else {
                this.setType(6);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("dolphin.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("dolphin2.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("dolphin3.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("dolphin4.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("dolphin5.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("dolphin6.png");
            }
        }
        return MoCreatures.proxy.getTexture("dolphin.png");
    }

    @Override
    public int getMaxTemper() {
        switch (this.getType()) {
            case 1: {
                return 50;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 250;
            }
            case 6: {
                return 300;
            }
        }
        return 100;
    }

    public int getInitialTemper() {
        switch (this.getType()) {
            case 1: {
                return 50;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 250;
            }
            case 6: {
                return 300;
            }
        }
        return 50;
    }

    @Override
    public double getCustomSpeed() {
        switch (this.getType()) {
            case 1: {
                return 1.2;
            }
            case 2: {
                return 1.4;
            }
            case 3: {
                return 1.8;
            }
            case 4: {
                return 2.0;
            }
            case 5: {
                return 2.2;
            }
            case 6: {
                return 2.4;
            }
        }
        return 1.2;
    }

    public double getCustomDolphinJump() {
        switch (this.getType()) {
            case 1: {
                return 1.0;
            }
            case 2: {
                return 1.1;
            }
            case 3: {
                return 1.2;
            }
            case 4: {
                return 1.3;
            }
            case 5: {
                return 1.4;
            }
            case 6: {
                return 1.5;
            }
        }
        return 1.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public boolean getIsHungry() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getHasEaten() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setIsHungry(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setHasEaten(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        float sizeFactor = (float)this.getMoCAge() * 0.01f;
        double distance = (double)sizeFactor / 4.0;
        double xAdjustment = Math.cos(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        double zAdjustment = Math.sin(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        double newPosX = this.field_70165_t - distance * xAdjustment;
        double newPosZ = this.field_70161_v - distance * zAdjustment;
        double newPosY = this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W();
        if (this.getRotationAmount() != 0.0f) {
            float rotationAdjustmentFactor = Math.abs(this.getRotationAmount()) / 24.0f;
            newPosX += (double)(rotationAdjustmentFactor * Math.signum(this.getRotationAmount())) * (distance * Math.cos((double)this.getRotationAmount() * Math.PI / 180.0) * xAdjustment);
            newPosZ += (double)(rotationAdjustmentFactor * Math.signum(this.getRotationAmount())) * (distance * Math.cos((double)this.getRotationAmount() * Math.PI / 180.0) * zAdjustment);
            newPosY += (double)rotationAdjustmentFactor * (this.func_70042_X() * Math.sin((double)this.getRotationAmount() * Math.PI / 180.0));
        }
        this.field_70153_n.func_70107_b(newPosX, newPosY, newPosZ);
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 3.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e && this.getMoCAge() >= 100) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken) && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70067_L() {
        return this.field_70153_n == null;
    }

    protected Entity func_70782_k() {
        EntityLivingBase entityLiving;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getMoCAge() >= 100 && MoCreatures.proxy.attackDolphins && this.field_70146_Z.nextInt(50) == 0 && (entityLiving = this.FindTarget((Entity)this, 12.0)) != null && entityLiving.func_70090_H()) {
            return entityLiving;
        }
        return null;
    }

    public EntityLivingBase FindTarget(Entity entity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityLivingBase entityLiving = null;
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityShark) || entityNearby instanceof MoCEntityShark && ((MoCEntityShark)entityNearby).getIsTamed()) continue;
                double overallDistanceSquared = entityNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance) || !((EntityLivingBase)entityNearby).func_70685_l(entity)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityLiving = (EntityLivingBase)entityNearby;
            }
        }
        return entityLiving;
    }

    private int genetics(MoCEntityDolphin entityDolphinParent1, MoCEntityDolphin entityDolphinParent2) {
        boolean isHigherTierDolphinGranted;
        if (entityDolphinParent1.getType() == entityDolphinParent2.getType()) {
            return entityDolphinParent1.getType();
        }
        int typeToSet = entityDolphinParent1.getType() + entityDolphinParent2.getType();
        boolean isLowerTierDolphinGranted = this.field_70146_Z.nextInt(3) == 0;
        boolean bl = isHigherTierDolphinGranted = this.field_70146_Z.nextInt(10) == 0;
        if (typeToSet < 5 && isLowerTierDolphinGranted) {
            return typeToSet;
        }
        if ((typeToSet == 5 || typeToSet == 6) && isHigherTierDolphinGranted) {
            return typeToSet;
        }
        return 0;
    }

    @Override
    protected String func_70673_aS() {
        return "mocreatures:dolphindying";
    }

    protected Item func_146068_u() {
        return Items.field_151115_aP;
    }

    @Override
    protected String func_70621_aR() {
        return "mocreatures:dolphinhurt";
    }

    @Override
    protected String func_70639_aQ() {
        return "mocreatures:dolphin";
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    protected String getUpsetSound() {
        return "mocreatures:dolphinupset";
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && this.isMyHealFood(itemStack)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (MoCreatures.isServer()) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 1);
                }
                this.func_70691_i(5.0f);
                if (!this.getIsAdult()) {
                    this.setMoCAge(this.getMoCAge() + 1);
                }
            }
            this.func_85030_a("mocreatures:eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            return true;
        }
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151101_aQ && this.getIsTamed() && this.getIsAdult()) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.func_70691_i(5.0f);
            this.setHasEaten(true);
            this.func_85030_a("mocreatures:eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            return true;
        }
        if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.field_70153_n == null && this.getIsAdult()) {
            entityPlayer.field_70177_z = this.field_70177_z;
            entityPlayer.field_70125_A = this.field_70125_A;
            entityPlayer.field_70163_u = this.field_70163_u;
            if (!this.field_70170_p.field_72995_K) {
                entityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70153_n != null && !this.field_70122_E && MoCTools.distanceToWaterSurface((Entity)this) == 1.0f && this.field_70181_x > 0.0 && Math.abs(this.field_70181_x) < this.getCustomDolphinJump() && MoCreatures.isServer()) {
            this.setIsJumping(true);
            this.field_70181_x = this.getCustomDolphinJump();
            this.jumpPending = false;
            this.hasExecutedOneJump = true;
        }
        if (this.hasExecutedOneJump && MoCTools.distanceToWaterSurface((Entity)this) == 1.0f && this.field_70181_x < 0.0) {
            this.func_85030_a("game.neutral.swim.splash", 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            if (MoCreatures.isServer() && this.getIsJumping()) {
                this.field_70181_x = -3.0;
            }
            this.hasExecutedOneJump = false;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(50) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 150) {
                    this.setAdult(true);
                }
            }
            if (!this.getIsHungry() && this.field_70146_Z.nextInt(100) == 0) {
                this.setIsHungry(true);
            }
            if (!this.isReadyforParenting(this)) {
                return;
            }
            int amountOfOtherDolphinsNearby = 0;
            List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(8.0, 2.0, 8.0));
            for (int index = 0; index < entitiesNearbyList.size(); ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityDolphin)) continue;
                ++amountOfOtherDolphinsNearby;
            }
            if (amountOfOtherDolphinsNearby > 1) {
                return;
            }
            List entitiesNearbyList1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.0, 2.0, 4.0));
            for (int index1 = 0; index1 < entitiesNearbyList1.size(); ++index1) {
                Entity entityNearby1 = (Entity)entitiesNearbyList1.get(index1);
                if (!(entityNearby1 instanceof MoCEntityDolphin) || entityNearby1 == this) continue;
                MoCEntityDolphin entityDolphinNearby = (MoCEntityDolphin)entityNearby1;
                if (!this.isReadyforParenting(this) || !this.isReadyforParenting(entityDolphinNearby)) continue;
                if (this.field_70146_Z.nextInt(100) == 0) {
                    ++this.gestationTime;
                }
                if (this.gestationTime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHeart(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.gestationTime <= 50) continue;
                MoCEntityDolphin babyDolphin = new MoCEntityDolphin(this.field_70170_p);
                babyDolphin.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (!this.field_70170_p.func_72838_d((Entity)babyDolphin)) continue;
                this.setHasEaten(false);
                entityDolphinNearby.setHasEaten(false);
                this.gestationTime = 0;
                entityDolphinNearby.gestationTime = 0;
                int typeToSet = this.genetics(this, entityDolphinNearby);
                babyDolphin.setMoCAge(35);
                babyDolphin.setAdult(false);
                babyDolphin.setOwner(this.getOwnerName());
                babyDolphin.setTamed(true);
                EntityPlayer entityPlayer = this.field_70170_p.func_72924_a(this.getOwnerName());
                if (entityPlayer != null) {
                    MoCTools.tameWithName(entityPlayer, babyDolphin);
                }
                babyDolphin.setTypeInt(typeToSet);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
                break;
            }
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }

    public boolean isReadyforParenting(MoCEntityDolphin entityDolphin) {
        return entityDolphin.field_70153_n == null && entityDolphin.field_70154_o == null && entityDolphin.getIsTamed() && entityDolphin.getHasEaten() && entityDolphin.getIsAdult();
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setDisplayName(nbtTagCompound.func_74767_n("DisplayName"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("DisplayName", this.getShouldDisplayName());
    }

    public int func_70641_bl() {
        return 1;
    }

    public float getRotationAmount() {
        float rotationAmount = 0.0f;
        Block blockUnderneath = this.field_70170_p.func_147439_a(Math.round((float)this.field_70165_t), Math.round((float)this.field_70163_u - 1.0f), Math.round((float)this.field_70161_v));
        if (blockUnderneath == Blocks.field_150355_j || blockUnderneath == Blocks.field_150350_a || blockUnderneath == Blocks.field_150358_i) {
            int maxUpwardRotationAmountInDegrees = 20;
            rotationAmount = this.func_70055_a(Material.field_151579_a) && this.field_70181_x > -0.2 ? 20.0f : (float)this.field_70181_x * 90.0f;
            int maxOverallRotationAmountInDegrees = 60;
            if (Math.signum(rotationAmount) > 0.0f && rotationAmount > 20.0f) {
                rotationAmount = 20.0f;
            }
            if (Math.abs(rotationAmount) > 60.0f) {
                rotationAmount = 60.0f * Math.signum(rotationAmount);
            }
        }
        return rotationAmount;
    }
}

