/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBird;
import drzhark.mocreatures.entity.animal.MoCEntityMouse;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;

public class MoCEntitySnake
extends MoCEntityTameableAnimal {
    private float tongueState;
    private float mouthState;
    private boolean isBiting;
    private int rattleState;
    private boolean isPissed;
    private int hissCounter;
    private int moveInt;
    private boolean isNearPlayer;
    public float bodyswing;
    public static final String[] snakeNames = new String[]{"Dark", "Spotted", "Orange", "Green", "Coral", "Cobra", "Rattle", "Python"};

    public MoCEntitySnake(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.5f);
        this.bodyswing = 2.0f;
        this.moveInt = this.field_70146_Z.nextInt(10);
        this.setMoCAge(50 + this.field_70146_Z.nextInt(50));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(8) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("snake1.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("snake2.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("snake3.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("snake4.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("snake5.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("snake6.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("snake7.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("snake8.png");
            }
        }
        return MoCreatures.proxy.getTexture("snake1.png");
    }

    @Override
    public float getMoveSpeed() {
        return 0.6f;
    }

    protected void func_70069_a(float f) {
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    protected void func_70664_aZ() {
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    public boolean pickedUp() {
        return this.field_70154_o != null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (entityPlayer.field_70153_n != null && entityPlayer.field_70153_n instanceof MoCEntityMouse) {
            entityPlayer.field_70153_n.func_70106_y();
            MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
            this.func_70691_i(5.0f);
            entityPlayer.func_71064_a((StatBase)MoCAchievements.feed_snake_with_live_mouse, 1);
            return false;
        }
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        if (!this.getIsTamed()) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack == null) {
            this.field_70177_z = entityPlayer.field_70177_z;
            if (this.field_70154_o == null) {
                if (MoCreatures.isServer() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && entityPlayer.field_70154_o == null) {
                    this.func_70078_a((Entity)entityPlayer);
                }
            } else {
                if (MoCreatures.isServer()) {
                    this.func_70078_a(null);
                }
                this.field_70143_R = -3.0f;
            }
            this.field_70159_w = entityPlayer.field_70159_w * 5.0;
            this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.5;
            this.field_70179_y = entityPlayer.field_70179_y * 5.0;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return this.getType() > 2 && this.getMoCAge() > 50 || this.getType() == 7;
    }

    public boolean isClimbing() {
        return this.func_70617_f_() && this.field_70181_x > (double)0.01f;
    }

    public boolean isResting() {
        return !this.getNearPlayer() && this.field_70122_E && this.field_70159_w < 0.01 && this.field_70159_w > -0.01 && this.field_70179_y < 0.01 && this.field_70179_y > -0.01;
    }

    public boolean getNearPlayer() {
        return this.isNearPlayer;
    }

    public int getMoveInt() {
        return this.moveInt;
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    public void setNearPlayer(boolean flag) {
        this.isNearPlayer = flag;
        if (!flag) {
            this.rattleState = 0;
        }
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - 1.5f;
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M + 0.1f;
        }
        return this.field_70129_M;
    }

    public float getSizeF() {
        float factor = 1.0f;
        if (this.getType() == 1 || this.getType() == 2) {
            factor = 0.8f;
        } else if (this.getType() == 5) {
            factor = 0.6f;
        }
        if (this.getType() == 6) {
            factor = 1.1f;
        }
        if (this.getType() == 7) {
            factor = 0.9f;
        }
        if (this.getType() == 8) {
            factor = 1.5f;
        }
        return (float)this.getMoCAge() * 0.01f * factor;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getMoCAge() < 100 && this.field_70146_Z.nextInt(500) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
        }
        if (this.pickedUp()) {
            this.moveInt = 0;
        }
        if (this.isResting()) {
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            this.field_70760_ar = this.field_70177_z;
        }
        if (!this.field_70122_E && this.field_70154_o != null) {
            this.field_70177_z = this.field_70154_o.field_70177_z;
        }
        if (this.getTongueState() != 0.0f) {
            this.setTongueState(this.getTongueState() + 0.2f);
            if (this.getTongueState() > 8.0f) {
                this.setTongueState(0.0f);
            }
        }
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getNearPlayer() && !this.getIsTamed() && this.isNotScared()) {
            ++this.hissCounter;
            if (this.hissCounter % 25 == 0) {
                this.setMouthState(0.3f);
                this.func_85030_a("mocreatures:snakeupset", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (this.hissCounter % 35 == 0) {
                this.setMouthState(0.0f);
            }
            if (this.hissCounter > 100 && this.field_70146_Z.nextInt(50) == 0) {
                this.setPissed(true);
                this.hissCounter = 0;
            }
        }
        if (this.hissCounter > 500) {
            this.hissCounter = 0;
        }
        if (this.getMouthState() != 0.0f && this.hissCounter == 0) {
            this.setMouthState(this.getMouthState() + 0.1f);
            if (this.getMouthState() > 0.5f) {
                this.setMouthState(0.0f);
            }
        }
        if (this.getType() == 7 && this.getRattleState() != 0.0f && !this.getIsTamed()) {
            ++this.rattleState;
            this.setPissed(true);
            if (this.rattleState % 20 == 0) {
                this.func_85030_a("mocreatures:snakerattle", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (this.getRattleState() > 40.0f) {
                this.setRattleState(0);
            }
        }
    }

    public float getTongueState() {
        return this.tongueState;
    }

    public void setTongueState(float toungeStateToSet) {
        this.tongueState = toungeStateToSet;
    }

    public float getMouthState() {
        return this.mouthState;
    }

    public void setMouthState(float mouthStateToSet) {
        this.mouthState = mouthStateToSet;
    }

    public float getRattleState() {
        return this.rattleState;
    }

    public void setRattleState(int rattleStateToSet) {
        this.rattleState = rattleStateToSet;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer entityPlayer1;
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(50) == 0 && this.getTongueState() == 0.0f) {
            this.setTongueState(0.1f);
        }
        if (this.field_70146_Z.nextInt(100) == 0 && this.getMouthState() == 0.0f) {
            this.setMouthState(0.1f);
        }
        if (this.getType() == 7) {
            int chance = 0;
            chance = this.getNearPlayer() ? 30 : 100;
            if (this.field_70146_Z.nextInt(chance) == 0) {
                this.setRattleState(1);
            }
        }
        if (!this.isResting() && !this.pickedUp() && this.field_70146_Z.nextInt(50) == 0) {
            this.moveInt = this.field_70146_Z.nextInt(10);
        }
        if (this.isBiting()) {
            this.bodyswing -= 0.5f;
            this.setMouthState(0.3f);
            if (this.bodyswing < 0.0f) {
                this.func_85030_a("mocreatures:snakesnap", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                this.bodyswing = 2.5f;
                this.setMouthState(0.0f);
                this.setBiting(false);
            }
        }
        if (this.field_70789_a != null && this.field_70146_Z.nextInt(100) == 0) {
            this.field_70789_a = null;
        }
        if ((entityPlayer1 = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null) {
            double playerDistanceToSnake = MoCTools.getSqDistanceTo((Entity)entityPlayer1, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.isNotScared()) {
                if (this.getType() == 7 && playerDistanceToSnake <= 8.0) {
                    this.setNearPlayer(true);
                    this.func_70625_a((Entity)entityPlayer1, 8.0f, 8.0f);
                } else if (this.getType() != 7 && playerDistanceToSnake <= 5.0) {
                    this.setNearPlayer(true);
                } else {
                    this.setNearPlayer(false);
                }
                if (entityPlayer1.field_70153_n != null && (entityPlayer1.field_70153_n instanceof MoCEntityMouse || entityPlayer1.field_70153_n instanceof MoCEntityBird)) {
                    PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)entityPlayer1, 16.0f, true, false, false, true);
                    this.func_70778_a(pathEntity);
                    this.setPissed(false);
                    this.hissCounter = 0;
                }
            } else {
                this.setNearPlayer(false);
                if (playerDistanceToSnake < 2.0 && !this.getIsTamed() && this.getType() != 7) {
                    this.field_70788_c = 40;
                }
            }
        } else {
            this.setNearPlayer(false);
        }
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if ((this.getType() < 3 || this.getIsTamed()) && entity instanceof EntityPlayer) {
            this.field_70789_a = null;
            return;
        }
        if (!this.isPissed() && !this.getIsTamed()) {
            return;
        }
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.setBiting(true);
            this.field_70724_aR = 20;
            if (this.field_70146_Z.nextInt(2) == 0 && entity instanceof EntityPlayer && this.getType() > 2 && this.getType() < 8) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 0));
            }
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
    }

    @Override
    public void performAnimation(int i) {
        this.setBiting(true);
    }

    public boolean isBiting() {
        return this.isBiting;
    }

    public void setBiting(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isBiting = flag;
    }

    public boolean isPissed() {
        return this.isPissed;
    }

    public void setPissed(boolean isPissed) {
        this.isPissed = isPissed;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer()) {
            if (this.field_70154_o != null && (damageSource.func_76346_g() == this.field_70154_o || DamageSource.field_76368_d.equals(damageSource))) {
                return false;
            }
            if (this.isThisADesertSnake() && damageSource.field_76373_n == "cactus") {
                return false;
            }
            if (this.getType() < 3) {
                return super.func_70097_a(damageSource, damageTaken);
            }
            if (super.func_70097_a(damageSource, damageTaken)) {
                Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
                if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                    return false;
                }
                if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                    return true;
                }
                if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                    this.setPissed(true);
                    this.field_70789_a = entityThatAttackedThisCreature;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 4.0);
            if (!this.getIsTamed() && entityPlayer != null && this.isNotScared() && this.isPissed()) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 8.0);
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && this.field_70154_o == null && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    protected void func_70628_a(boolean flag, int x) {
        if (this.getMoCAge() > 60) {
            int j = this.field_70146_Z.nextInt(3);
            for (int l = 0; l < j; ++l) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, this.getType() + 20), 0.0f);
            }
        }
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntitySnake || (double)entity.field_70131_O > 0.5 && (double)entity.field_70130_N > 0.5;
    }

    protected String func_70673_aS() {
        return "mocreatures:snakedying";
    }

    protected String func_70621_aR() {
        return "mocreatures:snakehurt";
    }

    protected String func_70639_aQ() {
        return "mocreatures:snakehiss";
    }

    @Override
    public boolean func_70601_bi() {
        return this.checkSpawningBiome() && this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving();
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        int typeChance = this.field_70146_Z.nextInt(10);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            if (typeChance < 5) {
                this.setType(7);
            } else {
                this.setType(2);
            }
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            if (typeChance < 4) {
                this.setType(4);
            } else {
                this.setType(1);
            }
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            if (typeChance < 4) {
                this.setType(3);
            } else if (typeChance < 7) {
                this.setType(4);
            } else {
                this.setType(6);
            }
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            if (typeChance < 4) {
                this.setType(8);
            } else if (typeChance < 8) {
                this.setType(2);
            } else {
                this.setType(1);
            }
        }
        return true;
    }

    private boolean isThisADesertSnake() {
        return this.getType() == 7 || this.getType() == 2;
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public int nameYOffset() {
        return -20;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        return itemStack != null && (itemStack.func_77973_b() == MoCreatures.ratRaw || MoCreatures.isGregTech6Loaded && OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)) == "foodScrapmeat");
    }

    public int func_70641_bl() {
        return 2;
    }
}

