/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.monster.MoCEntityScorpion;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MoCEntityPetScorpion
extends MoCEntityTameableAnimal {
    public static final String[] scorpionNames = new String[]{"Dirt", "Cave", "Nether", "Frost", "Undead"};
    private boolean isPoisoning;
    private int poisontimer;
    public int mouthCounter;
    public int armCounter;

    public MoCEntityPetScorpion(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.poisontimer = 0;
        this.setAdult(false);
        this.setMoCAge(20);
        this.roper = null;
        this.setHasBabies(false);
        this.field_70138_W = 20.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        boolean hasSaddle = this.getIsRideable();
        switch (this.getType()) {
            case 1: {
                if (!hasSaddle) {
                    return MoCreatures.proxy.getTexture("scorpiondirt.png");
                }
                return MoCreatures.proxy.getTexture("scorpiondirtsaddle.png");
            }
            case 2: {
                if (!hasSaddle) {
                    return MoCreatures.proxy.getTexture("scorpioncave.png");
                }
                return MoCreatures.proxy.getTexture("scorpioncavesaddle.png");
            }
            case 3: {
                if (!hasSaddle) {
                    return MoCreatures.proxy.getTexture("scorpionnether.png");
                }
                return MoCreatures.proxy.getTexture("scorpionnethersaddle.png");
            }
            case 4: {
                if (!hasSaddle) {
                    return MoCreatures.proxy.getTexture("scorpionfrost.png");
                }
                return MoCreatures.proxy.getTexture("scorpionfrostsaddle.png");
            }
            case 5: {
                if (!hasSaddle) {
                    return MoCreatures.proxy.getTexture("scorpionundead.png");
                }
                return MoCreatures.proxy.getTexture("scorpionundeadsaddle.png");
            }
        }
        return MoCreatures.proxy.getTexture("scorpiondirt.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    @Override
    public boolean getIsRideable() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getHasBabies() {
        return this.getIsAdult() && this.field_70180_af.func_75683_a(23) == 1;
    }

    public boolean getIsPicked() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    @Override
    public void setRideable(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setHasBabies(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void setPicked(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    public void setPoisoning(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        }
    }

    @Override
    public float getMoveSpeed() {
        return 0.8f;
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean climbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    @Override
    public void func_70636_d() {
        if (this.getType() == 3 && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
        this.tryToSetEffectOnMobThatTheOwnerAttacked();
        if (!(this.field_70789_a == null || this.field_70789_a != this.field_70153_n || this.field_70153_n instanceof EntityPlayer && this.field_70153_n.func_70005_c_().equals(this.getOwnerName()))) {
            this.field_70153_n.func_70078_a(null);
        }
        if (!this.field_70122_E && this.field_70154_o != null) {
            this.field_70177_z = this.field_70154_o.field_70177_z;
        }
        if (this.getIsAdult() && this.field_70788_c > 0) {
            this.field_70788_c = 0;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (MoCreatures.isServer() && (this.armCounter == 10 || this.armCounter == 40)) {
            this.func_85030_a("mocreatures:scorpionclaw", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                this.func_85030_a("mocreatures:scorpionsting", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 120) {
                this.setAdult(true);
            }
        }
        if (this.field_70154_o instanceof EntityPlayer && MoCreatures.proxy.emptyHandMountAndPickUpOnly && ((EntityPlayer)this.field_70154_o).func_70694_bm() != null) {
            this.func_70078_a(null);
            this.field_70143_R = -3.0f;
            this.setPicked(false);
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer()) {
            Entity entityThatAttackedThisCreature;
            if (this.field_70154_o != null && (damageSource.func_76346_g() == this.field_70154_o || DamageSource.field_76368_d.equals(damageSource))) {
                return false;
            }
            if (super.func_70097_a(damageSource, damageTaken) && (entityThatAttackedThisCreature = damageSource.func_76346_g()) != null) {
                if (this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                    return false;
                }
                if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getIsAdult()) {
                    this.field_70789_a = entityThatAttackedThisCreature;
                }
                return true;
            }
        }
        return true;
    }

    private void tryToSetEffectOnMobThatTheOwnerAttacked() {
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.getIsTamed() && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && this.field_70153_n == ownerOfEntityThatIsOnline && ownerOfEntityThatIsOnline.field_82175_bq && !this.getIsPoisoning() && ownerOfEntityThatIsOnline.func_110144_aD() != null && !ownerOfEntityThatIsOnline.func_110144_aD().field_70128_L && this.field_70146_Z.nextInt(100) < 30) {
            EntityLivingBase entityToAttack = ownerOfEntityThatIsOnline.func_110144_aD();
            double distanceToTargetEntity = MoCTools.getSqDistanceTo((Entity)this, entityToAttack.field_70165_t, entityToAttack.field_70163_u, entityToAttack.field_70161_v);
            if (distanceToTargetEntity < 5.0) {
                this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ownerOfEntityThatIsOnline), 3.0f);
            }
        }
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && !this.field_70170_p.func_72935_r() && this.getIsAdult()) {
            if (!this.getIsTamed()) {
                EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 12.0);
                if (entityPlayer != null && this.getIsAdult()) {
                    return entityPlayer;
                }
            } else if (this.field_70146_Z.nextInt(80) == 0) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 10.0);
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && this.field_70153_n == null && this.field_70154_o == null && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || this.getIsTamed() && entity instanceof MoCEntityScorpion && ((MoCEntityScorpion)entity).getIsTamed();
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(50) == 0) {
            if (this.field_70122_E) {
                double xDistance = entity.field_70165_t - this.field_70165_t;
                double zDistance = entity.field_70161_v - this.field_70161_v;
                float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
                this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70159_w * 0.2;
                this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70179_y * 0.2;
                this.field_70181_x = 0.4;
            }
        } else if (this.field_70724_aR <= 0 && (double)distanceToEntity < 3.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0) {
                this.stingAndApplyEffectOnEntity(entity);
            } else {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                this.swingArm();
            }
        }
    }

    private void stingAndApplyEffectOnEntity(Entity entity) {
        int potionTime = 70;
        this.setPoisoning(true);
        if (this.getType() <= 1) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, potionTime, 0));
        } else if (this.getType() == 2) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, potionTime, 0));
        } else if (this.getType() == 4) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, potionTime, 0));
        } else if (this.getType() == 3 && entity instanceof EntityPlayer && MoCreatures.isServer() && !this.field_70170_p.field_73011_w.field_76575_d) {
            ((EntityLivingBase)entity).func_70015_d(15);
        }
    }

    public void swingArm() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (MoCreatures.isServer() && this.getIsAdult() && this.getHasBabies()) {
            int amountOfBabyScorpionsToSpawn = this.field_70146_Z.nextInt(5);
            for (int index = 0; index < amountOfBabyScorpionsToSpawn; ++index) {
                MoCEntityScorpion entityPetScorpion = new MoCEntityScorpion(this.field_70170_p);
                entityPetScorpion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entityPetScorpion.setAdult(false);
                entityPetScorpion.setType(this.getType());
                entityPetScorpion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
                this.field_70170_p.func_72838_d((Entity)entityPetScorpion);
                this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected String func_70673_aS() {
        return "mocreatures:scorpiondying";
    }

    protected String func_70621_aR() {
        return "mocreatures:scorpionhurt";
    }

    protected String func_70639_aQ() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return "mocreatures:scorpiongrunt";
    }

    protected Item func_146068_u() {
        if (!this.getIsAdult()) {
            return null;
        }
        boolean flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        switch (this.getType()) {
            case 1: {
                if (flag) {
                    return MoCreatures.scorpStingDirt;
                }
                return MoCreatures.chitin;
            }
            case 2: {
                if (flag) {
                    return MoCreatures.scorpStingCave;
                }
                return MoCreatures.chitinCave;
            }
            case 3: {
                if (flag) {
                    return MoCreatures.scorpStingNether;
                }
                return MoCreatures.chitinNether;
            }
            case 4: {
                if (flag) {
                    return MoCreatures.scorpStingFrost;
                }
                return MoCreatures.chitinFrost;
            }
            case 5: {
                return Items.field_151078_bh;
            }
        }
        return null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && this.getIsAdult() && !this.getIsRideable() && itemStack.func_77973_b() == MoCreatures.craftedSaddle) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.setRideable(true);
            return true;
        }
        if (itemStack != null && this.getIsTamed() && itemStack.func_77973_b() == MoCreatures.essenceUndead) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.setType(5);
            return true;
        }
        if (itemStack != null && this.getIsTamed() && itemStack.func_77973_b() == MoCreatures.essenceDarkness) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.func_70606_j(this.func_110138_aP());
            if (MoCreatures.isServer() && this.getIsAdult()) {
                int eggType = this.getType() + 40;
                MoCEntityEgg entityEgg = new MoCEntityEgg(this.field_70170_p, eggType);
                entityEgg.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
                entityPlayer.field_70170_p.func_72838_d((Entity)entityEgg);
                entityEgg.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                entityEgg.field_70159_w += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
                entityEgg.field_70179_y += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
            }
            return true;
        }
        if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.field_70154_o == null && this.getMoCAge() < 60) {
            this.field_70177_z = entityPlayer.field_70177_z;
            if (MoCreatures.isServer() && entityPlayer.field_70154_o == null) {
                this.func_70078_a((Entity)entityPlayer);
                this.setPicked(true);
            }
            if (MoCreatures.isServer() && !this.getIsTamed()) {
                MoCTools.tameWithName(entityPlayer, this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_scorpion, 1);
            }
        } else if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && this.field_70154_o != null && this.getIsPicked()) {
            this.setPicked(false);
            if (MoCreatures.isServer()) {
                this.func_70078_a(null);
            }
            this.field_70143_R = -3.0f;
            this.field_70159_w = entityPlayer.field_70159_w * 5.0;
            this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.5;
            this.field_70179_y = entityPlayer.field_70179_y * 5.0;
        }
        if (itemStack == null && this.getIsRideable() && this.getIsTamed() && this.getIsAdult() && this.field_70153_n == null) {
            entityPlayer.field_70177_z = this.field_70177_z;
            entityPlayer.field_70125_A = this.field_70125_A;
            this.func_70019_c(false);
            if (MoCreatures.isServer()) {
                entityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - 1.7f;
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M - 0.1f;
        }
        return this.field_70129_M;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setHasBabies(nbtTagCompound.func_74767_n("Babies"));
        this.setRideable(nbtTagCompound.func_74767_n("Saddled"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Babies", this.getHasBabies());
        nbtTagCompound.func_74757_a("Saddled", this.getIsRideable());
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public int nameYOffset() {
        int yOffsetName = (int)(1.0 - (double)this.getMoCAge() * 0.8);
        if (yOffsetName < -70) {
            yOffsetName = -70;
        }
        return yOffsetName;
    }

    @Override
    public double roperYOffset() {
        double yOffsetRoper = (double)(150 - this.getMoCAge()) * 0.012;
        if (yOffsetRoper < 0.55) {
            yOffsetRoper = 0.55;
        }
        if (yOffsetRoper > 1.2) {
            yOffsetRoper = 1.2;
        }
        return yOffsetRoper;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_151078_bh || itemStack.func_77973_b() == MoCreatures.ratRaw || itemStack.func_77973_b() == MoCreatures.ratCooked || MoCreatures.isGregTech6Loaded && OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)) == "foodScrapmeat";
    }

    public int func_70627_aG() {
        return 300;
    }

    protected void func_70069_a(float f) {
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null && this.field_70154_o == null;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    protected boolean func_70780_i() {
        return this.field_70153_n != null;
    }

    @Override
    public void dropMyStuff() {
        MoCTools.dropSaddle(this, this.field_70170_p);
    }

    public boolean isUndead() {
        return this.getType() == 5;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }
}

