/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityOstrich
extends MoCEntityTameableAnimal {
    private int eggCounter;
    private int hidingCounter;
    public int mouthCounter;
    public int wingCounter;
    public int sprintCounter;
    public int jumpCounter;
    public int transformCounter;
    public int transformType;
    public boolean canLayEggs;
    public MoCAnimalChest localChest;
    public ItemStack localItemstack;

    public MoCEntityOstrich(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.6f);
        this.setMoCAge(35);
        this.roper = null;
        this.eggCounter = this.field_70146_Z.nextInt(1000) + 1000;
        this.field_70138_W = 1.0f;
        this.canLayEggs = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    @Override
    public void selectType() {
        if (this.checkSpawningBiome() && this.getType() == 0) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 20) {
                this.setType(1);
            } else if (typeChance <= 65) {
                this.setType(2);
            } else if (typeChance <= 95) {
                this.setType(3);
            } else {
                this.setType(4);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        this.field_70146_Z.nextInt(100);
        return !BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || !currentBiome.field_76791_y.toLowerCase().contains("outback");
    }

    @Override
    public boolean getIsRideable() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    @Override
    public void setRideable(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean getEggWatching() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setEggWatching(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public boolean getHiding() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setHiding(boolean flag) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    public byte getHelmet() {
        return this.field_70180_af.func_75683_a(25);
    }

    public void setHelmet(byte b) {
        this.field_70180_af.func_75692_b(25, (Object)b);
    }

    public byte getFlagColor() {
        return this.field_70180_af.func_75683_a(26);
    }

    public void setFlagColor(byte b) {
        this.field_70180_af.func_75692_b(26, (Object)b);
    }

    public boolean getIsChested() {
        return this.field_70180_af.func_75683_a(27) == 1;
    }

    public void setIsChested(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(27, (Object)input);
    }

    protected boolean func_70780_i() {
        return this.getHiding() || this.field_70153_n != null;
    }

    @Override
    public boolean isNotScared() {
        return this.getType() == 2 && this.field_70789_a != null || this.getType() > 2;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        int damageReduction;
        if (this.getIsTamed() && this.getHelmet() != 0 && (damageTaken -= (float)(damageReduction = this.getDamageReductionFromHelmetWornByOstrich())) <= 0.0f) {
            damageTaken = 1.0f;
        }
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n != null && entityThatAttackedThisCreature == this.field_70153_n) {
                return false;
            }
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getType() > 2) {
                this.field_70789_a = entityThatAttackedThisCreature;
                this.flapWings();
            }
            return true;
        }
        return false;
    }

    private int getDamageReductionFromHelmetWornByOstrich() {
        switch (this.getHelmet()) {
            case 1: 
            case 5: 
            case 6: {
                return 1;
            }
            case 2: 
            case 7: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.dropMyStuff();
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && distanceToEntity < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.openMouth();
            this.flapWings();
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
        }
    }

    public float calculateMaxHealth() {
        switch (this.getType()) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 20.0f;
            }
            case 4: {
                return 20.0f;
            }
            case 5: {
                return 20.0f;
            }
        }
        return 20.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.transformCounter != 0 && this.transformType > 4) {
            String newTexture = "ostricha.png";
            if (this.transformType == 5) {
                newTexture = "ostriche.png";
            }
            if (this.transformType == 6) {
                newTexture = "ostrichf.png";
            }
            if (this.transformType == 7) {
                newTexture = "ostrichg.png";
            }
            if (this.transformType == 8) {
                newTexture = "ostrichh.png";
            }
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
        }
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("ostrichc.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("ostrichb.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("ostricha.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("ostrichd.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("ostriche.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("ostrichf.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("ostrichg.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("ostrichh.png");
            }
        }
        return MoCreatures.proxy.getTexture("ostricha.png");
    }

    @Override
    public double getCustomSpeed() {
        double ostrichSpeed = 0.8;
        switch (this.getType()) {
            case 1: {
                ostrichSpeed = 0.9;
                break;
            }
            case 2: {
                ostrichSpeed = 0.8;
                break;
            }
            case 3: {
                ostrichSpeed = 0.9;
                break;
            }
            case 4: {
                ostrichSpeed = 1.0;
                break;
            }
            case 5: {
                ostrichSpeed = 1.1;
                this.field_70178_ae = true;
                break;
            }
            case 6: {
                ostrichSpeed = 1.12;
                break;
            }
            case 7: {
                ostrichSpeed = 1.2;
                this.field_70178_ae = true;
                break;
            }
            case 8: {
                ostrichSpeed = 1.25;
                this.field_70178_ae = true;
                break;
            }
            default: {
                return 0.8;
            }
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 200) {
            ostrichSpeed *= 1.2;
        }
        if (this.sprintCounter > 200 && this.getType() == 8) {
            ostrichSpeed *= 0.7;
        }
        return ostrichSpeed;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean isSelfPropelledFlyer() {
        return this.getType() == 6;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getType() == 5 && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
        if (this.getHiding()) {
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            this.field_70760_ar = this.field_70177_z;
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 20) {
            this.mouthCounter = 0;
        }
        if (this.wingCounter > 0 && ++this.wingCounter > 80) {
            this.wingCounter = 0;
        }
        if (this.jumpCounter > 0 && ++this.jumpCounter > 8) {
            this.jumpCounter = 0;
        }
        if (this.sprintCounter > 0 && ++this.sprintCounter > 300) {
            this.sprintCounter = 0;
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, "transform", this.field_70170_p);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.dropArmor();
                    this.setType(this.transformType);
                }
            }
        }
    }

    public void transform(int typeToTransformInto) {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), typeToTransformInto), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformType = typeToTransformInto;
        if (this.field_70153_n == null && this.transformType != 0) {
            this.dropArmor();
            this.transformCounter = 1;
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType >= 5 && animationType < 9) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getType() == 8 && this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextInt(100) == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.getIsTamed() && MoCreatures.isServer() && this.field_70146_Z.nextInt(300) == 0 && this.func_110143_aJ() <= this.func_110138_aP() && this.field_70725_aQ == 0) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        if (MoCreatures.isServer()) {
            double distP;
            EntityPlayer entityPlayer1;
            if (this.getType() == 8 && this.sprintCounter > 0 && this.sprintCounter < 150 && this.field_70153_n != null) {
                MoCTools.buckleMobs((EntityLiving)this, 2.0f, 2.0, this.field_70170_p);
            }
            if (!this.isNotScared() && this.field_70788_c > 0 && this.field_70788_c < 2) {
                this.field_70788_c = 0;
                this.setHiding(true);
                this.func_70778_a(null);
            }
            if (this.getHiding() && ++this.hidingCounter > 500 && !this.getIsTamed()) {
                this.setHiding(false);
                this.hidingCounter = 0;
            }
            if (this.getType() == 1 && this.field_70146_Z.nextInt(200) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 100) {
                    this.setAdult(true);
                    this.setType(0);
                    this.selectType();
                }
            }
            if (this.canLayEggs && this.getType() == 2 && !this.getEggWatching() && --this.eggCounter <= 0 && this.field_70146_Z.nextInt(5) == 0 && (entityPlayer1 = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null && (distP = MoCTools.getSqDistanceTo((Entity)entityPlayer1, this.field_70165_t, this.field_70163_u, this.field_70161_v)) < 10.0) {
                int OstrichEggType = 30;
                MoCEntityOstrich maleOstrich = this.getClosestMaleOstrich((Entity)this, 8.0);
                if (maleOstrich != null && this.field_70146_Z.nextInt(100) < MoCreatures.proxy.ostrichEggDropChance) {
                    MoCEntityEgg entityegg = new MoCEntityEgg(this.field_70170_p, OstrichEggType);
                    entityegg.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityegg);
                    if (!this.getIsTamed()) {
                        this.setEggWatching(true);
                        if (maleOstrich != null) {
                            maleOstrich.setEggWatching(true);
                        }
                        this.openMouth();
                    }
                    this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    this.eggCounter = this.field_70146_Z.nextInt(2000) + 2000;
                    this.canLayEggs = false;
                }
            }
            if (this.getEggWatching()) {
                MoCEntityEgg myEgg = (MoCEntityEgg)MoCTools.getScaryEntity((Entity)this, 8.0);
                if (myEgg != null && MoCTools.getSqDistanceTo((Entity)myEgg, this.field_70165_t, this.field_70163_u, this.field_70161_v) > 4.0) {
                    PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)myEgg, 16.0f, true, false, false, true);
                    this.func_70778_a(pathEntity);
                }
                if (myEgg == null) {
                    this.setEggWatching(false);
                    EntityPlayer eggStealer = this.field_70170_p.func_72890_a((Entity)this, 10.0);
                    if (eggStealer != null && !this.getIsTamed() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
                        this.field_70789_a = eggStealer;
                        this.flapWings();
                    }
                }
            }
        }
    }

    protected MoCEntityOstrich getClosestMaleOstrich(Entity entity, double d) {
        double d1 = -1.0;
        MoCEntityOstrich entityLiving = null;
        List list = this.field_70170_p.func_72839_b(entity, entity.field_70121_D.func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof MoCEntityOstrich) || entity1 instanceof MoCEntityOstrich && ((MoCEntityOstrich)entity1).getType() < 3) continue;
            double d2 = entity1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityLiving = (MoCEntityOstrich)entity1;
        }
        return entityLiving;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return entity instanceof MoCEntityEgg && ((MoCEntityEgg)entity).eggType == 30;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item instanceof ItemSeeds || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:beetroot_seeds") || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:turnipSeeds") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllseed") || oreDictionaryNameArray.contains("foodRaisins"));
        }
        return false;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        EntityPlayer owner = this.field_70170_p.func_72924_a(this.getOwnerName());
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (this.getIsTamed() && this.getType() > 1) {
                if (!(this.getIsRideable() || item != MoCreatures.craftedSaddle && item != Items.field_151141_av)) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    this.setRideable(true);
                    return true;
                }
                if (this.interactIfItemstackisEssenceOfDarkness(entityPlayer, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackisEssenceOfUndead(entityPlayer, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackisEssenceOfLight(entityPlayer, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackisEssenceOfFire(entityPlayer, itemStack, owner, item)) {
                    return true;
                }
                if (this.getIsChested() && item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                    int colorInt = itemStack.func_77960_j();
                    if (colorInt == 0) {
                        colorInt = 16;
                    }
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    this.dropFlag();
                    this.setFlagColor((byte)colorInt);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.ostrich_flag, 1);
                    return true;
                }
                if (!this.getIsChested() && item == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    this.setIsChested(true);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.ostrich_chest, 1);
                    return true;
                }
                if (this.interactIfPlayerIsHoldingWearableHelmet(entityPlayer, item)) {
                    return true;
                }
            } else if (this.getType() == 2 && item == Items.field_151081_bc) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                this.openMouth();
                MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                this.canLayEggs = true;
                return true;
            }
        }
        if (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) {
            if (entityPlayer.func_70093_af() && this.getIsChested()) {
                if (this.localChest == null) {
                    this.localChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.OstrichChest"), 9);
                }
                if (MoCreatures.isServer()) {
                    entityPlayer.func_71007_a((IInventory)this.localChest);
                }
                return true;
            }
            if (!entityPlayer.func_70093_af() && this.getIsRideable() && this.getIsAdult() && this.field_70153_n == null) {
                entityPlayer.field_70177_z = this.field_70177_z;
                entityPlayer.field_70125_A = this.field_70125_A;
                this.setHiding(false);
                if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != entityPlayer)) {
                    entityPlayer.func_70078_a((Entity)this);
                }
                return true;
            }
        }
        return false;
    }

    private boolean interactIfItemstackisEssenceOfDarkness(EntityPlayer entityPlayer, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceDarkness) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.getType() == 6) {
                this.func_70606_j(this.func_110138_aP());
            } else {
                this.transform(6);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.wyvern_ostrich, 1);
                }
            }
            MoCTools.playCustomSound((Entity)this, "drinking", this.field_70170_p);
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackisEssenceOfUndead(EntityPlayer entityPlayer, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceUndead) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.getType() == 7) {
                this.func_70606_j(this.func_110138_aP());
            } else {
                this.transform(7);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.undead_ostrich, 1);
                }
            }
            MoCTools.playCustomSound((Entity)this, "drinking", this.field_70170_p);
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackisEssenceOfLight(EntityPlayer entityPlayer, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceLight) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.getType() == 8) {
                this.func_70606_j(this.func_110138_aP());
            } else {
                this.transform(8);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.unihorn_ostrich, 1);
                }
            }
            MoCTools.playCustomSound((Entity)this, "drinking", this.field_70170_p);
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackisEssenceOfFire(EntityPlayer entityPlayer, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceFire) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.getType() == 5) {
                this.func_70606_j(this.func_110138_aP());
            } else {
                this.transform(5);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.nether_ostrich, 1);
                }
            }
            MoCTools.playCustomSound((Entity)this, "drinking", this.field_70170_p);
            return true;
        }
        return false;
    }

    private boolean interactIfPlayerIsHoldingWearableHelmet(EntityPlayer entityPlayer, Item item) {
        if (item instanceof ItemArmor) {
            int helmetType = 0;
            if (item == Items.field_151024_Q) {
                helmetType = 1;
            } else if (item == Items.field_151028_Y) {
                helmetType = 2;
            } else if (item == Items.field_151169_ag) {
                helmetType = 3;
            } else if (item == Items.field_151161_ac) {
                helmetType = 4;
            } else if (item == MoCreatures.helmetHide) {
                helmetType = 5;
            } else if (item == MoCreatures.helmetFur) {
                helmetType = 6;
            } else if (item == MoCreatures.helmetReptile) {
                helmetType = 7;
            } else if (item == MoCreatures.scorpHelmetDirt) {
                helmetType = 9;
            } else if (item == MoCreatures.scorpHelmetFrost) {
                helmetType = 10;
            } else if (item == MoCreatures.scorpHelmetCave) {
                helmetType = 11;
            } else if (item == MoCreatures.scorpHelmetNether) {
                helmetType = 12;
            }
            if (helmetType != 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                this.dropArmor();
                MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
                this.setHelmet((byte)helmetType);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.ostrich_helmet, 1);
                return true;
            }
        }
        return false;
    }

    private void dropFlag() {
        if (MoCreatures.isServer() && this.getFlagColor() != 0) {
            byte color = this.getFlagColor();
            if (color == 16) {
                color = 0;
            }
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Blocks.field_150325_L, 1, (int)color));
            entityItem.field_145804_b = 10;
            this.field_70170_p.func_72838_d((Entity)entityItem);
            this.setFlagColor((byte)0);
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void flapWings() {
        this.wingCounter = 1;
    }

    protected String func_70621_aR() {
        this.openMouth();
        return "mocreatures:ostrichhurt";
    }

    protected String func_70639_aQ() {
        this.openMouth();
        if (this.getType() == 1) {
            return "mocreatures:ostrichchick";
        }
        return "mocreatures:ostrichgrunt";
    }

    protected String func_70673_aS() {
        this.openMouth();
        return "mocreatures:ostrichdying";
    }

    protected Item func_146068_u() {
        boolean flag;
        boolean bl = flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        if (flag && this.getType() == 8) {
            return MoCreatures.unicornHorn;
        }
        if (this.getType() == 5 && flag) {
            return MoCreatures.heartFire;
        }
        if (this.getType() == 6 && flag) {
            return MoCreatures.heartDarkness;
        }
        if (this.getType() == 7) {
            if (flag) {
                return MoCreatures.heartundead;
            }
            return Items.field_151078_bh;
        }
        return MoCreatures.ostrichRaw;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setRideable(nbtTagCompound.func_74767_n("Saddle"));
        this.setEggWatching(nbtTagCompound.func_74767_n("EggWatch"));
        this.setHiding(nbtTagCompound.func_74767_n("Hiding"));
        this.setHelmet(nbtTagCompound.func_74771_c("Helmet"));
        this.setFlagColor(nbtTagCompound.func_74771_c("FlagColor"));
        this.setIsChested(nbtTagCompound.func_74767_n("Bagged"));
        if (this.getIsChested()) {
            NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Items", 10);
            this.localChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.OstrichChest"), 9);
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound1 = nbtTagList.func_150305_b(i);
                int j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localChest.func_70302_i_()) continue;
                this.localChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Saddle", this.getIsRideable());
        nbtTagCompound.func_74757_a("EggWatch", this.getEggWatching());
        nbtTagCompound.func_74757_a("Hiding", this.getHiding());
        nbtTagCompound.func_74774_a("Helmet", this.getHelmet());
        nbtTagCompound.func_74774_a("FlagColor", this.getFlagColor());
        nbtTagCompound.func_74757_a("Bagged", this.getIsChested());
        if (this.getIsChested() && this.localChest != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (int i = 0; i < this.localChest.func_70302_i_(); ++i) {
                this.localItemstack = this.localChest.func_70301_a(i);
                if (this.localItemstack == null) continue;
                NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbtTagList.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbtTagList);
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (!MoCreatures.isBiomesOPlentyLoaded || MoCreatures.isBiomesOPlentyLoaded && this.checkSpawningBiome() && this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving()) {
            return super.func_70601_bi();
        }
        return false;
    }

    @Override
    public int nameYOffset() {
        if (this.getType() > 1) {
            return -105;
        }
        return -5 - this.getMoCAge();
    }

    @Override
    public double roperYOffset() {
        if (this.getType() > 1) {
            return 0.0;
        }
        return (double)(120 - this.getMoCAge()) * 0.01;
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public void dropMyStuff() {
        if (MoCreatures.isServer()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localChest);
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public void dropArmor() {
        if (MoCreatures.isServer()) {
            EntityItem entityItem = null;
            switch (this.getHelmet()) {
                case 0: 
                case 8: {
                    return;
                }
                case 1: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)Items.field_151024_Q, 1));
                    break;
                }
                case 2: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)Items.field_151028_Y, 1));
                    break;
                }
                case 3: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)Items.field_151169_ag, 1));
                    break;
                }
                case 4: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)Items.field_151161_ac, 1));
                    break;
                }
                case 5: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.helmetHide, 1));
                    break;
                }
                case 6: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.helmetFur, 1));
                    break;
                }
                case 7: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.helmetReptile, 1));
                    break;
                }
                case 9: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.scorpHelmetDirt, 1));
                    break;
                }
                case 10: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.scorpHelmetFrost, 1));
                    break;
                }
                case 11: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.scorpHelmetCave, 1));
                    break;
                }
                case 12: {
                    entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.scorpHelmetNether, 1));
                }
            }
            if (entityItem != null) {
                entityItem.field_145804_b = 10;
                this.field_70170_p.func_72838_d(entityItem);
            }
            this.setHelmet((byte)0);
        }
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 5 || this.getType() == 6;
    }

    protected void func_70069_a(float f) {
        if (this.isFlyer()) {
            return;
        }
    }

    @Override
    protected double myFallSpeed() {
        if (this.getType() == 6) {
            return 0.9;
        }
        return 0.99;
    }

    @Override
    protected double flyerThrust() {
        return 0.6;
    }

    @Override
    protected float flyerFriction() {
        return 0.96f;
    }

    @Override
    public void makeEntityJump() {
        if (this.jumpCounter > 5) {
            this.jumpCounter = 1;
        }
        if (this.jumpCounter == 0) {
            if (this.isFlyer()) {
                MoCTools.playCustomSound((Entity)this, "wingflap", this.field_70170_p);
            }
            this.jumpPending = true;
            this.jumpCounter = 1;
        }
    }

    public boolean isUndead() {
        return this.getType() == 7;
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getType() == 7) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    public int func_70641_bl() {
        return 1;
    }
}

