/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class MoCEntityKomodoDragon
extends MoCEntityTameableAnimal {
    public int sitCounter;
    public int tailCounter;
    public int tongueCounter;
    public int mouthCounter;

    public MoCEntityKomodoDragon(World world) {
        super(world);
        this.func_70105_a(1.6f, 0.5f);
        this.texture = "komododragon.png";
        this.setTamed(false);
        this.setAdult(false);
        this.field_70138_W = 1.0f;
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.setMoCAge(30 + this.field_70146_Z.nextInt(40));
        } else {
            this.setMoCAge(90 + this.field_70146_Z.nextInt(30));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    @Override
    public void setRideable(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    @Override
    public boolean getIsRideable() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving();
    }

    protected String func_70673_aS() {
        this.openmouth();
        return "mocreatures:snakedying";
    }

    protected String func_70621_aR() {
        this.openmouth();
        return "mocreatures:snakehurt";
    }

    protected String func_70639_aQ() {
        this.openmouth();
        return "mocreatures:snakehiss";
    }

    public int func_70627_aG() {
        return 500;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.field_70789_a == null || this.field_70789_a != this.field_70153_n || this.field_70153_n instanceof EntityPlayer && this.field_70153_n.func_70005_c_().equals(this.getOwnerName()))) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 30) {
            this.tailCounter = 0;
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.tailCounter = 1;
        }
        if (this.sitCounter > 0 && (this.field_70153_n != null || ++this.sitCounter > 150)) {
            this.sitCounter = 0;
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.tongueCounter = 1;
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.tongueCounter > 0 && ++this.tongueCounter > 20) {
            this.tongueCounter = 0;
        }
        if (MoCreatures.isServer() && this.field_70153_n == null && this.sitCounter == 0 && this.field_70146_Z.nextInt(500) == 0) {
            this.sit();
        }
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(500) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 120) {
                this.setAdult(true);
            }
        }
    }

    private void openmouth() {
        this.mouthCounter = 1;
    }

    private void sit() {
        this.sitCounter = 1;
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.func_70778_a(null);
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.sitCounter = 1;
            this.func_70778_a(null);
        }
    }

    protected void func_70628_a(boolean flag, int x) {
        boolean flag2;
        boolean bl = flag2 = this.getMoCAge() > 90 && this.field_70146_Z.nextInt(5) == 0;
        if (flag2) {
            int j = this.field_70146_Z.nextInt(2) + 1;
            for (int k = 0; k < j; ++k) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, 33), 0.0f);
            }
        } else {
            this.func_70099_a(new ItemStack(MoCreatures.hideReptile, 1, 0), 0.0f);
        }
    }

    @Override
    public float getSizeFactor() {
        if (!this.getIsAdult()) {
            return (float)this.getMoCAge() * 0.01f;
        }
        return 1.2f;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && this.getIsTamed() && !this.getIsRideable() && this.getMoCAge() > 90 && (itemStack.func_77973_b() == Items.field_151141_av || itemStack.func_77973_b() == MoCreatures.craftedSaddle)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.setRideable(true);
            MoCTools.playCustomSound((Entity)this, "roping", this.field_70170_p);
            return true;
        }
        if (this.getIsRideable() && this.getIsTamed() && this.getMoCAge() > 90 && this.field_70153_n == null && MoCreatures.isServer() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.field_70153_n == null) {
            entityPlayer.field_70177_z = this.field_70177_z;
            entityPlayer.field_70125_A = this.field_70125_A;
            entityPlayer.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    protected boolean func_70780_i() {
        return this.sitCounter != 0 || this.field_70153_n != null;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -55;
        }
        return 60 / this.getMoCAge() * -50;
    }

    @Override
    public double roperYOffset() {
        double r = (double)(150 - this.getMoCAge()) * 0.012;
        if (r < 0.55) {
            r = 0.55;
        }
        if (r > 1.2) {
            r = 1.2;
        }
        return r;
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Saddle", this.getIsRideable());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setRideable(nbtTagCompound.func_74767_n("Saddle"));
    }

    public double func_70042_X() {
        boolean sit;
        double yOffset = 0.15f;
        boolean bl = sit = this.sitCounter != 0;
        if (sit) {
            // empty if block
        }
        if (this.getIsAdult()) {
            return yOffset + (double)this.field_70131_O;
        }
        return this.field_70131_O * (float)(120 / this.getMoCAge());
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 3.0) {
            this.field_70724_aR = 20;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 150, 0));
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n != null && entityThatAttackedThisCreature == this.field_70153_n) {
                return false;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 6.0);
            if (!this.getIsTamed() && entityPlayer != null && this.getMoCAge() > 70) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(80) == 0) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 8.0);
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && this.field_70153_n == null && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151147_al || item == Items.field_151082_bd || item == Items.field_151076_bf || item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || item == Items.field_151078_bh || item == MoCreatures.ratRaw || item == MoCreatures.turkeyRaw || item == MoCreatures.ostrichRaw || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:rabbit_raw") || oreDictionaryNameArray.contains("listAllmeatraw") || oreDictionaryNameArray.contains("listAllfishraw") || MoCreatures.isGregTech6Loaded && oreDictionaryNameArray.contains("foodScrapmeat");
        }
        return false;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntityKomodoDragon || entity instanceof EntityPlayer || entity instanceof MoCEntityBigCat || entity instanceof MoCEntityShark || entity instanceof IMob || entity instanceof MoCEntityMob || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityRay || entity instanceof EntitySquid || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityAmbient || (double)entity.field_70130_N > 0.9 && (double)entity.field_70131_O > 0.9;
    }

    @Override
    public void dropMyStuff() {
        if (MoCreatures.isServer()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
        }
    }

    public int func_70641_bl() {
        return 2;
    }
}

