/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityItemPlaceable;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityDeer;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityKitty
extends MoCEntityTameableAnimal {
    private int kittyTimer;
    private int madTimer;
    private boolean hasFoundTree;
    private final int[] treeCoord = new int[]{-1, -1, -1};
    private boolean isSwingingArm;
    private boolean isOnTree;
    static final int KITTY_STATE_UNTAMED = 1;
    static final int KITTY_STATE_PRETAMED = 2;
    static final int KITTY_STATE_WANTS_FOOD = 3;
    static final int KITTY_STATE_USING_KITTY_BED = 4;
    static final int KITTY_STATE_LOOKING_FOR_LITTER_BOX = 5;
    static final int KITTY_STATE_USING_LITTER_BOX = 6;
    static final int KITTY_STATE_NORMAL_HAPPY = 7;
    static final int KITTY_STATE_PLAYING_WITH_WOOLBALL = 8;
    static final int KITTY_STATE_IN_LOVE_STAGE_ONE = 9;
    static final int KITTY_STATE_KITTEN = 10;
    static final int KITTY_STATE_INTERESTED = 11;
    static final int KITTY_STATE_SLEEPING = 12;
    static final int KITTY_STATE_ANGRY = 13;
    static final int KITTY_STATE_HELD_ON_PLAYERS_HAND_USING_ROPE = 14;
    static final int KITTY_STATE_ON_PLAYERS_BACK = 15;
    static final int KITTY_STATE_TREE = 16;
    static final int KITTY_STATE_GOING_INTO_LABOUR = 17;
    static final int KITTY_STATE_IN_LOVE_STAGE_TWO = 18;
    static final int KITTY_STATE_GIVING_BIRTH_STAGE_ONE = 19;
    static final int KITTY_STATE_GIVING_BIRTH_STAGE_TWO = 20;
    static final int KITTY_STATE_PARENTING = 21;

    public MoCEntityKitty(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.5f);
        this.setAdult(true);
        this.setMoCAge(40);
        this.setKittyState(1);
        this.kittyTimer = 0;
        this.madTimer = this.field_70146_Z.nextInt(5);
        this.hasFoundTree = false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(8) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("pussycata.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("pussycatb.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("pussycatc.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("pussycatd.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("pussycate.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("pussycatf.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("pussycatg.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("pussycath.png");
            }
        }
        return MoCreatures.proxy.getTexture("pussycata.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int getKittyState() {
        return this.field_70180_af.func_75679_c(22);
    }

    public boolean getIsSitting() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public boolean getIsHungry() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public boolean getIsEmo() {
        return this.field_70180_af.func_75683_a(25) == 1;
    }

    public boolean getIsSwinging() {
        return this.isSwingingArm;
    }

    public boolean getOnTree() {
        return this.isOnTree;
    }

    public void setKittyState(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public void setSitting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void setHungry(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    public void setIsEmo(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(25, (Object)input);
    }

    public void setOnTree(boolean var1) {
        this.isOnTree = var1;
    }

    public void setSwinging(boolean var1) {
        this.isSwingingArm = var1;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(30) == 0 && this.field_70122_E) {
            double xDistance = entity.field_70165_t - this.field_70165_t;
            double zDistance = entity.field_70161_v - this.field_70161_v;
            float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
            this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70159_w * 0.2;
            this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70179_y * 0.2;
            this.field_70181_x = 0.4;
        }
        if ((double)distanceToEntity < 2.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            if (this.getKittyState() != 18 && this.getKittyState() != 10) {
                this.swingArm();
            }
            if (this.getKittyState() == 13 && entity instanceof EntityPlayer || this.getKittyState() == 8 && entity instanceof EntityItem || this.getKittyState() == 18 && entity instanceof MoCEntityKitty || this.getKittyState() == 10) {
                return;
            }
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != this) {
                if (this.getKittyState() == 10) {
                    List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 6.0, 16.0));
                    for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
                        Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
                        if (!(entityNearby instanceof MoCEntityKitty) || ((MoCEntityKitty)entityNearby).getKittyState() != 21) continue;
                        ((MoCEntityKitty)entityNearby).field_70789_a = entityThatAttackedThisCreature;
                        return true;
                    }
                    return true;
                }
                if (entityThatAttackedThisCreature instanceof EntityPlayer) {
                    if (this.getKittyState() < 2) {
                        this.field_70789_a = entityThatAttackedThisCreature;
                        this.setKittyState(-1);
                    }
                    if (this.getKittyState() == 19 || this.getKittyState() == 20 || this.getKittyState() == 21) {
                        this.field_70789_a = entityThatAttackedThisCreature;
                        this.setSitting(false);
                        return true;
                    }
                    if (this.getKittyState() > 1 && this.getKittyState() != 10 && this.getKittyState() != 19 && this.getKittyState() != 20 && this.getKittyState() != 21) {
                        this.setKittyState(13);
                        this.setSitting(false);
                    }
                    return true;
                }
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    private void changeKittyStateTo(int i) {
        this.setKittyState(i);
        if (MoCreatures.isServer()) {
            this.func_70078_a(null);
        }
        this.setSitting(false);
        this.kittyTimer = 0;
        this.setOnTree(false);
        this.hasFoundTree = false;
        this.field_70789_a = null;
    }

    public boolean isClimbingTree() {
        return this.getKittyState() == 16 && this.func_70617_f_();
    }

    protected void func_70069_a(float f) {
    }

    @Override
    protected Entity func_70782_k() {
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getKittyState() != 8 && this.getKittyState() != 10 && this.getKittyState() != 15 && this.getKittyState() != 18 && this.getKittyState() != 19 && !this.func_70780_i()) {
            EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 10.0);
            return entityLiving;
        }
        return null;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5) && !(entity instanceof MoCEntityDeer) && !(entity instanceof MoCEntityHorse) && (this.getKittyState() == 1 || !(entity instanceof EntityPlayer));
    }

    protected String func_70673_aS() {
        if (this.getKittyState() == 10) {
            return "mocreatures:kittendying";
        }
        return "mocreatures:kittydying";
    }

    protected Item func_146068_u() {
        return null;
    }

    public ResourceLocation getEmoteIcon() {
        switch (this.getKittyState()) {
            case -1: {
                return null;
            }
            case 3: {
                return MoCreatures.proxy.getTexture("emoticon3.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("emoticon4.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("emoticon5.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("emoticon7.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("emoticon8.png");
            }
            case 9: {
                return MoCreatures.proxy.getTexture("emoticon9.png");
            }
            case 10: {
                return MoCreatures.proxy.getTexture("emoticon10.png");
            }
            case 11: {
                return MoCreatures.proxy.getTexture("emoticon11.png");
            }
            case 12: {
                return MoCreatures.proxy.getTexture("emoticon12.png");
            }
            case 13: {
                return MoCreatures.proxy.getTexture("emoticon13.png");
            }
            case 16: {
                return MoCreatures.proxy.getTexture("emoticon16.png");
            }
            case 17: {
                return MoCreatures.proxy.getTexture("emoticon17.png");
            }
            case 18: {
                return MoCreatures.proxy.getTexture("emoticon9.png");
            }
            case 19: {
                return MoCreatures.proxy.getTexture("emoticon19.png");
            }
            case 20: {
                return MoCreatures.proxy.getTexture("emoticon19.png");
            }
            case 21: {
                return MoCreatures.proxy.getTexture("emoticon10.png");
            }
        }
        return MoCreatures.proxy.getTexture("emoticon1.png");
    }

    protected String func_70621_aR() {
        if (this.getKittyState() == 10) {
            return "mocreatures:kittenhurt";
        }
        return "mocreatures:kittyhurt";
    }

    public EntityLiving findKittyStuffNearby(Entity entity, double searchDistance, boolean lookForKittyLitterBox) {
        double distanceToTheTargetEntity = -1.0;
        MoCEntityItemPlaceable targetEntityObject = null;
        List listOfEntitiesNearby = this.field_70170_p.func_72839_b(entity, this.field_70121_D.func_72314_b(searchDistance, searchDistance, searchDistance));
        for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
            double distanceToEntityNearby;
            Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
            if (lookForKittyLitterBox) {
                MoCEntityLitterBox entityLitterBox;
                if (!(entityNearby instanceof MoCEntityLitterBox) || (entityLitterBox = (MoCEntityLitterBox)entityNearby).getUsedLitter()) continue;
                distanceToEntityNearby = entityNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(searchDistance < 0.0) && !(distanceToEntityNearby < searchDistance * searchDistance) || distanceToTheTargetEntity != -1.0 && !(distanceToEntityNearby < distanceToTheTargetEntity) || !entityLitterBox.func_70685_l(entity)) continue;
                distanceToTheTargetEntity = distanceToEntityNearby;
                targetEntityObject = entityLitterBox;
                continue;
            }
            if (!(entityNearby instanceof MoCEntityKittyBed)) continue;
            MoCEntityKittyBed entityKittyBed = (MoCEntityKittyBed)entityNearby;
            distanceToEntityNearby = entityNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(searchDistance < 0.0) && !(distanceToEntityNearby < searchDistance * searchDistance) || distanceToTheTargetEntity != -1.0 && !(distanceToEntityNearby < distanceToTheTargetEntity) || !entityKittyBed.func_70685_l(entity)) continue;
            distanceToTheTargetEntity = distanceToEntityNearby;
            targetEntityObject = entityKittyBed;
        }
        return targetEntityObject;
    }

    protected String func_70639_aQ() {
        if (this.getKittyState() == 4) {
            if (this.field_70154_o != null) {
                MoCEntityKittyBed entityKittyBed = (MoCEntityKittyBed)this.field_70154_o;
                if (entityKittyBed != null && !entityKittyBed.getHasMilk()) {
                    return "mocreatures:kittyeatingm";
                }
                if (entityKittyBed != null && !entityKittyBed.getHasFood()) {
                    return "mocreatures:kittyeatingf";
                }
            }
            return null;
        }
        if (this.getKittyState() == 6) {
            return "mocreatures:kittylitter";
        }
        if (this.getKittyState() == 3) {
            return "mocreatures:kittyfood";
        }
        if (this.getKittyState() == 10) {
            return "mocreatures:kittengrunt";
        }
        if (this.getKittyState() == 13) {
            return "mocreatures:kittyupset";
        }
        if (this.getKittyState() == 17) {
            return "mocreatures:kittytrapped";
        }
        if (this.getKittyState() == 18 || this.getKittyState() == 12) {
            return "mocreatures:kittypurr";
        }
        return "mocreatures:kittygrunt";
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            if (this.getKittyState() == 10) {
                return this.field_70129_M - 1.1f;
            }
            if (this.isUpsideDown()) {
                return this.field_70129_M - 1.7f;
            }
            if (this.isOnPlayersBack()) {
                return this.field_70129_M - 1.5f;
            }
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            if (this.getKittyState() == 10) {
                return this.field_70129_M + 0.3f;
            }
            if (this.isUpsideDown()) {
                return this.field_70129_M - 0.1f;
            }
            if (this.isOnPlayersBack()) {
                return this.field_70129_M + 0.1f;
            }
        }
        return this.field_70129_M;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (this.getKittyState() == 2 && itemStack != null && itemStack.func_77973_b() == MoCreatures.medallion && this.func_70638_az() != entityPlayer) {
            if (MoCreatures.isServer()) {
                MoCTools.tameWithName(entityPlayer, this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_kitty, 1);
            }
            if (this.getIsTamed() && --itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (this.getIsTamed()) {
                this.changeKittyStateTo(3);
                return true;
            }
            return false;
        }
        if (this.getKittyState() == 7 && itemStack != null && (itemStack.func_77973_b() == Items.field_151105_aU || itemStack.func_77973_b() == Items.field_151115_aP && itemStack.func_77960_j() != 3 || this.isItemStackInRawFishOreDictionary(itemStack) || itemStack.func_77973_b() == Items.field_151101_aQ)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.func_85030_a("mocreatures:kittyeatingf", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_70691_i(8.0f);
            this.changeKittyStateTo(9);
            return true;
        }
        if (this.getKittyState() == 11 && itemStack != null && itemStack.func_77973_b() == MoCreatures.woolball && MoCreatures.isServer()) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.setKittyState(8);
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, new ItemStack(MoCreatures.woolball, 1));
            entityItem.field_145804_b = 30;
            entityItem.field_70292_b = -10000;
            this.field_70170_p.func_72838_d((Entity)entityItem);
            entityItem.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.05f);
            entityItem.field_70159_w += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
            entityItem.field_70179_y += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
            this.field_70789_a = entityItem;
            return true;
        }
        if (this.getKittyState() == 13 && itemStack != null && (itemStack.func_77973_b() == Items.field_151115_aP || this.isItemStackInRawFishOreDictionary(itemStack) || itemStack.func_77973_b() == Items.field_151101_aQ)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.func_85030_a("mocreatures:kittyeatingf", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_70691_i(5.0f);
            this.changeKittyStateTo(7);
            return true;
        }
        if (itemStack != null && this.getKittyState() > 2 && itemStack.func_77973_b() == MoCreatures.medallion) {
            if (MoCreatures.isServer()) {
                MoCTools.tameWithName(entityPlayer, this);
            }
            return true;
        }
        if (itemStack != null && this.getKittyState() > 2 && this.isPickable() && itemStack.func_77973_b() == Items.field_151058_ca && entityPlayer.field_70154_o == null) {
            this.changeKittyStateTo(14);
            if (MoCreatures.isServer()) {
                this.func_70078_a((Entity)entityPlayer);
            }
            return true;
        }
        if (itemStack != null && this.getKittyState() > 2 && this.isWhipeable() && itemStack.func_77973_b() == MoCreatures.whip) {
            this.setSitting(!this.getIsSitting());
            return true;
        }
        if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.getKittyState() == 10 && this.field_70154_o != null) {
            this.field_70154_o = null;
            return true;
        }
        if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.getKittyState() > 2 && this.isPickable() && entityPlayer.field_70154_o == null) {
            this.changeKittyStateTo(15);
            if (MoCreatures.isServer()) {
                this.func_70078_a((Entity)entityPlayer);
            }
            return true;
        }
        if ((MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af() && this.getKittyState() == 15) {
            this.changeKittyStateTo(7);
            return true;
        }
        if (this.getKittyState() == 14 && this.field_70154_o != null) {
            this.changeKittyStateTo(7);
            return true;
        }
        return false;
    }

    protected boolean func_70780_i() {
        return this.getIsSitting() || this.getKittyState() == 6 || this.getKittyState() == 16 && this.getOnTree() || this.getKittyState() == 12 || this.getKittyState() == 17 || this.getKittyState() == 14 || this.getKittyState() == 20 || this.getKittyState() == 23;
    }

    public boolean func_70617_f_() {
        if (this.getKittyState() == 16) {
            return this.field_70123_F && this.getOnTree();
        }
        return super.func_70617_f_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void func_70636_d() {
        if (MoCreatures.isServer()) {
            if (!this.getIsAdult() && this.getKittyState() != 10) {
                this.setKittyState(10);
            }
            if (this.getKittyState() != 12) {
                super.func_70636_d();
            }
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.setIsEmo(!this.getIsEmo());
            }
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 100) {
                    this.setAdult(true);
                    this.setKittyState(7);
                }
            }
            if (this.getIsTamed() && this.isNight() && this.field_70154_o == null && !this.getIsSitting()) {
                MoCEntityKittyBed entityKittyBedNearby = (MoCEntityKittyBed)this.findKittyStuffNearby((Entity)this, 18.0, false);
                if (entityKittyBedNearby != null && entityKittyBedNearby.field_70153_n == null) {
                    float distanceToKittybed = entityKittyBedNearby.func_70032_d((Entity)this);
                    if (distanceToKittybed > 2.0f) {
                        this.getMyOwnPath((Entity)entityKittyBedNearby, distanceToKittybed);
                    }
                    if (distanceToKittybed < 2.0f) {
                        this.func_70078_a((Entity)entityKittyBedNearby);
                        this.setKittyState(12);
                    }
                }
                if (entityKittyBedNearby == null && this.field_70146_Z.nextInt(500) == 0) {
                    this.setKittyState(12);
                }
            }
            if (this.getIsTamed() && !this.isNight() && this.getKittyState() == 12) {
                this.changeKittyStateTo(7);
            }
            if (!this.getIsHungry() && !this.getIsSitting() && this.field_70146_Z.nextInt(100) == 0) {
                this.setHungry(true);
            }
            switch (this.getKittyState()) {
                case -1: {
                    return;
                }
                case 23: {
                    return;
                }
                case 1: {
                    EntityItem closestEntityItemForTaming;
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        EntityLivingBase scaryEntityNearby = MoCTools.getScaryEntity((Entity)this, 6.0);
                        if (scaryEntityNearby == null) return;
                        MoCTools.runAway((EntityCreature)this, (Entity)scaryEntityNearby);
                        return;
                    }
                    if (!this.getIsHungry()) return;
                    if (this.field_70146_Z.nextInt(10) != 0 || (closestEntityItemForTaming = MoCTools.getClosestSpecificEntityItemItemNearby((Entity)this, 10.0, Items.field_151101_aQ, Items.field_151101_aQ)) == null) return;
                    float distanceToEntityItemForTaming = closestEntityItemForTaming.func_70032_d((Entity)this);
                    if (distanceToEntityItemForTaming > 2.0f) {
                        this.getMyOwnPath((Entity)closestEntityItemForTaming, distanceToEntityItemForTaming);
                    }
                    if (!(distanceToEntityItemForTaming < 2.0f) || closestEntityItemForTaming == null || this.field_70725_aQ != 0) return;
                    closestEntityItemForTaming.func_70106_y();
                    this.func_85030_a("mocreatures:kittyeatingf", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.setHungry(false);
                    this.setKittyState(2);
                    return;
                }
                case 2: {
                    EntityLivingBase scaryEntityNearby = MoCTools.getScaryEntity((Entity)this, 6.0);
                    if (scaryEntityNearby == null) return;
                    MoCTools.runAway((EntityCreature)this, (Entity)scaryEntityNearby);
                    return;
                }
                case 3: {
                    ++this.kittyTimer;
                    if (this.kittyTimer > 500 && this.field_70146_Z.nextInt(500) == 0) {
                        this.changeKittyStateTo(7);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(20) != 0) return;
                    MoCEntityKittyBed entityKittyBedNearby = (MoCEntityKittyBed)this.findKittyStuffNearby((Entity)this, 18.0, false);
                    if (entityKittyBedNearby == null || entityKittyBedNearby.field_70153_n != null) return;
                    if (!entityKittyBedNearby.getHasMilk() && !entityKittyBedNearby.getHasFood()) return;
                    float distanceToNearbyKittyBed = entityKittyBedNearby.func_70032_d((Entity)this);
                    if (distanceToNearbyKittyBed > 2.0f) {
                        this.getMyOwnPath((Entity)entityKittyBedNearby, distanceToNearbyKittyBed);
                    }
                    if (!(distanceToNearbyKittyBed < 2.0f)) return;
                    this.changeKittyStateTo(4);
                    this.func_70078_a((Entity)entityKittyBedNearby);
                    this.setSitting(true);
                    return;
                }
                case 4: {
                    if (this.field_70154_o != null) {
                        MoCEntityKittyBed kittyBedNearby = (MoCEntityKittyBed)this.field_70154_o;
                        if (kittyBedNearby != null && !kittyBedNearby.getHasMilk() && !kittyBedNearby.getHasFood()) {
                            this.func_70691_i(5.0f);
                            this.changeKittyStateTo(5);
                        }
                    } else {
                        this.func_70691_i(5.0f);
                        this.changeKittyStateTo(5);
                    }
                    if (this.field_70146_Z.nextInt(2500) != 0) return;
                    this.func_70691_i(5.0f);
                    this.changeKittyStateTo(7);
                    return;
                }
                case 5: {
                    ++this.kittyTimer;
                    if (this.kittyTimer > 2000 && this.field_70146_Z.nextInt(1000) == 0) {
                        this.changeKittyStateTo(13);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(20) != 0) return;
                    MoCEntityLitterBox entityLitterBoxNearby = (MoCEntityLitterBox)this.findKittyStuffNearby((Entity)this, 18.0, true);
                    if (entityLitterBoxNearby == null || entityLitterBoxNearby.field_70153_n != null) return;
                    if (entityLitterBoxNearby.getUsedLitter()) return;
                    float distanceToLitterBoxNearby = entityLitterBoxNearby.func_70032_d((Entity)this);
                    if (distanceToLitterBoxNearby > 2.0f) {
                        this.getMyOwnPath((Entity)entityLitterBoxNearby, distanceToLitterBoxNearby);
                    }
                    if (!(distanceToLitterBoxNearby < 2.0f)) return;
                    this.changeKittyStateTo(6);
                    this.func_70078_a((Entity)entityLitterBoxNearby);
                    return;
                }
                case 6: {
                    ++this.kittyTimer;
                    if (this.kittyTimer <= 300) return;
                    MoCEntityLitterBox litterBoxNearby = (MoCEntityLitterBox)this.field_70154_o;
                    if (litterBoxNearby != null) {
                        litterBoxNearby.setUsedLitter(true);
                        litterBoxNearby.litterTime = 0;
                    }
                    this.changeKittyStateTo(7);
                    return;
                }
                case 7: {
                    ItemStack itemstackHeldByPlayer;
                    EntityPlayer entityPlayerNearby;
                    if (this.getIsSitting()) return;
                    if (this.field_70146_Z.nextInt(20) == 0 && (entityPlayerNearby = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null && (itemstackHeldByPlayer = entityPlayerNearby.func_70694_bm()) != null && itemstackHeldByPlayer.func_77973_b() == MoCreatures.woolball) {
                        this.changeKittyStateTo(11);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(500) == 0 && !this.field_70170_p.func_72935_r()) {
                        this.changeKittyStateTo(12);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(2000) == 0) {
                        this.changeKittyStateTo(3);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(4000) != 0) return;
                    this.changeKittyStateTo(16);
                    return;
                }
                case 8: {
                    float distanceToEntityItem;
                    if (this.field_70789_a != null && this.field_70789_a instanceof EntityItem && (distanceToEntityItem = this.func_70032_d(this.field_70789_a)) < 1.5f) {
                        this.swingArm();
                        if (this.field_70146_Z.nextInt(10) == 0) {
                            MoCTools.pushEntityBack((Entity)this, this.field_70789_a, 0.3f);
                        }
                    }
                    if (this.field_70789_a != null && this.field_70146_Z.nextInt(1000) != 0) return;
                    this.changeKittyStateTo(7);
                    return;
                }
                case 9: {
                    ++this.kittyTimer;
                    if (this.field_70146_Z.nextInt(50) == 0) {
                        List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 6.0, 16.0));
                        for (int minimumListSize = 0; minimumListSize < listOfEntitiesNearby.size(); ++minimumListSize) {
                            Entity entityNearby = (Entity)listOfEntitiesNearby.get(minimumListSize);
                            if (!(entityNearby instanceof MoCEntityKitty) || !(entityNearby instanceof MoCEntityKitty) || ((MoCEntityKitty)entityNearby).getKittyState() != 9) continue;
                            this.changeKittyStateTo(18);
                            this.field_70789_a = entityNearby;
                            ((MoCEntityKitty)entityNearby).changeKittyStateTo(18);
                            ((MoCEntityKitty)entityNearby).field_70789_a = this;
                            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 8.0);
                            if (player == null) break;
                            player.func_71064_a((StatBase)MoCAchievements.breed_kitty, 1);
                            break;
                        }
                    }
                    if (this.kittyTimer <= 2000) return;
                    this.changeKittyStateTo(7);
                    return;
                }
                case 10: {
                    float distanceToOtherKittyToAttack;
                    float distanceToEntityItemToAttack;
                    if (this.getIsAdult()) {
                        this.changeKittyStateTo(7);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(50) == 0) {
                        List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 6.0, 16.0));
                        for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
                            float distanceToOtherKitty;
                            Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
                            if (!(entityNearby instanceof MoCEntityKitty) || ((MoCEntityKitty)entityNearby).getKittyState() != 21 || !((distanceToOtherKitty = this.func_70032_d(entityNearby)) > 12.0f)) continue;
                            this.field_70789_a = entityNearby;
                        }
                    }
                    if (this.field_70789_a == null && this.field_70146_Z.nextInt(100) == 0) {
                        this.field_70789_a = this.field_70146_Z.nextInt(10) < 7 ? MoCTools.getClosestSpecificEntityItemItemNearby((Entity)this, 10.0, null, null) : this.field_70170_p.func_72890_a((Entity)this, 18.0);
                    }
                    if (this.field_70789_a != null && this.field_70146_Z.nextInt(400) == 0) {
                        this.field_70789_a = null;
                    }
                    if (this.field_70789_a != null && this.field_70789_a instanceof EntityItem && (distanceToEntityItemToAttack = this.func_70032_d(this.field_70789_a)) < 1.5f) {
                        this.swingArm();
                        if (this.field_70146_Z.nextInt(10) == 0) {
                            MoCTools.pushEntityBack((Entity)this, this.field_70789_a, 0.2f);
                        }
                    }
                    if (this.field_70789_a != null && this.field_70789_a instanceof MoCEntityKitty && this.field_70146_Z.nextInt(20) == 0 && (distanceToOtherKittyToAttack = this.func_70032_d(this.field_70789_a)) < 2.0f) {
                        this.swingArm();
                        this.func_70778_a(null);
                    }
                    if (this.field_70789_a == null) return;
                    if (!(this.field_70789_a instanceof EntityPlayer)) return;
                    float distanceToPlayerToAttack = this.func_70032_d(this.field_70789_a);
                    if (!(distanceToPlayerToAttack < 2.0f) || this.field_70146_Z.nextInt(20) != 0) return;
                    this.swingArm();
                    return;
                }
                case 11: {
                    EntityPlayer closestEntityPlayerNearby = this.field_70170_p.func_72890_a((Entity)this, 18.0);
                    if (closestEntityPlayerNearby == null) return;
                    if (this.field_70146_Z.nextInt(10) != 0) return;
                    ItemStack itemstackHeldByPlyer = closestEntityPlayerNearby.func_70694_bm();
                    if (itemstackHeldByPlyer == null || itemstackHeldByPlyer != null && itemstackHeldByPlyer.func_77973_b() != MoCreatures.woolball) {
                        this.changeKittyStateTo(7);
                        return;
                    }
                    float distanceToPlayer = closestEntityPlayerNearby.func_70032_d((Entity)this);
                    if (!(distanceToPlayer > 5.0f)) return;
                    this.getPathOrWalkableBlock((Entity)closestEntityPlayerNearby, distanceToPlayer);
                    return;
                }
                case 12: {
                    ++this.kittyTimer;
                    if (this.field_70170_p.func_72935_r() || this.kittyTimer > 500 && this.field_70146_Z.nextInt(500) == 0) {
                        this.changeKittyStateTo(7);
                        return;
                    }
                    this.setSitting(true);
                    if (this.field_70146_Z.nextInt(80) != 0 && this.field_70122_E) return;
                    super.func_70636_d();
                    return;
                }
                case 13: {
                    this.setHungry(false);
                    this.field_70789_a = this.field_70170_p.func_72890_a((Entity)this, 18.0);
                    if (this.field_70789_a != null) {
                        float distanceToEntityToAttack = this.func_70032_d(this.field_70789_a);
                        if (distanceToEntityToAttack < 1.5f) {
                            this.swingArm();
                            if (this.field_70146_Z.nextInt(20) == 0) {
                                --this.madTimer;
                                this.field_70789_a.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                                if (this.madTimer < 1) {
                                    this.changeKittyStateTo(7);
                                    this.madTimer = this.field_70146_Z.nextInt(5);
                                }
                            }
                        }
                        if (this.field_70146_Z.nextInt(500) != 0) return;
                        this.changeKittyStateTo(7);
                        return;
                    }
                    this.changeKittyStateTo(7);
                    return;
                }
                case 14: {
                    if (this.field_70122_E) {
                        this.changeKittyStateTo(13);
                        return;
                    }
                    if (this.field_70146_Z.nextInt(50) == 0) {
                        this.swingArm();
                    }
                    if (this.field_70154_o == null) return;
                    this.field_70177_z = this.field_70154_o.field_70177_z + 90.0f;
                    EntityPlayer playerThatThisKittyIsMountedOn = (EntityPlayer)this.field_70154_o;
                    if (playerThatThisKittyIsMountedOn == null) {
                        this.changeKittyStateTo(13);
                        return;
                    }
                    ItemStack itemstackHeldByPlayer = playerThatThisKittyIsMountedOn.func_70694_bm();
                    if (itemstackHeldByPlayer != null && (itemstackHeldByPlayer == null || itemstackHeldByPlayer.func_77973_b() == Items.field_151058_ca)) return;
                    this.changeKittyStateTo(13);
                    return;
                }
                case 15: {
                    if (this.field_70122_E) {
                        this.changeKittyStateTo(7);
                    }
                    if (this.field_70154_o == null) return;
                    this.field_70177_z = this.field_70154_o.field_70177_z + 90.0f;
                    return;
                }
                case 16: {
                    ++this.kittyTimer;
                    if (this.kittyTimer > 500 && !this.getOnTree()) {
                        this.changeKittyStateTo(7);
                    }
                    if (!this.getOnTree()) {
                        Double distanceToTree;
                        int[] coordinatesOfNearestLogBlock;
                        if (!this.hasFoundTree && this.field_70146_Z.nextInt(50) == 0 && (coordinatesOfNearestLogBlock = MoCTools.ReturnNearestMaterialCoord((Entity)this, Material.field_151575_d, 18.0, 4.0))[0] != -1) {
                            for (int index = 0; index < 20; ++index) {
                                Block blockThatIsNearLogBlock = this.field_70170_p.func_147439_a(coordinatesOfNearestLogBlock[0], coordinatesOfNearestLogBlock[1] + index, coordinatesOfNearestLogBlock[2]);
                                if (blockThatIsNearLogBlock.func_149688_o() != Material.field_151584_j) continue;
                                this.hasFoundTree = true;
                                this.treeCoord[0] = coordinatesOfNearestLogBlock[0];
                                this.treeCoord[1] = coordinatesOfNearestLogBlock[1];
                                this.treeCoord[2] = coordinatesOfNearestLogBlock[2];
                                break;
                            }
                        }
                        if (!this.hasFoundTree) return;
                        if (this.field_70146_Z.nextInt(10) != 0) return;
                        PathEntity pathEntity = this.field_70170_p.func_72844_a((Entity)this, this.treeCoord[0], this.treeCoord[1], this.treeCoord[2], 24.0f, true, false, false, true);
                        if (pathEntity != null) {
                            this.func_70778_a(pathEntity);
                        }
                        if (!((distanceToTree = Double.valueOf(this.func_70092_e(this.treeCoord[0], this.treeCoord[1], this.treeCoord[2]))) < 7.0)) return;
                        this.setOnTree(true);
                        return;
                    }
                    if (!this.getOnTree()) return;
                    int treeCoordX = this.treeCoord[0];
                    int treeCoordY = this.treeCoord[1];
                    int treeCoordZ = this.treeCoord[2];
                    MoCTools.faceItem((Entity)this, treeCoordX, treeCoordY, treeCoordZ, 30.0f);
                    if (treeCoordY - MathHelper.func_76128_c((double)this.field_70163_u) > 2) {
                        this.field_70181_x += 0.03;
                    }
                    if (this.field_70165_t < (double)treeCoordX) {
                        MathHelper.func_76128_c((double)this.field_70165_t);
                        this.field_70159_w += 0.01;
                    } else {
                        MathHelper.func_76128_c((double)this.field_70165_t);
                        this.field_70159_w -= 0.01;
                    }
                    if (this.field_70161_v < (double)treeCoordZ) {
                        MathHelper.func_76128_c((double)this.field_70161_v);
                        this.field_70179_y += 0.01;
                    } else {
                        MathHelper.func_76128_c((double)this.field_70165_t);
                        this.field_70179_y -= 0.01;
                    }
                    if (this.field_70122_E || !this.field_70123_F) return;
                    if (!this.field_70124_G) return;
                    for (int i4 = 0; i4 < 30; ++i4) {
                        Block block = this.field_70170_p.func_147439_a(this.treeCoord[0], this.treeCoord[1] + i4, this.treeCoord[2]);
                        if (block != Blocks.field_150350_a) continue;
                        this.func_70012_b(this.treeCoord[0], this.treeCoord[1] + i4, this.treeCoord[2], this.field_70177_z, this.field_70125_A);
                        this.changeKittyStateTo(17);
                        this.treeCoord[0] = -1;
                        this.treeCoord[1] = -1;
                        this.treeCoord[2] = -1;
                        return;
                    }
                    return;
                }
                case 17: {
                    EntityPlayer closestPlayerNearby = this.field_70170_p.func_72890_a((Entity)this, 2.0);
                    if (closestPlayerNearby == null) return;
                    this.changeKittyStateTo(7);
                    return;
                }
                case 18: {
                    if (this.field_70789_a == null || !(this.field_70789_a instanceof MoCEntityKitty)) {
                        this.changeKittyStateTo(9);
                        return;
                    }
                    MoCEntityKitty otherKittyToMateWith = (MoCEntityKitty)this.field_70789_a;
                    if (otherKittyToMateWith != null && otherKittyToMateWith.getKittyState() == 18) {
                        float distanceToOtherKittyToMateWith;
                        if (this.field_70146_Z.nextInt(50) == 0) {
                            this.swingArm();
                        }
                        if ((distanceToOtherKittyToMateWith = this.func_70032_d((Entity)otherKittyToMateWith)) < 5.0f) {
                            ++this.kittyTimer;
                        }
                        if (this.kittyTimer <= 500 || this.field_70146_Z.nextInt(50) != 0) return;
                        ((MoCEntityKitty)this.field_70789_a).changeKittyStateTo(7);
                        this.changeKittyStateTo(19);
                        return;
                    }
                    this.changeKittyStateTo(9);
                    return;
                }
                case 19: {
                    if (this.field_70146_Z.nextInt(20) != 0) return;
                    MoCEntityKittyBed kittyBedNearby = (MoCEntityKittyBed)this.findKittyStuffNearby((Entity)this, 18.0, false);
                    if (kittyBedNearby == null) return;
                    if (kittyBedNearby.field_70153_n != null) return;
                    float distanceToKittyBedNearby = kittyBedNearby.func_70032_d((Entity)this);
                    if (distanceToKittyBedNearby > 2.0f) {
                        this.getMyOwnPath((Entity)kittyBedNearby, distanceToKittyBedNearby);
                    }
                    if (!(distanceToKittyBedNearby < 2.0f)) return;
                    this.changeKittyStateTo(20);
                    this.func_70078_a((Entity)kittyBedNearby);
                    return;
                }
                case 20: {
                    if (this.field_70154_o == null) {
                        this.changeKittyStateTo(19);
                        return;
                    }
                    this.field_70177_z = 180.0f;
                    ++this.kittyTimer;
                    if (this.kittyTimer <= 1000) return;
                    MoCEntityKitty entityKittyToSpawn = new MoCEntityKitty(this.field_70170_p);
                    int babyType = this.getType();
                    if (this.field_70146_Z.nextInt(2) == 0) {
                        babyType = this.field_70146_Z.nextInt(8) + 1;
                    }
                    entityKittyToSpawn.setType(babyType);
                    entityKittyToSpawn.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityKittyToSpawn);
                    entityKittyToSpawn.setAdult(false);
                    entityKittyToSpawn.changeKittyStateTo(10);
                    EntityPlayerMP ownerOfKittyThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName());
                    if (ownerOfKittyThatIsOnline != null) {
                        MoCTools.tameWithName((EntityPlayer)ownerOfKittyThatIsOnline, entityKittyToSpawn);
                    }
                    this.changeKittyStateTo(21);
                    return;
                }
                case 21: {
                    ++this.kittyTimer;
                    if (this.kittyTimer > 2000) {
                        List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(24.0, 8.0, 24.0));
                        int numberOfKittensNearby = 0;
                        for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
                            Entity entity2 = (Entity)listOfEntitiesNearby.get(index);
                            if (!(entity2 instanceof MoCEntityKitty) || ((MoCEntityKitty)entity2).getKittyState() != 10) continue;
                            ++numberOfKittensNearby;
                        }
                        if (numberOfKittensNearby < 1) {
                            this.changeKittyStateTo(7);
                            return;
                        }
                        this.kittyTimer = 1000;
                    }
                    if (this.field_70789_a == null || !(this.field_70789_a instanceof EntityPlayer) || this.field_70146_Z.nextInt(300) != 0) return;
                    this.field_70789_a = null;
                    return;
                }
                case 0: {
                    this.changeKittyStateTo(1);
                    return;
                }
                default: {
                    this.changeKittyStateTo(7);
                    return;
                }
            }
        } else {
            super.func_70636_d();
        }
    }

    public boolean isOnPlayersBack() {
        return this.getKittyState() == 15;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsSwinging()) {
            this.field_70733_aJ += 0.2f;
            if (this.field_70733_aJ > 2.0f) {
                this.setSwinging(false);
                this.field_70733_aJ = 0.0f;
            }
        }
    }

    private boolean isPickable() {
        return this.getKittyState() != 13 && this.getKittyState() != 14 && this.getKittyState() != 15 && this.getKittyState() != 19 && this.getKittyState() != 20 && this.getKittyState() != 21;
    }

    private boolean isItemStackInRawFishOreDictionary(ItemStack itemStack) {
        if (itemStack != null) {
            itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.getKittyState() != 14 && this.getKittyState() != 15 && this.getKittyState() > 1;
    }

    @Override
    public void func_70106_y() {
        if (MoCreatures.isServer() && this.getKittyState() > 2 && this.func_110143_aJ() > 0.0f && !MoCreatures.isMobConfinementLoaded) {
            return;
        }
        super.func_70106_y();
    }

    public void swingArm() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        if (!this.getIsSwinging()) {
            this.setSwinging(true);
            this.field_70733_aJ = 0.0f;
        }
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || !(entity instanceof EntityLiving) || entity instanceof MoCEntityKitty || entity instanceof EntityPlayer || entity instanceof IMob || entity instanceof MoCEntityMob || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityRay || (double)entity.field_70130_N > 0.5 && (double)entity.field_70131_O > 0.5 || MoCTools.isEntityAFishThatIsInTheOcean(entity);
    }

    @Override
    public void performAnimation(int i) {
        this.swingArm();
    }

    public boolean isUpsideDown() {
        return this.getKittyState() == 14;
    }

    public boolean isWhipeable() {
        return this.getKittyState() != 13;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setSitting(nbtTagCompound.func_74767_n("Sitting"));
        this.setKittyState(nbtTagCompound.func_74762_e("KittyState"));
        this.setDisplayName(nbtTagCompound.func_74767_n("DisplayName"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Sitting", this.getIsSitting());
        nbtTagCompound.func_74768_a("KittyState", this.getKittyState());
        nbtTagCompound.func_74757_a("DisplayName", this.getShouldDisplayName());
    }

    @Override
    public boolean updateMount() {
        return true;
    }

    @Override
    public boolean forceUpdates() {
        return true;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (MoCreatures.isServer() && this.getIsTamed()) {
            MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.medallion, 1));
        }
        super.func_70645_a(damageSource);
    }

    private boolean isNight() {
        return !this.field_70170_p.func_72935_r();
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }
}

