/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MoCEntityCrocodile
extends MoCEntityTameableAnimal {
    public float biteProgress;
    public int spinInt;
    private boolean waterbound;
    private int hunting;
    private float spinAttackStrength;
    private int attackSpeedWhenCaughtPreyInMouth;

    public MoCEntityCrocodile(World world) {
        super(world);
        this.texture = "crocodile.png";
        this.func_70105_a(2.0f, 0.6f);
        this.setMoCAge(50 + this.field_70146_Z.nextInt(50));
        this.setTamed(false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    public boolean getIsBiting() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getIsResting() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public boolean getHasCaughtPrey() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setBiting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setIsResting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void setHasCaughtPrey(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    protected void func_70664_aZ() {
        if (this.func_70055_a(Material.field_151586_h)) {
            if (this.getHasCaughtPrey() || this.field_70789_a == null && this.field_70146_Z.nextInt(20) != 0) {
                return;
            }
            this.field_70181_x = 0.3;
            if (this.func_70051_ag()) {
                float f = this.field_70177_z * 0.01745329f;
                this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
            }
            this.field_70160_al = true;
        } else if (this.field_70789_a != null || this.getHasCaughtPrey()) {
            super.func_70664_aZ();
        }
    }

    protected boolean func_70780_i() {
        return this.getIsResting();
    }

    @Override
    protected void func_70626_be() {
        if (!this.getIsResting()) {
            super.func_70626_be();
        }
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }

    @Override
    public void func_70636_d() {
        if (this.getIsResting()) {
            this.field_70125_A = -5.0f;
            if (!this.func_70055_a(Material.field_151586_h) && this.biteProgress < 0.3f && this.field_70146_Z.nextInt(5) == 0) {
                this.biteProgress += 0.005f;
            }
            this.field_70789_a = this.func_70782_k();
            if (this.field_70789_a != null) {
                this.setIsResting(false);
                this.getMyOwnPath(this.field_70789_a, 16.0f);
            }
            if (MoCreatures.isServer() && this.field_70789_a != null || this.getHasCaughtPrey() || this.field_70146_Z.nextInt(500) == 0) {
                this.setIsResting(false);
                this.biteProgress = 0.0f;
                this.hunting = 1;
            }
        } else if (MoCreatures.isServer() && this.field_70146_Z.nextInt(500) == 0 && this.field_70789_a == null && !this.getHasCaughtPrey() && !this.func_70090_H()) {
            this.setIsResting(true);
            this.func_70778_a(null);
        }
        if (this.func_70055_a(Material.field_151586_h)) {
            // empty if block
        }
        if (this.hunting > 0) {
            ++this.hunting;
            if (this.hunting > 120) {
                this.hunting = 0;
            }
            if (this.field_70789_a == null) {
                this.hunting = 0;
            }
        }
        if (this.field_70146_Z.nextInt(80) == 0 && !this.getHasCaughtPrey() && !this.getIsResting()) {
            this.crocBite();
        }
        if (MoCreatures.isServer() && this.field_70146_Z.nextInt(500) == 0 && !this.waterbound && !this.getIsResting() && !this.func_70055_a(Material.field_151586_h)) {
            MoCTools.moveToWater((EntityCreature)this);
        }
        if (MoCreatures.isServer() && this.getMoCAge() < 150 && this.field_70146_Z.nextInt(200) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 90) {
                this.setAdult(true);
            }
        }
        if (this.waterbound) {
            if (!this.func_70055_a(Material.field_151586_h)) {
                MoCTools.moveToWater((EntityCreature)this);
            } else {
                this.waterbound = false;
            }
        }
        if (this.getHasCaughtPrey()) {
            if (this.field_70153_n != null) {
                this.field_70789_a = null;
                this.biteProgress = 0.4f;
                this.setIsResting(false);
                if (!this.func_70055_a(Material.field_151586_h)) {
                    this.waterbound = true;
                    if (this.field_70153_n instanceof EntityLiving && ((EntityLivingBase)this.field_70153_n).func_110143_aJ() > 0.0f) {
                        ((EntityLivingBase)this.field_70153_n).field_70725_aQ = 0;
                    }
                    this.attackSpeedWhenCaughtPreyInMouth = this.getMoCAge() < 90 ? 15 : 5;
                    if (MoCreatures.isServer() && this.field_70146_Z.nextInt(this.attackSpeedWhenCaughtPreyInMouth) == 0) {
                        this.field_70153_n.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
                    }
                }
            } else {
                this.setHasCaughtPrey(false);
                MoCTools.checkForTwistedEntities(this.field_70170_p);
                this.biteProgress = 0.0f;
                this.waterbound = false;
            }
            if (this.isSpinning()) {
                this.spinAttackStrength = this.getMoCAge() < 90 ? 2.0f : 7.0f;
                this.spinInt += 3;
                if (this.spinInt % 10 == 0) {
                    this.func_85030_a("mocreatures:crocroll", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                }
                if (this.spinInt > 40) {
                    this.spinInt = 0;
                    this.field_70153_n.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.spinAttackStrength);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    public void crocBite() {
        if (!this.getIsBiting()) {
            this.setBiting(true);
            this.biteProgress = 0.0f;
        }
    }

    public void func_70071_h_() {
        if (this.getIsBiting() && !this.getHasCaughtPrey()) {
            this.biteProgress += 0.1f;
            if (this.biteProgress == 0.4f) {
                this.func_85030_a("mocreatures:crocjawsnap", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (this.biteProgress > 0.6f) {
                this.setBiting(false);
                this.biteProgress = 0.0f;
            }
        }
        super.func_70071_h_();
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.getIsResting()) {
            this.setIsResting(false);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        if (this.getHasCaughtPrey()) {
            return;
        }
        if (this.field_70724_aR <= 0 && distanceToEntity < 2.5f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            float attackStrength = this.getMoCAge() < 90 ? 2.0f : 10.0f;
            this.field_70724_aR = 20;
            if (entity.field_70154_o == null && this.field_70146_Z.nextInt(3) == 0) {
                entity.func_70078_a((Entity)this);
                this.setHasCaughtPrey(true);
            } else {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackStrength);
                this.crocBite();
                this.setHasCaughtPrey(false);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature;
        if (this.getIsResting()) {
            this.setIsResting(false);
        }
        if (this.field_70153_n != null && (entityThatAttackedThisCreature = damageSource.func_76346_g()) != null && this.field_70153_n == entityThatAttackedThisCreature) {
            if (this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            this.unMount();
        }
        if (super.func_70097_a(damageSource, damageTaken)) {
            entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
                return true;
            }
            if (this.field_70153_n != null && this.field_70153_n == entityThatAttackedThisCreature) {
                if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                    this.field_70789_a = entityThatAttackedThisCreature;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected Entity func_70782_k() {
        if (this.getHasCaughtPrey()) {
            return null;
        }
        if (this.field_70146_Z.nextInt(80) == 0 && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            double attackDistance = 6.0;
            EntityPlayer closestEntityPlayer = this.field_70170_p.func_72856_b((Entity)this, attackDistance);
            if (closestEntityPlayer != null && this.getIsAdult()) {
                return closestEntityPlayer;
            }
            EntityLivingBase closestEntityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, attackDistance);
            if (closestEntityLiving != null && !MoCTools.isEntityAFishThatIsInTheOcean((Entity)closestEntityLiving)) {
                return closestEntityLiving;
            }
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof IMob || entity instanceof MoCEntityMob || entity instanceof EntityPlayer || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof MoCEntityEgg || entity instanceof MoCEntityCrocodile || this.getMoCAge() > 90 && (double)entity.field_70130_N > 1.3 && (double)entity.field_70131_O > 1.3 || this.getMoCAge() < 90 && (double)entity.field_70130_N > 0.5 && (double)entity.field_70131_O > 0.5 || entity instanceof MoCEntityBigCat || entity instanceof MoCEntityAmbient || entity instanceof MoCEntityShark || entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityRay || entity instanceof EntitySquid;
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        double dist = (double)((float)this.getMoCAge() * 0.01f + this.field_70153_n.field_70130_N) - 0.4;
        double newPosX = this.field_70165_t - dist * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
        this.field_70153_n.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), newPosZ);
        ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70177_z;
        ((EntityLivingBase)this.field_70153_n).field_70760_ar = this.field_70177_z;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.35;
    }

    @Override
    public void floatOnWater() {
        if (this.field_70789_a != null && this.field_70789_a.field_70163_u < this.field_70163_u - 0.5 && this.func_70032_d(this.field_70789_a) < 10.0f) {
            if (this.field_70181_x < -0.1) {
                this.field_70181_x = -0.1;
            }
        } else {
            super.floatOnWater();
        }
    }

    protected String func_70673_aS() {
        return "mocreatures:crocdying";
    }

    protected String func_70621_aR() {
        return "mocreatures:crochurt";
    }

    protected String func_70639_aQ() {
        if (this.getIsResting()) {
            return "mocreatures:crocresting";
        }
        return "mocreatures:crocgrunt";
    }

    protected Item func_146068_u() {
        return MoCreatures.hideReptile;
    }

    public boolean isSpinning() {
        return this.getHasCaughtPrey() && this.field_70153_n != null && this.func_70055_a(Material.field_151586_h);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        this.unMount();
        MoCTools.checkForTwistedEntities(this.field_70170_p);
        super.func_70645_a(damageSource);
    }

    public void unMount() {
        if (this.field_70153_n != null) {
            if (this.field_70153_n instanceof EntityLiving && !(this.field_70153_n instanceof EntityPlayer) && ((EntityLivingBase)this.field_70153_n).func_110143_aJ() > 0.0f) {
                ((EntityLivingBase)this.field_70153_n).field_70725_aQ = 0;
            }
            this.field_70153_n.func_70078_a(null);
            this.setHasCaughtPrey(false);
        }
    }

    public int func_70627_aG() {
        return 120;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
    }
}

