/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.registry.GameRegistry;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityBunny
extends MoCEntityTameableAnimal {
    public boolean isPickedUp;
    public int bunnyReproduceTickerA;
    public int bunnyReproduceTickerB;

    public MoCEntityBunny(World world) {
        super(world);
        this.setAdult(true);
        this.setTamed(false);
        this.setMoCAge(50);
        this.func_70105_a(0.4f, 0.4f);
        this.bunnyReproduceTickerA = this.field_70146_Z.nextInt(64);
        this.bunnyReproduceTickerB = 0;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public boolean getHasEatenBreedingItem() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setHasEatenBreedingItem(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    @Override
    public float getMoveSpeed() {
        return 1.5f;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(5) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3);
            return true;
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("bunny.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("bunnyb.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("bunnyc.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("bunnyd.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("bunnye.png");
            }
        }
        return MoCreatures.proxy.getTexture("bunny.png");
    }

    protected String func_70673_aS() {
        return "mocreatures:rabbitdeath";
    }

    protected String func_70621_aR() {
        return "mocreatures:rabbithurt";
    }

    protected String func_70639_aQ() {
        return null;
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - 1.3f;
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M + 0.3f;
        }
        return this.field_70129_M;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            if (item == Items.field_151172_bF || item == Items.field_151150_bK || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:beetroot") || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:food") && itemStack.func_77960_j() == 2 || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:food") && itemStack.func_77960_j() == 11 || oreDictionaryNameArray.size() > 0 && oreDictionaryNameArray.contains("listAllveggie")) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    MoCTools.tameWithName(entityPlayer, this);
                }
                if (this.getIsTamed() && !this.getHasEatenBreedingItem()) {
                    this.setHasEatenBreedingItem(true);
                }
                MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                this.func_70691_i(5.0f);
                return true;
            }
        }
        if (this.getIsTamed() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && !entityPlayer.func_70093_af()) {
            this.field_70177_z = entityPlayer.field_70177_z;
            if (this.field_70154_o == null && entityPlayer.field_70154_o == null) {
                if (MoCreatures.isServer()) {
                    this.func_70078_a((Entity)entityPlayer);
                }
                this.isPickedUp = true;
                return true;
            }
            if (this.field_70154_o == entityPlayer) {
                this.func_85030_a("mocreatures:rabbitlift", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                if (MoCreatures.isServer()) {
                    this.func_70078_a(null);
                    this.field_70143_R = -5.0f;
                    this.field_70159_w = entityPlayer.field_70159_w * 5.0;
                    this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.5;
                    this.field_70179_y = entityPlayer.field_70179_y * 5.0;
                }
                this.isPickedUp = false;
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_70636_d() {
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 100) {
                this.setAdult(true);
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (MoCreatures.isServer()) {
            if (!(this.getIsTamed() && this.getIsAdult() && this.getHasEatenBreedingItem() && this.field_70154_o == null)) {
                return;
            }
            if (this.bunnyReproduceTickerA < 1023) {
                ++this.bunnyReproduceTickerA;
            } else if (this.bunnyReproduceTickerB < 127) {
                ++this.bunnyReproduceTickerB;
            } else {
                this.tryToFindAdultBunnyNearByAndReproduce();
            }
        }
    }

    private void tryToFindAdultBunnyNearByAndReproduce() {
        List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.0, 4.0, 4.0));
        for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
            Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
            if (!(entityNearby instanceof MoCEntityBunny) || entityNearby == this) continue;
            MoCEntityBunny entityBunnyNearby = (MoCEntityBunny)entityNearby;
            if (entityBunnyNearby.field_70154_o != null || entityBunnyNearby.bunnyReproduceTickerA < 1023 || !entityBunnyNearby.getIsAdult() || !entityBunnyNearby.getHasEatenBreedingItem()) continue;
            MoCEntityBunny entityBunnyBaby = new MoCEntityBunny(this.field_70170_p);
            entityBunnyBaby.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityBunnyBaby.setAdult(false);
            int babyType = this.getType();
            if (this.field_70146_Z.nextInt(2) == 0) {
                babyType = entityBunnyNearby.getType();
            }
            entityBunnyBaby.setType(babyType);
            this.field_70170_p.func_72838_d((Entity)entityBunnyBaby);
            this.proceed();
            entityBunnyNearby.proceed();
            break;
        }
    }

    public void proceed() {
        this.setHasEatenBreedingItem(false);
        this.bunnyReproduceTickerB = 0;
        this.bunnyReproduceTickerA = this.field_70146_Z.nextInt(64);
    }

    @Override
    protected void func_70626_be() {
        EntityPlayer entityPlayer;
        if (this.field_70122_E && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05)) {
            this.field_70181_x = 0.45;
            this.field_70143_R = -5.0f;
        }
        if (this.isPickedUp && this.field_70154_o instanceof EntityPlayer && (entityPlayer = (EntityPlayer)this.field_70154_o) != null) {
            this.field_70177_z = entityPlayer.field_70177_z;
        }
        if (!this.isPickedUp) {
            super.func_70626_be();
        } else if (this.field_70122_E && this.field_70154_o == null) {
            this.isPickedUp = false;
            this.func_85030_a("mocreatures:rabbitland", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(12.0, 12.0, 12.0));
            for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
                Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
                if (!(entityNearby instanceof EntityMob)) continue;
                EntityMob entityMob = (EntityMob)entityNearby;
                entityMob.func_70624_b((EntityLivingBase)this);
            }
        }
    }

    protected void func_70628_a(boolean hasEntityBeenHitByPlayer, int levelOfLootingEnchantmentUsedToKillThisEntity) {
        int randomAmount = this.field_70146_Z.nextInt(2);
        if (MoCreatures.isEtFuturumRequiemLoaded) {
            this.func_145779_a(GameRegistry.findItem((String)"etfuturum", (String)"rabbit_hide"), randomAmount);
            if (this.func_70027_ad()) {
                this.func_145779_a(GameRegistry.findItem((String)"etfuturum", (String)"rabbit_cooked"), randomAmount);
            } else {
                this.func_145779_a(GameRegistry.findItem((String)"etfuturum", (String)"rabbit_raw"), randomAmount);
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.func_145779_a(GameRegistry.findItem((String)"etfuturum", (String)"rabbit_foot"), 1);
            }
        } else {
            this.func_145779_a(MoCreatures.fur, randomAmount);
        }
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public double roperYOffset() {
        return 0.9;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer() && this.field_70154_o != null && (damageSource.func_76346_g() == this.field_70154_o || DamageSource.field_76368_d.equals(damageSource))) {
            return false;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }
}

