/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.entity.animal.MoCEntityElephant;
import drzhark.mocreatures.entity.animal.MoCEntityWyvern;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityBigCat
extends MoCEntityTameableAnimal {
    public MoCEntityBigCat(World world) {
        super(world);
        this.setMoCAge(35);
        this.func_70105_a(0.9f, 1.3f);
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.setAdult(false);
        } else {
            this.setAdult(true);
        }
        this.setHungry(true);
        this.setTamed(false);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0 && this.checkSpawningBiome()) {
            this.setType(1);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_70606_j(this.func_110138_aP());
    }

    @Override
    public float getMoveSpeed() {
        switch (this.getType()) {
            case 1: {
                return 1.4f;
            }
            case 2: {
                return 1.4f;
            }
            case 3: {
                return 1.6f;
            }
            case 4: {
                return 1.9f;
            }
            case 5: {
                return 1.6f;
            }
            case 6: {
                return 1.7f;
            }
            case 7: {
                return 1.7f;
            }
        }
        return 1.4f;
    }

    public float calculateMaxHealth() {
        switch (this.getType()) {
            case 1: {
                return 25.0f;
            }
            case 2: {
                return 30.0f;
            }
            case 3: {
                return 20.0f;
            }
            case 4: {
                return 20.0f;
            }
            case 5: {
                return 35.0f;
            }
            case 6: {
                return 25.0f;
            }
            case 7: {
                return 40.0f;
            }
        }
        return 20.0f;
    }

    public float getWidthF() {
        switch (this.getType()) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.1f;
            }
            case 3: {
                return 0.9f;
            }
            case 4: {
                return 0.8f;
            }
            case 5: {
                return 1.1f;
            }
            case 6: {
                return 0.8f;
            }
            case 7: {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    public float getHeightF() {
        switch (this.getType()) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.1f;
            }
            case 3: {
                return 0.9f;
            }
            case 4: {
                return 0.8f;
            }
            case 5: {
                return 1.1f;
            }
            case 6: {
                return 0.8f;
            }
            case 7: {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    public float getLengthF() {
        switch (this.getType()) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 0.9f;
            }
            case 4: {
                return 1.0f;
            }
            case 5: {
                return 1.1f;
            }
            case 6: {
                return 0.9f;
            }
            case 7: {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    public int getAttackStrength() {
        switch (this.getType()) {
            case 1: {
                return 5;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 8;
            }
        }
        return 5;
    }

    public double getAttackRange() {
        switch (this.getType()) {
            case 1: {
                return 8.0;
            }
            case 2: {
                return 4.0;
            }
            case 3: {
                return 6.0;
            }
            case 4: {
                return 6.0;
            }
            case 5: {
                return 8.0;
            }
            case 6: {
                return 4.0;
            }
            case 7: {
                return 10.0;
            }
        }
        return 6.0;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("lionf.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("lionf.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("panther.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("cheetah.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("tiger.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("leopard.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("tigerw.png");
            }
        }
        return MoCreatures.proxy.getTexture("lionf.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public boolean getIsHungry() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getPreTamed() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public boolean getIsSitting() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setHungry(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setPreTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void setSitting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(50) == 0) {
            if (this.field_70122_E) {
                double xDistance = entity.field_70165_t - this.field_70165_t;
                double zDistance = entity.field_70161_v - this.field_70161_v;
                float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
                this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70159_w * 0.2;
                this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70179_y * 0.2;
                this.field_70181_x = 0.4;
            }
            return;
        }
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
                this.field_70789_a = entityThatAttackedThisCreature;
                if (!this.getIsAdult() && entityThatAttackedThisCreature != null && !this.getIsTamed()) {
                    List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                    for (int index = 0; index < entitiesNearbyList.size(); ++index) {
                        Entity entity1 = (Entity)entitiesNearbyList.get(index);
                        if (!(entity1 instanceof MoCEntityBigCat)) continue;
                        MoCEntityBigCat bigCatEntityNearBy = (MoCEntityBigCat)entity1;
                        if (bigCatEntityNearBy.getIsAdult()) {
                            // empty if block
                        }
                        if (bigCatEntityNearBy.getIsTamed() || bigCatEntityNearBy.getType() != this.getType()) continue;
                        bigCatEntityNearBy.field_70789_a = damageSource.func_76346_g();
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int checkForOtherBigCatsNearbyAndTheirType(double d) {
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d, d, d));
        for (int index = 0; index < entitiesNearbyList.size(); ++index) {
            Entity entityNearby = (Entity)entitiesNearbyList.get(index);
            if (entityNearby == this || !(entityNearby instanceof MoCEntityBigCat)) continue;
            MoCEntityBigCat entitybigcatNearby = (MoCEntityBigCat)entityNearby;
            return entitybigcatNearby.getType();
        }
        return 0;
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.roper != null && this.roper instanceof EntityPlayer) {
            return this.getMastersEnemy((EntityPlayer)this.roper, 12.0);
        }
        if (this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, this.getAttackRange());
            if (!this.getIsTamed() && entityPlayer != null && this.getIsAdult() && this.getIsHungry()) {
                if (this.getType() == 1 || this.getType() == 5 || this.getType() == 7) {
                    this.setHungry(false);
                    return entityPlayer;
                }
                if (this.field_70146_Z.nextInt(30) == 0) {
                    this.setHungry(false);
                    return entityPlayer;
                }
            }
            if (this.field_70146_Z.nextInt(80) == 0 && this.getIsHungry()) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, this.getAttackRange());
                this.setHungry(false);
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        int typeChance = this.field_70146_Z.nextInt(100);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            if (!currentBiome.field_76791_y.toLowerCase().contains("outback")) {
                if (typeChance <= 30) {
                    this.setType(4);
                } else if (typeChance <= 40) {
                    this.setType(2);
                } else {
                    this.setType(1);
                }
            } else {
                return false;
            }
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            if (typeChance <= 10) {
                this.setType(7);
            } else if (typeChance <= 30) {
                this.setType(3);
            } else {
                this.setType(5);
            }
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(6);
            return true;
        }
        int typeOfOtherBigCatNearby = 0;
        typeOfOtherBigCatNearby = this.checkForOtherBigCatsNearbyAndTheirType(12.0);
        if (typeOfOtherBigCatNearby == 2) {
            typeOfOtherBigCatNearby = 1;
        } else if (typeOfOtherBigCatNearby == 1 && this.field_70146_Z.nextInt(3) == 0) {
            typeOfOtherBigCatNearby = 2;
        } else if (typeOfOtherBigCatNearby == 7) {
            typeOfOtherBigCatNearby = 5;
        }
        this.setType(typeOfOtherBigCatNearby);
        return true;
    }

    public boolean NearSnowWithDistance(Entity entity, Double double1) {
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(double1.doubleValue(), double1.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == Blocks.field_150350_a || block.func_149688_o() != Material.field_151597_y) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntityBigCat || this.getIsAdult() && (double)entity.field_70130_N > 1.3 && (double)entity.field_70131_O > 1.3 || !this.getIsAdult() && (double)entity.field_70130_N > 0.5 && (double)entity.field_70131_O > 0.5 || entity == entity.field_70153_n || entity == entity.field_70154_o || entity instanceof MoCEntityAmbient || entity instanceof MoCEntityWyvern || entity instanceof MoCEntityAquatic || entity instanceof MoCEntityTameableAquatic || entity instanceof EntitySquid || entity instanceof MoCEntityElephant || entity instanceof EntityMob && (!this.getIsTamed() || !this.getIsAdult());
    }

    protected String func_70673_aS() {
        if (this.getIsAdult()) {
            return "mocreatures:liondeath";
        }
        return "mocreatures:cubdying";
    }

    protected Item func_146068_u() {
        return MoCreatures.bigcatClaw;
    }

    protected String func_70621_aR() {
        if (this.getIsAdult()) {
            return "mocreatures:lionhurt";
        }
        return "mocreatures:cubhurt";
    }

    protected String func_70639_aQ() {
        if (this.getIsAdult()) {
            return "mocreatures:liongrunt";
        }
        return "mocreatures:cubgrunt";
    }

    public EntityCreature getMastersEnemy(EntityPlayer entityPlayer, double d) {
        EntityCreature entitycreature = null;
        List list = this.field_70170_p.func_72839_b((Entity)entityPlayer, this.field_70121_D.func_72314_b(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            EntityCreature entitycreature1;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityCreature) || entity == this || (entitycreature1 = (EntityCreature)entity) == null || entitycreature1.func_70638_az() != entityPlayer) continue;
            return entitycreature1;
        }
        return entitycreature;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && !this.getIsTamed() && this.getPreTamed() && itemStack.func_77973_b() == MoCreatures.medallion) {
            if (MoCreatures.isServer()) {
                MoCTools.tameWithName(entityPlayer, this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_big_cat, 1);
            }
            if (this.getIsTamed() && --itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                return true;
            }
            return false;
        }
        if (itemStack != null && this.getIsTamed() && this.isMyHealFood(itemStack)) {
            this.func_70691_i(5.0f);
            this.func_85030_a("mocreatures:eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.setHungry(false);
        }
        return false;
    }

    protected boolean func_70780_i() {
        return this.getIsSitting();
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult() && this.getType() == 2) {
            return -80;
        }
        return -60;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (MoCreatures.isServer() && this.getIsTamed()) {
            MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.medallion, 1));
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(300) == 0 && this.func_110143_aJ() <= this.func_110138_aP() && this.field_70725_aQ == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        if (!this.getIsAdult() && this.field_70146_Z.nextInt(250) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 100) {
                int typeThatBabyLionGrowsUpToBe;
                this.setAdult(true);
                if (this.getType() == 1 && (typeThatBabyLionGrowsUpToBe = this.field_70146_Z.nextInt(2) + 1) != 1) {
                    this.setType(typeThatBabyLionGrowsUpToBe);
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
                    this.func_70606_j(this.func_110138_aP());
                }
            }
        }
        if (!this.getIsHungry() && !this.getIsSitting() && this.field_70146_Z.nextInt(200) == 0) {
            this.setHungry(true);
        }
        if (this.roper != null) {
            float f = this.roper.func_70032_d((Entity)this);
            if (f > 5.0f && !this.getIsSitting()) {
                this.getPathOrWalkableBlock((Entity)this.roper, f);
            }
            if (f > 18.0f & this.getIsSitting()) {
                this.roper = null;
            }
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151147_al || item == Items.field_151082_bd || item == Items.field_151076_bf || item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || item == MoCreatures.ostrichRaw || item == MoCreatures.turkeyRaw || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:rabbit_raw") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllmeatraw") || oreDictionaryNameArray.contains("listAllfishraw") || MoCreatures.isGregTech6Loaded && oreDictionaryNameArray.contains("foodScrapmeat"));
        }
        return false;
    }

    @Override
    public boolean func_70601_bi() {
        if (!MoCreatures.isBiomesOPlentyLoaded || MoCreatures.isBiomesOPlentyLoaded && this.checkSpawningBiome()) {
            return super.func_70601_bi();
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public boolean shouldRenderName() {
        return !this.getName().isEmpty() && this.getShouldDisplayName() && MoCreatures.proxy.getDisplayPetName();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setSitting(nbtTagCompound.func_74767_n("Sitting"));
        this.setDisplayName(nbtTagCompound.func_74767_n("DisplayName"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Sitting", this.getIsSitting());
        nbtTagCompound.func_74757_a("DisplayName", this.getShouldDisplayName());
    }

    @Override
    public void dropMyStuff() {
    }
}

