/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ambient;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityInsect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;

public class MoCEntityCricket
extends MoCEntityInsect {
    private int jumpCounter;
    private int soundCounter;

    public MoCEntityCricket(World world) {
        super(world);
        this.texture = "cricketa.png";
    }

    protected void func_70626_be() {
        if (this.jumpCounter == 0 && this.field_70122_E && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05)) {
            this.field_70181_x = 0.45;
            this.field_70159_w *= 5.0;
            this.field_70179_y *= 5.0;
            this.jumpCounter = 1;
        }
        super.func_70626_be();
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 50) {
                this.setType(1);
            } else {
                this.setType(2);
            }
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            this.setType(2);
            return true;
        }
        this.setType(1);
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.getType() == 1) {
            return MoCreatures.proxy.getTexture("cricketa.png");
        }
        return MoCreatures.proxy.getTexture("cricketb.png");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            EntityPlayer entityPlayer;
            if (this.getIsFlying() && this.field_70146_Z.nextInt(50) == 0) {
                this.setIsFlying(false);
            }
            if (this.getIsFlying() || !this.field_70122_E) {
                EntityPlayer entityPlayer2 = this.field_70170_p.func_72890_a((Entity)this, 5.0);
                if (entityPlayer2 != null && --this.soundCounter == -1) {
                    MoCTools.playCustomSound((Entity)this, "cricketfly", this.field_70170_p);
                    this.soundCounter = 10;
                }
            } else if (!DimensionManager.getWorld((int)0).func_72935_r() && (entityPlayer = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null && --this.soundCounter == -1) {
                MoCTools.playCustomSound((Entity)this, "cricket", this.field_70170_p);
                this.soundCounter = 20;
            }
            if (this.jumpCounter > 0 && ++this.jumpCounter > 30) {
                this.jumpCounter = 0;
            }
        }
    }

    @Override
    protected float getFlyingSpeed() {
        return 0.4f;
    }

    @Override
    protected float getWalkingSpeed() {
        return 0.5f;
    }
}

