/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHealth;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class MoCEntityMob
extends EntityMob
implements IMoCEntity {
    protected boolean divePending;
    protected int maxHealth;
    private PathEntity entitypath;
    public EntityLiving roper;
    protected float moveSpeed;
    protected String texture;
    private boolean hasKilledPrey = false;

    public MoCEntityMob(World world) {
        super(world);
        this.setTamed(false);
        this.texture = "blank.jpg";
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        this.selectType();
        return super.func_110161_a(entityLivingData);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    protected double getAttackStrength() {
        return 2.0;
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    @Override
    public int getType() {
        return this.field_70180_af.func_75679_c(19);
    }

    public boolean getShouldDisplayName() {
        return this.getName() != null && !this.getName().equals("");
    }

    @Override
    public boolean getIsAdult() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    @Override
    public boolean getIsTamed() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    @Override
    public String getName() {
        return this.field_70180_af.func_75681_e(17);
    }

    @Override
    public int getMoCAge() {
        return this.field_70180_af.func_75679_c(18);
    }

    @Override
    public void setMoCAge(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    @Override
    public void setAdult(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(15, (Object)input);
    }

    @Override
    public void setName(String name) {
        this.field_70180_af.func_75692_b(17, (Object)String.valueOf(name));
    }

    @Override
    public void setTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(16, (Object)input);
    }

    public boolean getCanSpawnHereLiving() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public boolean getCanSpawnHereCreature() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.func_70783_a(xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v)) >= 0.0f;
    }

    public boolean func_70601_bi() {
        return MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && super.func_70601_bi();
    }

    public boolean getCanSpawnHereMob() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(xCoordinate, yCoordinate, zCoordinate);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(xCoordinate, yCoordinate, zCoordinate);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof MoCEntityEgg || entity instanceof EntityPlayer && this.getIsTamed() || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof MoCEntityAnimal && ((MoCEntityAnimal)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof MoCEntityAnimal || entity instanceof MoCEntityAmbient;
    }

    public boolean isPredator() {
        return false;
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        if (this.isPredator() && MoCreatures.proxy.destroyDrops && !(entityLiving instanceof EntityPlayer) && !(entityLiving instanceof EntityMob)) {
            this.hasKilledPrey = true;
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void func_70636_d() {
        if (MoCreatures.isServer() && this.forceUpdates() && this.field_70146_Z.nextInt(1000) == 0) {
            MoCTools.forceDataSync(this);
        }
        if (MoCreatures.isServer() && this.getIsTamed() && this.field_70146_Z.nextInt(200) == 0) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHealth(this.func_145782_y(), this.func_110143_aJ()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        if (this.isPredator() && this.hasKilledPrey) {
            List entitiesNearbyList;
            int iterationLength;
            if (MoCreatures.proxy.destroyDrops && (iterationLength = (entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(3.0, 3.0, 3.0))).size()) > 0) {
                for (int index = 0; index < iterationLength; ++index) {
                    EntityItem entityItem;
                    Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                    if (!(entityNearby instanceof EntityItem) || (entityItem = (EntityItem)entityNearby) == null || entityItem.field_70292_b >= 5) continue;
                    entityItem.func_70106_y();
                }
            }
            this.func_70691_i(5.0f);
            this.hasKilledPrey = false;
        }
        this.moveSpeed = this.getMoveSpeed();
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer() && this.getIsTamed()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHealth(this.func_145782_y(), this.func_110143_aJ()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public boolean isFlyer() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Tamed", this.getIsTamed());
        nbtTagCompound.func_74757_a("Adult", this.getIsAdult());
        nbtTagCompound.func_74768_a("Age", this.getMoCAge());
        nbtTagCompound.func_74778_a("Name", this.getName());
        nbtTagCompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setTamed(nbtTagCompound.func_74767_n("Tamed"));
        this.setAdult(nbtTagCompound.func_74767_n("Adult"));
        this.setMoCAge(nbtTagCompound.func_74762_e("Age"));
        this.setName(nbtTagCompound.func_74779_i("Name"));
        this.setType(nbtTagCompound.func_74762_e("TypeInt"));
    }

    protected void func_70069_a(float f) {
        if (!this.isFlyer()) {
            super.func_70069_a(f);
        }
    }

    protected Entity func_70782_k() {
        if (this.isFlyer()) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 20.0);
            if (entityPlayer != null && this.func_70685_l((Entity)entityPlayer)) {
                return entityPlayer;
            }
            return null;
        }
        return super.func_70782_k();
    }

    public boolean func_70617_f_() {
        if (this.isFlyer()) {
            return false;
        }
        return super.func_70617_f_();
    }

    public void func_70612_e(float f, float f1) {
        if (!this.isFlyer()) {
            super.func_70612_e(f, f1);
            return;
        }
        if (this.func_70072_I()) {
            this.func_70060_a(f, f1, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_70058_J()) {
            this.func_70060_a(f, f1, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.5460001f;
                Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (block != Blocks.field_150350_a) {
                    f2 = block.field_149765_K * 0.91f;
                }
            }
            float f3 = 0.162771f / (f2 * f2 * f2);
            this.func_70060_a(f, f1, this.field_70122_E ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.5460001f;
                Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (block != Blocks.field_150350_a) {
                    f2 = block.field_149765_K * 0.91f;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            if (this.field_70123_F) {
                this.field_70181_x = 0.2;
            }
            if (this.field_70789_a != null && this.field_70789_a.field_70163_u < this.field_70163_u && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = -0.25;
            }
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d2 = this.field_70165_t - this.field_70169_q;
        double d3 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    protected void func_70626_be() {
        if (!this.isFlyer()) {
            super.func_70626_be();
            return;
        }
        this.field_70787_b = false;
        float f = 16.0f;
        if (this.field_70789_a == null) {
            this.field_70789_a = this.func_70782_k();
            if (this.field_70789_a != null) {
                this.entitypath = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, f, true, false, false, true);
            }
        } else if (!this.field_70789_a.func_70089_S()) {
            this.field_70789_a = null;
        } else {
            float f1 = this.field_70789_a.func_70032_d((Entity)this);
            if (this.func_70685_l(this.field_70789_a)) {
                this.func_70785_a(this.field_70789_a, f1);
            }
        }
        if (!(this.field_70787_b || this.field_70789_a == null || this.entitypath != null && this.field_70146_Z.nextInt(10) != 0)) {
            this.entitypath = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, f, true, false, false, true);
        } else if (this.entitypath == null && this.field_70146_Z.nextInt(80) == 0 || this.field_70146_Z.nextInt(80) == 0) {
            boolean flag = false;
            int j = -1;
            int k = -1;
            int l = -1;
            float f2 = -99999.0f;
            for (int i1 = 0; i1 < 10; ++i1) {
                int l1;
                int k1;
                int j1 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70146_Z.nextInt(13) - 6.0));
                float f3 = this.func_70783_a(j1, k1 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70146_Z.nextInt(7) - 3.0)), l1 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70146_Z.nextInt(13) - 6.0)));
                if (!(f3 > f2)) continue;
                f2 = f3;
                j = j1;
                k = k1;
                l = l1;
                flag = true;
            }
            if (flag) {
                this.entitypath = this.field_70170_p.func_72844_a((Entity)this, j, k, l, 10.0f, true, false, false, true);
            }
        }
        int i = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        boolean flag1 = this.func_70072_I();
        boolean flag2 = this.func_70058_J();
        this.field_70125_A = 0.0f;
        if (this.entitypath == null || this.field_70146_Z.nextInt(100) == 0) {
            super.func_70626_be();
            this.entitypath = null;
            return;
        }
        Vec3 vectorThreeDimensional = this.entitypath.func_75878_a((Entity)this);
        double d = this.field_70130_N * 2.0f;
        while (vectorThreeDimensional != null && vectorThreeDimensional.func_72445_d(this.field_70165_t, vectorThreeDimensional.field_72448_b, this.field_70161_v) < d * d) {
            this.entitypath.func_75875_a();
            if (this.entitypath.func_75879_b()) {
                vectorThreeDimensional = null;
                this.entitypath = null;
                continue;
            }
            vectorThreeDimensional = this.entitypath.func_75878_a((Entity)this);
        }
        this.field_70703_bu = false;
        if (vectorThreeDimensional != null) {
            float amountOfDegreesToChangeRotationYawBy;
            double d1 = vectorThreeDimensional.field_72450_a - this.field_70165_t;
            double d2 = vectorThreeDimensional.field_72449_c - this.field_70161_v;
            double d3 = vectorThreeDimensional.field_72448_b - (double)i;
            float angleInDegreesToNewLocation = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
            this.field_70701_bs = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            for (amountOfDegreesToChangeRotationYawBy = angleInDegreesToNewLocation - this.field_70177_z; amountOfDegreesToChangeRotationYawBy < -180.0f; amountOfDegreesToChangeRotationYawBy += 360.0f) {
            }
            while (amountOfDegreesToChangeRotationYawBy >= 180.0f) {
                amountOfDegreesToChangeRotationYawBy -= 360.0f;
            }
            if (amountOfDegreesToChangeRotationYawBy > 30.0f) {
                amountOfDegreesToChangeRotationYawBy = 30.0f;
            }
            if (amountOfDegreesToChangeRotationYawBy < -30.0f) {
                amountOfDegreesToChangeRotationYawBy = -30.0f;
            }
            this.field_70177_z += amountOfDegreesToChangeRotationYawBy;
            if (this.field_70787_b && this.field_70789_a != null) {
                double xDistance = this.field_70789_a.field_70165_t - this.field_70165_t;
                double zDistance = this.field_70789_a.field_70161_v - this.field_70161_v;
                float previousRotationYaw = this.field_70177_z;
                this.field_70177_z = (float)(Math.atan2(zDistance, xDistance) * 180.0 / Math.PI) - 90.0f;
                float angleInDegreesBetweenPreviousAndNewRotationYaw = (previousRotationYaw - this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f;
                this.field_70702_br = -MathHelper.func_76126_a((float)angleInDegreesBetweenPreviousAndNewRotationYaw) * this.field_70701_bs * 1.0f;
                this.field_70701_bs = MathHelper.func_76134_b((float)angleInDegreesBetweenPreviousAndNewRotationYaw) * this.field_70701_bs * 1.0f;
            }
            if (d3 > 0.0) {
                this.field_70703_bu = true;
            }
        }
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 30.0f, 30.0f);
        }
        if (this.field_70123_F) {
            this.field_70703_bu = true;
        }
        if (this.field_70146_Z.nextFloat() < 0.8f && (flag1 || flag2)) {
            this.field_70703_bu = true;
        }
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public double roperYOffset() {
        return 0.0;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public Entity getRoper() {
        return this.roper;
    }

    @Override
    public boolean updateMount() {
        return false;
    }

    @Override
    public boolean forceUpdates() {
        return false;
    }

    protected Vec3 findPossibleShelter() {
        Random var1 = this.func_70681_au();
        for (int var2 = 0; var2 < 10; ++var2) {
            int var5;
            int var4;
            int var3 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)var1.nextInt(20) - 10.0));
            if (this.field_70170_p.func_72937_j(var3, var4 = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + (double)var1.nextInt(6) - 3.0)), var5 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)var1.nextInt(20) - 10.0))) || !(this.func_70783_a(var3, var4, var5) < 0.0f)) continue;
            return Vec3.func_72443_a((double)var3, (double)var4, (double)var5);
        }
        return null;
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    protected boolean func_70692_ba() {
        return !this.getIsTamed();
    }

    public void func_70106_y() {
        if (MoCreatures.isServer() && this.getIsTamed() && this.func_110143_aJ() > 0.0f && !MoCreatures.isMobConfinementLoaded) {
            return;
        }
        super.func_70106_y();
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathEntity == null && f > 12.0f) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int j = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int k = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.field_70170_p.func_147439_a(i + l, k - 1, j + i1).func_149721_r() || this.field_70170_p.func_147439_a(i + l, k, j + i1).func_149721_r() || this.field_70170_p.func_147439_a(i + l, k + 1, j + i1).func_149721_r()) continue;
                    this.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.func_70778_a(pathEntity);
        }
    }

    @Override
    public String getOwnerName() {
        return "";
    }

    @Override
    public void setOwner(String par1Str) {
    }

    @Override
    public void setArmorType(byte i) {
    }

    public byte getArmorType() {
        return 0;
    }

    @Override
    public void dismountEntity() {
    }

    @Override
    public int pitchRotationOffset() {
        return 0;
    }

    @Override
    public int rollRotationOffset() {
        return 0;
    }

    @Override
    public int yawRotationOffset() {
        return 0;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public void riderIsDisconnecting(boolean flag) {
    }
}

