/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.animal.MoCEntityBird;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.animal.MoCEntityWyvern;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MoCEntityAnimal
extends EntityAnimal
implements IMoCEntity {
    protected boolean divePending;
    protected boolean jumpPending;
    protected int temper;
    protected boolean isEntityJumping;
    public EntityLivingBase roper;
    private PathEntity entitypath;
    protected boolean riderIsDisconnecting;
    public float moveSpeed;
    protected String texture;
    private boolean hasKilledPrey = false;

    public MoCEntityAnimal(World world) {
        super(world);
        this.setTamed(false);
        this.setAdult(true);
        this.riderIsDisconnecting = false;
        this.texture = "blank.jpg";
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        this.selectType();
        return super.func_110161_a(entityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)String.valueOf(""));
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    @Override
    public int getType() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setDisplayName(boolean flag) {
    }

    public boolean getShouldDisplayName() {
        return this.getName() != null && !this.getName().equals("");
    }

    @Override
    public boolean getIsAdult() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    @Override
    public boolean getIsTamed() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    @Override
    public String getName() {
        return this.field_70180_af.func_75681_e(17);
    }

    @Override
    public int getMoCAge() {
        return this.field_70180_af.func_75679_c(18);
    }

    public boolean func_70067_L() {
        return this.field_70153_n == null;
    }

    public boolean func_70104_M() {
        return this.func_70067_L();
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    @Override
    public void setMoCAge(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    @Override
    public void setAdult(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(15, (Object)input);
    }

    @Override
    public void setName(String name) {
        this.field_70180_af.func_75692_b(17, (Object)String.valueOf(name));
    }

    @Override
    public void setTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(16, (Object)input);
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof IMob || entity instanceof MoCEntityMob || entity instanceof EntityPlayer || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity.field_70130_N > this.field_70130_N || entity.field_70131_O > this.field_70131_O || entity instanceof MoCEntityEgg;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    public boolean isPredator() {
        return false;
    }

    public boolean doesForageForFood() {
        return false;
    }

    public void func_70074_a(EntityLivingBase entityLivingThatHasBeenKilled) {
        if (this.isPredator() && MoCreatures.proxy.destroyDrops && !(entityLivingThatHasBeenKilled instanceof EntityPlayer) && !(entityLivingThatHasBeenKilled instanceof EntityMob)) {
            this.hasKilledPrey = true;
        }
    }

    public void func_70636_d() {
        if (MoCreatures.isServer()) {
            EntityItem closestEntityFoodItem;
            if (this.forceUpdates() && this.field_70146_Z.nextInt(500) == 0) {
                MoCTools.forceDataSync(this);
            }
            if (this.isPredator() && this.hasKilledPrey && this.func_110143_aJ() > 0.0f) {
                List entitiesNearbyList;
                int iterationLength;
                if (MoCreatures.proxy.destroyDrops && (iterationLength = (entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(3.0, 3.0, 3.0))).size()) > 0) {
                    for (int index = 0; index < iterationLength; ++index) {
                        EntityItem entityItemNearby;
                        Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                        if (!(entityNearby instanceof EntityItem) || (entityItemNearby = (EntityItem)entityNearby) == null || entityItemNearby.field_70292_b >= 5) continue;
                        entityItemNearby.func_70106_y();
                    }
                }
                this.func_70691_i(5.0f);
                MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                this.hasKilledPrey = false;
                if (this instanceof MoCEntityBigCat) {
                    ((MoCEntityBigCat)this).setHungry(false);
                }
            }
            if (this.doesForageForFood() && this.func_110143_aJ() > 0.0f && !this.func_70780_i() && (this.func_110143_aJ() < this.func_110138_aP() || !this.isPredator() || !this.getIsAdult()) && this.field_70153_n == null && this.field_70154_o == null && (closestEntityFoodItem = this.getClosestFoodEntityItem((Entity)this, 12.0)) != null) {
                float distanceToEntityItem = closestEntityFoodItem.func_70032_d((Entity)this);
                if (this instanceof MoCEntityBird) {
                    MoCEntityBird bird = (MoCEntityBird)this;
                    if (bird.isFleeing) {
                        return;
                    }
                    MoCTools.flyToNextEntity((Entity)bird, (Entity)closestEntityFoodItem);
                    if (distanceToEntityItem < 2.0f && closestEntityFoodItem != null && this.field_70146_Z.nextInt(50) == 0) {
                        closestEntityFoodItem.func_70106_y();
                        this.func_70691_i(5.0f);
                        if (!this.getIsTamed() && this.field_70146_Z.nextInt(3) == 0) {
                            bird.setPreTamed(true);
                        }
                    }
                } else {
                    if (distanceToEntityItem > 2.0f) {
                        this.getMyOwnPath((Entity)closestEntityFoodItem, distanceToEntityItem);
                    }
                    if (distanceToEntityItem < 2.0f && closestEntityFoodItem != null) {
                        closestEntityFoodItem.func_70106_y();
                        this.func_70691_i(5.0f);
                        MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                    }
                    if (this instanceof MoCEntityBigCat && !this.getIsAdult() && !this.getIsTamed() && this.getMoCAge() < 80 && this.field_70146_Z.nextInt(10) == 0) {
                        ((MoCEntityBigCat)this).setPreTamed(true);
                    }
                }
            }
        }
        if (this.isNotScared() && this.field_70788_c > 0) {
            this.field_70788_c = 0;
        }
        if (this.isSwimming() && this.isSwimmerEntity()) {
            this.floatOnWater();
        }
        if (!this.func_70780_i() && this.field_70789_a == null) {
            this.followPlayer();
        }
        this.func_70875_t();
        super.func_70636_d();
    }

    public boolean isNotScared() {
        return false;
    }

    public boolean isSwimmerEntity() {
        return false;
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public void floatOnWater() {
        if (this.field_70181_x < 0.0) {
            this.field_70181_x = 0.0;
        }
        this.field_70181_x += 0.001;
        int yDistanceToSurfaceOfWater = (int)MoCTools.distanceToWaterSurface((Entity)this);
        if (yDistanceToSurfaceOfWater > 1) {
            this.field_70181_x += (double)yDistanceToSurfaceOfWater * 0.07;
        }
        if (this.func_70781_l() && this.field_70123_F) {
            this.func_70664_aZ();
        }
    }

    public boolean isItemEdible(Item item) {
        return item instanceof ItemFood || item instanceof ItemSeeds || item == Items.field_151015_O || item == Items.field_151102_aT || item == Items.field_151105_aU || item == Items.field_151110_aK;
    }

    public boolean isMyAphrodisiac(Item item1) {
        return false;
    }

    public void dropMyStuff() {
    }

    public boolean isMyHealFood(ItemStack itemStack) {
        return false;
    }

    public boolean func_70090_H() {
        if (this.isSwimmerEntity()) {
            return false;
        }
        return super.func_70090_H();
    }

    public boolean func_70648_aU() {
        return this.isSwimmerEntity();
    }

    public EntityItem getClosestEntityItem(Entity entity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityItem entityItem = null;
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof EntityItem)) continue;
                EntityItem entityItemNearby = (EntityItem)entityNearby;
                double overallDistanceSquared = entityItemNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityItem = entityItemNearby;
            }
        }
        return entityItem;
    }

    public EntityItem getClosestFoodEntityItem(Entity entity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityItem entityItem = null;
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                EntityItem entityItemNearby;
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof EntityItem) || (entityItemNearby = (EntityItem)entityNearby).func_92059_d() == null && !this.isItemEdible(entityItemNearby.func_92059_d().func_77973_b()) && !this.isMyHealFood(entityItemNearby.func_92059_d())) continue;
                double overallDistanceSquared = entityItemNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityItem = entityItemNearby;
            }
        }
        return entityItem;
    }

    public void getMyOwnPath(Entity entity, float f) {
        PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathEntity != null) {
            this.func_70778_a(pathEntity);
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathEntity == null && f > 8.0f) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int y = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int z = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            for (int index = 0; index <= 4; ++index) {
                for (int index1 = 0; index1 <= 4; ++index1) {
                    if (index >= 1 && index1 >= 1 && index <= 3 && index1 <= 3 || !this.field_70170_p.func_147439_a(x + index, z - 1, y + index1).func_149721_r() || this.field_70170_p.func_147439_a(x + index, z, y + index1).func_149721_r() || this.field_70170_p.func_147439_a(x + index, z + 1, y + index1).func_149721_r()) continue;
                    this.func_70012_b((float)(x + index) + 0.5f, z, (float)(y + index1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.func_70778_a(pathEntity);
        }
    }

    public MoCEntityAnimal spawnBabyAnimal(EntityAgeable entityAgeable) {
        return null;
    }

    public boolean getCanSpawnHereCreature() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.func_70783_a(xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v)) >= 0.0f;
    }

    public boolean getCanSpawnHereLiving() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public boolean func_70601_bi() {
        int zCoordinate;
        int yCoordinate;
        if (MoCreatures.entityMap.get(this.getClass()).getFrequency() <= 0) {
            return false;
        }
        if (this.field_70170_p.field_73011_w.field_76574_g != 0) {
            return this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving();
        }
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        String biomeName = MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (biomeName.toLowerCase().contains("jungle")) {
            return this.getCanSpawnHereJungle();
        }
        if (biomeName.equals("WyvernBiome")) {
            return this.getCanSpawnHereMoCBiome();
        }
        return super.func_70601_bi();
    }

    private boolean getCanSpawnHereMoCBiome() {
        if (this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
            int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
            int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
            if (yCoordinate < 50) {
                return false;
            }
            Block block = this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate);
            if (block == MoCreatures.mocDirt || block == MoCreatures.mocGrass || block != null && block.isLeaves((IBlockAccess)this.field_70170_p, xCoordinate, yCoordinate - 1, zCoordinate)) {
                return true;
            }
        }
        return false;
    }

    public boolean getCanSpawnHereJungle() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Tamed", this.getIsTamed());
        nbtTagCompound.func_74757_a("Adult", this.getIsAdult());
        nbtTagCompound.func_74768_a("Age", this.getMoCAge());
        nbtTagCompound.func_74778_a("Name", this.getName());
        nbtTagCompound.func_74768_a("TypeInt", this.getType());
        nbtTagCompound.func_74778_a("Owner", this.getOwnerName());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setTamed(nbtTagCompound.func_74767_n("Tamed"));
        this.setAdult(nbtTagCompound.func_74767_n("Adult"));
        this.setMoCAge(nbtTagCompound.func_74762_e("Age"));
        this.setName(nbtTagCompound.func_74779_i("Name"));
        this.setType(nbtTagCompound.func_74762_e("TypeInt"));
        this.setOwner(nbtTagCompound.func_74779_i("Owner"));
    }

    public void func_70612_e(float strafeMovement, float forwardMovement) {
        if (!(this.isFlyer() || this.rideableEntity() && this.field_70153_n != null)) {
            super.func_70612_e(strafeMovement, forwardMovement);
            return;
        }
        float movementSideways = strafeMovement;
        float movementForward = forwardMovement;
        if (this.func_70072_I()) {
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.field_70153_n.field_70179_y * (this.getCustomSpeed() / 2.0);
                movementSideways = (float)((double)(((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f) * (this.getCustomSpeed() / 2.0));
                movementForward = (float)((double)((EntityLivingBase)this.field_70153_n).field_70701_bs * (this.getCustomSpeed() / 2.0));
                if (this.jumpPending && !this.getIsJumping()) {
                    this.field_70181_x = this.getCustomJump() * 2.0;
                    this.setIsJumping(true);
                    this.jumpPending = false;
                }
                if (!this.field_70170_p.field_72995_K) {
                    super.func_70612_e(movementSideways, movementForward);
                }
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.field_70153_n.field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    this.func_85030_a(this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.3;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
                if (this.field_70146_Z.nextInt(25) == 0) {
                    this.setIsJumping(false);
                }
            }
            double yCoordinate = this.field_70163_u;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70060_a(strafeMovement, forwardMovement, 0.02f);
                super.func_70612_e(movementSideways, movementForward);
            }
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + yCoordinate, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else if (this.func_70058_J()) {
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.field_70153_n.field_70179_y * (this.getCustomSpeed() / 2.0);
                movementSideways = (float)((double)(((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f) * (this.getCustomSpeed() / 2.0));
                movementForward = (float)((double)((EntityLivingBase)this.field_70153_n).field_70701_bs * (this.getCustomSpeed() / 2.0));
                if (this.jumpPending && !this.getIsJumping()) {
                    this.field_70181_x = this.getCustomJump();
                    this.jumpPending = false;
                }
                super.func_70612_e(movementSideways, movementForward);
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.field_70153_n.field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    this.func_85030_a(this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.3;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
            }
            double yCoordinate1 = this.field_70163_u;
            this.func_70060_a(strafeMovement, forwardMovement, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + yCoordinate1, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else {
            float acceleration = 0.91f;
            if (this.field_70122_E) {
                acceleration = 0.5460001f;
                Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (block != Blocks.field_150350_a) {
                    acceleration = block.field_149765_K * 0.91f;
                }
            }
            float f3 = 0.162771f / (acceleration * acceleration * acceleration);
            this.func_70060_a(strafeMovement, forwardMovement, this.field_70122_E ? 0.1f * f3 : 0.02f);
            if (this.func_70617_f_()) {
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            if (this.field_70153_n != null && !this.getIsTamed()) {
                if (this.field_70146_Z.nextInt(5) == 0 && !this.getIsJumping() && this.field_70181_x < 0.0 && this.field_70181_x > -0.2) {
                    this.field_70181_x = this.getCustomJump();
                    this.setIsJumping(true);
                }
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                    this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                    this.func_85030_a(this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.9;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
                if (this.field_70122_E) {
                    this.setIsJumping(false);
                }
                if (MoCreatures.isServer() && this instanceof MoCEntityTameableAnimal) {
                    int chance = this.getMaxTemper() - this.getTemper();
                    if (chance <= 0) {
                        chance = 5;
                    }
                    if (this.field_70146_Z.nextInt(chance * 8) == 0) {
                        MoCTools.tameWithName((EntityPlayer)this.field_70153_n, (MoCEntityTameableAnimal)this);
                    }
                }
            }
            if (this.field_70153_n != null && this.getIsTamed()) {
                this.field_70121_D.field_72337_e = this.field_70153_n.field_70121_D.field_72337_e;
                if (!this.isSelfPropelledFlyer() || this.isSelfPropelledFlyer() && !this.isOnAir()) {
                    movementSideways = (float)((double)(((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f) * this.getCustomSpeed());
                    movementForward = (float)((double)((EntityLivingBase)this.field_70153_n).field_70701_bs * this.getCustomSpeed());
                }
                if (this.jumpPending && this.isFlyer()) {
                    this.field_70181_x += this.flyerThrust();
                    this.jumpPending = false;
                    if (this.isSelfPropelledFlyer() && this.isOnAir() && MoCreatures.isServer()) {
                        float velX = (float)(0.5 * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f));
                        float velZ = (float)(0.5 * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f));
                        this.field_70159_w -= (double)velX;
                        this.field_70179_y -= (double)velZ;
                        if (MoCreatures.isServer()) {
                            this.func_70091_d(this.field_70159_w, 0.0, this.field_70179_y);
                        }
                    }
                } else if (this.jumpPending && !this.getIsJumping()) {
                    this.field_70181_x = this.getCustomJump() * 2.0;
                    this.setIsJumping(true);
                    this.jumpPending = false;
                }
                if (this.divePending) {
                    this.divePending = false;
                    this.field_70181_x -= 0.3;
                }
                if (MoCreatures.isServer()) {
                    super.func_70612_e(movementSideways, movementForward);
                }
                if (this.field_70122_E) {
                    this.jumpPending = false;
                    this.setIsJumping(false);
                    this.divePending = false;
                }
                this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            if (!this.field_70170_p.field_72995_K) {
                super.func_70612_e(movementSideways, movementForward);
            }
            if (this.isFlyingAlone()) {
                int yDistanceFromGround = MoCTools.distanceToWaterFloor((Entity)this);
                if (yDistanceFromGround <= this.flyingHeight()) {
                    this.field_70181_x *= 0.3 + (double)acceleration;
                }
                if (yDistanceFromGround <= this.flyingHeight() && (this.field_70123_F || this.field_70146_Z.nextInt(100) == 0)) {
                    this.field_70181_x += 0.1;
                }
                if (yDistanceFromGround > this.flyingHeight() || this.field_70146_Z.nextInt(150) == 0) {
                    this.field_70181_x -= 0.1;
                }
                if (this.isOnAir()) {
                    double xVelocity = (double)0.1f * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    double zVelocity = (double)0.1f * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    this.field_70159_w -= xVelocity;
                    this.field_70179_y -= zVelocity;
                }
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x *= 0.5;
                }
            }
            if (this.isFlyer() && this.field_70153_n == null && this.field_70789_a != null && this.field_70789_a.field_70163_u < this.field_70163_u && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = -0.25;
            }
            if (!this.isFlyer() && this instanceof MoCEntityHorse && ((MoCEntityHorse)this).isFloater()) {
                this.field_70181_x += 0.21 - this.myFallSpeed() / 10.0;
                this.field_70181_x *= this.myFallSpeed();
            }
            if (this.field_70153_n != null && this.getIsTamed() && this.getCustomSpeed() > 0.0 && this.getCustomSpeed() != 0.80000001) {
                if (this.isFlyer()) {
                    this.field_70181_x += 0.21 - this.myFallSpeed() / 10.0;
                    this.field_70181_x *= this.myFallSpeed();
                }
                if (this.isOnAir() || !(this instanceof MoCEntityWyvern)) {
                    acceleration = (float)this.getCustomSpeed() * 0.77f;
                }
            } else if (!this.isFlyingAlone()) {
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
            }
            if (this.field_70153_n != null && this.isOnAir() & !this.isFlyer()) {
                acceleration = this.flyerFriction();
            }
            this.field_70159_w *= (double)acceleration;
            this.field_70179_y *= (double)acceleration;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double xDistanceTravelled = this.field_70165_t - this.field_70169_q;
        double zDistanceTravelled = this.field_70161_v - this.field_70166_s;
        float overallHorizontalDistanceTravelledSquared = MathHelper.func_76133_a((double)(xDistanceTravelled * xDistanceTravelled + zDistanceTravelled * zDistanceTravelled)) * 4.0f;
        if (overallHorizontalDistanceTravelledSquared > 1.0f) {
            overallHorizontalDistanceTravelledSquared = 1.0f;
        }
        this.field_70721_aZ += (overallHorizontalDistanceTravelledSquared - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public int flyingHeight() {
        return 5;
    }

    protected double myFallSpeed() {
        return 0.6;
    }

    protected double flyerThrust() {
        return 0.3;
    }

    protected float flyerFriction() {
        return 0.91f;
    }

    protected boolean isSelfPropelledFlyer() {
        return false;
    }

    @Override
    public void makeEntityJump() {
        this.jumpPending = true;
    }

    public boolean isFlyer() {
        return false;
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int getMaxTemper() {
        return 100;
    }

    public double getCustomSpeed() {
        return 0.80000001;
    }

    public double getCustomJump() {
        return 0.4;
    }

    protected String getMadSound() {
        return null;
    }

    public boolean rideableEntity() {
        return false;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    @Override
    public double roperYOffset() {
        return 0.0;
    }

    protected void func_70626_be() {
        float distance;
        if (this.getIsTamed() && this.field_70153_n == null && this.roper != null && (distance = this.roper.func_70032_d((Entity)this)) > 3.0f) {
            this.getPathOrWalkableBlock((Entity)this.roper, distance);
        }
        if (!this.isFlyingAlone()) {
            super.func_70626_be();
            return;
        }
        this.field_70787_b = false;
        float huntingRange = 16.0f;
        if (this.field_70789_a == null) {
            this.field_70789_a = this.func_70782_k();
            if (this.field_70789_a != null) {
                this.entitypath = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, huntingRange, true, false, false, true);
            }
        } else if (!this.field_70789_a.func_70089_S() || MoCTools.isTamed(this.field_70789_a)) {
            this.field_70789_a = null;
        } else {
            float distanceToPrey = this.field_70789_a.func_70032_d((Entity)this);
            if (this.func_70685_l(this.field_70789_a)) {
                this.func_70785_a(this.field_70789_a, distanceToPrey);
            }
        }
        if (!(this.field_70787_b || this.field_70789_a == null || this.entitypath != null && this.field_70146_Z.nextInt(10) != 0)) {
            this.entitypath = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, huntingRange, true, false, false, true);
        } else if (this.entitypath == null && this.field_70146_Z.nextInt(80) == 0 || this.field_70146_Z.nextInt(80) == 0) {
            boolean flag = false;
            int newPosX = -1;
            int newPosY = -1;
            int newPosZ = -1;
            float minimumProbability = -99999.0f;
            for (int index = 0; index < 10; ++index) {
                int tempZ;
                int tempY;
                int tempX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70146_Z.nextInt(13) - 6.0));
                float liklihoodOfEntityWalkingToThisBlock = this.func_70783_a(tempX, tempY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70146_Z.nextInt(7) - 3.0)), tempZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70146_Z.nextInt(13) - 6.0)));
                if (!(liklihoodOfEntityWalkingToThisBlock > minimumProbability)) continue;
                minimumProbability = liklihoodOfEntityWalkingToThisBlock;
                newPosX = tempX;
                newPosY = tempY;
                newPosZ = tempZ;
                flag = true;
            }
            if (flag) {
                this.entitypath = this.field_70170_p.func_72844_a((Entity)this, newPosX, newPosY, newPosZ, 10.0f, true, false, false, true);
            }
        }
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        boolean isWaterMovement = this.func_70072_I();
        boolean isLavaMovement = this.func_70058_J();
        this.field_70125_A = 0.0f;
        if (this.entitypath == null || this.field_70146_Z.nextInt(100) == 0) {
            super.func_70626_be();
            this.entitypath = null;
            return;
        }
        Vec3 vectorThreeDimensional = this.entitypath.func_75878_a((Entity)this);
        double d = this.field_70130_N * 2.0f;
        while (vectorThreeDimensional != null && vectorThreeDimensional.func_72445_d(this.field_70165_t, vectorThreeDimensional.field_72448_b, this.field_70161_v) < d * d) {
            this.entitypath.func_75875_a();
            if (this.entitypath.func_75879_b()) {
                vectorThreeDimensional = null;
                this.entitypath = null;
                continue;
            }
            vectorThreeDimensional = this.entitypath.func_75878_a((Entity)this);
        }
        this.field_70703_bu = false;
        if (vectorThreeDimensional != null) {
            float amountOfDegreesToChangeRotationYawBy;
            double vectorDistanceX = vectorThreeDimensional.field_72450_a - this.field_70165_t;
            double vectorDistanceY = vectorThreeDimensional.field_72448_b - (double)yCoordinate;
            double vectorDistanceZ = vectorThreeDimensional.field_72449_c - this.field_70161_v;
            float angleInDegreesToNewLocation = (float)(Math.atan2(vectorDistanceZ, vectorDistanceX) * 180.0 / Math.PI) - 90.0f;
            this.field_70701_bs = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            for (amountOfDegreesToChangeRotationYawBy = angleInDegreesToNewLocation - this.field_70177_z; amountOfDegreesToChangeRotationYawBy < -180.0f; amountOfDegreesToChangeRotationYawBy += 360.0f) {
            }
            while (amountOfDegreesToChangeRotationYawBy >= 180.0f) {
                amountOfDegreesToChangeRotationYawBy -= 360.0f;
            }
            if (amountOfDegreesToChangeRotationYawBy > 30.0f) {
                amountOfDegreesToChangeRotationYawBy = 30.0f;
            }
            if (amountOfDegreesToChangeRotationYawBy < -30.0f) {
                amountOfDegreesToChangeRotationYawBy = -30.0f;
            }
            this.field_70177_z += amountOfDegreesToChangeRotationYawBy;
            if (this.field_70787_b && this.field_70789_a != null) {
                double xDistance = this.field_70789_a.field_70165_t - this.field_70165_t;
                double zDistance = this.field_70789_a.field_70161_v - this.field_70161_v;
                float previousRotationYaw = this.field_70177_z;
                this.field_70177_z = (float)(Math.atan2(zDistance, xDistance) * 180.0 / Math.PI) - 90.0f;
                float angleInDegreesBetweenPreviousAndNewRotationYaw = (previousRotationYaw - this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f;
                this.field_70702_br = -MathHelper.func_76126_a((float)angleInDegreesBetweenPreviousAndNewRotationYaw) * this.field_70701_bs * 1.0f;
                this.field_70701_bs = MathHelper.func_76134_b((float)angleInDegreesBetweenPreviousAndNewRotationYaw) * this.field_70701_bs * 1.0f;
            }
            if (vectorDistanceY > 0.0) {
                this.field_70703_bu = true;
            }
        }
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 30.0f, 30.0f);
        }
        if (this.field_70123_F) {
            this.field_70703_bu = true;
        }
        if (this.field_70146_Z.nextFloat() < 0.8f && (isWaterMovement || isLavaMovement)) {
            this.field_70703_bu = true;
        }
    }

    protected Entity func_70782_k() {
        return null;
    }

    public boolean isFlyingAlone() {
        return false;
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    public void SpawnHeart() {
        double xVelocity = this.field_70146_Z.nextGaussian() * 0.02;
        double yVelocity = this.field_70146_Z.nextGaussian() * 0.02;
        double zVelocity = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, xVelocity, yVelocity, zVelocity);
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFollowFood(ItemStack itemStack) {
        return false;
    }

    private void followPlayer() {
        EntityPlayer closestEntityPlayer = this.field_70170_p.func_72890_a((Entity)this, 24.0);
        if (closestEntityPlayer == null) {
            return;
        }
        ItemStack itemstackThatPlayerIsHolding = closestEntityPlayer.func_70694_bm();
        if (itemstackThatPlayerIsHolding != null && this.isMyFollowFood(itemstackThatPlayerIsHolding)) {
            PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)closestEntityPlayer, 16.0f, true, false, false, true);
            this.func_70778_a(pathEntity);
        }
    }

    public void func_70078_a(Entity entity) {
        if (this.updateMount()) {
            if (entity == null) {
                if (this.field_70154_o != null) {
                    this.func_70012_b(this.field_70154_o.field_70165_t, this.field_70154_o.field_70121_D.field_72338_b + (double)this.field_70154_o.field_70131_O, this.field_70154_o.field_70161_v, this.field_70177_z, this.field_70125_A);
                    this.field_70154_o.field_70153_n = null;
                }
                this.field_70154_o = null;
            } else {
                this.field_70154_o = entity;
                entity.field_70153_n = this;
            }
        } else {
            super.func_70078_a(entity);
        }
    }

    @Override
    public Entity getRoper() {
        return this.roper;
    }

    @Override
    public boolean updateMount() {
        return false;
    }

    @Override
    public boolean forceUpdates() {
        return false;
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.2)), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    @Override
    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(20);
    }

    @Override
    public void setOwner(String par1Str) {
        this.field_70180_af.func_75692_b(20, (Object)par1Str);
    }

    public void func_70645_a(DamageSource damageSource) {
        if (MoCreatures.isServer()) {
            this.dropMyStuff();
        }
        super.func_70645_a(damageSource);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (MoCreatures.proxy.enableStrictOwnership && this.getOwnerName() != null && !this.getOwnerName().equals("") && entityThatAttackedThisCreature != null && entityThatAttackedThisCreature instanceof EntityPlayer && !((EntityPlayer)entityThatAttackedThisCreature).func_70005_c_().equals(this.getOwnerName()) && !MoCTools.isThisPlayerAnOP((EntityPlayer)entityThatAttackedThisCreature)) {
            return false;
        }
        if (this.isNotScared()) {
            Entity tempEntity = this.field_70789_a;
            boolean flag = super.func_70097_a(damageSource, damageTaken);
            this.field_70788_c = 0;
            this.field_70789_a = tempEntity;
            return flag;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    @Override
    public void setArmorType(byte i) {
    }

    public byte getArmorType() {
        return 0;
    }

    @Override
    public void dismountEntity() {
        if (MoCreatures.isServer() && this.field_70153_n != null) {
            this.field_70153_n.func_70078_a(null);
            this.field_70153_n = null;
        }
    }

    public void dropArmor() {
    }

    @Override
    public int pitchRotationOffset() {
        return 0;
    }

    @Override
    public int rollRotationOffset() {
        return 0;
    }

    @Override
    public int yawRotationOffset() {
        return 0;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInAmulet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    @Override
    public void riderIsDisconnecting(boolean flag) {
        this.riderIsDisconnecting = true;
    }
}

