/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class MoCWorldGenPortal
extends WorldGenerator {
    private Block pillarBlock;
    private Block stairBlock;
    private Block wallBlock;
    private Block centerBlock;
    private int pillarMetadata;
    private int stairMetadata;
    private int wallMetadata;
    private int centerMetadata;

    public MoCWorldGenPortal(Block pillar, int pillarMeta, Block stair, int stairMeta, Block wall, int wallMeta, Block center, int centerMeta) {
        this.pillarBlock = pillar;
        this.stairBlock = stair;
        this.wallBlock = wall;
        this.centerBlock = center;
        this.pillarMetadata = pillarMeta;
        this.stairMetadata = stairMeta;
        this.wallMetadata = wallMeta;
        this.centerMetadata = centerMeta;
    }

    public boolean generatePillar(World world, int x, int y, int z) {
        for (int nY = y; nY < y + 6; ++nY) {
            world.func_147465_d(x, nY, z, this.pillarBlock, this.pillarMetadata, 2);
        }
        return true;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int nZ;
        int nX;
        if (world.func_147439_a(x, y, z) == this.centerBlock || world.func_147439_a(x, y - 1, z) == this.centerBlock || world.func_147439_a(x, y + 1, z) == this.centerBlock) {
            return true;
        }
        if (world.func_147437_c(x, y, z) || !world.func_147437_c(x, y + 1, z)) {
            return false;
        }
        this.stairMetadata = 2;
        for (int nZ2 = z - 3; nZ2 < z + 3; nZ2 += 5) {
            for (int nX2 = x - 2; nX2 < x + 2; ++nX2) {
                if (nZ2 > z) {
                    this.stairMetadata = 3;
                }
                world.func_147465_d(nX2, y + 1, nZ2, this.stairBlock, this.stairMetadata, 2);
            }
        }
        for (nX = x - 2; nX < x + 2; ++nX) {
            for (nZ = z - 2; nZ < z + 2; ++nZ) {
                world.func_147465_d(nX, y + 1, nZ, this.wallBlock, this.wallMetadata, 2);
            }
        }
        for (nX = x - 1; nX < x + 1; ++nX) {
            for (nZ = z - 1; nZ < z + 1; ++nZ) {
                world.func_147465_d(nX, y + 1, nZ, this.centerBlock, this.centerMetadata, 2);
            }
        }
        for (int j = x - 3; j < x + 3; j += 5) {
            for (nZ = z - 3; nZ < z + 3; ++nZ) {
                world.func_147465_d(j, y + 6, nZ, this.wallBlock, this.wallMetadata, 2);
            }
        }
        this.generatePillar(world, x - 3, y, z - 3);
        this.generatePillar(world, x - 3, y, z + 2);
        this.generatePillar(world, x + 2, y, z - 3);
        this.generatePillar(world, x + 2, y, z + 2);
        return true;
    }
}

