/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import drzhark.mocreatures.MoCEntityData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.entity.ambient.MoCEntityMaggot;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.animal.MoCEntityOstrich;
import drzhark.mocreatures.entity.animal.MoCEntityPetScorpion;
import drzhark.mocreatures.entity.monster.MoCEntityOgre;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAttachedEntity;
import drzhark.mocreatures.network.message.MoCMessageNameGUI;
import drzhark.mocreatures.utils.MoCLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class MoCTools {
    public static void dropSaddle(MoCEntityAnimal entity, World worldObj) {
        if (!entity.getIsRideable() || !MoCreatures.isServer()) {
            return;
        }
        MoCTools.dropCustomItem((Entity)entity, worldObj, new ItemStack(MoCreatures.craftedSaddle, 1));
        entity.setRideable(false);
    }

    public static void dropBags(MoCEntityAnimal entity, World worldObj) {
        if (!MoCreatures.isServer()) {
            return;
        }
        MoCTools.dropCustomItem((Entity)entity, worldObj, new ItemStack((Block)Blocks.field_150486_ae, 1));
    }

    public static void dropCustomItem(Entity entity, World worldObj, ItemStack itemStack) {
        if (!MoCreatures.isServer()) {
            return;
        }
        EntityItem entityItem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack);
        float f3 = 0.05f;
        entityItem.field_70159_w = (float)worldObj.field_73012_v.nextGaussian() * f3;
        entityItem.field_70181_x = (float)worldObj.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityItem.field_70179_y = (float)worldObj.field_73012_v.nextGaussian() * f3;
        worldObj.func_72838_d((Entity)entityItem);
    }

    public static List<String> getOreDictionaryEntries(ItemStack itemStack) {
        int[] oreDictionaryIdList = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> oreDictionaryNameArray = new ArrayList<String>();
        if (oreDictionaryIdList.length > 0) {
            for (int element : oreDictionaryIdList) {
                oreDictionaryNameArray.add(OreDictionary.getOreName((int)element));
            }
        }
        return oreDictionaryNameArray;
    }

    public static boolean isPlayerInWolfForm(EntityPlayer player) {
        return MoCreatures.isWitcheryLoaded && 24.0f <= player.func_110138_aP() && player.func_110138_aP() <= 32.0f && !player.func_70644_a(Potion.field_76434_w) && MoCTools.isNightVisionPotionEffectActiveAndIsItFromWitcheryWerewolfMechanism(player);
    }

    public static boolean isPlayerInWerewolfForm(EntityPlayer player) {
        return MoCreatures.isWitcheryLoaded && 40.0f <= player.func_110138_aP() && player.func_110138_aP() <= 60.0f && !player.func_70644_a(Potion.field_76434_w) && MoCTools.isNightVisionPotionEffectActiveAndIsItFromWitcheryWerewolfMechanism(player);
    }

    private static boolean isNightVisionPotionEffectActiveAndIsItFromWitcheryWerewolfMechanism(EntityPlayer entityPlayer) {
        PotionEffect nightVisionPotionEffect;
        int potionEffectDuration;
        return entityPlayer.func_70660_b(Potion.field_76439_r) != null && (potionEffectDuration = (nightVisionPotionEffect = entityPlayer.func_70660_b(Potion.field_76439_r)).func_76459_b() / 20) > 15 && potionEffectDuration < 21;
    }

    public static boolean flyToNextEntity(Entity entityThatIsFlying, Entity entityToFlyNextTo) {
        if (entityToFlyNextTo != null) {
            double zDistance;
            double xDistance;
            int entityPosX = MathHelper.func_76128_c((double)entityToFlyNextTo.field_70165_t);
            int entityPosY = MathHelper.func_76128_c((double)entityToFlyNextTo.field_70163_u);
            int entityPosZ = MathHelper.func_76128_c((double)entityToFlyNextTo.field_70161_v);
            MoCTools.faceLocation(entityThatIsFlying, entityPosX, entityPosY, entityPosZ, 30.0f);
            if (MathHelper.func_76128_c((double)entityThatIsFlying.field_70163_u) < entityPosY) {
                entityThatIsFlying.field_70181_x += 0.15;
            }
            if (entityThatIsFlying.field_70165_t < entityToFlyNextTo.field_70165_t) {
                xDistance = entityToFlyNextTo.field_70165_t - entityThatIsFlying.field_70165_t;
                if (xDistance > 0.5) {
                    entityThatIsFlying.field_70159_w += 0.05;
                }
            } else {
                xDistance = entityThatIsFlying.field_70165_t - entityToFlyNextTo.field_70165_t;
                if (xDistance > 0.5) {
                    entityThatIsFlying.field_70159_w -= 0.05;
                }
            }
            if (entityThatIsFlying.field_70161_v < entityToFlyNextTo.field_70161_v) {
                zDistance = entityToFlyNextTo.field_70161_v - entityThatIsFlying.field_70161_v;
                if (zDistance > 0.5) {
                    entityThatIsFlying.field_70179_y += 0.05;
                }
            } else {
                zDistance = entityThatIsFlying.field_70161_v - entityToFlyNextTo.field_70161_v;
                if (zDistance > 0.5) {
                    entityThatIsFlying.field_70179_y -= 0.05;
                }
            }
            return true;
        }
        return false;
    }

    public static void faceLocation(Entity entity, int x, int y, int z, float f) {
        double xDistanceToNewFacingLocation = (double)x + 0.5 - entity.field_70165_t;
        double yDistanceToNewFacingLocation = (double)y + 0.5 - entity.field_70163_u;
        double zDistanceToNewFacingLocation = (double)z + 0.5 - entity.field_70161_v;
        double overallDistanceToNewFacingLocationSquared = MathHelper.func_76133_a((double)(xDistanceToNewFacingLocation * xDistanceToNewFacingLocation + zDistanceToNewFacingLocation * zDistanceToNewFacingLocation));
        float xzAngleInDegreesToNewFacingLocation = (float)(Math.atan2(zDistanceToNewFacingLocation, xDistanceToNewFacingLocation) * 180.0 / Math.PI) - 90.0f;
        float yAngleInDegreesToNewFacingLocation = (float)(-(Math.atan2(yDistanceToNewFacingLocation, overallDistanceToNewFacingLocationSquared) * 180.0 / Math.PI));
        entity.field_70125_A = -MoCTools.updateRotation(entity.field_70125_A, yAngleInDegreesToNewFacingLocation, f);
        entity.field_70177_z = MoCTools.updateRotation(entity.field_70177_z, xzAngleInDegreesToNewFacingLocation, f);
    }

    private static float updateRotation(float currentRotation, float intendedRotation, float maxIncrement) {
        float amountToChangeRotationBy;
        for (amountToChangeRotationBy = intendedRotation - currentRotation; amountToChangeRotationBy < -180.0f; amountToChangeRotationBy += 360.0f) {
        }
        while (amountToChangeRotationBy >= 180.0f) {
            amountToChangeRotationBy -= 360.0f;
        }
        if (amountToChangeRotationBy > maxIncrement) {
            amountToChangeRotationBy = maxIncrement;
        }
        if (amountToChangeRotationBy < -maxIncrement) {
            amountToChangeRotationBy = -maxIncrement;
        }
        return currentRotation + amountToChangeRotationBy;
    }

    public static EntityItem getClosestSpecificEntityItemItemNearby(Entity entity, double distance, Item item, Item item1) {
        double currentMinimumDistance = -1.0;
        EntityItem entityItem = null;
        List entitiesNearbyList = entity.field_70170_p.func_72839_b(entity, entity.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                EntityItem entityItemNearby;
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof EntityItem) || (entityItemNearby = (EntityItem)entityNearby).func_92059_d().func_77973_b() != item && entityItemNearby.func_92059_d().func_77973_b() != item1) continue;
                double overallDistanceSquared = entityItemNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityItem = entityItemNearby;
            }
        }
        return entityItem;
    }

    public static EntityLivingBase getClosestEntityLivingThatCanBeTargetted(Entity thisEntity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityLivingBase entityLiving = null;
        List entitiesNearbyList = thisEntity.field_70170_p.func_72839_b(thisEntity, thisEntity.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (thisEntity instanceof IMoCEntity && ((IMoCEntity)thisEntity).shouldEntityBeIgnored(entityNearby)) continue;
                double overallDistanceSquared = entityNearby.func_70092_e(thisEntity.field_70165_t, thisEntity.field_70163_u, thisEntity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance) || !((EntityLivingBase)entityNearby).func_70685_l(thisEntity)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityLiving = (EntityLivingBase)entityNearby;
            }
        }
        return entityLiving;
    }

    public static EntityLivingBase getScaryEntity(Entity entity, double distance) {
        EntityLivingBase entityLiving = null;
        List entitiesNearbyList = entity.field_70170_p.func_72839_b(entity, entity.field_70121_D.func_72314_b(distance, 4.0, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entity instanceof IMoCEntity) || !((IMoCEntity)entity).entitiesThatAreScary(entityNearby)) continue;
                entityLiving = (EntityLivingBase)entityNearby;
            }
        }
        return entityLiving;
    }

    public static void pushEntityBack(Entity entityThatIsPushing, Entity entityToPushBack, float forceOfPush) {
        double d = entityThatIsPushing.field_70165_t - entityToPushBack.field_70165_t;
        double d1 = entityThatIsPushing.field_70161_v - entityToPushBack.field_70161_v;
        d1 = entityThatIsPushing.field_70161_v - entityToPushBack.field_70161_v;
        while (d * d + d1 * d1 < 1.0E-4) {
            d = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        entityToPushBack.field_70159_w /= 2.0;
        entityToPushBack.field_70181_x /= 2.0;
        entityToPushBack.field_70179_y /= 2.0;
        entityToPushBack.field_70159_w -= d / (double)f * (double)forceOfPush;
        entityToPushBack.field_70181_x += (double)forceOfPush;
        entityToPushBack.field_70179_y -= d1 / (double)f * (double)forceOfPush;
        if (entityToPushBack.field_70181_x > (double)forceOfPush) {
            entityToPushBack.field_70181_x = forceOfPush;
        }
    }

    public static void buckleMobs(EntityLiving entityPerformingTheRam, float damage, Double dististanceToBuckleEntities, World worldObj) {
        List list = worldObj.func_72839_b((Entity)entityPerformingTheRam, entityPerformingTheRam.field_70121_D.func_72314_b(dististanceToBuckleEntities.doubleValue(), 2.0, dististanceToBuckleEntities.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entityTarget = (Entity)list.get(i);
            if (!(entityTarget instanceof EntityLiving) || entityPerformingTheRam.field_70153_n != null && entityTarget == entityPerformingTheRam.field_70153_n) continue;
            entityTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityPerformingTheRam), damage);
            MoCTools.pushEntityBack((Entity)entityPerformingTheRam, entityTarget, 0.6f);
        }
    }

    public static void buckleMobsNotPlayers(EntityLiving entityattacker, float damage, Double distanceToBuckleEntities, World worldObj) {
        List list = worldObj.func_72839_b((Entity)entityattacker, entityattacker.field_70121_D.func_72314_b(distanceToBuckleEntities.doubleValue(), 2.0, distanceToBuckleEntities.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entityTarget = (Entity)list.get(i);
            if (!(entityTarget instanceof EntityLiving) || entityTarget instanceof EntityPlayer || entityattacker.field_70153_n != null && entityTarget == entityattacker.field_70153_n) continue;
            entityTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityattacker), damage);
            MoCTools.pushEntityBack((Entity)entityattacker, entityTarget, 0.6f);
        }
    }

    public static boolean isEntityAFishThatIsInTheOcean(Entity entity) {
        int z;
        int y;
        int x;
        BiomeGenBase biomeThatEntityIsIn;
        return !(!(entity instanceof MoCEntityAquatic) && !(entity instanceof MoCEntityTameableAquatic) || BiomeDictionary.isBiomeOfType((BiomeGenBase)(biomeThatEntityIsIn = MoCTools.biomekind(entity.field_70170_p, x = MathHelper.func_76128_c((double)entity.field_70165_t), y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v))), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || !BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeThatEntityIsIn, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeThatEntityIsIn, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
    }

    public static void spawnNearPlayer(EntityPlayer player, int entityId, int numberToSpawn) {
        WorldServer worldObj = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_70170_p.field_73011_w.field_76574_g);
        for (int i = 0; i < numberToSpawn; ++i) {
            EntityLiving entityLiving = null;
            try {
                Class<? extends EntityLiving> entityClass = MoCreatures.instaSpawnerMap.get(entityId);
                entityLiving = entityClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            if (entityLiving == null) continue;
            entityLiving.func_70012_b(player.field_70165_t - 1.0, player.field_70163_u, player.field_70161_v - 1.0, player.field_70177_z, player.field_70125_A);
            worldObj.func_72838_d((Entity)entityLiving);
        }
    }

    public static void spawnNearPlayerbyName(EntityPlayer player, String eName, int numberToSpawn) {
        WorldServer worldObj = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_70170_p.field_73011_w.field_76574_g);
        for (int i = 0; i < numberToSpawn; ++i) {
            EntityLiving entityToSpawn = null;
            try {
                MoCEntityData entityData = MoCreatures.mocEntityMap.get(eName);
                Class<? extends EntityLiving> myClass = entityData.getEntityClass();
                entityToSpawn = myClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            if (entityToSpawn == null) continue;
            IEntityLivingData entityLivingdata = null;
            entityToSpawn.func_110161_a(entityLivingdata);
            entityToSpawn.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            worldObj.func_72838_d((Entity)entityToSpawn);
        }
    }

    public static void playCustomSound(Entity entity, String customSound, World worldObj) {
        worldObj.func_72956_a(entity, "mocreatures:" + customSound, 1.0f, 1.0f + (worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()) * 0.2f);
    }

    public static void playCustomSound(Entity entity, String customSound, World worldObj, float volume) {
        worldObj.func_72956_a(entity, "mocreatures:" + customSound, volume, 1.0f + (worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()) * 0.2f);
    }

    public static EntityLiving spawnListByNameClass(String eName, World worldObj) {
        EntityLiving entityToSpawn;
        block2: {
            entityToSpawn = null;
            try {
                MoCEntityData entityData = MoCreatures.mocEntityMap.get(eName);
                Class<Object> myClass = null;
                myClass = entityData == null && eName.contains("PetScorpion") ? MoCEntityPetScorpion.class : entityData.getEntityClass();
                entityToSpawn = myClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                if (!MoCreatures.proxy.debug) break block2;
                MoCLog.logger.warn("Unable to find class for entity " + eName + ", " + e);
            }
        }
        return entityToSpawn;
    }

    public static boolean nearMaterialWithDistance(Entity entity, Double double1, Material mat) {
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(double1.doubleValue(), double1.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == Blocks.field_150350_a || block.func_149688_o() != mat) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNearBlockName(Entity entity, Double dist, String blockName) {
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(dist.doubleValue(), dist / 2.0, dist.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == Blocks.field_150350_a) continue;
                    String nameToCheck = "";
                    nameToCheck = block.func_149739_a();
                    if (nameToCheck == null || nameToCheck.length() <= 0 || !nameToCheck.equals(blockName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static BlockJukebox.TileEntityJukebox nearJukeBoxRecord(Entity entity, Double dist) {
        AxisAlignedBB axisAlignedBoundingBox = entity.field_70121_D.func_72314_b(dist.doubleValue(), dist / 2.0, dist.doubleValue());
        int xMin = MathHelper.func_76128_c((double)axisAlignedBoundingBox.field_72340_a);
        int xMax = MathHelper.func_76128_c((double)(axisAlignedBoundingBox.field_72336_d + 1.0));
        int yMin = MathHelper.func_76128_c((double)axisAlignedBoundingBox.field_72338_b);
        int yMax = MathHelper.func_76128_c((double)(axisAlignedBoundingBox.field_72337_e + 1.0));
        int zMin = MathHelper.func_76128_c((double)axisAlignedBoundingBox.field_72339_c);
        int zNax = MathHelper.func_76128_c((double)(axisAlignedBoundingBox.field_72334_f + 1.0));
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zNax; ++z) {
                    Block block = entity.field_70170_p.func_147439_a(x, y, z);
                    if (entity.field_70170_p.func_147437_c(x, y, z) || !(block instanceof BlockJukebox)) continue;
                    BlockJukebox.TileEntityJukebox juky = (BlockJukebox.TileEntityJukebox)entity.field_70170_p.func_147438_o(x, y, z);
                    return juky;
                }
            }
        }
        return null;
    }

    public static void checkForTwistedEntities(World world) {
        for (int l = 0; l < world.field_72996_f.size(); ++l) {
            Entity entity = (Entity)world.field_72996_f.get(l);
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase twisted = (EntityLivingBase)entity;
            if (twisted.field_70725_aQ <= 0 || twisted.field_70154_o != null || !(twisted.func_110143_aJ() > 0.0f)) continue;
            twisted.field_70725_aQ = 0;
        }
    }

    public static double getSqDistanceTo(Entity entity, double i, double j, double k) {
        double l = entity.field_70165_t - i;
        double i1 = entity.field_70163_u - j;
        double j1 = entity.field_70161_v - k;
        return Math.sqrt(l * l + i1 * i1 + j1 * j1);
    }

    public static int[] ReturnNearestMaterialCoord(Entity entity, Material material, Double double1, Double yOffset) {
        double shortestDistance = -1.0;
        double distance = 0.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(double1.doubleValue(), yOffset.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == Blocks.field_150350_a || block.func_149688_o() != material) continue;
                    distance = MoCTools.getSqDistanceTo(entity, k1, l1, i2);
                    if (shortestDistance == -1.0) {
                        x = k1;
                        y = l1;
                        z = i2;
                        shortestDistance = distance;
                    }
                    if (!(distance < shortestDistance)) continue;
                    x = k1;
                    y = l1;
                    z = i2;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.field_70165_t > (double)x ? (x -= 2) : (x += 2);
        z = entity.field_70161_v > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static int[] ReturnNearestBlockCoord(Entity entity, Block block1, Double dist) {
        double shortestDistance = -1.0;
        double distance = 0.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(dist.doubleValue(), dist.doubleValue(), dist.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == Blocks.field_150350_a || block != block1) continue;
                    distance = MoCTools.getSqDistanceTo(entity, k1, l1, i2);
                    if (shortestDistance == -1.0) {
                        x = k1;
                        y = l1;
                        z = i2;
                        shortestDistance = distance;
                    }
                    if (!(distance < shortestDistance)) continue;
                    x = k1;
                    y = l1;
                    z = i2;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.field_70165_t > (double)x ? (x -= 2) : (x += 2);
        z = entity.field_70161_v > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static void moveCreatureToXYZ(EntityCreature movingEntity, int x, int y, int z, float f) {
        PathEntity pathEntity = movingEntity.field_70170_p.func_72844_a((Entity)movingEntity, x, y, z, f, true, false, false, true);
        if (pathEntity != null) {
            movingEntity.func_70778_a(pathEntity);
        }
    }

    public static void moveToWater(EntityCreature entity) {
        int[] ai = MoCTools.ReturnNearestMaterialCoord((Entity)entity, Material.field_151586_h, 20.0, 2.0);
        if (ai[0] > -1000) {
            MoCTools.moveCreatureToXYZ(entity, ai[0], ai[1], ai[2], 24.0f);
        }
    }

    public static float realAngle(float origAngle) {
        return origAngle % 360.0f;
    }

    public static void slideEntityToXYZ(Entity entity, int x, int y, int z) {
        if (entity != null) {
            if (entity.field_70163_u < (double)y) {
                entity.field_70181_x += 0.15;
            }
            if (entity.field_70165_t < (double)x) {
                double d = (double)x - entity.field_70165_t;
                if (d > 0.5) {
                    entity.field_70159_w += 0.05;
                }
            } else {
                double d1 = entity.field_70165_t - (double)x;
                if (d1 > 0.5) {
                    entity.field_70159_w -= 0.05;
                }
            }
            if (entity.field_70161_v < (double)z) {
                double d2 = (double)z - entity.field_70161_v;
                if (d2 > 0.5) {
                    entity.field_70179_y += 0.05;
                }
            } else {
                double d3 = entity.field_70161_v - (double)z;
                if (d3 > 0.5) {
                    entity.field_70179_y -= 0.05;
                }
            }
        }
    }

    public static float distanceToWaterSurface(Entity entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = entity.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (block != Blocks.field_150350_a && block.func_149688_o() == Material.field_151586_h) {
            for (int index = 1; index < 64; ++index) {
                block = entity.field_70170_p.func_147439_a(x, y + index, z);
                if (block != Blocks.field_150350_a && block.func_149688_o() == Material.field_151586_h) continue;
                return index;
            }
        }
        return 0.0f;
    }

    public static int distanceToWaterFloor(Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int index = 0; index < 64; ++index) {
            Block block = entity.field_70170_p.func_147439_a(x, y - index, z);
            if (block == Blocks.field_150350_a) continue;
            return index;
        }
        return 0;
    }

    public boolean isInsideOfMaterial(Material material, Entity entity) {
        int z;
        int y;
        double yDistance = entity.field_70163_u + (double)entity.func_70047_e();
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = entity.field_70170_p.func_147439_a(x, y = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)yDistance)), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (block != Blocks.field_150350_a && block.func_149688_o() == material) {
            float f = BlockLiquid.func_149801_b((int)entity.field_70170_p.func_72805_g(x, y, z)) - 0.1111111f;
            float f1 = (float)(y + 1) - f;
            return yDistance < (double)f1;
        }
        return false;
    }

    public static void disorientEntity(Entity entity) {
        double rotation = 0.0;
        double motion = 0.0;
        double randDouble = entity.field_70170_p.field_73012_v.nextGaussian();
        double randDouble1 = 0.1 * randDouble;
        motion = 0.2 * randDouble1 + 0.8 * motion;
        entity.field_70159_w += motion;
        entity.field_70179_y += motion;
        double randDouble2 = 0.78 * randDouble;
        rotation = 0.125 * randDouble2 + 0.875 * rotation;
        entity.field_70177_z = (float)((double)entity.field_70177_z + rotation);
        entity.field_70125_A = (float)((double)entity.field_70125_A + rotation);
    }

    public static void slowEntity(Entity entity) {
        entity.field_70159_w *= 0.8;
        entity.field_70179_y *= 0.8;
    }

    public static int colorize(int i) {
        return ~i & 0xF;
    }

    public int countEntities(Class class1, World worldObj) {
        int numberOfEntities = 0;
        for (int index = 0; index < worldObj.field_72996_f.size(); ++index) {
            Entity entity = (Entity)worldObj.field_72996_f.get(index);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++numberOfEntities;
        }
        return numberOfEntities;
    }

    public static BiomeGenBase whatBiomeIsAtXYZ(World world, int x, int y, int z) {
        WorldChunkManager worldchunkmanager = world.func_72959_q();
        if (worldchunkmanager == null) {
            return null;
        }
        BiomeGenBase biomegenbase = worldchunkmanager.func_76935_a(x, z);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase;
    }

    public static float distToPlayer(Entity entity) {
        return 0.0f;
    }

    public static String biomeName(World world, int x, int y, int z) {
        WorldChunkManager worldchunkmanager = world.func_72959_q();
        if (worldchunkmanager == null) {
            return null;
        }
        BiomeGenBase biomegenbase = worldchunkmanager.func_76935_a(x, z);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.field_76791_y;
    }

    public static BiomeGenBase biomekind(World world, int i, int j, int k) {
        WorldChunkManager worldchunkmanager = world.func_72959_q();
        if (worldchunkmanager == null) {
            return null;
        }
        BiomeGenBase biomegenbase = worldchunkmanager.func_76935_a(i, k);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase;
    }

    public static void dropGoodies(World worldObj, Entity entity) {
        if (!MoCreatures.isServer()) {
            return;
        }
        EntityItem entityItem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150364_r, 16));
        entityItem.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem);
        EntityItem entityItem2 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151045_i, 64));
        entityItem2.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem2);
        EntityItem entityItem3 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150423_aK, 6));
        entityItem3.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem3);
        EntityItem entityItem4 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150347_e, 64));
        entityItem4.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem4);
        EntityItem entityItem5 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151034_e, 24));
        entityItem5.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem5);
        EntityItem entityItem6 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151116_aA, 64));
        entityItem6.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem6);
        EntityItem entityItem7 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.recordShuffle, 6));
        entityItem7.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem7);
        EntityItem entityItem8 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151042_j, 64));
        entityItem8.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem8);
        EntityItem entityItem9 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151043_k, 12));
        entityItem9.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem9);
        EntityItem entityItem10 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151007_F, 32));
        entityItem10.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem10);
        EntityItem entityItem12 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Block)Blocks.field_150328_O, 6));
        entityItem12.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem12);
        EntityItem entityItem13 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151072_bj, 12));
        entityItem13.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem13);
        EntityItem entityItem14 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151079_bi, 12));
        entityItem14.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem14);
        EntityItem entityItem15 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151073_bk, 12));
        entityItem15.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem15);
        EntityItem entityItem16 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150368_y, 2));
        entityItem16.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem16);
        EntityItem entityItem17 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151103_aS, 12));
        entityItem17.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem17);
        EntityItem entityItem18 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.unicornHorn, 16));
        entityItem18.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem18);
        EntityItem entityItem19 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Block)Blocks.field_150480_ab, 32));
        entityItem19.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem19);
        EntityItem entityItem20 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essenceDarkness, 6));
        entityItem20.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem20);
        EntityItem entityItem21 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essenceUndead, 6));
        entityItem21.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem21);
        EntityItem entityItem22 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essenceFire, 6));
        entityItem22.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem22);
        EntityItem entityItem23 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 6, 15));
        entityItem23.field_145804_b = 10;
        worldObj.func_72838_d((Entity)entityItem23);
    }

    public static boolean mobGriefing(World world) {
        return world.func_82736_K().func_82766_b("mobGriefing");
    }

    public static void destroyBlast(Entity entity, double d, double d1, double d2, float f, boolean flag) {
        Block block;
        int index;
        entity.field_70170_p.func_72908_a(d, d1, d2, "destroy", 4.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        boolean mobGriefing = MoCTools.mobGriefing(entity.field_70170_p);
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        float f1 = f;
        int i = 16;
        for (int index2 = 0; index2 < i; ++index2) {
            for (int index1 = 0; index1 < i; ++index1) {
                for (int j1 = 0; j1 < i; ++j1) {
                    if (index2 != 0 && index2 != i - 1 && index1 != 0 && index1 != i - 1 && j1 != 0 && j1 != i - 1) continue;
                    double d3 = (float)index2 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d4 = (float)index1 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d5 = (float)j1 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d8 = d;
                    double d10 = d1;
                    double d12 = d2;
                    float f3 = 0.3f;
                    float f4 = 5.0f;
                    for (float f2 = f * (0.7f + entity.field_70170_p.field_73012_v.nextFloat() * 0.6f); !(f2 <= 0.0f); f2 -= f3 * 0.75f) {
                        int i6;
                        int l5;
                        int k5 = MathHelper.func_76128_c((double)d8);
                        Block block2 = entity.field_70170_p.func_147439_a(k5, l5 = MathHelper.func_76128_c((double)d10), i6 = MathHelper.func_76128_c((double)d12));
                        if (block2 != Blocks.field_150350_a) {
                            f4 = block2.func_149712_f(entity.field_70170_p, k5, l5, i6);
                            f2 -= (block2.func_149638_a(entity) + 0.3f) * (f3 / 10.0f);
                        }
                        if (f2 > 0.0f && d10 > entity.field_70163_u && f4 < 3.0f) {
                            hashset.add(new ChunkPosition(k5, l5, i6));
                        }
                        d8 += d3 * (double)f3;
                        d10 += d4 * (double)f3;
                        d12 += d5 * (double)f3;
                    }
                }
            }
        }
        f *= 2.0f;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int k = MathHelper.func_76128_c((double)(d - (double)f - 1.0));
            int i1 = MathHelper.func_76128_c((double)(d + (double)f + 1.0));
            int k1 = MathHelper.func_76128_c((double)(d1 - (double)f - 1.0));
            int l1 = MathHelper.func_76128_c((double)(d1 + (double)f + 1.0));
            int i2 = MathHelper.func_76128_c((double)(d2 - (double)f - 1.0));
            int j2 = MathHelper.func_76128_c((double)(d2 + (double)f + 1.0));
            List list = entity.field_70170_p.func_72839_b(entity, AxisAlignedBB.func_72330_a((double)k, (double)k1, (double)i2, (double)i1, (double)l1, (double)j2));
            Vec3 vectorThreeDimensional = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Entity entity1 = (Entity)list.get(k2);
                double d7 = entity1.func_70011_f(d, d1, d2) / (double)f;
                if (d7 > 1.0) continue;
                double d9 = entity1.field_70165_t - d;
                double d11 = entity1.field_70163_u - d1;
                double d13 = entity1.field_70161_v - d2;
                double d15 = MathHelper.func_76133_a((double)(d9 * d9 + d11 * d11 + d13 * d13));
                d9 /= d15;
                d11 /= d15;
                d13 /= d15;
                double d17 = entity.field_70170_p.func_72842_a(vectorThreeDimensional, entity1.field_70121_D);
                double d19 = (1.0 - d7) * d17;
                if (entity1 instanceof MoCEntityOgre) continue;
                entity1.func_70097_a(DamageSource.field_76377_j, (float)((int)((d19 * d19 + d19) / 2.0 * 3.0 * (double)f + 1.0)));
                double d21 = d19;
                entity1.field_70159_w += d9 * d21;
                entity1.field_70181_x += d11 * d21;
                entity1.field_70179_y += d13 * d21;
            }
        }
        f = f1;
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>();
        arraylist.addAll(hashset);
        for (index = arraylist.size() - 1; index >= 0; --index) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(index);
            int j3 = chunkposition.field_151329_a;
            int l3 = chunkposition.field_151327_b;
            int j4 = chunkposition.field_151328_c;
            block = entity.field_70170_p.func_147439_a(j3, l3, j4);
            for (int j5 = 0; j5 < 5; ++j5) {
                double d14 = (float)j3 + entity.field_70170_p.field_73012_v.nextFloat();
                double d16 = (float)l3 + entity.field_70170_p.field_73012_v.nextFloat();
                double d18 = (float)j4 + entity.field_70170_p.field_73012_v.nextFloat();
                double d20 = d14 - d;
                double d22 = d16 - d1;
                double d23 = d18 - d2;
                double d24 = MathHelper.func_76133_a((double)(d20 * d20 + d22 * d22 + d23 * d23));
                d20 /= d24;
                d22 /= d24;
                d23 /= d24;
                double d25 = 0.5 / (d24 / (double)f + 0.1);
                d25 *= (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70170_p.field_73012_v.nextFloat() + 0.3f);
                d20 *= (d25 -= 1.0);
                d22 *= d25 - 1.0;
                d23 *= d25;
                if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) continue;
                entity.field_70170_p.func_72869_a("explode", (d14 + d * 1.0) / 2.0, (d16 + d1 * 1.0) / 2.0, (d18 + d2 * 1.0) / 2.0, d20, d22, d23);
                entity.field_70159_w -= 0.001000000047497451;
                entity.field_70181_x -= 0.001000000047497451;
            }
            if (!mobGriefing || FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER || block == Blocks.field_150350_a) continue;
            int metadata = entity.field_70170_p.func_72805_g(j3, l3, j4);
            BlockEvent.BreakEvent event = null;
            if (!entity.field_70170_p.field_72995_K) {
                event = new BlockEvent.BreakEvent(j3, l3, j4, entity.field_70170_p, block, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)entity.field_70170_p.field_73011_w.field_76574_g), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
            }
            if (event == null || event.isCanceled()) continue;
            block.func_149690_a(entity.field_70170_p, j3, l3, j4, entity.field_70170_p.func_72805_g(j3, l3, j4), 0.3f, 1);
            entity.field_70170_p.func_147465_d(j3, l3, j4, Blocks.field_150350_a, 0, 3);
            Explosion explosion = new Explosion(entity.field_70170_p, null, (double)j3, (double)l3, (double)j4, 3.0f);
            block.func_149723_a(entity.field_70170_p, j3, l3, j4, explosion);
        }
        if (mobGriefing && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && flag) {
            for (index = arraylist.size() - 1; index >= 0; --index) {
                ChunkPosition chunkposition1 = (ChunkPosition)arraylist.get(index);
                int k3 = chunkposition1.field_151329_a;
                int i4 = chunkposition1.field_151327_b;
                int k4 = chunkposition1.field_151328_c;
                block = entity.field_70170_p.func_147439_a(k3, i4, k4);
                if (block != Blocks.field_150350_a || entity.field_70170_p.field_73012_v.nextInt(8) != 0) continue;
                int metadata = entity.field_70170_p.func_72805_g(k3, i4, k4);
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(k3, i4, k4, entity.field_70170_p, block, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
                }
                if (event == null || event.isCanceled()) continue;
                entity.field_70170_p.func_147465_d(k3, i4, k4, (Block)Blocks.field_150480_ab, 0, 3);
            }
        }
    }

    public static void forceDataSync(IMoCEntity entityMoCreature) {
        if (entityMoCreature.updateMount() && ((Entity)entityMoCreature).field_70154_o != null) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAttachedEntity(((Entity)entityMoCreature).func_145782_y(), ((Entity)entityMoCreature).field_70154_o.func_145782_y()), new NetworkRegistry.TargetPoint(((Entity)entityMoCreature).field_70154_o.field_70170_p.field_73011_w.field_76574_g, ((Entity)entityMoCreature).field_70154_o.field_70165_t, ((Entity)entityMoCreature).field_70154_o.field_70163_u, ((Entity)entityMoCreature).field_70154_o.field_70161_v, 64.0));
        }
    }

    public static void updatePlayerArmorEffects(EntityPlayer player) {
        ItemStack[] itemstackInArmorSlot = new ItemStack[]{player.field_71071_by.func_70440_f(0), player.field_71071_by.func_70440_f(1), player.field_71071_by.func_70440_f(2), player.field_71071_by.func_70440_f(3)};
        if (itemstackInArmorSlot[0] != null && itemstackInArmorSlot[0].func_77973_b() == MoCreatures.scorpBootsCave && itemstackInArmorSlot[1] != null && itemstackInArmorSlot[1].func_77973_b() == MoCreatures.scorpLegsCave && itemstackInArmorSlot[2] != null && itemstackInArmorSlot[2].func_77973_b() == MoCreatures.scorpPlateCave && itemstackInArmorSlot[3] != null && itemstackInArmorSlot[3].func_77973_b() == MoCreatures.scorpHelmetCave) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0));
            return;
        }
        if (itemstackInArmorSlot[0] != null && itemstackInArmorSlot[0].func_77973_b() == MoCreatures.scorpBootsNether && itemstackInArmorSlot[1] != null && itemstackInArmorSlot[1].func_77973_b() == MoCreatures.scorpLegsNether && itemstackInArmorSlot[2] != null && itemstackInArmorSlot[2].func_77973_b() == MoCreatures.scorpPlateNether && itemstackInArmorSlot[3] != null && itemstackInArmorSlot[3].func_77973_b() == MoCreatures.scorpHelmetNether) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 300, 0));
            return;
        }
        if (itemstackInArmorSlot[0] != null && itemstackInArmorSlot[0].func_77973_b() == MoCreatures.scorpBootsFrost && itemstackInArmorSlot[1] != null && itemstackInArmorSlot[1].func_77973_b() == MoCreatures.scorpLegsFrost && itemstackInArmorSlot[2] != null && itemstackInArmorSlot[2].func_77973_b() == MoCreatures.scorpPlateFrost && itemstackInArmorSlot[3] != null && itemstackInArmorSlot[3].func_77973_b() == MoCreatures.scorpHelmetFrost) {
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 300, 0));
            return;
        }
        if (itemstackInArmorSlot[0] != null && itemstackInArmorSlot[0].func_77973_b() == MoCreatures.scorpBootsDirt && itemstackInArmorSlot[1] != null && itemstackInArmorSlot[1].func_77973_b() == MoCreatures.scorpLegsDirt && itemstackInArmorSlot[2] != null && itemstackInArmorSlot[2].func_77973_b() == MoCreatures.scorpPlateDirt && itemstackInArmorSlot[3] != null && itemstackInArmorSlot[3].func_77973_b() == MoCreatures.scorpHelmetDirt) {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 70, 0));
            return;
        }
    }

    public static int destroyRandomBlock(Entity entity, double distance) {
        int totalNumberOfBlocksFromDistanceInThreeDimensions = (int)(distance * distance * distance);
        for (int index = 0; index < totalNumberOfBlocksFromDistanceInThreeDimensions; ++index) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 4.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            Block block = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)((double)y + 1.1)), MathHelper.func_76128_c((double)z));
            Block block1 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            if (block == Blocks.field_150350_a || block1 != Blocks.field_150350_a) continue;
            if (MoCTools.mobGriefing(entity.field_70170_p)) {
                block1 = entity.field_70170_p.func_147439_a(x, y, z);
                int metadata = entity.field_70170_p.func_72805_g(x, y, z);
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(x, y, z, entity.field_70170_p, block, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
                }
                if (event != null && !event.isCanceled()) {
                    entity.field_70170_p.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
                }
            }
            return Block.func_149682_b((Block)block);
        }
        return 0;
    }

    public static int[] destroyRandomBlockWithMetadata(Entity entity, double distance) {
        int totalNumberOfBlocksFromDistanceInThreeDimensions = (int)(distance * distance * distance);
        int metaData = 0;
        for (int index = 0; index < totalNumberOfBlocksFromDistanceInThreeDimensions; ++index) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            Block blockAbove = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)((double)y + 1.1)), MathHelper.func_76128_c((double)z));
            Block block = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            if (block == Blocks.field_150350_a || block == Blocks.field_150357_h || block == Blocks.field_150355_j || block == Blocks.field_150353_l || block instanceof BlockLiquid || blockAbove != Blocks.field_150350_a) continue;
            metaData = entity.field_70170_p.func_72805_g(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            if (MoCTools.mobGriefing(entity.field_70170_p)) {
                Block block2 = entity.field_70170_p.func_147439_a(x, y, z);
                int metadata = entity.field_70170_p.func_72805_g(x, y, z);
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(x, y, z, entity.field_70170_p, block2, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
                }
                if (event != null && !event.isCanceled()) {
                    entity.field_70170_p.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
                } else {
                    block = null;
                }
            }
            return new int[]{block == null ? -1 : Block.func_149682_b((Block)block), metaData};
        }
        return new int[]{-1, metaData};
    }

    public static int[] getRandomBlockCoords(Entity entity, double distance) {
        int tempX = -9999;
        int tempY = -1;
        int tempZ = -1;
        int ii = (int)(distance * distance * (distance / 2.0));
        for (int i = 0; i < ii; ++i) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)(distance / 2.0)) - (double)((int)(distance / 4.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            Block block1 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)((double)y + 1.1)), MathHelper.func_76128_c((double)z));
            Block block2 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            Block block3 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)((double)x + 1.1)), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            Block block4 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)((double)x - 1.1)), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            Block block5 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)((double)y - 1.1)), MathHelper.func_76128_c((double)z));
            Block block6 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)((double)z + 1.1)));
            Block block7 = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)((double)z - 1.1)));
            float tempX1 = (float)x - (float)entity.field_70165_t;
            float tempY1 = (float)y - (float)entity.field_70163_u;
            float tempZ1 = (float)z - (float)entity.field_70161_v;
            float spawnDist = tempX1 * tempX1 + tempY1 * tempY1 + tempZ1 * tempZ1;
            if (!MoCTools.allowedBlock(Block.func_149682_b((Block)block1)) || !((block2 == Blocks.field_150350_a || block3 == Blocks.field_150350_a || block4 == Blocks.field_150350_a || block5 == Blocks.field_150350_a || block6 == Blocks.field_150350_a || block7 == Blocks.field_150350_a) & spawnDist > 100.0f)) continue;
            tempX = x;
            tempY = y;
            tempZ = z;
            break;
        }
        return new int[]{tempX, tempY, tempZ};
    }

    public static boolean allowedBlock(int ID) {
        return ID != 0 && ID != 7 && ID != 8 && ID != 9 && ID != 10 && ID != 11 && ID != 23 && ID != 37 && ID != 38 && ID != 50 && ID != 51 && ID != 54 && (ID < 63 || ID > 77) && ID != 95 && ID != 90 && ID != 93 && ID != 94 && ID < 134;
    }

    public static boolean tameWithName(EntityPlayer entityPlayer, IMoCTameable mocreature) {
        if (entityPlayer == null || mocreature == null) {
            return false;
        }
        if (mocreature.getOwnerName().length() > 0 && !mocreature.getOwnerName().equals(entityPlayer.func_70005_c_()) && !mocreature.getOwnerName().equals("NoOwner") && MoCreatures.instance.mapData != null) {
            return false;
        }
        if (MoCreatures.proxy.enableStrictOwnership) {
            int maxNumberOfPetsAllowed = 0;
            maxNumberOfPetsAllowed = MoCreatures.proxy.maxTamed;
            if (!MoCreatures.instance.mapData.isExistingPet(entityPlayer.func_70005_c_(), mocreature)) {
                int petCount = MoCTools.numberTamedByPlayer(entityPlayer);
                if (MoCTools.isThisPlayerAnOP(entityPlayer)) {
                    maxNumberOfPetsAllowed = MoCreatures.proxy.maxOPTamed;
                }
                if (petCount >= maxNumberOfPetsAllowed) {
                    if (MoCreatures.isServer()) {
                        String message = StatCollector.func_74837_a((String)"notify.MoCreatures.max_pet_count_reached", (Object[])new Object[]{maxNumberOfPetsAllowed});
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
                    }
                    return false;
                }
            }
        }
        mocreature.setOwner(entityPlayer.func_70005_c_());
        MoCMessageHandler.INSTANCE.sendTo((IMessage)new MoCMessageNameGUI(((Entity)mocreature).func_145782_y()), (EntityPlayerMP)entityPlayer);
        mocreature.setTamed(true);
        return true;
    }

    public static int numberTamedByPlayer(EntityPlayer entityPlayer) {
        if (MoCreatures.instance.mapData != null && MoCreatures.instance.mapData.getPetData(entityPlayer.func_70005_c_()) != null) {
            return MoCreatures.instance.mapData.getPetData(entityPlayer.func_70005_c_()).getTamedList().func_74745_c();
        }
        return 0;
    }

    public static int destroyBlocksInFront(Entity entity, double distance, int strength, int height) {
        if (strength == 0) {
            return 0;
        }
        int count = 0;
        float strengthF = strength;
        double newPosX = entity.field_70165_t - distance * Math.cos(MoCTools.realAngle(entity.field_70177_z - 90.0f) / 57.29578f);
        double newPosZ = entity.field_70161_v - distance * Math.sin(MoCTools.realAngle(entity.field_70177_z - 90.0f) / 57.29578f);
        double newPosY = entity.field_70163_u;
        int x = MathHelper.func_76128_c((double)newPosX);
        int y = MathHelper.func_76128_c((double)newPosY);
        int z = MathHelper.func_76128_c((double)newPosZ);
        for (int index = 0; index < height; ++index) {
            Block block = entity.field_70170_p.func_147439_a(x, y + index, z);
            if (block == Blocks.field_150350_a || block == Blocks.field_150357_h) continue;
            int metadata = entity.field_70170_p.func_72805_g(x, y + index, z);
            BlockEvent.BreakEvent event = null;
            if (!entity.field_70170_p.field_72995_K) {
                event = new BlockEvent.BreakEvent(x, y + index, z, entity.field_70170_p, block, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
            }
            if (event == null || event.isCanceled()) continue;
            block.func_149690_a(entity.field_70170_p, x, y + index, z, entity.field_70170_p.func_72805_g(x, y + index, z), 0.2f * strengthF, 1);
            entity.field_70170_p.func_147465_d(x, y + index, z, Blocks.field_150350_a, 0, 3);
            if (entity.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
            MoCTools.playCustomSound(entity, "golemwalk", entity.field_70170_p);
            ++count;
        }
        return count;
    }

    public static void dropInventory(Entity entity, MoCAnimalChest animalchest) {
        if (animalchest == null || !MoCreatures.isServer()) {
            return;
        }
        int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityPosY = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
        int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int l = 0; l < animalchest.func_70302_i_(); ++l) {
            ItemStack itemStack = animalchest.func_70301_a(l);
            if (itemStack == null) continue;
            float xOffset = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float yOffset = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float zOffset = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float motionMultiplier = 0.05f;
            EntityItem entityItem = new EntityItem(entity.field_70170_p, (double)((float)entityPosX + xOffset), (double)((float)entityPosY + yOffset), (double)((float)entityPosZ + zOffset), itemStack);
            entityItem.field_70159_w = (float)entity.field_70170_p.field_73012_v.nextGaussian() * motionMultiplier;
            entityItem.field_70181_x = (float)entity.field_70170_p.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
            entityItem.field_70179_y = (float)entity.field_70170_p.field_73012_v.nextGaussian() * motionMultiplier;
            entity.field_70170_p.func_72838_d((Entity)entityItem);
            animalchest.func_70299_a(l, null);
        }
    }

    public static void dropHorseAmuletWithNewPetInformation(MoCEntityTameableAnimal entity) {
        if (MoCreatures.isServer()) {
            ItemStack stack = MoCTools.getProperAmulet(entity);
            if (stack == null) {
                return;
            }
            if (stack.field_77990_d == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtTagCompound = stack.field_77990_d;
            try {
                nbtTagCompound.func_74768_a("SpawnClass", 21);
                nbtTagCompound.func_74776_a("MaxHealth", (float)entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                nbtTagCompound.func_74776_a("Health", entity.func_110143_aJ());
                nbtTagCompound.func_74768_a("Age", entity.getMoCAge());
                nbtTagCompound.func_74778_a("Name", entity.getName());
                nbtTagCompound.func_74757_a("Rideable", entity.getIsRideable());
                nbtTagCompound.func_74774_a("Armor", entity.getArmorType());
                nbtTagCompound.func_74768_a("CreatureType", entity.getType());
                nbtTagCompound.func_74757_a("Adult", entity.getIsAdult());
                nbtTagCompound.func_74778_a("OwnerName", entity.getOwnerName());
                nbtTagCompound.func_74768_a("PetId", entity.getOwnerPetId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            EntityPlayer ownerOfCreature = entity.field_70170_p.func_72924_a(entity.getOwnerName());
            if (ownerOfCreature != null && ownerOfCreature.field_71071_by.func_70447_i() != -1) {
                ownerOfCreature.field_71071_by.func_70441_a(stack);
            } else {
                EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                entityItem.field_145804_b = 20;
                entity.field_70170_p.func_72838_d((Entity)entityItem);
            }
        }
    }

    public static void dropAmuletWithNewPetInformation(IMoCTameable entity, int amuletType) {
        if (MoCreatures.isServer()) {
            ItemStack stack = new ItemStack(MoCreatures.fishNet, 1, 1);
            if (amuletType == 2) {
                stack = new ItemStack(MoCreatures.petAmulet, 1, 1);
            }
            if (stack.field_77990_d == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtTagCompound = stack.field_77990_d;
            try {
                String petClass = entity.getClass().getSimpleName().replace("MoCEntity", "");
                if (petClass.equalsIgnoreCase("Horse")) {
                    petClass = "Horse";
                } else if (petClass.equalsIgnoreCase("Komodo")) {
                    petClass = "KomodoDragon";
                }
                nbtTagCompound.func_74778_a("SpawnClass", petClass);
                nbtTagCompound.func_74776_a("MaxHealth", (float)((EntityLiving)entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                nbtTagCompound.func_74776_a("Health", ((EntityLiving)entity).func_110143_aJ());
                nbtTagCompound.func_74768_a("Age", entity.getMoCAge());
                nbtTagCompound.func_74778_a("Name", entity.getName());
                nbtTagCompound.func_74768_a("CreatureType", entity.getType());
                nbtTagCompound.func_74778_a("OwnerName", entity.getOwnerName());
                nbtTagCompound.func_74757_a("Adult", entity.getIsAdult());
                nbtTagCompound.func_74768_a("PetId", entity.getOwnerPetId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            EntityPlayer epOwner = ((EntityLivingBase)entity).field_70170_p.func_72924_a(entity.getOwnerName());
            if (epOwner != null) {
                epOwner.field_71071_by.func_70441_a(stack);
            } else {
                EntityItem entityItem = new EntityItem(((EntityLivingBase)entity).field_70170_p, ((EntityLivingBase)entity).field_70165_t, ((EntityLivingBase)entity).field_70163_u, ((EntityLivingBase)entity).field_70161_v, stack);
                entityItem.field_145804_b = 20;
                ((EntityLivingBase)entity).field_70170_p.func_72838_d((Entity)entityItem);
            }
        }
    }

    public static ItemStack getProperAmulet(MoCEntityAnimal entity) {
        if (entity instanceof MoCEntityHorse) {
            if (entity.getType() == 26 || entity.getType() == 27 || entity.getType() == 28) {
                return new ItemStack(MoCreatures.amuletBoneFull, 1, entity.getType());
            }
            if (entity.getType() > 47 && entity.getType() < 60) {
                return new ItemStack(MoCreatures.amuletFairyFull, 1, entity.getType());
            }
            if (entity.getType() == 39 || entity.getType() == 40) {
                return new ItemStack(MoCreatures.amuletPegasusFull, 1, entity.getType());
            }
            if (entity.getType() == 21 || entity.getType() == 22) {
                return new ItemStack(MoCreatures.amuletGhostFull, 1, entity.getType());
            }
        }
        return null;
    }

    public static ItemStack getProperEmptyAmulet(MoCEntityAnimal entity) {
        if (entity instanceof MoCEntityHorse) {
            if (entity.getType() == 26 || entity.getType() == 27 || entity.getType() == 28) {
                return new ItemStack(MoCreatures.amuletBone, 1, entity.getType());
            }
            if (entity.getType() > 49 && entity.getType() < 60) {
                return new ItemStack(MoCreatures.amuletFairy, 1, entity.getType());
            }
            if (entity.getType() == 39 || entity.getType() == 40) {
                return new ItemStack(MoCreatures.amuletPegasus, 1, entity.getType());
            }
            if (entity.getType() == 21 || entity.getType() == 22) {
                return new ItemStack(MoCreatures.amuletGhost, 1, entity.getType());
            }
        }
        return null;
    }

    public static int countPlayersInDimension(WorldServer worldObj, int dimension) {
        int playersInDimension = 0;
        for (int j = 0; j < worldObj.field_73010_i.size(); ++j) {
            EntityPlayerMP entityPlayermp = (EntityPlayerMP)worldObj.field_73010_i.get(j);
            if (entityPlayermp.field_71093_bK != dimension) continue;
            ++playersInDimension;
        }
        return playersInDimension;
    }

    public static boolean isThisPlayerAnOP(EntityPlayer player) {
        if (!MoCreatures.isServer()) {
            return false;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static void spawnMaggots(World worldObj, Entity entity) {
        if (MoCreatures.isServer()) {
            int amountOfMaggotsToSpawn = 1 + worldObj.field_73012_v.nextInt(4);
            for (int index = 0; index < amountOfMaggotsToSpawn; ++index) {
                float maggotPosX = ((float)(index % 2) - 0.5f) * 1.0f / 4.0f;
                float maggotPosZ = ((float)(index / 2) - 0.5f) * 1.0f / 4.0f;
                MoCEntityMaggot maggot = new MoCEntityMaggot(worldObj);
                maggot.func_70012_b(entity.field_70165_t + (double)maggotPosX, entity.field_70163_u + 0.5, entity.field_70161_v + (double)maggotPosZ, worldObj.field_73012_v.nextFloat() * 360.0f, 0.0f);
                worldObj.func_72838_d((Entity)maggot);
            }
        }
    }

    public static void faceItem(Entity entity, int xCoordinate, int yCoordinate, int zCoordinate, float f) {
        double xDistance = (double)xCoordinate - entity.field_70165_t;
        double yDistance = (double)yCoordinate - entity.field_70163_u;
        double zDistance = (double)zCoordinate - entity.field_70161_v;
        double overallDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
        float xzAngleInDegreesToNewLocation = (float)(Math.atan2(zDistance, xDistance) * 180.0 / Math.PI) - 90.0f;
        float yAngleInDegreesToNewLocation = (float)(Math.atan2(yDistance, overallDistanceSquared) * 180.0 / Math.PI);
        entity.field_70125_A = -MoCTools.adjustRotation(entity.field_70125_A, yAngleInDegreesToNewLocation, f);
        entity.field_70177_z = MoCTools.adjustRotation(entity.field_70177_z, xzAngleInDegreesToNewLocation, f);
    }

    public static float adjustRotation(float currentRotation, float rotationAdjustment, float rotationLimit) {
        float amountToChangeRotationBy = rotationAdjustment;
        for (amountToChangeRotationBy = rotationAdjustment - currentRotation; amountToChangeRotationBy < -180.0f; amountToChangeRotationBy += 360.0f) {
        }
        while (amountToChangeRotationBy >= 180.0f) {
            amountToChangeRotationBy -= 360.0f;
        }
        if (amountToChangeRotationBy > rotationLimit) {
            amountToChangeRotationBy = rotationLimit;
        }
        if (amountToChangeRotationBy < -rotationLimit) {
            amountToChangeRotationBy = -rotationLimit;
        }
        return currentRotation + amountToChangeRotationBy;
    }

    public static void getPathToEntity(EntityCreature creatureToMove, Entity entityTarget, float f) {
        PathEntity pathEntity = creatureToMove.field_70170_p.func_72865_a((Entity)creatureToMove, entityTarget, 16.0f, true, false, false, true);
        if (pathEntity != null && f < 12.0f) {
            creatureToMove.func_70778_a(pathEntity);
        }
    }

    public static void runAway(EntityCreature runningEntity, Entity scaryEntity) {
        double xDistanceBetweenEntities = runningEntity.field_70165_t - scaryEntity.field_70165_t;
        double zDistanceBetweenEntities = runningEntity.field_70161_v - scaryEntity.field_70161_v;
        double angleInRadiansToNewLocation = Math.atan2(xDistanceBetweenEntities, zDistanceBetweenEntities);
        double tempNewPosX = runningEntity.field_70165_t + Math.sin(angleInRadiansToNewLocation += (double)(runningEntity.field_70170_p.field_73012_v.nextFloat() - runningEntity.field_70170_p.field_73012_v.nextFloat()) * 0.75) * 8.0;
        double tempNewPosZ = runningEntity.field_70161_v + Math.cos(angleInRadiansToNewLocation) * 8.0;
        int temp1NewPosX = MathHelper.func_76128_c((double)tempNewPosX);
        int temp1NewPosY = MathHelper.func_76128_c((double)runningEntity.field_70121_D.field_72338_b);
        int temp1NewPosZ = MathHelper.func_76128_c((double)tempNewPosZ);
        for (int index = 0; index < 16; ++index) {
            int newPosX = temp1NewPosX + runningEntity.field_70170_p.field_73012_v.nextInt(4) - runningEntity.field_70170_p.field_73012_v.nextInt(4);
            int newPosY = temp1NewPosY + runningEntity.field_70170_p.field_73012_v.nextInt(3) - runningEntity.field_70170_p.field_73012_v.nextInt(3);
            int newPosZ = temp1NewPosZ + runningEntity.field_70170_p.field_73012_v.nextInt(4) - runningEntity.field_70170_p.field_73012_v.nextInt(4);
            if (newPosY <= 4 || runningEntity.field_70170_p.func_147439_a(newPosX, newPosY, newPosZ) != Blocks.field_150350_a && runningEntity.field_70170_p.func_147439_a(newPosX, newPosY, newPosZ) != Blocks.field_150433_aE || runningEntity.field_70170_p.func_147439_a(newPosX, newPosY - 1, newPosZ) == Blocks.field_150350_a) continue;
            PathEntity pathEntity = runningEntity.field_70170_p.func_72844_a((Entity)runningEntity, newPosX, newPosY, newPosZ, 16.0f, true, false, false, true);
            runningEntity.func_70778_a(pathEntity);
            break;
        }
    }

    public static boolean findClosestPlayerAndPoisonThem(Entity poisoner, boolean needsToBeInWater) {
        EntityPlayer entityPlayerTarget = poisoner.field_70170_p.func_72856_b(poisoner, 2.0);
        if (entityPlayerTarget != null && (needsToBeInWater && entityPlayerTarget.func_70090_H() || !needsToBeInWater) && poisoner.func_70032_d((Entity)entityPlayerTarget) < 2.0f && (entityPlayerTarget.field_70154_o == null || !(entityPlayerTarget.field_70154_o instanceof EntityBoat))) {
            entityPlayerTarget.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 0));
            return true;
        }
        return false;
    }

    public static boolean isTamed(Entity entity) {
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return true;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        entity.func_70109_d(nbt);
        if (nbt != null) {
            if (nbt.func_74764_b("Owner") && !nbt.func_74779_i("Owner").equals("")) {
                return true;
            }
            if (nbt.func_74764_b("Tamed") && nbt.func_74767_n("Tamed")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEntityRidingUndeadMoCreature(EntityLivingBase entityLivingBase, EntityLivingBase entityThatIsBeingTargetted) {
        return entityThatIsBeingTargetted instanceof EntityPlayer && (entityThatIsBeingTargetted.field_70154_o instanceof MoCEntityHorse && ((MoCEntityHorse)entityThatIsBeingTargetted.field_70154_o).isUndead() || entityThatIsBeingTargetted.field_70154_o instanceof MoCEntityOstrich && ((MoCEntityOstrich)entityThatIsBeingTargetted.field_70154_o).isUndead() || entityThatIsBeingTargetted.field_70154_o instanceof MoCEntityPetScorpion && ((MoCEntityPetScorpion)entityThatIsBeingTargetted.field_70154_o).isUndead()) && entityLivingBase.func_110144_aD() != entityThatIsBeingTargetted;
    }

    public static boolean isItemPlantMegaPackEdibleSaltWaterPlant(Item item) {
        return Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:oceanCommonEelgrass") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:waterKelpGiantGRN") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:waterKelpGiantYEL") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:oceanMozuku") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:oceanSeaGrapes") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:oceanSeaLettuce");
    }
}

