/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import drzhark.mocreatures.MoCPetMapData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.ambient.MoCEntityBee;
import drzhark.mocreatures.entity.animal.MoCEntityKitty;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfVillagerWitchery;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfWitchery;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MoCEventHooks {
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            MoCreatures.proxy.worldInitDone = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (DimensionManager.getWorld((int)0) != null && !MoCreatures.proxy.worldInitDone) {
            MoCPetMapData data = (MoCPetMapData)DimensionManager.getWorld((int)0).field_72988_C.func_75742_a(MoCPetMapData.class, "mocreatures");
            if (data == null) {
                data = new MoCPetMapData("mocreatures");
            }
            DimensionManager.getWorld((int)0).field_72988_C.func_75745_a("mocreatures", (WorldSavedData)data);
            DimensionManager.getWorld((int)0).field_72988_C.func_75744_a();
            MoCreatures.instance.mapData = data;
            MoCreatures.proxy.worldInitDone = true;
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (MoCreatures.isWitcheryLoaded && !event.entityLiving.field_70170_p.field_72995_K) {
            if (MoCreatures.proxy.replaceWitcheryWerewolfEntities) {
                if (event.entity instanceof EntityMob && EntityList.func_75621_b((Entity)event.entity).equals("witchery.wolfman")) {
                    Random rand = new Random();
                    if (MoCreatures.isMinecraftComesAliveLoaded && MoCreatures.proxy.useHumanModelAndMCAVillagerTexturesForWitcheryHumanWerewolfEntities) {
                        int[] villagerInformation = this.generateRandomDataForMinecraftComesAliveVillagerWerewolf();
                        MoCEntityWerewolfWitchery werewolf = new MoCEntityWerewolfWitchery(event.entity.field_70170_p, villagerInformation[0] + 1, villagerInformation[1], villagerInformation[2]);
                        werewolf.func_82149_j(event.entity);
                        event.entity.func_70106_y();
                        werewolf.field_70170_p.func_72838_d((Entity)werewolf);
                    } else {
                        MoCEntityWerewolfWitchery werewolf = new MoCEntityWerewolfWitchery(event.entity.field_70170_p, rand.nextInt(5), rand.nextInt(3) + 1);
                        werewolf.func_82149_j(event.entity);
                        event.entity.func_70106_y();
                        werewolf.field_70170_p.func_72838_d((Entity)werewolf);
                    }
                }
                if (event.entity instanceof EntityVillager && EntityList.func_75621_b((Entity)event.entity).equals("witchery.werevillager")) {
                    EntityVillager oldVillager = (EntityVillager)event.entity;
                    int professionToSet = oldVillager.func_70946_n();
                    MoCEntityWerewolfVillagerWitchery werewolfVillager = new MoCEntityWerewolfVillagerWitchery(event.entity.field_70170_p);
                    werewolfVillager.func_82149_j(event.entity);
                    werewolfVillager.func_70938_b(professionToSet);
                    event.entity.func_70106_y();
                    werewolfVillager.field_70170_p.func_72838_d((Entity)werewolfVillager);
                }
            }
            if ((MoCreatures.proxy.replaceWitcheryPlayerWolf || MoCreatures.proxy.replaceWitcheryPlayerWerewolf) && event.entity instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)event.entity;
                if (!entityPlayer.func_82150_aj() && (MoCTools.isPlayerInWolfForm(entityPlayer) && MoCreatures.proxy.replaceWitcheryPlayerWolf || MoCTools.isPlayerInWerewolfForm(entityPlayer) && MoCreatures.proxy.replaceWitcheryPlayerWerewolf)) {
                    entityPlayer.func_82142_c(true);
                } else if (entityPlayer.func_82150_aj() && !entityPlayer.func_70644_a(Potion.field_76441_p) && !MoCTools.isPlayerInWolfForm(entityPlayer) && !MoCTools.isPlayerInWerewolfForm(entityPlayer)) {
                    entityPlayer.func_82142_c(false);
                }
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)event.entity;
            if (creeper.field_70714_bg != null) {
                creeper.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)creeper, MoCEntityKitty.class, 6.0f, 1.0, 1.2));
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.entityLiving.func_70662_br() && event.entityLiving.func_110138_aP() < 50.0f && MoCTools.isEntityRidingUndeadMoCreature(event.entityLiving, event.target)) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void BreakEvent(BlockEvent.BreakEvent event) {
        if (MoCreatures.isPalmsHarvestLoaded && !event.world.field_72995_K && Block.field_149771_c.func_148750_c((Object)event.block).equals("harvestcraft:beehive")) {
            Random rand = new Random();
            int amountOfBeesToSpawn = 2 + rand.nextInt(5);
            for (int index = 0; index < amountOfBeesToSpawn; ++index) {
                MoCEntityBee bee = new MoCEntityBee(event.world);
                bee.func_70107_b(event.x, event.y, event.z);
                bee.func_110161_a(null);
                bee.func_70784_b((Entity)event.getPlayer());
                bee.field_70181_x += 0.3;
                bee.setIsFlying(true);
                bee.field_70170_p.func_72838_d((Entity)bee);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (MoCreatures.isServer() && IMoCTameable.class.isAssignableFrom(event.entityLiving.getClass())) {
            IMoCTameable mocEntity = (IMoCTameable)event.entityLiving;
            if (mocEntity.getIsTamed() && mocEntity.getPetHealth() > 0.0f && !mocEntity.isRiderDisconnecting()) {
                return;
            }
            if (mocEntity.getOwnerPetId() != -1) {
                MoCreatures.instance.mapData.removeOwnerPet(mocEntity, mocEntity.getOwnerPetId());
                if (MoCreatures.proxy.enableMoCPetDeathMessages) {
                    EntityPlayerMP ownerOfMocEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(mocEntity.getOwnerName());
                    Entity attacker = event.source.func_76346_g();
                    String attackerStringName = null;
                    DamageSource lastDamageBeforeDeath = event.source;
                    if (ownerOfMocEntityThatIsOnline != null) {
                        if (attacker != null) {
                            attackerStringName = attacker instanceof IMoCTameable && ((IMoCTameable)attacker).getIsTamed() ? ((IMoCTameable)attacker).getName() : attacker.func_70005_c_();
                            if (lastDamageBeforeDeath.func_76352_a()) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.arrow", new Object[]{mocEntity.getName(), attackerStringName}));
                            } else if (lastDamageBeforeDeath.func_82725_o()) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.indirectMagic", new Object[]{mocEntity.getName(), attackerStringName}));
                            } else if (lastDamageBeforeDeath.func_94541_c()) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.explosion.player", new Object[]{mocEntity.getName(), attackerStringName}));
                            } else {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.mob", new Object[]{mocEntity.getName(), attackerStringName}));
                            }
                        }
                        if (attacker == null) {
                            if ((lastDamageBeforeDeath == DamageSource.field_76370_b || lastDamageBeforeDeath == DamageSource.field_76372_a) && lastDamageBeforeDeath != DamageSource.field_76371_c) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.onFire", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76371_c) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.lava", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76368_d) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.inWall", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76369_e) {
                                if (mocEntity instanceof MoCEntityAquatic) {
                                    ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.MoCreatures.attack.dehydration", new Object[]{mocEntity.getName()}));
                                } else {
                                    ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.drown", new Object[]{mocEntity.getName()}));
                                }
                            } else if (lastDamageBeforeDeath == DamageSource.field_76367_g) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.cactus", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath.func_94541_c()) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.explosion", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76376_m) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.magic", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76379_h) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.fell.accident.generic", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_76380_i) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.outOfWorld", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_82727_n) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.wither", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_82728_o) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.anvil", new Object[]{mocEntity.getName()}));
                            } else if (lastDamageBeforeDeath == DamageSource.field_82729_p) {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.fallingBlock", new Object[]{mocEntity.getName()}));
                            } else {
                                ownerOfMocEntityThatIsOnline.func_145747_a((IChatComponent)new ChatComponentTranslation("death.attack.generic", new Object[]{mocEntity.getName()}));
                            }
                        }
                    }
                }
            }
        }
    }

    private int[] generateRandomDataForMinecraftComesAliveVillagerWerewolf() {
        Random rand = new Random();
        int[] villagerInformation = new int[3];
        int hairColor = rand.nextInt(3);
        int profession = 0;
        profession = hairColor == 0 || hairColor == 2 ? rand.nextInt(7) : rand.nextInt(3);
        int skinID = this.generateSkinIdForMinecraftComesAliveVillagerWerewolf(hairColor, profession);
        villagerInformation[0] = hairColor;
        villagerInformation[1] = profession;
        villagerInformation[2] = skinID;
        return villagerInformation;
    }

    private int generateSkinIdForMinecraftComesAliveVillagerWerewolf(int hairColor, int profession) {
        Random rand = new Random();
        if (hairColor == 0) {
            switch (profession) {
                case 0: {
                    return rand.nextInt(9);
                }
                case 1: {
                    return rand.nextInt(3);
                }
                case 2: {
                    return rand.nextInt(2);
                }
                case 3: {
                    return rand.nextInt(4);
                }
                case 4: {
                    return rand.nextInt(2);
                }
            }
            return 0;
        }
        if (hairColor == 1) {
            switch (profession) {
                case 0: {
                    return rand.nextInt(2);
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return rand.nextInt(3);
                }
            }
            return 0;
        }
        if (hairColor == 2) {
            switch (profession) {
                case 0: {
                    return rand.nextInt(15);
                }
                case 1: {
                    return rand.nextInt(8);
                }
                case 2: {
                    return rand.nextInt(2);
                }
                case 3: {
                    return rand.nextInt(9);
                }
                case 4: {
                    return rand.nextInt(3);
                }
            }
            return 0;
        }
        return 0;
    }
}

