/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Canvas;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.sdl.SDLError;
import org.lwjgl.sdl.SDLHints;
import org.lwjgl.sdl.SDLKeyboard;
import org.lwjgl.sdl.SDLKeycode;
import org.lwjgl.sdl.SDLPixels;
import org.lwjgl.sdl.SDLProperties;
import org.lwjgl.sdl.SDLSurface;
import org.lwjgl.sdl.SDLVideo;
import org.lwjgl.sdl.SDL_DisplayMode;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.Lwjgl3ifyEventLoop;
import org.lwjglx.Sys;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.ContextAttribs;
import org.lwjglx.opengl.DisplayImplementation;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.Drawable;
import org.lwjglx.opengl.DrawableGL;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.Sync;

public class Display {
    private static String windowTitle = "Game";
    public static final ReentrantLock glContextMutex = new ReentrantLock();
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean displayCloseRequested = false;
    private static WindowedState displayWindowed = WindowedState.WINDOWED;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static int latestEventKey = 0;
    private static int displayX = 0;
    private static int displayY = 0;
    private static boolean displayResized = false;
    private static int displayWidth = 1;
    private static int displayHeight = 1;
    private static int displayFramebufferWidth = 1;
    private static int displayFramebufferHeight = 1;
    private static boolean latestResized = false;
    private static int latestWidth = 0;
    private static int latestHeight = 0;
    private static boolean cancelNextChar = false;
    private static Keyboard.KeyEvent ingredientKeyEvent;
    private static ByteBuffer[] savedIcons;
    private static boolean lastAltIsRightAlt;
    private static Int2ObjectOpenHashMap<String> sdlKeycodeNames;
    public static volatile long sdlWindow;
    public static volatile long sdlHiddenWindow;
    public static volatile long sdlMainGlContext;
    public static volatile long sdlCloneableGlContext;
    public static int sdlWindowId;
    private static final ByteBuffer HINT_MOUSE_RELATIVE_SYSTEM_SCALE;
    private static final ByteBuffer STR_0;
    private static final ByteBuffer STR_1;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixelFormat, Drawable sharedDrawable) {
        Display.create(pixelFormat, null, sharedDrawable.getSdlWindowId());
    }

    public static void create() {
        Display.create(null, (ContextAttribs)null);
    }

    public static void create(PixelFormat pixelFormat) {
        Display.create(pixelFormat, (ContextAttribs)null);
    }

    public static void create(PixelFormat pixelFormat, ContextAttribs attribs) {
        Display.create(pixelFormat, attribs, 0L);
    }

    public static void create(PixelFormat pixelFormat, ContextAttribs attribs, long sharedWindow) {
        if (displayCreated) {
            return;
        }
        Sys.initialize();
        MainThreadExec.runOnMainThread(() -> {
            int ctxMajor = attribs != null ? attribs.getMajorVersion() : 2;
            int ctxMinor = attribs != null ? attribs.getMinorVersion() : 1;
            boolean ctxForwardCompat = attribs != null && attribs.isForwardCompatible();
            boolean ctxDebug = attribs != null && attribs.isDebug() || Config.OPENGL_DEBUG_CONTEXT || Config.DEBUG_REGISTER_OPENGL_LOGGER;
            boolean ctxSrgb = pixelFormat != null ? pixelFormat.isSRGB() : Config.OPENGL_SRGB_CONTEXT;
            int props = SDLProperties.SDL_CreateProperties();
            try {
                long windowFlags = 0L;
                if (Config.WINDOW_START_FOCUSED) {
                    windowFlags |= 0x600L;
                }
                if (Config.WINDOW_START_ICONIFIED) {
                    windowFlags |= 0x40L;
                }
                if (!Config.WINDOW_DECORATED) {
                    windowFlags |= 0x10L;
                }
                Sys.checkSdl(SDLProperties.SDL_SetNumberProperty((int)props, (CharSequence)"SDL.window.create.x", (long)(Config.WINDOW_CENTERED ? (long)SDLVideo.SDL_WINDOWPOS_CENTERED : (long)SDLVideo.SDL_WINDOWPOS_UNDEFINED)));
                Sys.checkSdl(SDLProperties.SDL_SetNumberProperty((int)props, (CharSequence)"SDL.window.create.y", (long)(Config.WINDOW_CENTERED ? (long)SDLVideo.SDL_WINDOWPOS_CENTERED : (long)SDLVideo.SDL_WINDOWPOS_UNDEFINED)));
                Sys.checkSdl(SDLProperties.SDL_SetNumberProperty((int)props, (CharSequence)"SDL.window.create.width", (long)mode.getWidth()));
                Sys.checkSdl(SDLProperties.SDL_SetNumberProperty((int)props, (CharSequence)"SDL.window.create.height", (long)mode.getHeight()));
                Sys.checkSdl(SDLProperties.SDL_SetNumberProperty((int)props, (CharSequence)"SDL.window.create.flags", (long)windowFlags));
                Sys.checkSdl(SDLProperties.SDL_SetStringProperty((int)props, (CharSequence)"SDL.window.create.title", (CharSequence)windowTitle));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.opengl", (boolean)true));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.high_pixel_density", (boolean)Config.WINDOW_HIDPI_RENDERING));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.hidden", (boolean)false));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.resizable", (boolean)true));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.borderless", (!Config.WINDOW_DECORATED ? 1 : 0) != 0));
                Sys.checkSdl(SDLProperties.SDL_SetBooleanProperty((int)props, (CharSequence)"SDL.window.create.maximized", (boolean)Config.WINDOW_START_MAXIMIZED));
                int ctxFlags = 0;
                if (ctxForwardCompat) {
                    ctxFlags |= 2;
                }
                if (ctxDebug) {
                    ctxFlags |= 1;
                }
                SDLVideo.SDL_GL_ResetAttributes();
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)19, (int)ctxFlags));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)17, (int)ctxMajor));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)18, (int)ctxMinor));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)2, (int)(ctxForwardCompat ? 1 : 0)));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)22, (int)(ctxSrgb ? 1 : 0)));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)5, (int)(Config.OPENGL_DOUBLEBUFFER ? 1 : 0)));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)25, (int)(Config.OPENGL_CONTEXT_NO_ERROR ? 1 : 0)));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)6, (int)24));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)7, (int)8));
                Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)21, (int)1));
                if (attribs != null) {
                    if (attribs.isProfileCore()) {
                        Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)20, (int)1));
                    } else if (attribs.isProfileCompatibility()) {
                        Sys.checkSdl(SDLVideo.SDL_GL_SetAttribute((int)20, (int)2));
                    }
                }
                if ((sdlWindow = SDLVideo.SDL_CreateWindowWithProperties((int)props)) == 0L) {
                    throw new RuntimeException("Could not create the Display window: " + SDLError.SDL_GetError());
                }
                sdlWindowId = SDLVideo.SDL_GetWindowID((long)sdlWindow);
                Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)0L));
                sdlMainGlContext = SDLVideo.SDL_GL_CreateContext((long)sdlWindow);
                if (sdlMainGlContext == 0L) {
                    throw new RuntimeException("Could not create an OpenGL context: " + SDLError.SDL_GetError());
                }
                sdlHiddenWindow = SDLVideo.SDL_CreateWindow((CharSequence)"lwjgl3ify-cloneableGlContext", (int)1, (int)1, (long)10L);
                if (sdlHiddenWindow == 0L) {
                    throw new RuntimeException("Could not create the hidden Display window for sharing GL contexts: " + SDLError.SDL_GetError());
                }
                sdlCloneableGlContext = SDLVideo.SDL_GL_CreateContext((long)sdlHiddenWindow);
                if (sdlCloneableGlContext == 0L) {
                    throw new RuntimeException("Could not create a secondary OpenGL context: " + SDLError.SDL_GetError());
                }
                Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)sdlMainGlContext));
                Sys.checkSdl(SDLVideo.nSDL_GL_LoadLibrary((long)0L));
                Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)0L));
            }
            finally {
                SDLProperties.SDL_DestroyProperties((int)props);
            }
            long actualWindowFlags = SDLVideo.SDL_GetWindowFlags((long)sdlWindow);
            displayFocused = (actualWindowFlags & 0x200L) != 0L;
            displayVisible = (actualWindowFlags & 0x40L) == 0L;
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer w = stack.ints(0);
                IntBuffer h = stack.ints(0);
                SDLVideo.SDL_GetWindowSize((long)sdlWindow, (IntBuffer)w, (IntBuffer)h);
                displayWidth = w.get(0);
                displayHeight = h.get(0);
                SDLVideo.SDL_GetWindowSizeInPixels((long)sdlWindow, (IntBuffer)w, (IntBuffer)h);
                latestWidth = displayFramebufferWidth = w.get(0);
                latestHeight = displayFramebufferHeight = h.get(0);
            }
            if (savedIcons != null) {
                Display.setIcon(savedIcons);
                savedIcons = null;
            }
            SDLVideo.SDL_GL_SetSwapInterval((int)1);
            displayCreated = true;
            Display.lwjgl3ify$updateRawMouseMode(Config.INPUT_RAW_MOUSE);
            Keyboard.sdlKeyPressedArray = SDLKeyboard.SDL_GetKeyboardState();
            Mouse.create();
            Keyboard.create();
            if (Display.displayWindowed.isFullscreen) {
                Display.setFullscreen(true);
            }
        });
        Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)sdlMainGlContext));
        GL.create(SDLVideo::SDL_GL_GetProcAddress);
        drawable = new DrawableGL();
        drawable.makeCurrent();
        if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
            Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-created");
        }
    }

    public static void lwjgl3ify$updateRawMouseMode(boolean mode) {
        MainThreadExec.runOnMainThread(() -> {
            SDLHints.SDL_SetHintWithPriority((ByteBuffer)HINT_MOUSE_RELATIVE_SYSTEM_SCALE, (ByteBuffer)(mode ? STR_0 : STR_1), (int)2);
            Lwjgl3ifyCoremod.LOGGER.info("Updated raw mouse input mode to " + mode);
        });
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        Sys.checkSdl(SDLVideo.SDL_SetWindowPosition((long)sdlWindow, (int)new_x, (int)new_y));
    }

    public static void setVSyncEnabled(boolean sync) {
        Sys.checkSdl(SDLVideo.SDL_GL_SetSwapInterval((int)(sync ? 1 : 0)));
    }

    public static long getWindow() {
        return sdlWindow;
    }

    public static long getGlContext() {
        return sdlMainGlContext;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
        if (latestResized) {
            latestResized = false;
            displayResized = true;
        } else {
            displayResized = false;
        }
    }

    public static void processMessages() {
        Lwjgl3ifyEventLoop.pumpEvents();
        Keyboard.poll();
        Mouse.poll();
    }

    public static void swapBuffers() {
        Sys.checkSdl(SDLVideo.SDL_GL_SwapWindow((long)sdlWindow));
    }

    public static void destroy() {
        if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
            Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-destroy");
        }
        try {
            GL.setCapabilities(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            GL.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MainThreadExec.runOnMainThread(() -> {
            if (sdlCloneableGlContext != 0L) {
                SDLVideo.SDL_GL_DestroyContext((long)sdlCloneableGlContext);
                sdlCloneableGlContext = 0L;
            }
            if (sdlHiddenWindow != 0L) {
                SDLVideo.SDL_DestroyWindow((long)sdlHiddenWindow);
                sdlHiddenWindow = 0L;
            }
            if (sdlMainGlContext != 0L) {
                SDLVideo.SDL_GL_DestroyContext((long)sdlMainGlContext);
                sdlMainGlContext = 0L;
            }
            if (sdlWindow != 0L) {
                SDLVideo.SDL_DestroyWindow((long)sdlWindow);
                sdlWindow = 0L;
                sdlWindowId = 0;
            }
        });
        displayCreated = false;
    }

    public static synchronized void setDisplayMode(DisplayMode dm) {
        mode = dm;
        if (Display.isCreated()) {
            if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-set desktop mode: {}", new Object[]{dm});
            }
            MainThreadExec.runOnMainThread(() -> SDLVideo.SDL_SetWindowSize((long)sdlWindow, (int)dm.getWidth(), (int)dm.getHeight()));
        }
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        return MainThreadExec.runOnMainThread(() -> {
            int monitor = Sys.checkSdl(SDLVideo.SDL_GetPrimaryDisplay());
            PointerBuffer modes = Sys.checkSdl(SDLVideo.SDL_GetFullscreenDisplayModes((int)monitor));
            DisplayMode[] displayModes = new DisplayMode[modes.remaining()];
            for (int i = 0; i < displayModes.length; ++i) {
                SDL_DisplayMode reader = new SDL_DisplayMode(modes.getByteBuffer(i, SDL_DisplayMode.SIZEOF));
                byte bpp = Sys.checkSdl(SDLPixels.SDL_GetPixelFormatDetails((int)reader.format())).bits_per_pixel();
                displayModes[i] = new DisplayMode(reader.w(), reader.h(), bpp, Math.round(reader.refresh_rate()));
            }
            modes.free();
            return displayModes;
        });
    }

    public static DisplayMode getDesktopDisplayMode() {
        return MainThreadExec.runOnMainThread(() -> {
            int monitor = Sys.checkSdl(SDLVideo.SDL_GetPrimaryDisplay());
            SDL_DisplayMode mode = Sys.checkSdl(SDLVideo.SDL_GetDesktopDisplayMode((int)monitor));
            DisplayMode lwjglMode = new DisplayMode(mode.w(), mode.h(), Sys.checkSdl(SDLPixels.SDL_GetPixelFormatDetails((int)mode.format())).bits_per_pixel(), Math.round(mode.refresh_rate()));
            if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-get desktop mode: {}", new Object[]{lwjglMode});
            }
            return lwjglMode;
        });
    }

    public static synchronized boolean wasResized() {
        return displayResized;
    }

    public static synchronized int getX() {
        return displayX;
    }

    public static synchronized int getY() {
        return displayY;
    }

    public static synchronized int getWidth() {
        return displayFramebufferWidth;
    }

    public static synchronized int getHeight() {
        return displayFramebufferHeight;
    }

    public static synchronized void setTitle(String title) {
        windowTitle = title;
        if (Display.isCreated()) {
            MainThreadExec.runOnMainThread(() -> Sys.checkSdl(SDLVideo.SDL_SetWindowTitle((long)sdlWindow, (CharSequence)title)));
        }
    }

    public static synchronized boolean isCloseRequested() {
        boolean saved = displayCloseRequested;
        displayCloseRequested = false;
        return saved;
    }

    public static synchronized boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (icons == null || icons.length == 0) {
            return 0;
        }
        if (sdlWindow == 0L) {
            savedIcons = new ByteBuffer[icons.length];
            for (int i = 0; i < icons.length; ++i) {
                ByteBuffer icon = icons[i];
                Display.savedIcons[i] = ByteBuffer.allocate(icon.remaining()).order(ByteOrder.nativeOrder());
                int oldPos = icon.position();
                savedIcons[i].put(icon);
                icon.position(oldPos);
                savedIcons[i].flip();
            }
            return icons.length;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            SDL_Surface iconSet = null;
            ByteBuffer[] sortedIcons = Arrays.copyOf(icons, icons.length);
            Arrays.sort(sortedIcons, Comparator.comparingInt(bb -> -bb.remaining()));
            for (int icon = 0; icon < sortedIcons.length; ++icon) {
                ByteBuffer iconRgba = sortedIcons[icon];
                int dimension = (int)Math.sqrt((double)iconRgba.remaining() / 4.0);
                if (dimension * dimension * 4 != iconRgba.remaining()) {
                    throw new IllegalStateException("Could not determine icon size from a buffer length of " + iconRgba.remaining());
                }
                SDL_Surface iconSurface = Sys.checkSdl(SDLSurface.SDL_CreateSurface((int)dimension, (int)dimension, (int)SDLPixels.SDL_PIXELFORMAT_RGBA32));
                Sys.checkSdl(SDLSurface.SDL_LockSurface((SDL_Surface)iconSurface));
                ByteBuffer pixels = Objects.requireNonNull(iconSurface.pixels());
                int oldPos = iconRgba.position();
                pixels.put(iconRgba);
                iconRgba.position(oldPos);
                SDLSurface.SDL_UnlockSurface((SDL_Surface)iconSurface);
                if (iconSet == null) {
                    iconSet = iconSurface;
                    continue;
                }
                SDLSurface.SDL_AddSurfaceAlternateImage((SDL_Surface)iconSet, (SDL_Surface)iconSurface);
            }
            SDLVideo.SDL_SetWindowIcon((long)Display.getWindow(), iconSet);
            SDLSurface.SDL_DestroySurface(iconSet);
        }
        return icons.length;
    }

    public static synchronized void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static synchronized boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        Display.setDisplayMode(mode);
        Display.setFullscreen(true);
    }

    public static void setFullscreen(boolean fullscreen) {
        WindowedState windowedState = displayWindowed = fullscreen ? WindowedState.fullscreen() : WindowedState.WINDOWED;
        if (sdlWindow != 0L) {
            MainThreadExec.runOnMainThread(() -> {
                SDLVideo.SDL_SetWindowFullscreen((long)sdlWindow, (boolean)fullscreen);
                if (!fullscreen) {
                    SDLVideo.SDL_SetWindowSize((long)sdlWindow, (int)mode.getWidth(), (int)mode.getHeight());
                }
                SDLVideo.SDL_SyncWindow((long)sdlWindow);
            });
        }
    }

    public static boolean isFullscreen() {
        return Display.displayWindowed.isFullscreen;
    }

    public static void setParent(Canvas parent) {
    }

    public static void releaseContext() {
        glContextMutex.lock();
        try {
            SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)0L);
        }
        finally {
            glContextMutex.unlock();
        }
    }

    public static boolean isCurrent() {
        return SDLVideo.SDL_GL_GetCurrentContext() == sdlMainGlContext;
    }

    public static void makeCurrent() {
        glContextMutex.lock();
        try {
            SDLVideo.SDL_GL_MakeCurrent((long)sdlWindow, (long)sdlMainGlContext);
        }
        finally {
            glContextMutex.unlock();
        }
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7938);
        }
        return "Unknown";
    }

    public static String getTitle() {
        return windowTitle;
    }

    public static Canvas getParent() {
        return null;
    }

    public static float getPixelScaleFactor() {
        if (!Display.isCreated()) {
            return 1.0f;
        }
        return (float)MainThreadExec.runOnMainThread(() -> SDLVideo.SDL_GetWindowPixelDensity((long)sdlWindow));
    }

    public static void setSwapInterval(int value) {
        MainThreadExec.runOnMainThread(() -> SDLVideo.SDL_GL_SetSwapInterval((int)value));
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) {
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    static DisplayImplementation getImplementation() {
        return null;
    }

    public static synchronized boolean lwjgl3ify$handleSdlEvent() {
        boolean bl;
        switch (Lwjgl3ifyEventLoop.event.type()) {
            case 256: {
                displayCloseRequested = true;
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-close-request");
                }
                bl = true;
                break;
            }
            case 516: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayDirty = true;
                bl = true;
                break;
            }
            case 526: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayFocused = true;
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-focus");
                }
                bl = true;
                break;
            }
            case 527: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayFocused = false;
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-unfocus");
                }
                bl = true;
                break;
            }
            case 521: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayVisible = false;
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-minimize");
                }
                bl = true;
                break;
            }
            case 523: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayVisible = true;
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-restore");
                }
                bl = true;
                break;
            }
            case 518: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayWidth = Lwjgl3ifyEventLoop.windowEvent.data1();
                displayHeight = Lwjgl3ifyEventLoop.windowEvent.data2();
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] window-resize window:{} w:{} h:{}", new Object[]{Lwjgl3ifyEventLoop.windowEvent.windowID(), displayWidth, displayHeight});
                }
                bl = true;
                break;
            }
            case 519: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayFramebufferWidth = Lwjgl3ifyEventLoop.windowEvent.data1();
                displayFramebufferHeight = Lwjgl3ifyEventLoop.windowEvent.data2();
                if (Config.DEBUG_PRINT_WINDOW_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-WINDOW] framebuffer-pixel scale change window:{} w:{} h:{}", new Object[]{Lwjgl3ifyEventLoop.windowEvent.windowID(), displayFramebufferWidth, displayFramebufferHeight});
                }
                latestResized = true;
                latestWidth = displayFramebufferWidth;
                latestHeight = displayFramebufferHeight;
                bl = true;
                break;
            }
            case 517: {
                if (Lwjgl3ifyEventLoop.windowEvent.windowID() != sdlWindowId) {
                    bl = true;
                    break;
                }
                displayX = Lwjgl3ifyEventLoop.windowEvent.data1();
                displayY = Lwjgl3ifyEventLoop.windowEvent.data2();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    static {
        lastAltIsRightAlt = false;
        sdlKeycodeNames = new Int2ObjectOpenHashMap();
        try {
            Class<SDLKeycode> keycodeClass = SDLKeycode.class;
            for (Field f : keycodeClass.getFields()) {
                if (!f.getName().startsWith("SDLK") || f.getType() != Integer.TYPE || !Modifier.isStatic(f.getModifiers())) continue;
                int value = f.getInt(null);
                sdlKeycodeNames.put(value, (Object)f.getName());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        HINT_MOUSE_RELATIVE_SYSTEM_SCALE = MemoryUtil.memASCII((CharSequence)"SDL_MOUSE_RELATIVE_SYSTEM_SCALE");
        STR_0 = MemoryUtil.memASCII((CharSequence)"0");
        STR_1 = MemoryUtil.memASCII((CharSequence)"1");
        drawable = null;
    }

    static enum WindowedState {
        WINDOWED(false),
        BORDERLESS(true),
        FULLSCREEN(true);

        public final boolean isFullscreen;

        private WindowedState(boolean isFullscreen) {
            this.isFullscreen = isFullscreen;
        }

        public static WindowedState fullscreen() {
            return Config.WINDOW_BORDERLESS_REPLACES_FULLSCREEN ? BORDERLESS : FULLSCREEN;
        }
    }
}

