/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.textures;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import me.eigenraven.lwjgl3ify.textures.FastByteChannel;
import org.apache.commons.io.IOUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.spng.SPNG;
import org.lwjgl.util.spng.spng_ihdr;

public class NativeBackedImage
extends BufferedImage
implements AutoCloseable {
    private final int width;
    private final int height;
    private long pointer;
    private final int sizeBytes;
    static final int MAX_IMAGE_DIM = 32768;

    private NativeBackedImage(int width, int height, long pointer) {
        super(width, height, 2);
        this.width = width;
        this.height = height;
        this.pointer = pointer;
        this.sizeBytes = width * height * 4;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        for (int z = startY; z < h; ++z) {
            for (int x = startX; x < w; ++x) {
                int finalColor;
                int color = MemoryUtil.memGetInt((long)(this.pointer + (long)((x + z * this.width) * 4)));
                int a = color >> 24 & 0xFF;
                int b = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int r = color >> 0 & 0xFF;
                rgbArray[x + z * this.width] = finalColor = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return rgbArray;
    }

    @Override
    public int getRGB(int x, int z) {
        this.checkBounds(x, z);
        return MemoryUtil.memGetInt((long)(this.pointer + (long)((x + z * this.width) * 4)));
    }

    @Override
    public void setRGB(int x, int z, int rgb) {
        this.checkBounds(x, z);
        MemoryUtil.memPutInt((long)(this.pointer + (long)((x + z * this.width) * 4)), (int)rgb);
    }

    @Override
    public BufferedImage getSubimage(int x, int y, int w, int h) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void close() throws Exception {
        if (this.pointer != 0L) {
            MemoryUtil.nmemFree((long)this.pointer);
            this.pointer = 0L;
        }
    }

    private void checkBounds(int x, int z) {
        if (x < 0 || x >= this.width || z < 0 || z >= this.height) {
            throw new IllegalStateException("Out of bounds: " + x + ", " + z + " (width: " + this.width + ", height: " + this.height + ")");
        }
    }

    private static final void spngCheck(int ec) throws IOException {
        if (ec == 0) {
            return;
        }
        throw new IOException("Error while decoding PNG data: " + SPNG.spng_strerror((int)ec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeBackedImage make(InputStream stream) throws IOException {
        ByteBuffer imgBuf = null;
        try {
            NativeBackedImage nativeBackedImage;
            block15: {
                imgBuf = NativeBackedImage.readResource(stream);
                imgBuf.rewind();
                MemoryStack memoryStack = MemoryStack.stackPush();
                try {
                    long imageBuffer;
                    PointerBuffer outSize = memoryStack.mallocPointer(1);
                    spng_ihdr ihdr = spng_ihdr.calloc((MemoryStack)memoryStack);
                    long ctx = SPNG.spng_ctx_new((int)0);
                    try {
                        NativeBackedImage.spngCheck(SPNG.spng_set_image_limits((long)ctx, (int)0x200000, (int)0x200000));
                        NativeBackedImage.spngCheck(SPNG.spng_set_chunk_limits((long)ctx, (long)0x40000000L, (long)0x40000000L));
                        NativeBackedImage.spngCheck(SPNG.spng_set_png_buffer((long)ctx, (ByteBuffer)imgBuf));
                        NativeBackedImage.spngCheck(SPNG.spng_decoded_image_size((long)ctx, (int)1, (PointerBuffer)outSize));
                        if (outSize.get(0) > 0x40000000L) {
                            throw new IOException(String.format("Could not load image: output buffer size %d larger than max supported %d x %d", outSize.get(0), 32768, 32768));
                        }
                        int outSizeI = Math.toIntExact(outSize.get(0));
                        NativeBackedImage.spngCheck(SPNG.spng_get_ihdr((long)ctx, (spng_ihdr)ihdr));
                        imageBuffer = MemoryUtil.nmemAlloc((long)outSizeI);
                        int decodeEc = SPNG.nspng_decode_image((long)ctx, (long)imageBuffer, (long)outSizeI, (int)1, (int)3);
                        if (decodeEc != 0) {
                            MemoryUtil.nmemFree((long)imageBuffer);
                            NativeBackedImage.spngCheck(decodeEc);
                        }
                    }
                    finally {
                        SPNG.spng_ctx_free((long)ctx);
                    }
                    nativeBackedImage = new NativeBackedImage(ihdr.width(), ihdr.height(), imageBuffer);
                    if (memoryStack == null) break block15;
                }
                catch (Throwable throwable) {
                    if (memoryStack != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                memoryStack.close();
            }
            return nativeBackedImage;
        }
        finally {
            MemoryUtil.memFree((ByteBuffer)imgBuf);
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static ByteBuffer readResource(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer;
        if (inputStream instanceof FileInputStream) {
            FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
            byteBuffer = MemoryUtil.memAlloc((int)((int)fileChannel.size() + 1));
            while (fileChannel.read(byteBuffer) != -1) {
            }
        } else {
            int sizeGuess = 4096;
            try {
                sizeGuess = Math.max(4096, inputStream.available());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byteBuffer = MemoryUtil.memAlloc((int)(sizeGuess * 2));
            FastByteChannel readableByteChannel = new FastByteChannel(inputStream);
            while (readableByteChannel.read(byteBuffer) != -1) {
                if (byteBuffer.remaining() != 0) continue;
                byteBuffer = MemoryUtil.memRealloc((ByteBuffer)byteBuffer, (int)(byteBuffer.capacity() * 2));
            }
        }
        return byteBuffer;
    }
}

