/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.util;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.util.BlockPos;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Tools {
    public static String translate(String str, Object ... args) {
        return new ChatComponentTranslation(str, args).func_150254_d();
    }

    public static String dimIDToString(int id) {
        Map<Integer, String> dims = Config.instance().dimensionNames;
        String name = dims.get(id);
        if (name == null || name.isEmpty()) {
            return String.valueOf(id);
        }
        return name;
    }

    public static String getStringFromItem(Item item) {
        if (item == null) {
            return null;
        }
        return Item.field_150901_e.func_148750_c((Object)item).toString();
    }

    public static String translateItem(String str, int meta) {
        if (str == null) {
            return null;
        }
        Item i = (Item)Item.field_150901_e.func_82594_a(str);
        if (i == null) {
            return null;
        }
        return i.func_77653_i(new ItemStack(i, 1, meta));
    }

    public static boolean isArrayEmpty(Object[] obj) {
        for (Object o : obj) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean keepInventory(EntityPlayer player) {
        try {
            return player.field_70170_p.func_72912_H().func_82574_x().func_82766_b("keepInventory");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String timeToString(long time) {
        if (time == 0L) {
            return "";
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        SimpleDateFormat sdf = new SimpleDateFormat(Config.instance().dateFormat);
        return sdf.format(c.getTime());
    }

    public static ArrayList<Block> getBlocks(String[] names) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : names) {
            Block b = Tools.getBlock(s);
            if (b == null) continue;
            blocks.add(b);
        }
        return blocks;
    }

    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                if (b.equals(Blocks.field_150350_a)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IInventory inv) {
        Tools.drop(worldIn, pos.getX(), pos.getY(), pos.getZ(), inv);
    }

    private static void drop(World worldIn, double p_180174_1_, double p_180174_3_, double p_180174_5_, IInventory p_180174_7_) {
        for (int i = 0; i < p_180174_7_.func_70302_i_(); ++i) {
            ItemStack itemstack = p_180174_7_.func_70301_a(i);
            if (itemstack == null) continue;
            Tools.spawnItemStack(worldIn, p_180174_1_, p_180174_3_, p_180174_5_, itemstack);
        }
    }

    private static void spawnItemStack(World worldIn, double p_180173_1_, double p_180173_3_, double p_180173_5_, ItemStack p_180173_7_) {
        Random random = new Random();
        float f = random.nextFloat() * 0.8f + 0.1f;
        float f1 = random.nextFloat() * 0.8f + 0.1f;
        float f2 = random.nextFloat() * 0.8f + 0.1f;
        while (p_180173_7_.field_77994_a > 0) {
            int i = random.nextInt(21) + 10;
            if (i > p_180173_7_.field_77994_a) {
                i = p_180173_7_.field_77994_a;
            }
            p_180173_7_.field_77994_a -= i;
            EntityItem entityitem = new EntityItem(worldIn, p_180173_1_ + (double)f, p_180173_3_ + (double)f1, p_180173_5_ + (double)f2, new ItemStack(p_180173_7_.func_77973_b(), i, p_180173_7_.func_77960_j()));
            if (p_180173_7_.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)p_180173_7_.func_77978_p().func_74737_b());
            }
            float f3 = 0.05f;
            entityitem.field_70159_w = random.nextGaussian() * (double)f3;
            entityitem.field_70181_x = random.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = random.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public static int oppositeSite(EntityLivingBase entity) {
        int l = ((MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
        if (l == 0) {
            l = 2;
        } else if (l == 1) {
            l = 3;
        } else if (l == 2) {
            l = 0;
        } else if (l == 3) {
            l = 1;
        }
        return l;
    }
}

