/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.coremods.antiidconflict.managers;

import code.elix_x.coremods.antiidconflict.AntiIdConflictBase;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;

public class BiomesManager {
    public static String freeBiomeIDs = "";
    public static String occupiedBiomeIDs = "";
    public static String conflictedIds = "";
    public static boolean crashIfConflict;
    public static boolean ignoreRegistry;
    public static boolean debug;
    public static int freeIds;
    public static int occupiedIds;
    public static int IconflictedIds;
    public static ConflictingBiomes[] conflicts;

    public static void preinit(FMLPreInitializationEvent event) throws Exception {
        AntiIdConflictBase.biomesFolder = new File(AntiIdConflictBase.mainFolder, "\\biomes");
        AntiIdConflictBase.biomesFolder.mkdir();
        BiomesManager.setUpBiomesFolder();
    }

    public static void init(FMLInitializationEvent event) {
    }

    public static void postinit(FMLPostInitializationEvent event) throws Exception {
        BiomesManager.updateConflictedArrays();
        BiomesManager.updateBiomesFolder();
        BiomesManager.crash();
    }

    public static void setUpBiomesFolder() throws Exception {
        File conf = new File(AntiIdConflictBase.biomesFolder, "\\main.cfg");
        conf.createNewFile();
        Configuration config = new Configuration(conf);
        config.load();
        crashIfConflict = config.getBoolean("crashIfConflict", "Settings of reaction to repeated ids", true, "If mod detects biome trying to ovverride old one, force Minecraft to crash.\nRecommendation: do not tuch, may lead to worlds problems");
        ignoreRegistry = config.getBoolean("ignoreRegistry", "Settings of reaction to repeated ids", true, "If mod detects biome trying to ovverride old one, force Minecraft to crash EVEN IF BIOME ISN'T REGISTERED.\nRecommendation: do not tuch, may lead to many many many problems");
        debug = config.getBoolean("debug", "Settings of console output", false, "Enable debugging messages in console");
        config.save();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateBiomesFolder() throws Exception {
        void var0_1;
        boolean bl = false;
        while (var0_1 < BiomeGenBase.func_150565_n().length) {
            if (BiomeGenBase.func_150565_n()[var0_1] == null) {
                freeBiomeIDs = freeBiomeIDs + (int)var0_1 + "\n";
                ++freeIds;
            }
            ++var0_1;
        }
        System.out.println("Found tottally " + freeIds + " free biome ids");
        for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
            if (biomeGenBase == null) continue;
            occupiedBiomeIDs = occupiedBiomeIDs + biomeGenBase.field_76756_M + " : " + biomeGenBase.field_76791_y + " (" + biomeGenBase.func_150562_l() + ")\n";
            ++occupiedIds;
        }
        System.out.println("Found tottally " + occupiedIds + " occupied biome ids");
        for (ConflictingBiomes conflictingBiomes : conflicts) {
            if (conflictingBiomes == null) continue;
            if (debug) {
                System.out.println("Found biomes id conflict for " + conflictingBiomes.ID + " : " + conflictingBiomes.getCrashMessage());
            }
            conflictedIds = conflictedIds + conflictingBiomes.getCrashMessage() + "\n";
            ++IconflictedIds;
        }
        System.out.println("Found tottally " + IconflictedIds + " conflicted biome ids");
        File file = new File(AntiIdConflictBase.biomesFolder, "\\avaibleIDs.txt");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        PrintWriter writer = new PrintWriter(file);
        writer.println("Total amount of free biome ids: " + file);
        writer.println("List of free biome ids:");
        for (String s : freeBiomeIDs.split("\n")) {
            writer.println(s);
        }
        writer.close();
        File file2 = new File(AntiIdConflictBase.biomesFolder, "\\occupiedIDs.txt");
        if (file2.exists()) {
            file2.delete();
        }
        file2.createNewFile();
        writer = new PrintWriter(file2);
        writer.println("Total amount of occupied biome ids: " + occupiedIds);
        writer.println("Table of occupied biome ids and their owners");
        writer.println("id:name(class)");
        for (String s : occupiedBiomeIDs.split("\n")) {
            writer.println(s);
        }
        writer.close();
        File file3 = new File(AntiIdConflictBase.biomesFolder, "\\conflictedIDs.txt");
        if (file3.exists()) {
            file3.delete();
        }
        file3.createNewFile();
        writer = new PrintWriter(file3);
        writer.println("Total amount of conflicted biome ids: " + IconflictedIds);
        writer.println("IDs in conflict:\n");
        for (String s : conflictedIds.split("\n")) {
            writer.println(s);
        }
        writer.close();
        File file4 = new File(AntiIdConflictBase.biomesFolder, "\\AllIDs.txt");
        writer = new PrintWriter(file4);
        writer.println("Total amount of free biome ids: " + freeIds);
        writer.println("Total amount of occupied biome ids: " + occupiedIds);
        writer.println("Total amount of conflicted biome ids: " + IconflictedIds);
        writer.println("All ids and their position:");
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (!ArrayUtils.isEmpty((Object[])conflicts) && conflicts[i] != null) {
                writer.println(conflicts[i].getCrashMessage());
                continue;
            }
            if (BiomeGenBase.func_150565_n()[i] != null) {
                writer.println(i + " is Occupied by " + BiomeGenBase.func_150565_n()[i].field_76791_y + " (" + BiomeGenBase.func_150565_n()[i].func_150562_l().getName() + ")");
                continue;
            }
            writer.println(i + " is Avaible");
        }
        writer.close();
    }

    public static int getBiomeID(int id, boolean register) {
        if (!register && ignoreRegistry) {
            return id;
        }
        if (BiomeGenBase.func_150565_n()[id] != null) {
            if (debug) {
                System.out.println("Detected biomes conflict for id " + id + (crashIfConflict ? " Game will crash!" : ""));
            }
            BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
            ConflictingBiomes conflict = conflicts[id];
            if (conflict == null) {
                conflict = new ConflictingBiomes(id, biome);
            }
            BiomesManager.conflicts[id] = conflict;
        }
        BiomesManager.updateConflictedArrays();
        return id;
    }

    public static void updateConflictedArrays() {
        for (ConflictingBiomes conflict : conflicts) {
            if (conflict == null) continue;
            conflict.updateArray();
        }
    }

    private static void crash() throws BiomesIDConflictException {
        if (ArrayUtils.isEmpty((Object[])conflicts)) {
            if (debug) {
                System.out.println("No conflicts found");
            }
            return;
        }
        if (crashIfConflict) {
            for (ConflictingBiomes conflict : conflicts) {
                if (conflict == null) continue;
                String report = "Conflict between biomes with same id caused game to crash.\nAffected ids:\n" + conflictedIds;
                if (debug) {
                    System.out.println(report);
                }
                CrashReport crash = new CrashReport("Conflicting biomes forced game to crash: ", (Throwable)new BiomesIDConflictException(report));
                Minecraft.func_71410_x().func_71404_a(crash);
            }
            if (debug) {
                System.out.println("No conflicts found");
            }
        }
    }

    static {
        freeIds = 0;
        occupiedIds = 0;
        IconflictedIds = 0;
        conflicts = new ConflictingBiomes[256];
    }

    public static class BiomesIDConflictException
    extends Exception {
        public BiomesIDConflictException(String s) {
            super(s);
        }
    }

    public static class ConflictingBiomes {
        public BiomeGenBase[] biomes = new BiomeGenBase[256];
        public int ID;

        public ConflictingBiomes(int id, BiomeGenBase biome) {
            this.ID = id;
            this.biomes[0] = biome;
        }

        public void updateArray() {
            BiomeGenBase biome = BiomeGenBase.func_150565_n()[this.ID];
            if (biome != null) {
                boolean p = ArrayUtils.contains((Object[])this.biomes, (Object)biome);
                for (BiomeGenBase b : this.biomes) {
                    if (b == null) continue;
                    p |= b.equals(biome) || b.field_76791_y.equals(biome.field_76791_y) && b.getClass().getName().equals(biome.getClass().getName());
                }
                if (!p) {
                    this.biomes = (BiomeGenBase[])ArrayUtils.add((Object[])this.biomes, (Object)BiomeGenBase.func_150565_n()[this.ID]);
                }
            }
        }

        public String getCrashMessage() {
            String s = "";
            s = s + this.ID + " is asked by: ";
            boolean flag = false;
            for (BiomeGenBase biome : this.biomes) {
                if (biome == null) continue;
                if (flag) {
                    s = s + ", ";
                } else {
                    flag = true;
                }
                s = s + biome.field_76791_y;
                s = s + " (";
                s = s + biome.func_150562_l().getName();
                s = s + ")";
            }
            return s;
        }
    }
}

