/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft.client;

import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin {
    @Shadow
    @Final
    private Minecraft field_78531_r;
    private float eyeHeight;
    private float previousEyeHeight;
    private float entityEyeHeight;
    private float partialTicks;

    @Inject(method={"orientCamera"}, at={@At(value="HEAD")})
    private void orientCamera(float partialTicks, CallbackInfo callbackInfo) {
        this.partialTicks = partialTicks;
    }

    @ModifyVariable(method={"orientCamera"}, at=@At(value="FIELD", target="net/minecraft/entity/EntityLivingBase.prevPosX:D", ordinal=0), ordinal=1)
    public float getEyeHeight(float eyeHeight) {
        EntityLivingBase entity = this.field_78531_r.field_71451_h;
        if (!(entity instanceof EntityPlayer)) {
            return eyeHeight;
        }
        this.entityEyeHeight = entity.field_70131_O == 0.6f ? 0.0f : eyeHeight;
        return MathHelperNew.lerp(this.partialTicks, this.previousEyeHeight, this.eyeHeight);
    }

    @Inject(method={"updateRenderer"}, at={@At(value="TAIL")})
    public void updateRenderer(CallbackInfo callbackInfo) {
        this.interpolateHeight();
    }

    private void interpolateHeight() {
        this.previousEyeHeight = this.eyeHeight;
        this.eyeHeight += (this.entityEyeHeight - this.eyeHeight) * 0.5f;
    }
}

