/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft.client;

import com.fuzs.aquaacrobatics.client.entity.IPlayerSPSwimming;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.Session;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EntityClientPlayerMP.class})
public class EntityClientPlayerMPMixin
extends EntityPlayerSP
implements IPlayerSPSwimming {
    public EntityClientPlayerMPMixin(Minecraft mc, World world, Session session, NetHandlerPlayClient client, StatFileWriter statFileWriter) {
        super(mc, world, session, 0);
    }

    @Redirect(method={"sendMotionUpdates"}, at=@At(value="INVOKE", target="net/minecraft/client/entity/EntityClientPlayerMP.isSneaking()Z"))
    private boolean onUpdateWalkingPlayerIsSneaking(EntityClientPlayerMP playerIn) {
        return this.isActuallySneaking();
    }

    @Override
    public boolean isActuallySneaking() {
        return this.field_71158_b != null && this.field_71158_b.field_78899_d;
    }

    @Override
    public boolean isForcedDown() {
        return ((IPlayerResizeable)((Object)this)).isResizingAllowed() && !this.field_71075_bZ.field_75100_b ? this.func_70093_af() || ((IPlayerResizeable)((Object)this)).isVisuallySwimming() : this.isActuallySneaking();
    }

    @Override
    public boolean isUsingSwimmingAnimation() {
        return this.isUsingSwimmingAnimation(this.field_71158_b.field_78900_b, this.field_71158_b.field_78902_a);
    }

    @Override
    public boolean isUsingSwimmingAnimation(float moveForward, float moveStrafe) {
        if (this.canSwim()) {
            return this.isMovingForward(moveForward, moveStrafe);
        }
        if (ConfigHandler.MovementConfig.sidewaysSprinting) {
            return moveForward >= 0.8f || Math.abs(moveStrafe) > 0.8f;
        }
        return moveForward >= 0.8f;
    }

    @Override
    public boolean canSwim() {
        return ((IPlayerResizeable)((Object)this)).getEyesInWaterPlayer();
    }

    @Override
    public boolean isMovingForward(float moveForward, float moveStrafe) {
        if (moveForward > 1.0E-5f) {
            return true;
        }
        if (ConfigHandler.MovementConfig.sidewaysSwimming) {
            return Math.abs(moveStrafe) > 1.0E-5f;
        }
        return false;
    }

    @Override
    public boolean canPerformElytraTakeoff() {
        return false;
    }
}

