/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.mixins.early.minecraft;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.IBubbleColumnInteractable;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IBubbleColumnInteractable {
    @Shadow
    public double field_70181_x;
    @Shadow
    public float field_70143_R;
    @Shadow
    public World field_70170_p;

    @Shadow
    public abstract boolean func_70093_af();

    @Redirect(method={"moveEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isSneaking()Z"))
    public boolean isSneaking(Entity entity) {
        if (entity instanceof IPlayerResizeable) {
            return ((IPlayerResizeable)entity).isActuallySneaking();
        }
        return this.func_70093_af();
    }

    @ModifyConstant(method={"handleWaterMovement"}, constant={@Constant(doubleValue=-0.4000000059604645)})
    private double adjustWaterMovementY(double original) {
        return this instanceof IPlayerResizeable && ((IPlayerResizeable)((Object)this)).getPose() == Pose.SWIMMING ? -0.2500000059604645 : original;
    }

    @Override
    public void onEnterBubbleColumn(boolean downwards) {
        this.field_70181_x = !downwards ? Math.min(0.7, this.field_70181_x + 0.06) : Math.max(-0.3, this.field_70181_x - 0.03);
        this.field_70143_R = 0.0f;
    }

    @Override
    public void onEnterBubbleColumnWithAirAbove(boolean downwards) {
        this.field_70181_x = !downwards ? Math.min(1.8, this.field_70181_x + 0.1) : Math.max(-0.9, this.field_70181_x - 0.03);
    }

    @ModifyVariable(method={"moveEntity"}, ordinal=0, name={"block"}, at=@At(value="LOAD"))
    private Block getFakeClimbingBlock(Block original) {
        if (ConfigHandler.MovementConfig.newClimbingBehavior && original instanceof BlockVine) {
            return Blocks.field_150468_ap;
        }
        return original;
    }
}

