/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms.compiler.backend;

import com.ventooth.swansong.uniforms.Builtins;
import com.ventooth.swansong.uniforms.Type;
import com.ventooth.swansong.uniforms.UniformFunction;
import com.ventooth.swansong.uniforms.compiler.ast.ConstNode;
import com.ventooth.swansong.uniforms.compiler.ast.TypedNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedBoolNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedBranchNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedCastNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedFunctionNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedMathNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedMultiMatchNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedRelNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedUnaryMinusNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedUnaryNotNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CodeGenerator {
    private final Flags flags;
    private int localVariableIndex;

    public CodeGenerator(Flags flags, boolean isStatic) {
        this.flags = flags;
        this.localVariableIndex = isStatic ? 0 : 1;
    }

    public void genExpr(TypedNode input, InsnList insnList) {
        if (input instanceof ConstNode) {
            ConstNode constant = (ConstNode)input;
            this.genConst(constant, insnList);
        } else if (input instanceof TypedBoolNode) {
            TypedBoolNode bool = (TypedBoolNode)input;
            this.genBool(bool, insnList);
        } else if (input instanceof TypedBranchNode) {
            TypedBranchNode branch = (TypedBranchNode)input;
            this.genBranch(branch, insnList);
        } else if (input instanceof TypedCastNode) {
            TypedCastNode cast = (TypedCastNode)input;
            this.genCast(cast.input, cast.outputType(), insnList);
        } else if (input instanceof TypedFunctionNode) {
            TypedFunctionNode fn = (TypedFunctionNode)input;
            this.genFn(fn, insnList);
        } else if (input instanceof TypedMathNode) {
            TypedMathNode math = (TypedMathNode)input;
            this.genMath(math, insnList);
        } else if (input instanceof TypedMultiMatchNode) {
            TypedMultiMatchNode match = (TypedMultiMatchNode)input;
            this.genMultiMatch(match, insnList);
        } else if (input instanceof TypedRelNode) {
            TypedRelNode rel = (TypedRelNode)input;
            this.genRel(rel, insnList);
        } else if (input instanceof TypedUnaryMinusNode) {
            TypedUnaryMinusNode minus = (TypedUnaryMinusNode)input;
            this.genMinus(minus, insnList);
        } else {
            throw new UnsupportedOperationException(input.getClass().getName());
        }
    }

    private void genConst(ConstNode constant, InsnList insnList) {
        Object insn;
        if (constant instanceof ConstNode.Int) {
            InsnNode insnNode;
            ConstNode.Int intCst = (ConstNode.Int)constant;
            int i = intCst.value;
            switch (i) {
                case -1: {
                    insnNode = new InsnNode(2);
                    break;
                }
                case 0: {
                    insnNode = new InsnNode(3);
                    break;
                }
                case 1: {
                    insnNode = new InsnNode(4);
                    break;
                }
                case 2: {
                    insnNode = new InsnNode(5);
                    break;
                }
                case 3: {
                    insnNode = new InsnNode(6);
                    break;
                }
                case 4: {
                    insnNode = new InsnNode(7);
                    break;
                }
                case 5: {
                    insnNode = new InsnNode(8);
                    break;
                }
                default: {
                    insnNode = new LdcInsnNode((Object)i);
                }
            }
            insn = insnNode;
        } else if (constant instanceof ConstNode.Float) {
            ConstNode.Float floatCst = (ConstNode.Float)constant;
            double f = floatCst.value;
            insn = f == 0.0 ? new InsnNode(14) : (f == 1.0 ? new InsnNode(15) : new LdcInsnNode((Object)f));
        } else if (constant instanceof ConstNode.Bool) {
            ConstNode.Bool boolCst = (ConstNode.Bool)constant;
            insn = new InsnNode(boolCst.value() ? 4 : 3);
        } else {
            if (constant instanceof ConstNode.Vec2) {
                ConstNode.Vec2 vecCst = (ConstNode.Vec2)constant;
                double x = vecCst.x;
                double y = vecCst.y;
                if (x == y) {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec2", Collections.singletonList(Type.Float)), Collections.singletonList(new ConstNode.Float(x))), insnList);
                } else {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec2", Arrays.asList(Type.Float, Type.Float)), Arrays.asList(new ConstNode.Float(x), new ConstNode.Float(y))), insnList);
                }
                return;
            }
            if (constant instanceof ConstNode.Vec3) {
                ConstNode.Vec3 vecCst = (ConstNode.Vec3)constant;
                double x = vecCst.x;
                double y = vecCst.y;
                double z = vecCst.z;
                if (x == y && x == z) {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec3", Collections.singletonList(Type.Float)), Collections.singletonList(new ConstNode.Float(x))), insnList);
                } else {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec3", Arrays.asList(Type.Float, Type.Float, Type.Float)), Arrays.asList(new ConstNode.Float(x), new ConstNode.Float(y), new ConstNode.Float(z))), insnList);
                }
                return;
            }
            if (constant instanceof ConstNode.Vec4) {
                ConstNode.Vec4 vecCst = (ConstNode.Vec4)constant;
                double x = vecCst.x;
                double y = vecCst.y;
                double z = vecCst.z;
                double w = vecCst.w;
                if (x == y && x == z && x == w) {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec4", Collections.singletonList(Type.Float)), Collections.singletonList(new ConstNode.Float(x))), insnList);
                } else {
                    this.genFn(new TypedFunctionNode(Builtins.REGISTRY.resolve("vec4", Arrays.asList(Type.Float, Type.Float, Type.Float, Type.Float)), Arrays.asList(new ConstNode.Float(x), new ConstNode.Float(y), new ConstNode.Float(z), new ConstNode.Float(w))), insnList);
                }
                return;
            }
            throw new IllegalArgumentException();
        }
        insnList.add((AbstractInsnNode)insn);
    }

    private void genCast(TypedNode input, Type outType, InsnList insnList) {
        this.genExpr(input, insnList);
        Type inType = input.outputType();
        block0 : switch (outType) {
            case Bool: {
                if (inType == Type.Bool) break;
                throw new IllegalArgumentException();
            }
            case Int: {
                switch (inType) {
                    case Bool: 
                    case Int: {
                        break block0;
                    }
                    case Float: {
                        insnList.add((AbstractInsnNode)new InsnNode(142));
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case Float: {
                switch (inType) {
                    case Bool: 
                    case Int: {
                        insnList.add((AbstractInsnNode)new InsnNode(135));
                        break block0;
                    }
                    case Float: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case Vec2: 
            case Vec3: 
            case Vec4: {
                String fnName;
                UniformFunction fn;
                if (inType == Type.Int || inType == Type.Bool) {
                    insnList.add((AbstractInsnNode)new InsnNode(135));
                }
                if ((fn = Builtins.REGISTRY.resolve(fnName = outType.name().toLowerCase(), Collections.singletonList(Type.Float))) == null) {
                    throw new IllegalArgumentException();
                }
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, fn.javaOwner(), fn.javaName(), Type.methodDescriptor(outType, Type.Float), false));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void genMath(TypedMathNode math, InsnList insnList) {
        InsnNode insnNode;
        this.genExpr(math.left, insnList);
        this.genExpr(math.right, insnList);
        Type type = math.outputType();
        TypedMathNode.Op op = math.op;
        block0 : switch (type) {
            case Int: {
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        insnNode = new InsnNode(96);
                        break block0;
                    }
                    case Sub: {
                        insnNode = new InsnNode(100);
                        break block0;
                    }
                    case Mul: {
                        insnNode = new InsnNode(104);
                        break block0;
                    }
                    case Div: {
                        insnNode = new InsnNode(108);
                        break block0;
                    }
                    case Rem: 
                }
                insnNode = new InsnNode(112);
                break;
            }
            case Float: {
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        insnNode = new InsnNode(99);
                        break block0;
                    }
                    case Sub: {
                        insnNode = new InsnNode(103);
                        break block0;
                    }
                    case Mul: {
                        insnNode = new InsnNode(107);
                        break block0;
                    }
                    case Div: {
                        insnNode = new InsnNode(111);
                        break block0;
                    }
                    case Rem: 
                }
                insnNode = new InsnNode(115);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        InsnNode insn = insnNode;
        insnList.add((AbstractInsnNode)insn);
    }

    private void genMinus(TypedUnaryMinusNode minus, InsnList insnList) {
        int n;
        this.genExpr(minus.param, insnList);
        Type type = minus.outputType();
        switch (type) {
            case Bool: 
            case Int: {
                n = 116;
                break;
            }
            case Float: {
                n = 119;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int insn = n;
        insnList.add((AbstractInsnNode)new InsnNode(insn));
    }

    private void genNot(TypedUnaryNotNode not, InsnList insnList) {
        this.genBranchIndirect(not.param, new IndirectTarget.Expr(ConstNode.Bool.False, ConstNode.Bool.True), insnList);
    }

    private void genRel(TypedRelNode rel, InsnList insnList) {
        this.genRelIndirect(rel, new IndirectTarget.Expr(ConstNode.Bool.True, ConstNode.Bool.False), insnList);
    }

    private void genBranch(TypedBranchNode branch, InsnList insnList) {
        this.genBranchIndirect(branch.cond, new IndirectTarget.Expr(branch.ifTrue, branch.ifFalse), insnList);
    }

    private void genMultiMatch(TypedMultiMatchNode match, InsnList insnList) {
        this.genMultiMatchIndirect(match, new IndirectTarget.Expr(ConstNode.Bool.True, ConstNode.Bool.False), insnList);
    }

    private void genBool(TypedBoolNode bool, InsnList insnList) {
        this.genBoolIndirect(bool, new IndirectTarget.Expr(ConstNode.Bool.True, ConstNode.Bool.False), insnList);
    }

    private void genFn(TypedFunctionNode fn, InsnList insnList) {
        UniformFunction function = fn.function;
        StringBuilder desc = new StringBuilder("(");
        List<TypedNode> paramVals = fn.params;
        List<Type> params = function.params();
        for (int i = 0; i < params.size(); ++i) {
            this.genExpr(paramVals.get(i), insnList);
            desc.append(params.get(i).descriptor());
        }
        desc.append(')').append(function.returns().descriptor());
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, function.javaOwner(), function.javaName(), desc.toString(), false));
    }

    private void genRelIndirect(TypedRelNode rel, IndirectTarget tgt, InsnList insnList) {
        this.genExpr(rel.left, insnList);
        this.genExpr(rel.right, insnList);
        TypedRelNode.Op op = rel.op;
        JumpInsn jumpInsn = this.prepareJumpInsn(rel.left.outputType(), op, insnList);
        this.genTrueFalseBranch(tgt, jumpInsn, insnList);
    }

    private void genBranchIndirect(TypedNode cond, IndirectTarget tgt, InsnList insnList) {
        if (this.flags.fuseIfElseRelational) {
            if (cond instanceof TypedRelNode) {
                TypedRelNode rel = (TypedRelNode)cond;
                this.genRelIndirect(rel, tgt, insnList);
                return;
            }
            if (cond instanceof TypedMultiMatchNode) {
                TypedMultiMatchNode match = (TypedMultiMatchNode)cond;
                this.genMultiMatchIndirect(match, tgt, insnList);
                return;
            }
            if (cond instanceof TypedBoolNode) {
                TypedBoolNode bool = (TypedBoolNode)cond;
                this.genBoolIndirect(bool, tgt, insnList);
                return;
            }
        }
        this.genExpr(cond, insnList);
        this.genTrueFalseBranch(tgt, JumpInsn.BOOL, insnList);
    }

    private void genMultiMatchIndirect(TypedMultiMatchNode match, IndirectTarget tgt, InsnList insnList) {
        List<TypedNode> elems = match.elems;
        TypedNode root = elems.get(0);
        Type type = root.outputType();
        if (tgt instanceof IndirectTarget.Expr) {
            IndirectTarget.Expr expr = (IndirectTarget.Expr)tgt;
            LabelNode trueLabel = new LabelNode();
            this.genMultiMatchChain(root, elems, type, trueLabel, null, insnList);
            this.genIndirectExprPair(expr.ifFalse, expr.ifTrue, trueLabel, insnList);
        } else if (tgt instanceof IndirectTarget.Label) {
            IndirectTarget.Label lbl = (IndirectTarget.Label)tgt;
            boolean genTrue = !lbl.cond;
            LabelNode trueLabel = lbl.cond ? lbl.labelCond : new LabelNode();
            LabelNode falseLabel = lbl.cond ? null : lbl.labelCond;
            this.genMultiMatchChain(root, elems, type, trueLabel, falseLabel, insnList);
            if (genTrue) {
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, lbl.labelCond));
                insnList.add((AbstractInsnNode)trueLabel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genMultiMatchChain(TypedNode root, List<TypedNode> elems, Type type, LabelNode trueLabel, LabelNode falseLabel, InsnList insnList) {
        if (this.flags.inlineMultiMatchConst && root instanceof ConstNode) {
            int size = elems.size();
            for (int i = 1; i < size; ++i) {
                this.genExpr(elems.get(i), insnList);
                this.genExpr(root, insnList);
                JumpInsn jumpInsn = this.prepareJumpInsn(type, TypedRelNode.Op.Eq, insnList);
                insnList.add((AbstractInsnNode)new JumpInsnNode(jumpInsn.jumpOpCode(true), trueLabel));
            }
            if (falseLabel != null) {
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, falseLabel));
            }
            return;
        }
        this.genExpr(root, insnList);
        Type t = root.outputType();
        int local = this.localAlloc(t);
        try {
            this.genLocalStore(t, local, insnList);
            int size = elems.size();
            for (int i = 1; i < size; ++i) {
                this.genExpr(elems.get(i), insnList);
                this.genLocalLoad(t, local, insnList);
                JumpInsn jumpInsn = this.prepareJumpInsn(type, TypedRelNode.Op.Eq, insnList);
                insnList.add((AbstractInsnNode)new JumpInsnNode(jumpInsn.jumpOpCode(true), trueLabel));
            }
            if (falseLabel != null) {
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, falseLabel));
            }
        }
        finally {
            this.localFree(t, local);
        }
    }

    private void genBoolIndirect(TypedBoolNode bool, IndirectTarget tgt, InsnList insnList) {
        List<TypedNode> elems = bool.elems;
        TypedBoolNode.Op op = bool.op;
        if (tgt instanceof IndirectTarget.Expr) {
            boolean scBranch;
            TypedNode passThrough;
            TypedNode shortCircuit;
            IndirectTarget.Expr expr = (IndirectTarget.Expr)tgt;
            switch (op) {
                case And: {
                    shortCircuit = expr.ifFalse;
                    passThrough = expr.ifTrue;
                    scBranch = false;
                    break;
                }
                case Or: {
                    shortCircuit = expr.ifTrue;
                    passThrough = expr.ifFalse;
                    scBranch = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            LabelNode scLabel = new LabelNode();
            IndirectTarget.Label lbl = new IndirectTarget.Label(scLabel, scBranch);
            for (TypedNode elem : elems) {
                this.genBranchIndirect(elem, lbl, insnList);
            }
            this.genIndirectExprPair(passThrough, shortCircuit, scLabel, insnList);
        } else if (tgt instanceof IndirectTarget.Label) {
            boolean scGen;
            LabelNode passThrough;
            LabelNode shortCircuit;
            boolean scBranch;
            IndirectTarget.Label lbl = (IndirectTarget.Label)tgt;
            switch (op) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case And: {
                    boolean bl = false;
                    break;
                }
                case Or: {
                    boolean bl = scBranch = true;
                }
            }
            if (scBranch == lbl.cond) {
                shortCircuit = lbl.labelCond;
                passThrough = null;
                scGen = false;
            } else {
                shortCircuit = new LabelNode();
                passThrough = lbl.labelCond;
                scGen = true;
            }
            IndirectTarget.Label lbl2 = new IndirectTarget.Label(shortCircuit, scBranch);
            for (TypedNode elem : elems) {
                this.genBranchIndirect(elem, lbl2, insnList);
            }
            if (scGen) {
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, passThrough));
                insnList.add((AbstractInsnNode)shortCircuit);
            }
        }
    }

    private void genTrueFalseBranch(IndirectTarget tgt, JumpInsn jumpInsn, InsnList insnList) {
        if (tgt instanceof IndirectTarget.Expr) {
            IndirectTarget.Expr expr = (IndirectTarget.Expr)tgt;
            LabelNode falseLabel = new LabelNode();
            insnList.add((AbstractInsnNode)new JumpInsnNode(jumpInsn.jumpOpCode(false), falseLabel));
            this.genIndirectExprPair(expr.ifTrue, expr.ifFalse, falseLabel, insnList);
        } else if (tgt instanceof IndirectTarget.Label) {
            IndirectTarget.Label lbl = (IndirectTarget.Label)tgt;
            insnList.add((AbstractInsnNode)new JumpInsnNode(jumpInsn.jumpOpCode(lbl.cond), lbl.labelCond));
        }
    }

    private void genIndirectExprPair(TypedNode first, TypedNode second, LabelNode secondLabel, InsnList insnList) {
        LabelNode endLabel = new LabelNode();
        this.genExpr(first, insnList);
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, endLabel));
        insnList.add((AbstractInsnNode)secondLabel);
        this.genExpr(second, insnList);
        insnList.add((AbstractInsnNode)endLabel);
    }

    private JumpInsn prepareJumpInsn(Type type, TypedRelNode.Op op, InsnList insnList) {
        JumpInsn jumpInsn;
        switch (type) {
            case Bool: 
            case Int: {
                jumpInsn = JumpInsn.ofBin(op, true);
                break;
            }
            case Float: {
                int n;
                switch (op) {
                    case Le: 
                    case Lt: {
                        n = 152;
                        break;
                    }
                    default: {
                        n = 151;
                    }
                }
                insnList.add((AbstractInsnNode)new InsnNode(n));
                jumpInsn = JumpInsn.ofBin(op, false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return jumpInsn;
    }

    private int localAlloc(Type type) {
        int index = this.localVariableIndex++;
        switch (type) {
            case Bool: 
            case Int: 
            case Vec2: 
            case Vec3: 
            case Vec4: {
                break;
            }
            case Float: {
                this.localVariableIndex += 2;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return index;
    }

    private void localFree(Type type, int index) {
        switch (type) {
            case Bool: 
            case Int: 
            case Vec2: 
            case Vec3: 
            case Vec4: {
                --this.localVariableIndex;
                break;
            }
            case Float: {
                this.localVariableIndex -= 2;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.localVariableIndex != index) {
            throw new IllegalStateException();
        }
    }

    private void genLocalStore(Type type, int index, InsnList insnList) {
        int n;
        switch (type) {
            case Bool: 
            case Int: {
                n = 54;
                break;
            }
            case Float: {
                n = 57;
                break;
            }
            case Vec2: 
            case Vec3: 
            case Vec4: {
                n = 58;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        insnList.add((AbstractInsnNode)new VarInsnNode(n, index));
    }

    private void genLocalLoad(Type type, int index, InsnList insnList) {
        int n;
        switch (type) {
            case Bool: 
            case Int: {
                n = 21;
                break;
            }
            case Float: {
                n = 24;
                break;
            }
            case Vec2: 
            case Vec3: 
            case Vec4: {
                n = 25;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        insnList.add((AbstractInsnNode)new VarInsnNode(n, index));
    }

    public static final class Flags {
        public final boolean inlineMultiMatchConst;
        public final boolean fuseIfElseRelational;

        @Generated
        public Flags(boolean inlineMultiMatchConst, boolean fuseIfElseRelational) {
            this.inlineMultiMatchConst = inlineMultiMatchConst;
            this.fuseIfElseRelational = fuseIfElseRelational;
        }
    }

    private static interface IndirectTarget {

        public static final class Label
        implements IndirectTarget {
            public final LabelNode labelCond;
            public final boolean cond;

            @Generated
            public Label(LabelNode labelCond, boolean cond) {
                this.labelCond = labelCond;
                this.cond = cond;
            }
        }

        public static final class Expr
        implements IndirectTarget {
            public final TypedNode ifTrue;
            public final TypedNode ifFalse;

            @Generated
            public Expr(TypedNode ifTrue, TypedNode ifFalse) {
                this.ifTrue = ifTrue;
                this.ifFalse = ifFalse;
            }
        }
    }

    private static enum JumpInsn {
        IEq,
        INe,
        IGe,
        IGt,
        ILe,
        ILt,
        Eq,
        Ne,
        Ge,
        Gt,
        Le,
        Lt;

        public static final JumpInsn BOOL;

        public static JumpInsn ofBin(TypedRelNode.Op op, boolean i) {
            JumpInsn jumpInsn;
            switch (op) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case Eq: {
                    if (i) {
                        jumpInsn = IEq;
                        break;
                    }
                    jumpInsn = Eq;
                    break;
                }
                case Ne: {
                    if (i) {
                        jumpInsn = INe;
                        break;
                    }
                    jumpInsn = Ne;
                    break;
                }
                case Ge: {
                    if (i) {
                        jumpInsn = IGe;
                        break;
                    }
                    jumpInsn = Ge;
                    break;
                }
                case Gt: {
                    if (i) {
                        jumpInsn = IGt;
                        break;
                    }
                    jumpInsn = Gt;
                    break;
                }
                case Le: {
                    if (i) {
                        jumpInsn = ILe;
                        break;
                    }
                    jumpInsn = Le;
                    break;
                }
                case Lt: {
                    jumpInsn = i ? ILt : Lt;
                }
            }
            return jumpInsn;
        }

        public int jumpOpCode(boolean jumpToBranch) {
            int n;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case IEq: {
                    if (jumpToBranch) {
                        n = 159;
                        break;
                    }
                    n = 160;
                    break;
                }
                case INe: {
                    if (jumpToBranch) {
                        n = 160;
                        break;
                    }
                    n = 159;
                    break;
                }
                case IGe: {
                    if (jumpToBranch) {
                        n = 162;
                        break;
                    }
                    n = 161;
                    break;
                }
                case IGt: {
                    if (jumpToBranch) {
                        n = 163;
                        break;
                    }
                    n = 164;
                    break;
                }
                case ILe: {
                    if (jumpToBranch) {
                        n = 164;
                        break;
                    }
                    n = 163;
                    break;
                }
                case ILt: {
                    if (jumpToBranch) {
                        n = 161;
                        break;
                    }
                    n = 162;
                    break;
                }
                case Eq: {
                    if (jumpToBranch) {
                        n = 153;
                        break;
                    }
                    n = 154;
                    break;
                }
                case Ne: {
                    if (jumpToBranch) {
                        n = 154;
                        break;
                    }
                    n = 153;
                    break;
                }
                case Ge: {
                    if (jumpToBranch) {
                        n = 156;
                        break;
                    }
                    n = 155;
                    break;
                }
                case Gt: {
                    if (jumpToBranch) {
                        n = 157;
                        break;
                    }
                    n = 158;
                    break;
                }
                case Le: {
                    if (jumpToBranch) {
                        n = 158;
                        break;
                    }
                    n = 157;
                    break;
                }
                case Lt: {
                    n = jumpToBranch ? 155 : 156;
                }
            }
            return n;
        }

        static {
            BOOL = Ne;
        }
    }
}

