/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms.compiler;

import com.ventooth.swansong.mathparser.AbstractParser;
import com.ventooth.swansong.mathparser.Lexer;
import com.ventooth.swansong.mathparser.ParserException;
import com.ventooth.swansong.mathparser.Token;
import com.ventooth.swansong.uniforms.Builtins;
import com.ventooth.swansong.uniforms.Type;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import com.ventooth.swansong.uniforms.compiler.ast.TypedNode;
import com.ventooth.swansong.uniforms.compiler.ast.UntypedNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedCastNode;
import com.ventooth.swansong.uniforms.compiler.backend.BytecodeOptimizer;
import com.ventooth.swansong.uniforms.compiler.backend.CodeGenerator;
import com.ventooth.swansong.uniforms.compiler.frontend.Optimizer;
import com.ventooth.swansong.uniforms.compiler.frontend.TypeResolver;
import com.ventooth.swansong.uniforms.compiler.frontend.UntypedParser;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import lombok.Generated;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public class UniformCompiler {
    private final Flags flags;
    private final TypeResolver typeResolver;
    private final Optimizer optimizer;

    public UniformCompiler(Flags flags, UniformFunctionRegistry registry) {
        this.flags = flags;
        this.typeResolver = new TypeResolver(flags.typeResolver, registry);
        this.optimizer = new Optimizer(flags.optimizer);
    }

    public MethodNode compile(Type returnType, String expressionSource, MethodBuilder builder) {
        UntypedNode untypedExpr = this.parse(expressionSource);
        TypedNode typedExpr = this.resolveTypes(returnType, untypedExpr);
        TypedNode optimizedExpr = this.optimizer.transform(typedExpr);
        MethodNode method = this.codegen(optimizedExpr, builder);
        new BytecodeOptimizer(this.flags.bytecode).optimize(method.instructions);
        return method;
    }

    public void compile(Type returnType, String expressionSource, InsnList instructions, boolean isStatic) {
        UntypedNode untypedExpr = this.parse(expressionSource);
        TypedNode typedExpr = this.resolveTypes(returnType, untypedExpr);
        TypedNode optimizedExpr = this.optimizer.transform(typedExpr);
        this.codegen(optimizedExpr, instructions, isStatic);
        new BytecodeOptimizer(this.flags.bytecode).optimize(instructions);
    }

    private UntypedNode parse(String expressionSource) {
        Lexer lexer = new Lexer(expressionSource);
        UntypedParser parser = new UntypedParser(lexer);
        try {
            return (UntypedNode)parser.parse();
        }
        catch (Lexer.UnexpectedCharException e) {
            StringBuilder b = new StringBuilder("Unexpected character in uniform!\n");
            b.append(expressionSource).append('\n');
            for (int i = 0; i < e.at; ++i) {
                b.append(' ');
            }
            b.append("^ here\nExpected: ").append(e.expected).append("\nGot: ").append(e.got).append('\n');
            throw new RuntimeException(b.toString(), e);
        }
        catch (AbstractParser.UnexpectedTokenException e) {
            int i;
            StringBuilder b = new StringBuilder("Unexpected token in uniform!\n");
            b.append(expressionSource).append('\n');
            Token tok = e.got;
            int off = tok.offset();
            int til = tok.until();
            if (off >= 5) {
                for (i = 0; i < off - 5; ++i) {
                    b.append(' ');
                }
                b.append("here ");
            } else {
                for (i = 0; i < off; ++i) {
                    b.append(' ');
                }
            }
            for (i = off; i < til; ++i) {
                b.append('^');
            }
            if (off < 5) {
                b.append(" here");
            }
            b.append("\nExpected one of: ").append(e.expected).append("\nGot: ").append((Object)e.got.type()).append('\n');
            throw new RuntimeException(b.toString(), e);
        }
        catch (ParserException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private TypedNode resolveTypes(Type returnType, UntypedNode untyped) {
        TypedNode typed = this.typeResolver.transform(untyped);
        if (typed.outputType() != returnType) {
            return new TypedCastNode(returnType, typed);
        }
        return typed;
    }

    private MethodNode codegen(TypedNode expr, MethodBuilder builder) {
        Type ot = expr.outputType();
        String desc = "()" + ot.descriptor();
        InsnNode ret = new InsnNode(ot.returnOpcode());
        MethodNode method = builder.createEmptyMethod(desc);
        this.codegen(expr, method.instructions, (method.access & 8) != 0);
        method.instructions.add((AbstractInsnNode)ret);
        return method;
    }

    private void codegen(TypedNode expr, InsnList instructions, boolean isStatic) {
        CodeGenerator codeGenerator = new CodeGenerator(this.flags.codegen, isStatic);
        codeGenerator.genExpr(expr, instructions);
    }

    private static MethodNode createEmptyMethod(String desc) {
        return new MethodNode(9, "funy", desc, null, null);
    }

    public static void main(String[] args) {
        UniformFunctionRegistry.Multi registry = new UniformFunctionRegistry.Multi();
        registry.add(Builtins.REGISTRY);
        Flags flags = new Flags(new TypeResolver.Flags(true), new Optimizer.Flags(true, true, true), new CodeGenerator.Flags(false, false), new BytecodeOptimizer.Flags(false));
        UniformCompiler compiler = new UniformCompiler(flags, registry);
        MethodNode method = compiler.compile(Type.Vec3, "ceil(vec3(1.3) * pi)", UniformCompiler::createEmptyMethod);
        ClassNode outClass = new ClassNode();
        outClass.version = 52;
        outClass.superName = "java/lang/Object";
        outClass.name = "Funny";
        outClass.access = 1;
        outClass.methods.add(method);
        ClassWriter writer = new ClassWriter(3);
        outClass.accept((ClassVisitor)writer);
        Files.write(Paths.get("Funny.class", new String[0]), writer.toByteArray(), new OpenOption[0]);
    }

    public static final class Flags {
        public final TypeResolver.Flags typeResolver;
        public final Optimizer.Flags optimizer;
        public final CodeGenerator.Flags codegen;
        public final BytecodeOptimizer.Flags bytecode;

        @Generated
        public Flags(TypeResolver.Flags typeResolver, Optimizer.Flags optimizer, CodeGenerator.Flags codegen, BytecodeOptimizer.Flags bytecode) {
            this.typeResolver = typeResolver;
            this.optimizer = optimizer;
            this.codegen = codegen;
            this.bytecode = bytecode;
        }
    }

    @FunctionalInterface
    public static interface MethodBuilder {
        public MethodNode createEmptyMethod(String var1);
    }
}

