/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms;

import com.ventooth.swansong.uniforms.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class UniformFunction {
    @Nullable
    private final Method constantFoldMethod;
    private final String javaOwner;
    private final String javaName;
    private final Type returns;
    private final List<Type> params;
    private final boolean statefulIndexed;

    public UniformFunction(@Nullable Method constantFoldMethod, String javaOwner, String javaName, Type returns, List<Type> params, boolean statefulIndexed) {
        this.constantFoldMethod = constantFoldMethod;
        this.javaOwner = javaOwner;
        this.javaName = javaName;
        this.returns = returns;
        this.params = params;
        this.statefulIndexed = statefulIndexed;
    }

    public static UniformFunction of(Method method, boolean constantFoldable, boolean statefulIndexed) {
        Type returns = Type.of(method.getReturnType());
        Class<?>[] javaParams = method.getParameterTypes();
        ArrayList<Type> params = new ArrayList<Type>(javaParams.length);
        for (Class<?> javaParam : javaParams) {
            params.add(Type.of(javaParam));
        }
        return new UniformFunction(constantFoldable ? method : null, org.objectweb.asm.Type.getInternalName(method.getDeclaringClass()), method.getName(), returns, params, statefulIndexed);
    }

    @Nullable
    public Method constantFoldMethod() {
        return this.constantFoldMethod;
    }

    public String javaOwner() {
        return this.javaOwner;
    }

    public String javaName() {
        return this.javaName;
    }

    public Type returns() {
        return this.returns;
    }

    public List<Type> params() {
        return this.params;
    }

    public boolean statefulIndexed() {
        return this.statefulIndexed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UniformFunction that = (UniformFunction)obj;
        return Objects.equals(this.constantFoldMethod, that.constantFoldMethod) && Objects.equals(this.javaOwner, that.javaOwner) && Objects.equals(this.javaName, that.javaName) && Objects.equals((Object)this.returns, (Object)that.returns) && Objects.equals(this.params, that.params) && this.statefulIndexed == that.statefulIndexed;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constantFoldMethod, this.javaOwner, this.javaName, this.returns, this.params, this.statefulIndexed});
    }

    public String toString() {
        return "UniformFunction[constantFoldMethod=" + this.constantFoldMethod + ", javaOwner=" + this.javaOwner + ", javaName=" + this.javaName + ", returns=" + (Object)((Object)this.returns) + ", params=" + this.params + ", statefulIndexed=" + this.statefulIndexed + ']';
    }
}

