/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.uniform;

import com.ventooth.swansong.shader.ShaderState;
import com.ventooth.swansong.shader.uniform.Uniform;
import com.ventooth.swansong.shader.uniform.UniformGetterDanglingWires;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.joml.Matrix4dc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector4dc;

public final class GeneralUniforms {
    private static final List<Uniform<?>> LIVE_UNIFORMS = new GeneralUniformListBuilder().addInt("fogMode", ShaderState::fogMode).addVec3("fogColor", ShaderState::fogColor).addVec3("skyColor", ShaderState::skyColor).addVec4("entityColor", ShaderState::entityColor).addInt("entityId", ShaderState::entityId).addInt("blockEntityId", ShaderState::blockEntityId).addVec3("sunPosition", ShaderState::sunPosition).addVec3("moonPosition", ShaderState::moonPosition).addVec3("shadowLightPosition", ShaderState::shadowLightPosition).addVec3("upPosition", ShaderState::upPos).addMat4("gbufferProjection", ShaderState::projectionMat).addMat4("gbufferModelViewInverse", ShaderState::modelViewMatInv).addMat4("gbufferPreviousProjection", ShaderState::prevProjectionMat).addMat4("gbufferModelView", ShaderState::modelViewMat).addMat4("gbufferProjectionInverse", ShaderState::projectionMatInv).addMat4("gbufferPreviousModelView", ShaderState::prevModelViewMat).addMat4("shadowProjection", ShaderState::shadowProjection).addMat4("shadowProjectionInverse", ShaderState::shadowProjectionInverse).addMat4("shadowModelView", ShaderState::shadowModelView).addMat4("shadowModelViewInverse", ShaderState::shadowModelViewInverse).addBool("swan_portalEyeS", () -> ShaderState.portalEye()[0]).addBool("swan_portalEyeT", () -> ShaderState.portalEye()[1]).addBool("swan_portalEyeR", () -> ShaderState.portalEye()[2]).addBool("swan_portalEyeQ", () -> ShaderState.portalEye()[3]).addInt("renderStage", ShaderState::renderStage).addVec2i("atlasSize", ShaderState::atlasSize).build();
    private static final List<Uniform<?>> GENERAL_UNIFORMS = new GeneralUniformListBuilder(LIVE_UNIFORMS).addInt("heldItemId", ShaderState::heldItemId).addInt("heldBlockLightValue", ShaderState::heldBlockLightValue).addInt("worldTime", ShaderState::worldTime).addInt("worldDay", ShaderState::worldDay).addInt("moonPhase", ShaderState::moonPhase).addInt("frameCounter", ShaderState::frameCounter).addFloat("frameTime", ShaderState::frameTime).addFloat("frameTimeCounter", ShaderState::frameTimeCounter).addFloat("sunAngle", ShaderState::sunAngle).addFloat("shadowAngle", ShaderState::shadowAngle).addFloat("rainStrength", ShaderState::rainStrength).addFloat("aspectRatio", ShaderState::aspectRatio).addFloat("viewWidth", ShaderState::viewWidth).addFloat("viewHeight", ShaderState::viewHeight).addFloat("near", ShaderState::nearPlane).addFloat("far", ShaderState::farPlane).addVec3("previousCameraPosition", ShaderState::prevCamPos).addVec3("cameraPosition", ShaderState::camPos).addFloat("wetness", ShaderState::wetness).addFloat("eyeAltitude", ShaderState::eyeAltitude).addVec2i("eyeBrightness", ShaderState::eyeBrightness).addVec2i("eyeBrightnessSmooth", ShaderState::eyeBrightnessSmooth).addVec2i("terrainTextureSize", UniformGetterDanglingWires::terrainTextureSize).addInt("terrainIconSize", UniformGetterDanglingWires::terrainIconSize).addInt("isEyeInWater", ShaderState::isEyeInWater).addFloat("nightVision", ShaderState::nightVision).addFloat("blindness", ShaderState::blindness).addFloat("screenBrightness", ShaderState::screenBrightness).addBool("hideGUI", ShaderState::isGuiHidden).addFloat("centerDepthSmooth", ShaderState::centerDepthSmooth).build();
    private static final UniformFunctionRegistry UNIFORM_FUNCTION_REGISTRY;

    public static UniformFunctionRegistry getFuncRegistry() {
        return UNIFORM_FUNCTION_REGISTRY;
    }

    public static List<Uniform<?>> get() {
        return GENERAL_UNIFORMS;
    }

    public static List<Uniform<?>> getWith(List<Uniform<?>> other) {
        ArrayList list = new ArrayList(other);
        list.addAll(GENERAL_UNIFORMS);
        return Collections.unmodifiableList(list);
    }

    @Generated
    private GeneralUniforms() {
    }

    static {
        ShaderState.setUniformUpdateTask(() -> LIVE_UNIFORMS.forEach(Uniform::update));
        try {
            Class<ShaderState> clazz = ShaderState.class;
            UniformFunctionRegistry.Single reg = new UniformFunctionRegistry.Single();
            reg.impure(clazz.getDeclaredMethod("camPos", new Class[0]), "cameraPosition");
            reg.impure(clazz.getDeclaredMethod("eyeAltitude", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("camPosFract", new Class[0]), "cameraPositionFract");
            reg.impure(clazz.getDeclaredMethod("camPosIntD", new Class[0]), "cameraPositionInt");
            reg.impure(clazz.getDeclaredMethod("prevCamPos", new Class[0]), "previousCameraPosition");
            reg.impure(clazz.getDeclaredMethod("prevCamPosFract", new Class[0]), "previousCameraPositionFract");
            reg.impure(clazz.getDeclaredMethod("prevCamPosIntD", new Class[0]), "previousCameraPositionInt");
            reg.impure(clazz.getDeclaredMethod("upPos", new Class[0]), "upPosition");
            reg.impure(clazz.getDeclaredMethod("eyeBrightnessD", new Class[0]), "eyeBrightness");
            reg.impure(clazz.getDeclaredMethod("eyeBrightnessSmoothD", new Class[0]), "eyeBrightnessSmooth");
            reg.impure(clazz.getDeclaredMethod("centerDepthSmooth", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("isEyeInWater", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("blindness", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("nightVision", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("isGuiHidden", new Class[0]), "hideGUI");
            reg.impure(clazz.getDeclaredMethod("viewHeight", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("viewWidth", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("aspectRatio", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("screenBrightness", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("frameCounter", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("frameTime", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("frameTimeCounter", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("heldItemId", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("heldBlockLightValue", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("sunPosition", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("moonPosition", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("shadowLightPosition", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("sunAngle", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("shadowAngle", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("moonPhase", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("rainStrength", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("wetness", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("worldTime", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("worldDay", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("biome", new Class[0]));
            reg.impure(clazz.getDeclaredMethod("nearPlane", new Class[0]), "near");
            reg.impure(clazz.getDeclaredMethod("farPlane", new Class[0]), "far");
            reg.impure(clazz.getDeclaredMethod("skyColor", new Class[0]));
            UNIFORM_FUNCTION_REGISTRY = reg;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Someone messed up; [BIG_TIME]", e);
        }
    }

    private static class GeneralUniformListBuilder {
        final List<Uniform<?>> uniforms = new ArrayList();

        GeneralUniformListBuilder(List<Uniform<?>> uniforms) {
            this.uniforms.addAll(uniforms);
        }

        List<Uniform<?>> build() {
            return Collections.unmodifiableList(this.uniforms);
        }

        GeneralUniformListBuilder addBool(String name, Uniform.BooleanSupplier getter) {
            this.uniforms.add(new Uniform.OfBoolean(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addInt(String name, Uniform.IntSupplier getter) {
            this.uniforms.add(new Uniform.OfInt(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addVec2i(String name, Supplier<Vector2ic> getter) {
            this.uniforms.add(new Uniform.Of<Vector2ic>(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addFloat(String name, Uniform.DoubleSupplier getter) {
            this.uniforms.add(new Uniform.OfDouble(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addVec3(String name, Supplier<Vector3dc> getter) {
            this.uniforms.add(new Uniform.Of<Vector3dc>(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addVec4(String name, Supplier<Vector4dc> getter) {
            this.uniforms.add(new Uniform.Of<Vector4dc>(name, getter, Uniform::set));
            return this;
        }

        GeneralUniformListBuilder addMat4(String name, Supplier<Matrix4dc> getter) {
            this.uniforms.add(new Uniform.Of<Matrix4dc>(name, getter, Uniform::set));
            return this;
        }

        @Generated
        public GeneralUniformListBuilder() {
        }
    }
}

