/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import org.jetbrains.annotations.Nullable;

public final class Localization {
    private final String name;
    private final ObjectList<String> description;
    private final Object2ObjectMap<String, String> options;
    private static final int maxDescLineWidthPx = 250;

    public Localization(String name, ObjectList<String> description, Object2ObjectMap<String, String> options) {
        this.name = name;
        this.description = description;
        this.options = options;
    }

    public static String localize(Locale locale, String key) {
        return locale.func_135023_a(key, new Object[0]);
    }

    public static Localization create(Locale locale, boolean isScreen, String nameKey, @Nullable String description, ObjectList<String> optionsUnlocalized) {
        return Localization.createRaw(locale, nameKey, (isScreen ? "screen." : "option.") + nameKey, "value." + nameKey + ".", description, optionsUnlocalized);
    }

    public static Localization createProfile(Locale locale, ObjectList<String> options) {
        return Localization.createRaw(locale, I18n.func_135052_a((String)"gui.swansong.shaders.profile.key", (Object[])new Object[0]), "profile", "profile.", null, options);
    }

    public static Localization createScreen(Locale locale, @Nullable String screenName) {
        return Localization.createRaw(locale, screenName == null ? I18n.func_135052_a((String)"gui.swansong.shaders.root.title", (Object[])new Object[0]) : screenName, screenName == null ? "screen" : "screen." + screenName, null, null, null);
    }

    private static void subdivideLine(String line, ObjectList<String> output) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        output.addAll((Collection)fr.func_78271_c("- " + line, 250));
    }

    private static Localization createRaw(Locale locale, String name, String nameBase, @Nullable String optionBase, @Nullable String description, @Nullable ObjectList<String> optionsUnlocalized) {
        Object2ObjectMap options;
        ObjectList commentLines;
        String localizedComment;
        String key;
        String localizedName = Localization.localize(locale, nameBase);
        if (nameBase.equals(localizedName)) {
            String string = localizedName = name == null ? nameBase : name;
        }
        if ((key = nameBase + ".comment").equals(localizedComment = Localization.localize(locale, key))) {
            localizedComment = description;
        }
        if (localizedComment == null) {
            commentLines = ObjectLists.emptyList();
        } else {
            ObjectArrayList lines = new ObjectArrayList((Object[])localizedComment.split("\\. "));
            ObjectArrayList finalLines = new ObjectArrayList();
            for (String line : lines) {
                Localization.subdivideLine(line, (ObjectList<String>)finalLines);
            }
            commentLines = ObjectLists.unmodifiable((ObjectList)finalLines);
        }
        if (optionBase == null || optionsUnlocalized == null) {
            return new Localization(localizedName, (ObjectList<String>)commentLines, (Object2ObjectMap<String, String>)Object2ObjectMaps.emptyMap());
        }
        if (optionsUnlocalized.isEmpty()) {
            options = Object2ObjectMaps.emptyMap();
        } else {
            Object2ObjectOpenHashMap theOptions = new Object2ObjectOpenHashMap();
            for (String option : optionsUnlocalized) {
                String optionLoc;
                String optionKey = optionBase + option;
                theOptions.put((Object)option, (Object)Localization.localize(locale, Objects.equals(optionKey, optionLoc = Localization.localize(locale, optionKey)) ? option : optionLoc));
            }
            options = Object2ObjectMaps.unmodifiable((Object2ObjectMap)theOptions);
        }
        return new Localization(localizedName, (ObjectList<String>)commentLines, (Object2ObjectMap<String, String>)options);
    }

    public String name() {
        return this.name;
    }

    public ObjectList<String> description() {
        return this.description;
    }

    public Object2ObjectMap<String, String> options() {
        return this.options;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Localization that = (Localization)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.options);
    }

    public String toString() {
        return "Localization[name=" + this.name + ", description=" + this.description + ", options=" + this.options + ']';
    }
}

