/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader.config;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.loader.config.ConfigEntryBase;
import com.ventooth.swansong.shader.loader.config.ConfigRootScreen;
import com.ventooth.swansong.shader.loader.config.Localization;
import com.ventooth.swansong.shader.preprocessor.Option;
import net.minecraft.client.resources.Locale;

public abstract class ConfigChoice
extends ConfigEntryBase
implements ConfigEntry.Mutable {
    protected final int index;
    protected final Option option;
    protected final ConfigRootScreen root;

    public ConfigChoice(Locale locale, Option option, int index, ConfigRootScreen root) {
        super(Localization.create(locale, false, option.name, null, option.valueStrings()));
        this.index = index;
        this.option = option;
        this.root = root;
    }

    @Override
    public void resetToDefault() {
        this.option.setToDefault();
    }

    @Override
    public boolean isModified() {
        return this.root.isModified(this.index);
    }

    @Override
    public boolean isDefault() {
        return this.option.isDefaultValue();
    }

    @Override
    public String valueName() {
        String name = this.option.getCurrentValue().toString();
        return (String)this.locale.options().getOrDefault((Object)name, (Object)name);
    }

    public static class Toggleable
    extends ConfigChoice
    implements ConfigEntry.Toggleable {
        public Toggleable(Locale locale, Option opt, int index, ConfigRootScreen root) {
            super(locale, opt, index, root);
            if (!opt.isToggle()) {
                throw new AssertionError();
            }
        }

        @Override
        public boolean toggle() {
            this.option.setCurrentValue(((Option.Value.Bool)this.option.getCurrentValue()).toggle());
            return this.getValue();
        }

        @Override
        public void setValue(boolean value) {
            this.option.setCurrentValue(Option.Value.Bool.of(value));
        }

        @Override
        public boolean getValue() {
            return ((Option.Value.Bool)this.option.getCurrentValue()).boolValue();
        }

        @Override
        public String valueName() {
            throw new AssertionError();
        }
    }

    public static class Draggable
    extends ConfigChoice
    implements ConfigEntry.Draggable {
        private final int max;
        private final float scaler;

        public Draggable(Locale locale, Option option, int index, ConfigRootScreen root) {
            super(locale, option, index, root);
            this.max = option.getValueCount() - 1;
            this.scaler = this.max;
        }

        @Override
        public float setValue(float value) {
            value = MathUtil.clamp((float)value, (float)0.0f, (float)1.0f);
            int index = MathUtil.clamp((int)Math.round(value * this.scaler), (int)0, (int)this.max);
            this.option.setValueIndex(index);
            return (float)index / this.scaler;
        }

        @Override
        public float getValue() {
            return (float)this.option.getValueIndex() / this.scaler;
        }
    }

    public static class Switchable
    extends ConfigChoice
    implements ConfigEntry.Switchable {
        public Switchable(Locale locale, Option option, int index, ConfigRootScreen root) {
            super(locale, option, index, root);
        }

        @Override
        public void nextValue() {
            this.option.nextValue();
        }

        @Override
        public void prevValue() {
            this.option.prevValue();
        }
    }
}

