/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector4dc;

public class ShaderLoaderOutParams {
    @Nullable
    public final Quality clouds;
    @Nullable
    public final Boolean moon;
    @Nullable
    public final Boolean sun;
    @Nullable
    public final Boolean underwaterOverlay;
    @Nullable
    public final Boolean vignette;
    @Nullable
    public final Boolean oldHandLight;
    @Nullable
    public final Boolean oldLighting;
    public final boolean shadowTerrain;
    public final boolean shadowTranslucent;
    public final boolean shadowEntities;
    public final boolean shadowBlockEntities;
    public final boolean backFaceSolid;
    public final boolean backFaceCutout;
    public final boolean backFaceCutoutMipped;
    public final boolean backFaceTranslucent;
    public final boolean frustumCulling;
    public final boolean shadowCulling;
    public final boolean rainDepth;
    public final boolean beaconBeamDepth;
    @NotNull
    public final @Unmodifiable ObjectList<StagedTexture> textures;
    @Nullable
    public final String noiseTexture;
    @Nullable
    public final Double ambientOcclusionLevel;
    public final double sunPathRotation;
    public final double eyeBrightnessHalfLife;
    public final double centerDepthHalfLife;
    public final double drynessHalfLife;
    public final double wetnessHalfLife;
    @NotNull
    public final @Unmodifiable ObjectList<String> bufferClearDisabled;
    @NotNull
    public final @Unmodifiable Object2ObjectMap<String, Vector4dc> bufferClearColor;
    @NotNull
    public final @Unmodifiable Object2ObjectMap<String, String> bufferFormat;
    public final boolean shadowDepth0Mipmap;
    public final boolean shadowDepth0Nearest;
    public final boolean shadowDepth1Mipmap;
    public final boolean shadowDepth1Nearest;
    public final boolean shadowColor0Mipmap;
    public final boolean shadowColor0Nearest;
    public final boolean shadowColor1Mipmap;
    public final boolean shadowColor1Nearest;
    @Nullable
    public final Integer noiseTextureResolution;
    public final double shadowDistance;
    public final double shadowDistanceRenderMul;
    public final boolean shadowHardwareFiltering0;
    public final boolean shadowHardwareFiltering1;
    public final double shadowIntervalSize;
    @Nullable
    public final Double shadowMapFov;
    public final int shadowMapResolution;
    public final boolean rpleCompatible;

    @Generated
    private ShaderLoaderOutParams(@Nullable Quality clouds, @Nullable Boolean moon, @Nullable Boolean sun, @Nullable Boolean underwaterOverlay, @Nullable Boolean vignette, @Nullable Boolean oldHandLight, @Nullable Boolean oldLighting, boolean shadowTerrain, boolean shadowTranslucent, boolean shadowEntities, boolean shadowBlockEntities, boolean backFaceSolid, boolean backFaceCutout, boolean backFaceCutoutMipped, boolean backFaceTranslucent, boolean frustumCulling, boolean shadowCulling, boolean rainDepth, boolean beaconBeamDepth, @NotNull ObjectList<StagedTexture> textures, @Nullable String noiseTexture, @Nullable Double ambientOcclusionLevel, double sunPathRotation, double eyeBrightnessHalfLife, double centerDepthHalfLife, double drynessHalfLife, double wetnessHalfLife, @NotNull ObjectList<String> bufferClearDisabled, @NotNull Object2ObjectMap<String, Vector4dc> bufferClearColor, @NotNull Object2ObjectMap<String, String> bufferFormat, boolean shadowDepth0Mipmap, boolean shadowDepth0Nearest, boolean shadowDepth1Mipmap, boolean shadowDepth1Nearest, boolean shadowColor0Mipmap, boolean shadowColor0Nearest, boolean shadowColor1Mipmap, boolean shadowColor1Nearest, @Nullable Integer noiseTextureResolution, double shadowDistance, double shadowDistanceRenderMul, boolean shadowHardwareFiltering0, boolean shadowHardwareFiltering1, double shadowIntervalSize, @Nullable Double shadowMapFov, int shadowMapResolution, boolean rpleCompatible) {
        if (textures == null) {
            throw new NullPointerException("textures is marked non-null but is null");
        }
        if (bufferClearDisabled == null) {
            throw new NullPointerException("bufferClearDisabled is marked non-null but is null");
        }
        if (bufferClearColor == null) {
            throw new NullPointerException("bufferClearColor is marked non-null but is null");
        }
        if (bufferFormat == null) {
            throw new NullPointerException("bufferFormat is marked non-null but is null");
        }
        this.clouds = clouds;
        this.moon = moon;
        this.sun = sun;
        this.underwaterOverlay = underwaterOverlay;
        this.vignette = vignette;
        this.oldHandLight = oldHandLight;
        this.oldLighting = oldLighting;
        this.shadowTerrain = shadowTerrain;
        this.shadowTranslucent = shadowTranslucent;
        this.shadowEntities = shadowEntities;
        this.shadowBlockEntities = shadowBlockEntities;
        this.backFaceSolid = backFaceSolid;
        this.backFaceCutout = backFaceCutout;
        this.backFaceCutoutMipped = backFaceCutoutMipped;
        this.backFaceTranslucent = backFaceTranslucent;
        this.frustumCulling = frustumCulling;
        this.shadowCulling = shadowCulling;
        this.rainDepth = rainDepth;
        this.beaconBeamDepth = beaconBeamDepth;
        this.textures = textures;
        this.noiseTexture = noiseTexture;
        this.ambientOcclusionLevel = ambientOcclusionLevel;
        this.sunPathRotation = sunPathRotation;
        this.eyeBrightnessHalfLife = eyeBrightnessHalfLife;
        this.centerDepthHalfLife = centerDepthHalfLife;
        this.drynessHalfLife = drynessHalfLife;
        this.wetnessHalfLife = wetnessHalfLife;
        this.bufferClearDisabled = bufferClearDisabled;
        this.bufferClearColor = bufferClearColor;
        this.bufferFormat = bufferFormat;
        this.shadowDepth0Mipmap = shadowDepth0Mipmap;
        this.shadowDepth0Nearest = shadowDepth0Nearest;
        this.shadowDepth1Mipmap = shadowDepth1Mipmap;
        this.shadowDepth1Nearest = shadowDepth1Nearest;
        this.shadowColor0Mipmap = shadowColor0Mipmap;
        this.shadowColor0Nearest = shadowColor0Nearest;
        this.shadowColor1Mipmap = shadowColor1Mipmap;
        this.shadowColor1Nearest = shadowColor1Nearest;
        this.noiseTextureResolution = noiseTextureResolution;
        this.shadowDistance = shadowDistance;
        this.shadowDistanceRenderMul = shadowDistanceRenderMul;
        this.shadowHardwareFiltering0 = shadowHardwareFiltering0;
        this.shadowHardwareFiltering1 = shadowHardwareFiltering1;
        this.shadowIntervalSize = shadowIntervalSize;
        this.shadowMapFov = shadowMapFov;
        this.shadowMapResolution = shadowMapResolution;
        this.rpleCompatible = rpleCompatible;
    }

    public static enum Quality {
        Fancy,
        Fast,
        Off;

    }

    public static final class StagedTexture {
        private final String stage;
        private final String bufferName;
        private final String path;

        public StagedTexture(String stage, String bufferName, String path) {
            this.stage = stage;
            this.bufferName = bufferName;
            this.path = path;
        }

        public String stage() {
            return this.stage;
        }

        public String bufferName() {
            return this.bufferName;
        }

        public String path() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StagedTexture that = (StagedTexture)obj;
            return Objects.equals(this.stage, that.stage) && Objects.equals(this.bufferName, that.bufferName) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.stage, this.bufferName, this.path);
        }

        public String toString() {
            return "StagedTexture[stage=" + this.stage + ", bufferName=" + this.bufferName + ", path=" + this.path + ']';
        }
    }

    public static class Builder {
        public Quality clouds = null;
        public Boolean moon = null;
        public Boolean sun = null;
        public Boolean underwaterOverlay = null;
        public Boolean vignette = null;
        public Boolean oldHandLight = null;
        public Boolean oldLighting = null;
        public boolean shadowTerrain = true;
        public boolean shadowTranslucent = true;
        public boolean shadowEntities = true;
        public boolean shadowBlockEntities = true;
        public boolean backFaceSolid = true;
        public boolean backFaceCutout = true;
        public boolean backFaceCutoutMipped = true;
        public boolean backFaceTranslucent = true;
        public boolean frustumCulling = true;
        public boolean shadowCulling = true;
        public boolean rainDepth = false;
        public boolean beaconBeamDepth = true;
        public final Object2ObjectMap<String, Object2ObjectMap<String, String>> textures = new Object2ObjectLinkedOpenHashMap();
        public String noiseTexture = null;
        public Double ambientOcclusionLevel = null;
        public double sunPathRotation = 0.0;
        public double eyeBrightnessHalfLife = 10.0;
        public double centerDepthHalfLife = 1.0;
        public double drynessHalfLife = 200.0;
        public double wetnessHalfLife = 600.0;
        public final ObjectSet<String> bufferClearDisabled = new ObjectLinkedOpenHashSet();
        public final Object2ObjectMap<String, Vector4dc> bufferClearColor = new Object2ObjectLinkedOpenHashMap();
        public final Object2ObjectMap<String, String> bufferFormat = new Object2ObjectLinkedOpenHashMap();
        public boolean shadowDepth0Mipmap = false;
        public boolean shadowDepth0Nearest = false;
        public boolean shadowDepth1Mipmap = false;
        public boolean shadowDepth1Nearest = false;
        public boolean shadowColor0Mipmap = false;
        public boolean shadowColor0Nearest = false;
        public boolean shadowColor1Mipmap = false;
        public boolean shadowColor1Nearest = false;
        public Integer noiseTextureResolution = null;
        public double shadowDistance = 160.0;
        public double shadowDistanceRenderMul = -1.0;
        public boolean shadowHardwareFiltering0 = false;
        public boolean shadowHardwareFiltering1 = false;
        public double shadowIntervalSize = 2.0;
        public Double shadowMapFov = null;
        public int shadowMapResolution = 1024;
        public boolean rpleCompatible = false;

        Builder() {
        }

        public ShaderLoaderOutParams build() {
            ObjectArrayList textures = new ObjectArrayList();
            Object2ObjectMaps.fastForEach(this.textures, entry1 -> {
                String stage = (String)entry1.getKey();
                Object2ObjectMaps.fastForEach((Object2ObjectMap)((Object2ObjectMap)entry1.getValue()), entry2 -> {
                    String bufferName = (String)entry2.getKey();
                    String path = (String)entry2.getValue();
                    textures.add((Object)new StagedTexture(stage, bufferName, path));
                });
            });
            return new ShaderLoaderOutParams(this.clouds, this.moon, this.sun, this.underwaterOverlay, this.vignette, this.oldHandLight, this.oldLighting, this.shadowTerrain, this.shadowTranslucent, this.shadowEntities, this.shadowBlockEntities, this.backFaceSolid, this.backFaceCutout, this.backFaceCutoutMipped, this.backFaceTranslucent, this.frustumCulling, this.shadowCulling, this.rainDepth, this.beaconBeamDepth, ObjectLists.unmodifiable((ObjectList)textures), this.noiseTexture, this.ambientOcclusionLevel, this.sunPathRotation, this.eyeBrightnessHalfLife, this.centerDepthHalfLife, this.drynessHalfLife, this.wetnessHalfLife, ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(this.bufferClearDisabled)), Object2ObjectMaps.unmodifiable(this.bufferClearColor), Object2ObjectMaps.unmodifiable(this.bufferFormat), this.shadowDepth0Mipmap, this.shadowDepth0Nearest, this.shadowDepth1Mipmap, this.shadowDepth1Nearest, this.shadowColor0Mipmap, this.shadowColor0Nearest, this.shadowColor1Mipmap, this.shadowColor1Nearest, this.noiseTextureResolution, this.shadowDistance, this.shadowDistanceRenderMul, this.shadowHardwareFiltering0, this.shadowHardwareFiltering1, this.shadowIntervalSize, this.shadowMapFov, this.shadowMapResolution, this.rpleCompatible);
        }

        @Generated
        public Builder clouds(Quality clouds) {
            this.clouds = clouds;
            return this;
        }

        @Generated
        public Builder moon(Boolean moon) {
            this.moon = moon;
            return this;
        }

        @Generated
        public Builder sun(Boolean sun) {
            this.sun = sun;
            return this;
        }

        @Generated
        public Builder underwaterOverlay(Boolean underwaterOverlay) {
            this.underwaterOverlay = underwaterOverlay;
            return this;
        }

        @Generated
        public Builder vignette(Boolean vignette) {
            this.vignette = vignette;
            return this;
        }

        @Generated
        public Builder oldHandLight(Boolean oldHandLight) {
            this.oldHandLight = oldHandLight;
            return this;
        }

        @Generated
        public Builder oldLighting(Boolean oldLighting) {
            this.oldLighting = oldLighting;
            return this;
        }

        @Generated
        public Builder shadowTerrain(boolean shadowTerrain) {
            this.shadowTerrain = shadowTerrain;
            return this;
        }

        @Generated
        public Builder shadowTranslucent(boolean shadowTranslucent) {
            this.shadowTranslucent = shadowTranslucent;
            return this;
        }

        @Generated
        public Builder shadowEntities(boolean shadowEntities) {
            this.shadowEntities = shadowEntities;
            return this;
        }

        @Generated
        public Builder shadowBlockEntities(boolean shadowBlockEntities) {
            this.shadowBlockEntities = shadowBlockEntities;
            return this;
        }

        @Generated
        public Builder backFaceSolid(boolean backFaceSolid) {
            this.backFaceSolid = backFaceSolid;
            return this;
        }

        @Generated
        public Builder backFaceCutout(boolean backFaceCutout) {
            this.backFaceCutout = backFaceCutout;
            return this;
        }

        @Generated
        public Builder backFaceCutoutMipped(boolean backFaceCutoutMipped) {
            this.backFaceCutoutMipped = backFaceCutoutMipped;
            return this;
        }

        @Generated
        public Builder backFaceTranslucent(boolean backFaceTranslucent) {
            this.backFaceTranslucent = backFaceTranslucent;
            return this;
        }

        @Generated
        public Builder frustumCulling(boolean frustumCulling) {
            this.frustumCulling = frustumCulling;
            return this;
        }

        @Generated
        public Builder shadowCulling(boolean shadowCulling) {
            this.shadowCulling = shadowCulling;
            return this;
        }

        @Generated
        public Builder rainDepth(boolean rainDepth) {
            this.rainDepth = rainDepth;
            return this;
        }

        @Generated
        public Builder beaconBeamDepth(boolean beaconBeamDepth) {
            this.beaconBeamDepth = beaconBeamDepth;
            return this;
        }

        @Generated
        public Builder noiseTexture(String noiseTexture) {
            this.noiseTexture = noiseTexture;
            return this;
        }

        @Generated
        public Builder ambientOcclusionLevel(Double ambientOcclusionLevel) {
            this.ambientOcclusionLevel = ambientOcclusionLevel;
            return this;
        }

        @Generated
        public Builder sunPathRotation(double sunPathRotation) {
            this.sunPathRotation = sunPathRotation;
            return this;
        }

        @Generated
        public Builder eyeBrightnessHalfLife(double eyeBrightnessHalfLife) {
            this.eyeBrightnessHalfLife = eyeBrightnessHalfLife;
            return this;
        }

        @Generated
        public Builder centerDepthHalfLife(double centerDepthHalfLife) {
            this.centerDepthHalfLife = centerDepthHalfLife;
            return this;
        }

        @Generated
        public Builder drynessHalfLife(double drynessHalfLife) {
            this.drynessHalfLife = drynessHalfLife;
            return this;
        }

        @Generated
        public Builder wetnessHalfLife(double wetnessHalfLife) {
            this.wetnessHalfLife = wetnessHalfLife;
            return this;
        }

        @Generated
        public Builder shadowDepth0Mipmap(boolean shadowDepth0Mipmap) {
            this.shadowDepth0Mipmap = shadowDepth0Mipmap;
            return this;
        }

        @Generated
        public Builder shadowDepth0Nearest(boolean shadowDepth0Nearest) {
            this.shadowDepth0Nearest = shadowDepth0Nearest;
            return this;
        }

        @Generated
        public Builder shadowDepth1Mipmap(boolean shadowDepth1Mipmap) {
            this.shadowDepth1Mipmap = shadowDepth1Mipmap;
            return this;
        }

        @Generated
        public Builder shadowDepth1Nearest(boolean shadowDepth1Nearest) {
            this.shadowDepth1Nearest = shadowDepth1Nearest;
            return this;
        }

        @Generated
        public Builder shadowColor0Mipmap(boolean shadowColor0Mipmap) {
            this.shadowColor0Mipmap = shadowColor0Mipmap;
            return this;
        }

        @Generated
        public Builder shadowColor0Nearest(boolean shadowColor0Nearest) {
            this.shadowColor0Nearest = shadowColor0Nearest;
            return this;
        }

        @Generated
        public Builder shadowColor1Mipmap(boolean shadowColor1Mipmap) {
            this.shadowColor1Mipmap = shadowColor1Mipmap;
            return this;
        }

        @Generated
        public Builder shadowColor1Nearest(boolean shadowColor1Nearest) {
            this.shadowColor1Nearest = shadowColor1Nearest;
            return this;
        }

        @Generated
        public Builder noiseTextureResolution(Integer noiseTextureResolution) {
            this.noiseTextureResolution = noiseTextureResolution;
            return this;
        }

        @Generated
        public Builder shadowDistance(double shadowDistance) {
            this.shadowDistance = shadowDistance;
            return this;
        }

        @Generated
        public Builder shadowDistanceRenderMul(double shadowDistanceRenderMul) {
            this.shadowDistanceRenderMul = shadowDistanceRenderMul;
            return this;
        }

        @Generated
        public Builder shadowHardwareFiltering0(boolean shadowHardwareFiltering0) {
            this.shadowHardwareFiltering0 = shadowHardwareFiltering0;
            return this;
        }

        @Generated
        public Builder shadowHardwareFiltering1(boolean shadowHardwareFiltering1) {
            this.shadowHardwareFiltering1 = shadowHardwareFiltering1;
            return this;
        }

        @Generated
        public Builder shadowIntervalSize(double shadowIntervalSize) {
            this.shadowIntervalSize = shadowIntervalSize;
            return this;
        }

        @Generated
        public Builder shadowMapFov(Double shadowMapFov) {
            this.shadowMapFov = shadowMapFov;
            return this;
        }

        @Generated
        public Builder shadowMapResolution(int shadowMapResolution) {
            this.shadowMapResolution = shadowMapResolution;
            return this;
        }

        @Generated
        public Builder rpleCompatible(boolean rpleCompatible) {
            this.rpleCompatible = rpleCompatible;
            return this;
        }
    }
}

