/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.info;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.shader.info.Screen;
import com.ventooth.swansong.shader.info.ShaderVar;
import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import com.ventooth.swansong.shader.mappings.OrderedProperties;
import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.macro.InterpreterValue;
import com.ventooth.swansong.shader.preprocessor.macro.MacroExpressionInterpreter;
import com.ventooth.swansong.uniforms.Type;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShaderProperties {
    private final Screen screen;
    private final Object2ObjectMap<String, String> profiles;
    private final ObjectList<String> programEnableExpressions;
    private final ObjectList<ShaderVar> shaderVars;
    private final Object2ObjectMap<String, String> alphaTest;
    private final Object2ObjectMap<String, String> texture;
    private final Object2ObjectMap<String, String> everything;

    public ShaderProperties(Screen screen, Object2ObjectMap<String, String> profiles, ObjectList<String> programEnableExpressions, ObjectList<ShaderVar> shaderVars, Object2ObjectMap<String, String> alphaTest, Object2ObjectMap<String, String> texture, Object2ObjectMap<String, String> everything) {
        this.screen = screen;
        this.profiles = profiles;
        this.programEnableExpressions = programEnableExpressions;
        this.shaderVars = shaderVars;
        this.alphaTest = alphaTest;
        this.texture = texture;
        this.everything = everything;
    }

    @NotNull
    public static ShaderProperties parse(byte[] code) {
        OrderedProperties properties = new OrderedProperties();
        try {
            properties.load(new ByteArrayInputStream(code));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        ObjectSet sliders = ObjectSets.emptySet();
        ObjectList<String> screenMainPage = null;
        Object2ObjectLinkedOpenHashMap screenSubPages = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap profiles = new Object2ObjectLinkedOpenHashMap();
        ObjectArrayList expressions = new ObjectArrayList();
        ObjectArrayList shaderVars = new ObjectArrayList();
        Object2ObjectLinkedOpenHashMap alphaTest = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap texture = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap everything = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry<String, String> prop : properties) {
            ShaderVar v;
            String prog;
            String name = prop.getKey();
            String value = prop.getValue();
            everything.put((Object)name, (Object)value);
            if (name.startsWith("screen.")) {
                screenSubPages.put((Object)name.substring("screen.".length()), ShaderProperties.parseScreenPage(value));
                continue;
            }
            if ("screen".equals(name)) {
                screenMainPage = ShaderProperties.parseScreenPage(value);
                continue;
            }
            if ("sliders".equals(name)) {
                sliders = ObjectSets.unmodifiable((ObjectSet)new ObjectOpenHashSet((Object[])value.split("\\s+")));
            }
            if (name.startsWith("profile.")) {
                profiles.put((Object)name.substring("profile.".length()), (Object)value);
                continue;
            }
            if (name.startsWith("program.") && name.endsWith(".enabled")) {
                prog = name.substring("program.".length(), name.length() - ".enabled".length());
                expressions.add((Object)prog);
                continue;
            }
            if (name.startsWith("alphaTest.")) {
                prog = name.substring("alphaTest.".length());
                alphaTest.put((Object)prog, (Object)value);
                continue;
            }
            if (name.startsWith("uniform.")) {
                v = ShaderProperties.parseShaderVar(ShaderVar.Variant.Uniform, name.substring("uniform.".length()), value);
                if (v == null) continue;
                shaderVars.add((Object)v);
                continue;
            }
            if (name.startsWith("variable.")) {
                v = ShaderProperties.parseShaderVar(ShaderVar.Variant.Variable, name.substring("variable.".length()), value);
                if (v == null) continue;
                shaderVars.add((Object)v);
                continue;
            }
            if (!name.startsWith("texture.")) continue;
            texture.put((Object)name.substring("texture.".length()), (Object)value);
        }
        return new ShaderProperties(new Screen((ObjectSet<String>)sliders, screenMainPage, (Object2ObjectMap<String, ObjectList<String>>)screenSubPages), (Object2ObjectMap<String, String>)profiles, (ObjectList<String>)expressions, (ObjectList<ShaderVar>)shaderVars, (Object2ObjectMap<String, String>)alphaTest, (Object2ObjectMap<String, String>)texture, (Object2ObjectMap<String, String>)everything);
    }

    @Nullable
    private static ShaderVar parseShaderVar(ShaderVar.Variant variant, String name, String value) {
        String[] parts = name.split("\\.", 2);
        if (parts.length != 2) {
            Share.log.error("Failed to parse <type>.<name> for shader variable {} in shaders.properties!", new Object[]{name});
            return null;
        }
        return new ShaderVar(variant, Type.of(parts[0]), parts[1], value);
    }

    private static ObjectList<String> parseScreenPage(String entry) {
        return ObjectLists.unmodifiable((ObjectList)ObjectArrayList.of((Object[])entry.split("\\s+")));
    }

    public void parseBool(@NotNull String name, BooleanConsumer out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        switch (input.toLowerCase(Locale.ROOT)) {
            case "false": {
                out.accept(false);
                break;
            }
            case "true": {
                out.accept(true);
                break;
            }
            default: {
                Share.log.error("Error while parsing bool \"{}\" for \"{}\"", new Object[]{input, name});
            }
        }
    }

    public void parseInt(@NotNull String name, IntConsumer out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        try {
            out.accept(Integer.parseInt(input));
        }
        catch (NumberFormatException e) {
            Share.log.error("Error while parsing int \"{}\" for \"{}\"", new Object[]{input, name});
            Share.log.error("Stacktrace:", (Throwable)e);
        }
    }

    public void parseDouble(@NotNull String name, DoubleConsumer out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        try {
            out.accept(Double.parseDouble(input));
        }
        catch (NumberFormatException e) {
            Share.log.error("Error while parsing double \"{}\" for \"{}\"", new Object[]{input, name});
            Share.log.error("Stacktrace:", (Throwable)e);
        }
    }

    public void parseQuality(@NotNull String name, Consumer<ShaderLoaderOutParams.Quality> out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        switch (input.toLowerCase(Locale.ROOT)) {
            case "fancy": {
                out.accept(ShaderLoaderOutParams.Quality.Fancy);
                break;
            }
            case "fast": {
                out.accept(ShaderLoaderOutParams.Quality.Fast);
                break;
            }
            case "off": {
                out.accept(ShaderLoaderOutParams.Quality.Off);
                break;
            }
            default: {
                Share.log.error("Error while parsing quality \"{}\" for \"{}\"", new Object[]{input, name});
            }
        }
    }

    public void getValue(@NotNull String name, Consumer<String> out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        out.accept(input);
    }

    public void parseBoolExpr(Object2ObjectMap<String, Option.Value> defines, @NotNull String name, BooleanConsumer out) {
        String input = this.getValue(name);
        if (input == null) {
            return;
        }
        try {
            InterpreterValue res = MacroExpressionInterpreter.interpret(input, defines);
            out.accept(res.asBool());
        }
        catch (Exception e) {
            Share.log.error("Error while parsing bool expression \"{}\" for \"{}\"", new Object[]{input, name});
            Share.log.error("Stacktrace:", (Throwable)e);
        }
    }

    @Nullable
    private String getValue(@NotNull String name) {
        return (String)this.everything.get((Object)name);
    }

    public Screen screen() {
        return this.screen;
    }

    public Object2ObjectMap<String, String> profiles() {
        return this.profiles;
    }

    public ObjectList<String> programEnableExpressions() {
        return this.programEnableExpressions;
    }

    public ObjectList<ShaderVar> shaderVars() {
        return this.shaderVars;
    }

    public Object2ObjectMap<String, String> alphaTest() {
        return this.alphaTest;
    }

    public Object2ObjectMap<String, String> texture() {
        return this.texture;
    }

    public Object2ObjectMap<String, String> everything() {
        return this.everything;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ShaderProperties that = (ShaderProperties)obj;
        return Objects.equals(this.screen, that.screen) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.programEnableExpressions, that.programEnableExpressions) && Objects.equals(this.shaderVars, that.shaderVars) && Objects.equals(this.alphaTest, that.alphaTest) && Objects.equals(this.texture, that.texture) && Objects.equals(this.everything, that.everything);
    }

    public int hashCode() {
        return Objects.hash(this.screen, this.profiles, this.programEnableExpressions, this.shaderVars, this.alphaTest, this.texture, this.everything);
    }

    public String toString() {
        return "ShaderProperties[screen=" + this.screen + ", profiles=" + this.profiles + ", programEnableExpressions=" + this.programEnableExpressions + ", shaderVars=" + this.shaderVars + ", alphaTest=" + this.alphaTest + ", texture=" + this.texture + ", everything=" + this.everything + ']';
    }
}

