/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.EnvInfo;
import com.ventooth.swansong.debug.DebugMarker;
import com.ventooth.swansong.resources.pack.InternalShaderPack;
import com.ventooth.swansong.shader.ShaderException;
import com.ventooth.swansong.shader.ShaderTypes;
import com.ventooth.swansong.shader.loader.IShaderPool;
import com.ventooth.swansong.shader.loader.ShaderLoader;
import com.ventooth.swansong.shader.loader.ShaderLoaderInParams;
import com.ventooth.swansong.shader.shaderobjects.BlitShader;
import com.ventooth.swansong.shader.shaderobjects.CompositeShader;
import com.ventooth.swansong.shader.shaderobjects.GBufferShader;
import com.ventooth.swansong.shader.shaderobjects.ManagedShader;
import com.ventooth.swansong.shader.shaderobjects.ShadowShader;
import com.ventooth.swansong.shader.uniform.GeneralUniforms;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShaderBinding {
    private ManagedShader current;
    public final ObjectList<GBufferShader> gBufferList;
    public final ObjectList<ManagedShader> loadedShaders;
    public final GBufferShader basic;
    public final GBufferShader skybasic;
    public final GBufferShader textured;
    public final GBufferShader spidereyes;
    public final GBufferShader beaconbeam;
    public final GBufferShader clouds;
    public final GBufferShader skytextured;
    public final GBufferShader textured_lit;
    public final GBufferShader entities;
    public final GBufferShader weather;
    public final GBufferShader hand;
    public final GBufferShader hand_water;
    public final GBufferShader terrain;
    public final GBufferShader water;
    public final GBufferShader block;
    public final GBufferShader portal;
    @Nullable
    public final ShadowShader shadow;
    public final BlitShader blit_color_identical;
    public final BlitShader blit_depth_identical;
    public final BlitShader blit_color_mismatched;
    public final BlitShader blit_depth_mismatched;
    @Nullable
    public final ObjectList<CompositeShader> deferredList;
    @Nullable
    public final ObjectList<CompositeShader> compositeList;
    @Nullable
    public final CompositeShader _final;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderBinding init(IShaderPool shaderPool, @Nullable WorldProvider dimension) throws ShaderException {
        Builder b = ShaderBinding.builder();
        try {
            b.basic(b.gBuffer(shaderPool, ShaderTypes.gbuffers_basic));
            b.skybasic(b.gBuffer(shaderPool, ShaderTypes.gbuffers_skybasic));
            b.textured(b.gBuffer(shaderPool, ShaderTypes.gbuffers_textured));
            b.spidereyes(b.gBuffer(shaderPool, ShaderTypes.gbuffers_spidereyes));
            b.beaconbeam(b.gBuffer(shaderPool, ShaderTypes.gbuffers_beaconbeam));
            b.clouds(b.gBuffer(shaderPool, ShaderTypes.gbuffers_clouds));
            b.skytextured(b.gBuffer(shaderPool, ShaderTypes.gbuffers_skytextured));
            b.textured_lit(b.gBuffer(shaderPool, ShaderTypes.gbuffers_textured_lit));
            b.entities(b.gBuffer(shaderPool, ShaderTypes.gbuffers_entities));
            b.weather(b.gBuffer(shaderPool, ShaderTypes.gbuffers_weather));
            b.hand(b.gBuffer(shaderPool, ShaderTypes.gbuffers_hand));
            b.hand_water(b.gBuffer(shaderPool, ShaderTypes.gbuffers_hand_water));
            b.terrain(b.gBuffer(shaderPool, ShaderTypes.gbuffers_terrain));
            b.water(b.gBuffer(shaderPool, ShaderTypes.gbuffers_water));
            b.block(b.gBuffer(shaderPool, ShaderTypes.gbuffers_block));
            b.portal(b.gBuffer(shaderPool, ShaderTypes.gbuffers_portal));
            b.shadow((ShadowShader)b.safeInit(ShadowShader.load(shaderPool, ShaderTypes.shadow, false)));
            ShaderLoader internalLoader = new ShaderLoader(InternalShaderPack.INSTANCE, dimension);
            internalLoader.inExpectedShaders = ShaderTypes.internal;
            internalLoader.inAttribs = ObjectLists.emptyList();
            internalLoader.inParams = ShaderLoaderInParams.builder().handDepth(1.0).build();
            internalLoader.inShaderConfig = null;
            internalLoader.inEnvInfo = EnvInfo.get();
            internalLoader.inMcUniforms = GeneralUniforms.getFuncRegistry();
            internalLoader.load(null);
            IShaderPool internalPool = internalLoader.borrowOutShaderPool();
            try {
                b.blit_color_identical((BlitShader)b.safeInit(BlitShader.load(internalPool, ShaderTypes.blit_color_identical, true)));
                b.blit_depth_identical((BlitShader)b.safeInit(BlitShader.load(internalPool, ShaderTypes.blit_depth_identical, true)));
                b.blit_color_mismatched((BlitShader)b.safeInit(BlitShader.load(internalPool, ShaderTypes.blit_color_mismatched, true)));
                b.blit_depth_mismatched((BlitShader)b.safeInit(BlitShader.load(internalPool, ShaderTypes.blit_depth_mismatched, true)));
                internalLoader.reset();
            }
            finally {
                if (Collections.singletonList(internalPool).get(0) != null) {
                    internalPool.close();
                }
            }
            b.deferredList((ObjectList<CompositeShader>)b.composite(shaderPool, ShaderTypes.deferredList));
            b.compositeList((ObjectList<CompositeShader>)b.composite(shaderPool, ShaderTypes.compositeList));
            b._final(b.composite(shaderPool, ShaderTypes._final));
            return b.lockAndBuild();
        }
        catch (Throwable t) {
            ShaderBinding.safeDeinit((List<? extends ManagedShader>)b.loadedShaders);
            throw t;
        }
    }

    public void deinit() {
        if (this.current != null) {
            this.current.end(true);
            this.current = null;
        }
        ShaderBinding.safeDeinit(this.loadedShaders);
    }

    public boolean use(@Nullable ManagedShader shader) {
        if (shader == this.current) {
            return false;
        }
        if (this.current != null) {
            this.current.end(shader == null);
            this.current = null;
        }
        if (shader != null) {
            shader.begin();
            this.current = shader;
            if (DebugMarker.isEnabled()) {
                DebugMarker.GENERIC.insert("Bind Shader: " + shader.loc());
            }
        }
        return true;
    }

    private static void safeDeinit(List<? extends ManagedShader> shaders) {
        if (shaders == null) {
            return;
        }
        for (ManagedShader managedShader : shaders) {
            if (managedShader == null) continue;
            managedShader.deinit();
        }
    }

    @Generated
    ShaderBinding(ManagedShader current, ObjectList<GBufferShader> gBufferList, ObjectList<ManagedShader> loadedShaders, GBufferShader basic, GBufferShader skybasic, GBufferShader textured, GBufferShader spidereyes, GBufferShader beaconbeam, GBufferShader clouds, GBufferShader skytextured, GBufferShader textured_lit, GBufferShader entities, GBufferShader weather, GBufferShader hand, GBufferShader hand_water, GBufferShader terrain, GBufferShader water, GBufferShader block, GBufferShader portal, @Nullable ShadowShader shadow, BlitShader blit_color_identical, BlitShader blit_depth_identical, BlitShader blit_color_mismatched, BlitShader blit_depth_mismatched, @Nullable ObjectList<CompositeShader> deferredList, @Nullable ObjectList<CompositeShader> compositeList, @Nullable CompositeShader _final) {
        this.current = current;
        this.gBufferList = gBufferList;
        this.loadedShaders = loadedShaders;
        this.basic = basic;
        this.skybasic = skybasic;
        this.textured = textured;
        this.spidereyes = spidereyes;
        this.beaconbeam = beaconbeam;
        this.clouds = clouds;
        this.skytextured = skytextured;
        this.textured_lit = textured_lit;
        this.entities = entities;
        this.weather = weather;
        this.hand = hand;
        this.hand_water = hand_water;
        this.terrain = terrain;
        this.water = water;
        this.block = block;
        this.portal = portal;
        this.shadow = shadow;
        this.blit_color_identical = blit_color_identical;
        this.blit_depth_identical = blit_depth_identical;
        this.blit_color_mismatched = blit_color_mismatched;
        this.blit_depth_mismatched = blit_depth_mismatched;
        this.deferredList = deferredList;
        this.compositeList = compositeList;
        this._final = _final;
    }

    @Generated
    private static Builder builder() {
        return new Builder();
    }

    @Generated
    public ManagedShader current() {
        return this.current;
    }

    private static class Builder {
        @Generated
        private ManagedShader current;
        @Generated
        private ObjectList<GBufferShader> gBufferList = new ObjectArrayList();
        @Generated
        private ObjectList<ManagedShader> loadedShaders = new ObjectArrayList();
        @Generated
        private GBufferShader basic;
        @Generated
        private GBufferShader skybasic;
        @Generated
        private GBufferShader textured;
        @Generated
        private GBufferShader spidereyes;
        @Generated
        private GBufferShader beaconbeam;
        @Generated
        private GBufferShader clouds;
        @Generated
        private GBufferShader skytextured;
        @Generated
        private GBufferShader textured_lit;
        @Generated
        private GBufferShader entities;
        @Generated
        private GBufferShader weather;
        @Generated
        private GBufferShader hand;
        @Generated
        private GBufferShader hand_water;
        @Generated
        private GBufferShader terrain;
        @Generated
        private GBufferShader water;
        @Generated
        private GBufferShader block;
        @Generated
        private GBufferShader portal;
        @Generated
        private ShadowShader shadow;
        @Generated
        private BlitShader blit_color_identical;
        @Generated
        private BlitShader blit_depth_identical;
        @Generated
        private BlitShader blit_color_mismatched;
        @Generated
        private BlitShader blit_depth_mismatched;
        @Generated
        private ObjectList<CompositeShader> deferredList;
        @Generated
        private ObjectList<CompositeShader> compositeList;
        @Generated
        private CompositeShader _final;

        private ShaderBinding lockAndBuild() {
            this.gBufferList = ObjectLists.unmodifiable(this.gBufferList);
            this.loadedShaders = ObjectLists.unmodifiable(this.loadedShaders);
            return this.build();
        }

        @NotNull
        private GBufferShader gBuffer(IShaderPool pool, ResourceLocation loc) throws ShaderException {
            GBufferShader shader = this.safeInit(GBufferShader.load(pool, loc, true));
            this.gBufferList.add((Object)shader);
            return shader;
        }

        @Nullable
        private ObjectList<CompositeShader> composite(IShaderPool pool, List<ResourceLocation> locs) {
            ObjectArrayList list = new ObjectArrayList();
            for (ResourceLocation loc : locs) {
                CompositeShader shader = this.composite(pool, loc);
                if (shader == null) continue;
                list.add((Object)shader);
            }
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }

        @Nullable
        private CompositeShader composite(IShaderPool pool, ResourceLocation loc) {
            return this.safeInit(CompositeShader.load(pool, loc, false));
        }

        @Contract(value="!null -> !null; null -> null")
        @Nullable
        private <T extends ManagedShader> T safeInit(@Nullable T shader) {
            if (shader == null) {
                return null;
            }
            shader.init();
            this.loadedShaders.add(shader);
            return shader;
        }

        @Generated
        private Builder current(ManagedShader current) {
            this.current = current;
            return this;
        }

        @Generated
        private Builder gBufferList(ObjectList<GBufferShader> gBufferList) {
            this.gBufferList = gBufferList;
            return this;
        }

        @Generated
        private Builder loadedShaders(ObjectList<ManagedShader> loadedShaders) {
            this.loadedShaders = loadedShaders;
            return this;
        }

        @Generated
        private Builder basic(GBufferShader basic) {
            this.basic = basic;
            return this;
        }

        @Generated
        private Builder skybasic(GBufferShader skybasic) {
            this.skybasic = skybasic;
            return this;
        }

        @Generated
        private Builder textured(GBufferShader textured) {
            this.textured = textured;
            return this;
        }

        @Generated
        private Builder spidereyes(GBufferShader spidereyes) {
            this.spidereyes = spidereyes;
            return this;
        }

        @Generated
        private Builder beaconbeam(GBufferShader beaconbeam) {
            this.beaconbeam = beaconbeam;
            return this;
        }

        @Generated
        private Builder clouds(GBufferShader clouds) {
            this.clouds = clouds;
            return this;
        }

        @Generated
        private Builder skytextured(GBufferShader skytextured) {
            this.skytextured = skytextured;
            return this;
        }

        @Generated
        private Builder textured_lit(GBufferShader textured_lit) {
            this.textured_lit = textured_lit;
            return this;
        }

        @Generated
        private Builder entities(GBufferShader entities) {
            this.entities = entities;
            return this;
        }

        @Generated
        private Builder weather(GBufferShader weather) {
            this.weather = weather;
            return this;
        }

        @Generated
        private Builder hand(GBufferShader hand) {
            this.hand = hand;
            return this;
        }

        @Generated
        private Builder hand_water(GBufferShader hand_water) {
            this.hand_water = hand_water;
            return this;
        }

        @Generated
        private Builder terrain(GBufferShader terrain) {
            this.terrain = terrain;
            return this;
        }

        @Generated
        private Builder water(GBufferShader water) {
            this.water = water;
            return this;
        }

        @Generated
        private Builder block(GBufferShader block) {
            this.block = block;
            return this;
        }

        @Generated
        private Builder portal(GBufferShader portal) {
            this.portal = portal;
            return this;
        }

        @Generated
        private Builder shadow(@Nullable ShadowShader shadow) {
            this.shadow = shadow;
            return this;
        }

        @Generated
        private Builder blit_color_identical(BlitShader blit_color_identical) {
            this.blit_color_identical = blit_color_identical;
            return this;
        }

        @Generated
        private Builder blit_depth_identical(BlitShader blit_depth_identical) {
            this.blit_depth_identical = blit_depth_identical;
            return this;
        }

        @Generated
        private Builder blit_color_mismatched(BlitShader blit_color_mismatched) {
            this.blit_color_mismatched = blit_color_mismatched;
            return this;
        }

        @Generated
        private Builder blit_depth_mismatched(BlitShader blit_depth_mismatched) {
            this.blit_depth_mismatched = blit_depth_mismatched;
            return this;
        }

        @Generated
        private Builder deferredList(@Nullable ObjectList<CompositeShader> deferredList) {
            this.deferredList = deferredList;
            return this;
        }

        @Generated
        private Builder compositeList(@Nullable ObjectList<CompositeShader> compositeList) {
            this.compositeList = compositeList;
            return this;
        }

        @Generated
        private Builder _final(@Nullable CompositeShader _final) {
            this._final = _final;
            return this;
        }

        @Generated
        private ShaderBinding build() {
            return new ShaderBinding(this.current, this.gBufferList, this.loadedShaders, this.basic, this.skybasic, this.textured, this.spidereyes, this.beaconbeam, this.clouds, this.skytextured, this.textured_lit, this.entities, this.weather, this.hand, this.hand_water, this.terrain, this.water, this.block, this.portal, this.shadow, this.blit_color_identical, this.blit_depth_identical, this.blit_color_mismatched, this.blit_depth_mismatched, this.deferredList, this.compositeList, this._final);
        }

        @Generated
        public String toString() {
            return "ShaderBinding.Builder(current=" + this.current + ", gBufferList=" + this.gBufferList + ", loadedShaders=" + this.loadedShaders + ", basic=" + this.basic + ", skybasic=" + this.skybasic + ", textured=" + this.textured + ", spidereyes=" + this.spidereyes + ", beaconbeam=" + this.beaconbeam + ", clouds=" + this.clouds + ", skytextured=" + this.skytextured + ", textured_lit=" + this.textured_lit + ", entities=" + this.entities + ", weather=" + this.weather + ", hand=" + this.hand + ", hand_water=" + this.hand_water + ", terrain=" + this.terrain + ", water=" + this.water + ", block=" + this.block + ", portal=" + this.portal + ", shadow=" + this.shadow + ", blit_color_identical=" + this.blit_color_identical + ", blit_depth_identical=" + this.blit_depth_identical + ", blit_color_mismatched=" + this.blit_color_mismatched + ", blit_depth_mismatched=" + this.blit_depth_mismatched + ", deferredList=" + this.deferredList + ", compositeList=" + this.compositeList + ", _final=" + this._final + ")";
        }
    }
}

