/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.sufrace.FramebufferAttachment;
import com.ventooth.swansong.sufrace.Texture2D;
import cpw.mods.fml.common.Loader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Logger;

public class Report {
    private static final String CHAT_PREFIX = "[" + EnumChatFormatting.BLUE + "Swan" + EnumChatFormatting.AQUA + "Song" + EnumChatFormatting.RESET + "] ";
    public String name;
    public long startTime;
    public long endTime;
    public boolean rpleCompatible;
    public final Map<String, ShaderInfo> foundShaders = new LinkedHashMap<String, ShaderInfo>();
    public final Map<String, String> shadersFallback = new HashMap<String, String>();
    public final Set<String> erroredShaders = new HashSet<String>();
    public final Set<String> shadersFallbackInternal = new HashSet<String>();
    public final Map<String, DrawBufferInfo> drawBuffers = new LinkedHashMap<String, DrawBufferInfo>();
    public final Map<String, TextureInfo> customTextures = new LinkedHashMap<String, TextureInfo>();
    public final Map<String, CompositePipelineInfo> pipelines = new LinkedHashMap<String, CompositePipelineInfo>();

    public void print() {
        EntityClientPlayerMP entityClientPlayerMP;
        String name;
        int n;
        Logger log = Share.log;
        log.info("-----------------Shader Information-----------------");
        log.info("Active ShaderPack: {}", new Object[]{this.name});
        log.info("Loaded Shaders:");
        int longestName = 0;
        for (Map.Entry<String, ShaderInfo> entry : this.foundShaders.entrySet()) {
            longestName = Math.max(longestName, entry.getKey().length());
        }
        for (Map.Entry<String, ShaderInfo> entry : this.foundShaders.entrySet()) {
            String fb;
            String string = entry.getKey();
            ShaderInfo shaderInfo = entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            for (String target : shaderInfo.renderTargets) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(target);
            }
            log.info("  {}{}  [{}]", new Object[]{string, Report.padding(longestName - string.length()), stringBuilder});
            if (this.shadersFallbackInternal.contains(string)) {
                if (this.erroredShaders.contains(string)) {
                    log.info("    Failed to load, using internal shader.");
                } else {
                    log.info("    Not present, using internal shader.");
                }
            }
            if ((fb = this.shadersFallback.get(string)) == null) continue;
            log.info("    Using Fallback: {}", new Object[]{fb});
        }
        boolean headerErrored = false;
        for (String string : this.erroredShaders) {
            if (this.foundShaders.containsKey(string)) continue;
            if (!headerErrored) {
                headerErrored = true;
                log.error("Errored shaders:");
            }
            log.error("  {}", new Object[]{string});
        }
        log.info("Draw Buffers:");
        longestName = 0;
        for (Map.Entry<String, DrawBufferInfo> entry : this.drawBuffers.entrySet()) {
            longestName = Math.max(longestName, entry.getKey().length());
        }
        ArrayList<Map.Entry<String, DrawBufferInfo>> arrayList = new ArrayList<Map.Entry<String, DrawBufferInfo>>(this.drawBuffers.entrySet());
        arrayList.sort(Map.Entry.comparingByKey());
        for (Map.Entry<String, DrawBufferInfo> entry : arrayList) {
            String string = entry.getKey();
            DrawBufferInfo info = entry.getValue();
            int padding = longestName - string.length();
            log.info("  {}{}  {}", new Object[]{string, Report.padding(padding), info.ignored ? "(unused)" : info.format});
        }
        log.info("Custom Textures:");
        longestName = 0;
        boolean bl = false;
        for (Map.Entry<String, TextureInfo> entry : this.customTextures.entrySet()) {
            longestName = Math.max(longestName, entry.getKey().length());
            n = Math.max(n, entry.getValue().format.length());
        }
        for (Map.Entry<String, TextureInfo> entry : this.customTextures.entrySet()) {
            name = entry.getKey();
            TextureInfo info = entry.getValue();
            log.info("  {}{}  {}{}  {}x{}", new Object[]{name, Report.padding(longestName - name.length()), info.format, Report.padding(n - info.format.length()), info.width, info.height});
        }
        if (this.pipelines.isEmpty()) {
            log.info("No Post-Processing Pipelines present");
        } else {
            for (Map.Entry<String, CompositePipelineInfo> entry : this.pipelines.entrySet()) {
                name = entry.getKey();
                CompositePipelineInfo info = entry.getValue();
                log.info("Post Post-Processing Pipeline: {}", new Object[]{name});
                StringBuilder sb = new StringBuilder();
                for (CompositeStageInfo stage : info.stages) {
                    log.info("  {}", new Object[]{stage.name});
                    sb.setLength(0);
                    for (String mipmap : stage.mipmaps) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(mipmap);
                    }
                    if (sb.length() != 0) {
                        log.info("    Mipmap:  [{}]", new Object[]{sb});
                    }
                    sb.setLength(0);
                    for (Map.Entry input : stage.inputs.entrySet()) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append((String)input.getValue()).append(" -> ").append(((CompositeTextureData)((Object)input.getKey())).gpuIndex());
                    }
                    if (sb.length() != 0) {
                        log.info("    Inputs:  [{}]", new Object[]{sb});
                    }
                    sb.setLength(0);
                    for (Map.Entry output : stage.outputs.entrySet()) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(((FramebufferAttachment)((Object)output.getKey())).name()).append(" -> ").append((String)output.getValue());
                    }
                    if (sb.length() == 0) continue;
                    log.info("    Outputs: [{}]", new Object[]{sb});
                }
                if (info.postBlit == null) continue;
                sb.setLength(0);
                List<String> from = info.postBlit.from;
                List<String> to = info.postBlit.to;
                for (int i = 0; i < from.size(); ++i) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(from.get(i)).append(" -> ").append(to.get(i));
                }
                log.info("  Post Blit: [{}]", new Object[]{sb});
            }
        }
        if (!this.erroredShaders.isEmpty() && (entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g) != null) {
            TimeZone timeZone = TimeZone.getDefault();
            String now = ZonedDateTime.now(timeZone.toZoneId()).toLocalTime().toString();
            entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + "-----------------"));
            entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + EnumChatFormatting.YELLOW + now));
            entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + EnumChatFormatting.RED + "Failed to load shaders:"));
            for (String sh : this.erroredShaders) {
                entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + "  " + EnumChatFormatting.RED + sh));
            }
            entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + EnumChatFormatting.YELLOW + "Check the log for more details"));
            entityClientPlayerMP.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + "-----------------"));
        }
        if (!this.rpleCompatible && Loader.isModLoaded((String)"rple")) {
            String[] stringArray;
            for (String line : stringArray = "You are using a shaderpack which is not marked\nas compatible with RPLE. Do not report\nissues to SwanSong/RPLE.\nIf the shaderpack works fine,\nadd rpleCompatible=true to shaders.properties\n".split("\n")) {
                log.warn(line);
            }
            EntityClientPlayerMP entityClientPlayerMP2 = Minecraft.func_71410_x().field_71439_g;
            if (entityClientPlayerMP2 != null) {
                for (String line : stringArray) {
                    entityClientPlayerMP2.func_145747_a((IChatComponent)new ChatComponentText(CHAT_PREFIX + EnumChatFormatting.DARK_RED + line));
                }
            }
        }
    }

    private static String padding(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            res.append(' ');
        }
        return res.toString();
    }

    public static class ShaderInfo {
        public final Set<String> renderTargets = new LinkedHashSet<String>();
    }

    public static class DrawBufferInfo {
        public final boolean ignored;
        public final String format;

        @Generated
        public DrawBufferInfo(boolean ignored, String format) {
            this.ignored = ignored;
            this.format = format;
        }
    }

    public static class TextureInfo {
        public final int width;
        public final int height;
        public final String format;

        public TextureInfo(Texture2D tex) {
            this(tex.width(), tex.height(), BufferNameUtil.gbufferFormatNameFromEnum(tex.internalFormat()));
        }

        @Generated
        public TextureInfo(int width, int height, String format) {
            this.width = width;
            this.height = height;
            this.format = format;
        }
    }

    public static class CompositePipelineInfo {
        public final List<TextureInfo> auxTextures = new ArrayList<TextureInfo>();
        public final List<CompositeStageInfo> stages = new ArrayList<CompositeStageInfo>();
        public CompositePostBlit postBlit = null;
    }

    public static class CompositeStageInfo {
        public final String name;
        public final ObjectList<String> mipmaps = new ObjectArrayList(16);
        public final Map<CompositeTextureData, String> inputs = new EnumMap<CompositeTextureData, String>(CompositeTextureData.class);
        public final Map<FramebufferAttachment, String> outputs = new EnumMap<FramebufferAttachment, String>(FramebufferAttachment.class);

        @Generated
        public CompositeStageInfo(String name) {
            this.name = name;
        }
    }

    public static class CompositePostBlit {
        public final List<String> from = new ArrayList<String>();
        public final List<String> to = new ArrayList<String>();
    }
}

