/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mixin.mixins.client.texture;

import com.google.common.collect.Lists;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.mixin.extensions.TextureAtlasSpriteExt;
import com.ventooth.swansong.mixin.interfaces.ShadersTextureAtlasSprite;
import com.ventooth.swansong.pbr.PBRTextureEngine;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureAtlasSprite.class})
public abstract class TextureAtlasSpriteMixin
implements IIcon,
ShadersTextureAtlasSprite {
    @Shadow
    private AnimationMetadataSection field_110982_k;
    @Shadow
    protected List<int[][]> field_110976_a;
    @Shadow
    protected int field_130223_c;
    @Shadow
    protected int field_130224_d;
    @Shadow
    @Final
    private String field_110984_i;
    @Unique
    private TextureAtlasSprite s$spriteNormal = null;
    @Unique
    private TextureAtlasSprite s$spriteSpecular = null;
    @Unique
    private boolean s$isShadersSprite = false;

    @Shadow
    private static int[][] func_147962_a(int[][] data, int rows, int columns, int p_147962_3_) {
        return null;
    }

    @Shadow
    protected abstract void func_130099_d(int var1);

    @Override
    public boolean swan$isBaseSprite() {
        return !this.s$isShadersSprite;
    }

    @Override
    public TextureAtlasSprite swan$spriteNorm() {
        return this.s$spriteNormal;
    }

    @Override
    public TextureAtlasSprite swan$spriteSpec() {
        return this.s$spriteSpecular;
    }

    @Inject(method={"initSprite"}, at={@At(value="RETURN")}, require=1)
    private void initSprite(int inX, int inY, int originInX, int originInY, boolean rotated, CallbackInfo ci) {
        if (this.s$spriteNormal != null) {
            this.s$spriteNormal.func_110971_a(inX, inY, originInX, originInY, rotated);
        }
        if (this.s$spriteSpecular != null) {
            this.s$spriteSpecular.func_110971_a(inX, inY, originInX, originInY, rotated);
        }
    }

    @Inject(method={"updateAnimation"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void updateAnimation(CallbackInfo ci) {
        if (this.field_110982_k == null) {
            ci.cancel();
        }
    }

    @Inject(method={"loadSprite"}, at={@At(value="RETURN")}, require=1)
    private void loadShadersSprite(BufferedImage[] p_147964_1_, AnimationMetadataSection p_147964_2_, boolean p_147964_3_, CallbackInfo ci) {
        if (this.swan$isBaseSprite()) {
            TextureAtlasSpriteMixin spriteM;
            TextureAtlasSprite sprite;
            ITextureObject tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(PBRTextureEngine.currentlyLoadingAtlas);
            if (!(tex instanceof TextureMap)) {
                return;
            }
            TextureMap map = (TextureMap)tex;
            int s$mipmapLevels = Minecraft.func_71410_x().func_147117_R().field_147636_j;
            AnimationMetadataSection animBase = null;
            try {
                ResourceLocation locBase = TextureAtlasSpriteMixin.s$getIconResource(map, this.field_110984_i);
                IResource resBase = TextureAtlasSpriteMixin.swan$getResource(locBase);
                animBase = (AnimationMetadataSection)resBase.func_110526_a("animation");
            }
            catch (Exception locBase) {
                // empty catch block
            }
            if (ShadersConfig.NormalMapping.value) {
                String nameNormal = this.field_110984_i + "_n";
                ResourceLocation locNormal = TextureAtlasSpriteMixin.s$getIconResource(map, this.field_110984_i + "_n");
                if (TextureAtlasSpriteMixin.swan$hasResource(locNormal)) {
                    try {
                        sprite = TextureAtlasSpriteExt.newInstance(nameNormal);
                        spriteM = (TextureAtlasSpriteMixin)sprite;
                        spriteM.s$isShadersSprite = true;
                        sprite.func_94217_a((TextureAtlasSprite)this);
                        spriteM.s$loadShaderSpriteFrames(animBase, locNormal, s$mipmapLevels + 1);
                        sprite.func_147963_d(s$mipmapLevels);
                        this.s$spriteNormal = sprite;
                    }
                    catch (IOException e) {
                        Share.log.warn("Error loading normal texture: {}", new Object[]{nameNormal});
                        Share.log.warn("{}: {}", new Object[]{e.getClass().getName(), e.getMessage()});
                    }
                }
            }
            if (ShadersConfig.SpecularMapping.value) {
                String nameSpecular = this.field_110984_i + "_s";
                ResourceLocation locSpecular = TextureAtlasSpriteMixin.s$getIconResource(map, this.field_110984_i + "_s");
                if (TextureAtlasSpriteMixin.swan$hasResource(locSpecular)) {
                    try {
                        sprite = TextureAtlasSpriteExt.newInstance(nameSpecular);
                        spriteM = (TextureAtlasSpriteMixin)sprite;
                        spriteM.s$isShadersSprite = true;
                        sprite.func_94217_a((TextureAtlasSprite)this);
                        spriteM.s$loadShaderSpriteFrames(animBase, locSpecular, s$mipmapLevels + 1);
                        sprite.func_147963_d(s$mipmapLevels);
                        this.s$spriteSpecular = sprite;
                    }
                    catch (IOException e) {
                        Share.log.warn("Error loading specular texture: {}", new Object[]{nameSpecular});
                        Share.log.warn("{}: {}", new Object[]{e.getClass().getName(), e.getMessage()});
                    }
                }
            }
        }
    }

    @Unique
    private static ResourceLocation s$getIconResource(TextureMap map, String iconName) {
        ResourceLocation res = new ResourceLocation(iconName);
        return map.func_147634_a(res, 0);
    }

    @Unique
    private void s$loadShaderSpriteFrames(@Nullable AnimationMetadataSection baseAnim, ResourceLocation loc, int mipmaplevels) throws IOException {
        IResource resource = TextureAtlasSpriteMixin.swan$getResource(loc);
        BufferedImage bufferedimage = TextureAtlasSpriteMixin.swan$readBufferedImage(resource.func_110527_b());
        if (this.field_130223_c != bufferedimage.getWidth()) {
            bufferedimage = TextureAtlasSpriteMixin.swan$scaleImage(bufferedimage, this.field_130223_c);
        }
        AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)resource.func_110526_a("animation");
        int[][] aint = new int[mipmaplevels][];
        aint[0] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
        bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), aint[0], 0, bufferedimage.getWidth());
        if (animationmetadatasection == null) {
            if (baseAnim == null) {
                this.field_110976_a.add(aint);
            } else {
                try {
                    this.s$readAnimations(bufferedimage, baseAnim, aint);
                }
                catch (Exception ignored) {
                    this.field_110976_a.clear();
                    this.field_110976_a.add(aint);
                }
            }
        } else {
            this.s$readAnimations(bufferedimage, animationmetadatasection, aint);
        }
    }

    @Unique
    private void s$readAnimations(BufferedImage bufferedimage, AnimationMetadataSection animationmetadatasection, int[][] aint) {
        int i = bufferedimage.getHeight() / this.field_130223_c;
        if (animationmetadatasection.func_110473_c() > 0) {
            Iterator iterator = animationmetadatasection.func_130073_e().iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                if (j >= i) {
                    throw new RuntimeException("invalid frameindex " + j);
                }
                this.func_130099_d(j);
                this.field_110976_a.set(j, TextureAtlasSpriteMixin.func_147962_a(aint, this.field_130223_c, this.field_130223_c, j));
            }
            this.field_110982_k = animationmetadatasection;
        } else {
            if (i == 1) {
                this.field_110976_a.add(aint);
                return;
            }
            ArrayList list = Lists.newArrayList();
            for (int k = 0; k < i; ++k) {
                this.field_110976_a.add(TextureAtlasSpriteMixin.func_147962_a(aint, this.field_130223_c, this.field_130223_c, k));
                list.add(new AnimationFrame(k, -1));
            }
            this.field_110982_k = new AnimationMetadataSection((List)list, this.field_130223_c, this.field_130224_d, animationmetadatasection.func_110469_d());
        }
    }

    @Unique
    private static BufferedImage swan$readBufferedImage(InputStream is) throws IOException {
        BufferedImage var1;
        try {
            var1 = ImageIO.read(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return var1;
    }

    @Unique
    private static BufferedImage swan$scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    @Unique
    private static boolean swan$hasResource(ResourceLocation loc) {
        try {
            return TextureAtlasSpriteMixin.swan$getResource(loc) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Unique
    private static IResource swan$getResource(ResourceLocation loc) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
    }
}

