/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mathparser;

import com.ventooth.swansong.mathparser.Lexer;
import com.ventooth.swansong.mathparser.ParserException;
import com.ventooth.swansong.mathparser.Token;
import com.ventooth.swansong.mathparser.TokenType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

public abstract class AbstractParser<Node> {
    protected final Lexer lexer;

    public Node parse() throws ParserException {
        if (!this.lexer.hasNext()) {
            throw new UnexpectedEndOfTokenStreamException("Nothing to parse");
        }
        return this.parseExpr();
    }

    protected Node parseExpr() throws ParserException {
        if (!this.lexer.hasNext()) {
            return null;
        }
        ArrayList<Node> primaries = new ArrayList<Node>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        while (true) {
            Operator op;
            if (!this.lexer.hasNext()) {
                throw new UnexpectedEndOfTokenStreamException("Unterminated binary operation");
            }
            try {
                primaries.add(this.parsePrimaryExpr());
            }
            catch (UnexpectedTokenException e) {
                e.add(TokenType.Mul, TokenType.Div, TokenType.Mod, TokenType.Plus, TokenType.Minus, TokenType.GreaterEqual, TokenType.Greater, TokenType.LessEqual, TokenType.Less, TokenType.Equal, TokenType.NotEqual, TokenType.And, TokenType.Or);
                throw e;
            }
            if (!this.lexer.hasNext()) break;
            switch (this.lexer.peek().type()) {
                case Mul: {
                    Operator operator = Operator.Mul;
                    break;
                }
                case Div: {
                    Operator operator = Operator.Div;
                    break;
                }
                case Mod: {
                    Operator operator = Operator.Rem;
                    break;
                }
                case Plus: {
                    Operator operator = Operator.Add;
                    break;
                }
                case Minus: {
                    Operator operator = Operator.Sub;
                    break;
                }
                case GreaterEqual: {
                    Operator operator = Operator.Ge;
                    break;
                }
                case Greater: {
                    Operator operator = Operator.Gt;
                    break;
                }
                case LessEqual: {
                    Operator operator = Operator.Le;
                    break;
                }
                case Less: {
                    Operator operator = Operator.Lt;
                    break;
                }
                case Equal: {
                    Operator operator = Operator.Eq;
                    break;
                }
                case NotEqual: {
                    Operator operator = Operator.Ne;
                    break;
                }
                case And: {
                    Operator operator = Operator.And;
                    break;
                }
                case Or: {
                    Operator operator = Operator.Or;
                    break;
                }
                default: {
                    Operator operator = op = null;
                }
            }
            if (op == null) break;
            operators.add(op);
            this.lexer.next();
        }
        if (primaries.size() == 1) {
            return (Node)primaries.get(0);
        }
        return (Node)this.evaluatePrecedence(primaries, operators);
    }

    protected Node evaluatePrecedence(List<Node> primaries, List<Operator> operators) throws ParserException {
        int opSize = operators.size();
        int primSize = primaries.size();
        if (primSize != opSize + 1) {
            throw new AssertionError();
        }
        if (opSize == 0) {
            return primaries.get(0);
        }
        int current = 0;
        int index = -1;
        for (int i = 0; i < opSize; ++i) {
            Operator op = operators.get(i);
            if (op.precedence <= current) continue;
            index = i;
            current = op.precedence;
        }
        Node left = this.evaluatePrecedence(primaries.subList(0, index + 1), operators.subList(0, index));
        Node right = this.evaluatePrecedence(primaries.subList(index + 1, primSize), operators.subList(index + 1, opSize));
        return this.createBinaryOperation(left, right, operators.get(index));
    }

    protected Node parsePrimaryExpr() throws ParserException {
        Node Node2;
        Token token = this.lexer.next();
        switch (token.type()) {
            case Integer: {
                Node2 = this.createIntegerConstant(Integer.parseInt(token.text()));
                break;
            }
            case Float: {
                Node2 = this.createFloatConstant(Double.parseDouble(token.text()));
                break;
            }
            case True: {
                Node2 = this.createBoolConstant(true);
                break;
            }
            case False: {
                Node2 = this.createBoolConstant(false);
                break;
            }
            case Identifier: {
                Node2 = this.parseFunOrVar(token.text());
                break;
            }
            case LeftParen: {
                Node expr = this.parseExpr();
                if (!this.lexer.hasNext()) {
                    throw new UnexpectedEndOfTokenStreamException("Unterminated parenthesis");
                }
                Token tok = this.lexer.next();
                if (tok.type() != TokenType.RightParen) {
                    throw new UnexpectedTokenException(TokenType.RightParen, tok);
                }
                Node2 = expr;
                break;
            }
            case Minus: {
                if (!this.lexer.hasNext()) {
                    throw new UnexpectedEndOfTokenStreamException("Dangling minus sign");
                }
                Node expr = this.parsePrimaryExpr();
                Node2 = this.createUnaryMinus(expr);
                break;
            }
            case Not: {
                if (!this.lexer.hasNext()) {
                    throw new UnexpectedEndOfTokenStreamException("Dangling not sign");
                }
                Node expr = this.parsePrimaryExpr();
                Node2 = this.createUnaryNot(expr);
                break;
            }
            default: {
                throw new UnexpectedTokenException(Arrays.asList(TokenType.Integer, TokenType.Float, TokenType.True, TokenType.False, TokenType.Identifier, TokenType.LeftParen, TokenType.Not, TokenType.Minus), token);
            }
        }
        return Node2;
    }

    protected Node parseFunOrVar(String name) throws ParserException {
        if (this.lexer.hasNext()) {
            Token lookahead = this.lexer.peek();
            if (lookahead.type() == TokenType.Dot) {
                Node variable = this.createVariable(name);
                return this.parseSwizzle(variable);
            }
            if (lookahead.type() == TokenType.LeftParen) {
                this.lexer.next();
                return this.parseFun(name);
            }
        }
        return this.createVariable(name);
    }

    protected Node parseSwizzle(Node value) throws ParserException {
        while (this.lexer.hasNext() && this.lexer.peek().type() == TokenType.Dot) {
            Node Node2;
            this.lexer.next();
            if (!this.lexer.hasNext()) {
                throw new UnexpectedEndOfTokenStreamException("Dangling dot for swizzling");
            }
            Token swizzleToken = this.lexer.next();
            switch (swizzleToken.type()) {
                case Integer: {
                    int idx = Integer.parseInt(swizzleToken.text());
                    Node2 = this.createSwizzle(value, idx);
                    break;
                }
                case Identifier: {
                    int n;
                    String txt;
                    switch (txt = swizzleToken.text()) {
                        case "x": 
                        case "s": 
                        case "r": {
                            n = 0;
                            break;
                        }
                        case "y": 
                        case "t": 
                        case "g": {
                            n = 1;
                            break;
                        }
                        case "z": 
                        case "p": 
                        case "b": {
                            n = 2;
                            break;
                        }
                        case "w": 
                        case "q": 
                        case "a": {
                            n = 3;
                            break;
                        }
                        default: {
                            throw new ParserException("Unknown swizzle index \"" + txt + "\". Must be a number, or one of [x, y, z, w] or [s, t, p, q] or [r, g, b, a]");
                        }
                    }
                    Node2 = this.createSwizzle(value, n);
                    break;
                }
                default: {
                    throw new UnexpectedTokenException(Arrays.asList(TokenType.Integer, TokenType.Identifier), swizzleToken);
                }
            }
            value = Node2;
        }
        return value;
    }

    protected Node parseFun(String name) throws ParserException {
        ArrayList<Node> args = new ArrayList<Node>();
        boolean first = true;
        while (true) {
            if (!this.lexer.hasNext()) {
                throw new UnexpectedEndOfTokenStreamException("Unterminated function call");
            }
            Token lookaheadToken = this.lexer.peek();
            TokenType lookahead = lookaheadToken.type();
            if (lookahead == TokenType.RightParen) {
                this.lexer.next();
                return (Node)this.createFunctionCall(name, args);
            }
            if (first) {
                first = false;
            } else {
                if (lookahead != TokenType.Comma) {
                    throw new UnexpectedTokenException(TokenType.Comma, lookaheadToken);
                }
                this.lexer.next();
            }
            args.add(this.parseExpr());
        }
    }

    protected abstract Node createFunctionCall(String var1, List<Node> var2) throws ParserException;

    protected abstract Node createVariable(String var1) throws ParserException;

    protected abstract Node createBinaryOperation(Node var1, Node var2, Operator var3) throws ParserException;

    protected abstract Node createIntegerConstant(int var1) throws ParserException;

    protected abstract Node createFloatConstant(double var1) throws ParserException;

    protected abstract Node createBoolConstant(boolean var1) throws ParserException;

    protected abstract Node createUnaryNot(Node var1) throws ParserException;

    protected abstract Node createUnaryMinus(Node var1) throws ParserException;

    protected abstract Node createSwizzle(Node var1, int var2) throws ParserException;

    @Generated
    public AbstractParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public static class UnexpectedEndOfTokenStreamException
    extends ParserException {
        public UnexpectedEndOfTokenStreamException(String message) {
            super(message);
        }
    }

    public static class UnexpectedTokenException
    extends ParserException {
        public Set<TokenType> expected;
        public final Token got;

        public UnexpectedTokenException(TokenType expected, Token got) {
            this(Collections.singleton(expected), got);
        }

        public UnexpectedTokenException(Collection<TokenType> expected, Token got) {
            TreeSet<TokenType> treeSet;
            if (expected instanceof TreeSet) {
                TreeSet ts = (TreeSet)expected;
                treeSet = ts;
            } else {
                treeSet = new TreeSet<TokenType>(expected);
            }
            this((Set<TokenType>)treeSet, got);
        }

        public void add(TokenType ... expected) {
            TreeSet<TokenType> newEx = new TreeSet<TokenType>(this.expected);
            newEx.addAll(Arrays.asList(expected));
            this.expected = newEx;
        }

        @Generated
        private UnexpectedTokenException(Set<TokenType> expected, Token got) {
            this.expected = expected;
            this.got = got;
        }
    }

    public static enum Operator {
        Mul(3),
        Div(3),
        Rem(3),
        Add(4),
        Sub(4),
        Ge(6),
        Gt(6),
        Le(6),
        Lt(6),
        Eq(7),
        Ne(7),
        And(11),
        Or(12);

        public final int precedence;

        @Generated
        private Operator(int precedence) {
            this.precedence = precedence;
        }
    }
}

