/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.image;

import com.ventooth.swansong.debug.DebugMarker;
import com.ventooth.swansong.image.ImageUtils;
import com.ventooth.swansong.image.RawImage;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ScreenShotHelper;

public final class ThreadedScreenshot {
    private static final int STATE_IDLE = 0;
    private static final int STATE_CAPTURING = 1;
    private static final int STATE_POST_CAPTURE = 2;
    private static final AtomicInteger state = new AtomicInteger(0);
    private static volatile boolean resultSuccess = false;
    private static volatile File resultFile = null;
    private static volatile Exception resultException = null;

    public static void init() {
        FMLCommonHandler.instance().bus().register((Object)new ThreadedScreenshot());
    }

    public static IChatComponent captureScreenshot(File gameDirectory, Framebuffer frameBuffer) {
        RawImage rawImage;
        File imageFile;
        if (state.get() != 0) {
            return new ChatComponentTranslation("screenshot.swansong.nospam", new Object[0]);
        }
        try {
            imageFile = ScreenShotHelper.func_74290_a((File)new File(gameDirectory, "screenshots"));
            rawImage = ImageUtils.downloadGLTextureAsBGRA(frameBuffer);
            if (rawImage == null) {
                throw new IllegalStateException("Failed to copy from GPU");
            }
            if (DebugMarker.isEnabled()) {
                DebugMarker.SCREENSHOT_TAKEN.insert();
            }
        }
        catch (Exception e) {
            return new ChatComponentTranslation("screenshot.failure", new Object[]{e.getMessage()});
        }
        state.set(1);
        Thread thread = new Thread(() -> {
            try {
                imageFile.getParentFile().mkdirs();
                ImageIO.write((RenderedImage)rawImage.asBufImg(false, true), "png", imageFile);
                resultSuccess = true;
                resultFile = imageFile;
            }
            catch (IOException e) {
                resultSuccess = false;
                resultException = e;
            }
            state.set(2);
        });
        thread.setName("Screenshot Thread");
        thread.setDaemon(true);
        thread.start();
        return new ChatComponentTranslation("screenshot.swansong.threaded", new Object[0]);
    }

    @SubscribeEvent
    public void postClientTick(TickEvent.ClientTickEvent evt) {
        ChatComponentTranslation chatMessage;
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (state.get() != 2) {
            return;
        }
        if (resultSuccess) {
            File file = resultFile;
            ChatComponentText clickableFile = new ChatComponentText(file.getName());
            clickableFile.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())).func_150228_d(Boolean.valueOf(true));
            chatMessage = new ChatComponentTranslation("screenshot.success", new Object[]{clickableFile});
        } else {
            chatMessage = new ChatComponentTranslation("screenshot.failure", new Object[]{resultException.getMessage()});
        }
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)chatMessage);
        resultSuccess = false;
        resultFile = null;
        resultException = null;
        state.set(0);
    }

    @Generated
    private ThreadedScreenshot() {
    }
}

