/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.gl;

import com.falsepattern.lib.dependencies.DependencyLoader;
import com.falsepattern.lib.dependencies.Library;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.dependencies.Version;
import com.sun.jna.Function;
import com.sun.jna.Pointer;
import com.ventooth.swansong.asm.CoreLoadingPlugin;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import me.eigenraven.lwjgl3ify.api.Lwjgl3Aware;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.system.MemoryStack;

public class ShaderHax {
    private static final boolean lwjgl3;

    public static void glShaderSource(int shader, ByteBuffer sourceNullTerminated) {
        if (lwjgl3) {
            Lwjgl3.glShaderSource(shader, sourceNullTerminated);
        } else {
            Lwjgl2.glShaderSource(shader, sourceNullTerminated);
        }
    }

    static {
        boolean isLwjgl3 = false;
        try {
            Class.forName("org.lwjgl.system.MemoryUtil", false, CoreLoadingPlugin.class.getClassLoader());
            isLwjgl3 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lwjgl3 = isLwjgl3;
        if (!lwjgl3) {
            DependencyLoader.addMavenRepo((String)"https://repo1.maven.org/maven2/");
            DependencyLoader.loadLibraries((Library[])new Library[]{Library.builder().loadingModId("swansong").groupId("net.java.dev.jna").artifactId("jna").minVersion((Version)new SemanticVersion(5, 17, 0)).preferredVersion((Version)new SemanticVersion(5, 17, 0)).build()});
        }
    }

    @Lwjgl3Aware
    private static class Lwjgl3 {
        private Lwjgl3() {
        }

        private static void glShaderSource(int shader, ByteBuffer sourceNullTerminated) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                long ptr = stack.npointer((Buffer)sourceNullTerminated);
                GL20C.nglShaderSource((int)shader, (int)1, (long)ptr, (long)0L);
            }
        }
    }

    private static class Lwjgl2 {
        private static final Field glShaderSourceCaps;
        public static Pointer jnaPointerReachability;
        public static PointerBuffer pointerReachability;

        private Lwjgl2() {
        }

        private static synchronized void glShaderSource(int shader, ByteBuffer sourceNullTerminated) {
            Pointer jnaPointer;
            ContextCapabilities caps = GLContext.getCapabilities();
            long function_pointer = glShaderSourceCaps.getLong(caps);
            Function fn = Function.getFunction((Pointer)new Pointer(function_pointer));
            BufferChecks.checkFunctionAddress((long)function_pointer);
            BufferChecks.checkDirect((ByteBuffer)sourceNullTerminated);
            PointerBuffer ptrs = PointerBuffer.allocateDirect((int)1);
            ptrs.put(0, MemoryUtil.getAddress((ByteBuffer)sourceNullTerminated));
            pointerReachability = ptrs;
            jnaPointerReachability = jnaPointer = new Pointer(MemoryUtil.getAddress((PointerBuffer)ptrs));
            fn.invoke(new Object[]{shader, 1, jnaPointer, null});
            jnaPointerReachability = null;
            pointerReachability = null;
        }

        static {
            try {
                glShaderSourceCaps = Class.forName("org.lwjgl.opengl.ContextCapabilities").getDeclaredField("glShaderSource");
                glShaderSourceCaps.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

