/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.asm.transformers;

import com.falsepattern.lib.asm.ASMUtil;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TessellatorShaderTransformer
implements TurboClassTransformer {
    private static final String TESS_CLASS = "net.minecraft.client.renderer.Tessellator";
    private static final String TESS_INTERNAL = "net/minecraft/client/renderer/Tessellator";
    private static final String SHADER_TESS_INTERNAL = "com/ventooth/swansong/tessellator/ShaderTess";
    private static final String SHADER_TESS_DESC = "Lcom/ventooth/swansong/tessellator/ShaderTess;";
    private static final String TVS_INTERNAL = "net/minecraft/client/shader/TesselatorVertexState";
    private static final String TVS_DESC = "Lnet/minecraft/client/shader/TesselatorVertexState;";
    private static final String ENGINE_INTERNAL = "com/ventooth/swansong/shader/ShaderEngine";

    public String owner() {
        return "swansong";
    }

    public String name() {
        return "TessellatorShaderTransformer";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return TESS_CLASS.equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        this.injectDrawHook(ASMUtil.findMethodFromMCP((ClassNode)cn, (String)"draw", (String)"()I", (boolean)false));
        this.injectAddVertexHook(ASMUtil.findMethodFromMCP((ClassNode)cn, (String)"addVertex", (String)"(DDD)V", (boolean)false));
        FieldNode rawBufferIndex = ASMUtil.findFieldFromMCP((ClassNode)cn, (String)"rawBufferIndex", (boolean)false);
        MethodNode foamfixMethod = null;
        for (MethodNode method : cn.methods) {
            if (!"getVertexState_foamfix_old".equals(method.name)) continue;
            foamfixMethod = method;
            break;
        }
        if (foamfixMethod != null) {
            this.injectGetVertexState(foamfixMethod, rawBufferIndex);
        } else {
            this.injectGetVertexState(ASMUtil.findMethodFromMCP((ClassNode)cn, (String)"getVertexState", (String)"(FFF)Lnet/minecraft/client/shader/TesselatorVertexState;", (boolean)false), rawBufferIndex);
        }
        return true;
    }

    private void injectDrawHook(MethodNode methodNode) {
        InsnList instructions = new InsnList();
        LabelNode end = this.skipIfNotEnabled(instructions);
        this.getShaderTess(instructions);
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, SHADER_TESS_INTERNAL, "draw", "()I", false));
        instructions.add((AbstractInsnNode)new InsnNode(172));
        instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        instructions.add((AbstractInsnNode)end);
        methodNode.instructions.insert(instructions);
    }

    private void injectAddVertexHook(MethodNode methodNode) {
        InsnList instructions = new InsnList();
        LabelNode end = this.skipIfNotEnabled(instructions);
        this.getShaderTess(instructions);
        methodNode.maxStack = Math.max(methodNode.maxStack, 7);
        instructions.add((AbstractInsnNode)new VarInsnNode(24, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(24, 3));
        instructions.add((AbstractInsnNode)new VarInsnNode(24, 5));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, SHADER_TESS_INTERNAL, "addVertex", "(DDD)V", false));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        instructions.add((AbstractInsnNode)end);
        methodNode.instructions.insert(instructions);
    }

    private void injectGetVertexState(MethodNode methodNode, FieldNode rawBufferIndex) {
        InsnList instructions = new InsnList();
        LabelNode end = this.skipIfNotEnabled(instructions);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, TESS_INTERNAL, rawBufferIndex.name, rawBufferIndex.desc));
        instructions.add((AbstractInsnNode)new InsnNode(4));
        LabelNode endLabel = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(162, endLabel));
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        instructions.add((AbstractInsnNode)endLabel);
        instructions.add((AbstractInsnNode)end);
        methodNode.instructions.insert(instructions);
    }

    private void getShaderTess(InsnList instructions) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, TESS_INTERNAL, "swansong$shaderTess", SHADER_TESS_DESC));
    }

    private LabelNode skipIfNotEnabled(InsnList instructions) {
        LabelNode label = new LabelNode();
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, ENGINE_INTERNAL, "isInitialized", "()Z", false));
        instructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
        return label;
    }
}

