/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.asm.transformers;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SkyRendererTransformer
implements TurboClassTransformer {
    public String owner() {
        return "swansong";
    }

    public String name() {
        return "SkyRendererTransformer";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return !className.startsWith("com.ventooth.swansong");
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null) {
            return false;
        }
        if (!node.superName.equals("net/minecraftforge/client/IRenderHandler")) {
            return false;
        }
        boolean modified = false;
        for (MethodNode method : node.methods) {
            for (Object e : method.instructions) {
                MethodInsnNode inst;
                if (!(e instanceof MethodInsnNode) || (inst = (MethodInsnNode)e).getOpcode() != 184 || !"org/lwjgl/opengl/GL11".equals(inst.owner) && !"org/lwjglx/opengl/GL11".equals(inst.owner) || !"(I)V".equals(inst.desc)) continue;
                if (SkyRendererTransformer.patchTexture(inst)) {
                    modified = true;
                    continue;
                }
                if (!SkyRendererTransformer.patchCallList(inst)) continue;
                modified = true;
            }
        }
        return modified;
    }

    private static boolean patchTexture(MethodInsnNode inst) {
        IntInsnNode capInst;
        if (!"glEnable".equals(inst.name) && !"glDisable".equals(inst.name)) {
            return false;
        }
        AbstractInsnNode abstractInsnNode = inst.getPrevious();
        if (!(abstractInsnNode instanceof IntInsnNode) || (capInst = (IntInsnNode)abstractInsnNode).getOpcode() != 17) {
            return false;
        }
        int cap = capInst.operand;
        if (cap != 3553) {
            return false;
        }
        inst.owner = "com/ventooth/swansong/ASMHooks";
        return true;
    }

    private static boolean patchCallList(MethodInsnNode inst) {
        if (!"glCallList".equals(inst.name)) {
            return false;
        }
        inst.owner = "com/ventooth/swansong/ASMHooks";
        return true;
    }
}

