/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong;

import com.ventooth.swansong.Share;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;
import org.lwjgl.opengl.GL11;

public final class EnvInfo {
    public static final Logger log = Share.getLogger("EnvInfo");
    private static EnvInfo instance;
    public final String mcVersion;
    public final String swansongVersion;
    public final String osName = System.getProperty("os.name");
    public final String glVendorStr = GL11.glGetString((int)7936);
    public final String glRendererStr = GL11.glGetString((int)7937);
    public final String glVersionStr = GL11.glGetString((int)7938);
    public final @Unmodifiable List<String> glExtList = Arrays.asList(StringUtils.split((String)GL11.glGetString((int)7939)));
    public final @Unmodifiable Set<String> glExtSet = Collections.unmodifiableSet(new LinkedHashSet<String>(this.glExtList));
    public final String glslVersionStr = GL11.glGetString((int)35724);
    public final int maxTextureSize = GL11.glGetInteger((int)3379);
    public final OS osPlatform = OS.access$000(this.osName);
    public final GLVendor glVendor = GLVendor.access$100(this.glVendorStr);
    public final GLRenderer glRenderer = GLRenderer.access$200(this.glRendererStr);

    private EnvInfo() {
        this.mcVersion = "1.7.10";
        this.swansongVersion = "1.2.6";
    }

    public static void init() {
        if (instance != null) {
            log.error("", (Throwable)new IllegalStateException("Already initialized"));
        }
        instance = new EnvInfo();
        log.info("Initialized:\n{}", new Object[]{instance});
    }

    public static EnvInfo get() {
        if (instance == null) {
            throw new IllegalStateException("Not Initialized");
        }
        return instance;
    }

    @Generated
    public String toString() {
        return "EnvInfo(mcVersion=" + this.mcVersion + ", swansongVersion=" + this.swansongVersion + ", osName=" + this.osName + ", glVendorStr=" + this.glVendorStr + ", glRendererStr=" + this.glRendererStr + ", glVersionStr=" + this.glVersionStr + ", glExtList=" + this.glExtList + ", glExtSet=" + this.glExtSet + ", glslVersionStr=" + this.glslVersionStr + ", maxTextureSize=" + this.maxTextureSize + ", osPlatform=" + (Object)((Object)this.osPlatform) + ", glVendor=" + (Object)((Object)this.glVendor) + ", glRenderer=" + (Object)((Object)this.glRenderer) + ")";
    }

    public static enum OS {
        LINUX,
        WINDOWS,
        OSX,
        OTHER;


        private static OS of(String osName) {
            if ((osName = osName.toLowerCase(Locale.ROOT)).contains("linux") || osName.contains("unix")) {
                return LINUX;
            }
            if (osName.contains("win")) {
                return WINDOWS;
            }
            if (osName.contains("mac")) {
                return OSX;
            }
            return OTHER;
        }

        static /* synthetic */ OS access$000(String x0) {
            return OS.of(x0);
        }
    }

    public static enum GLVendor {
        ATI,
        INTEL,
        NVIDIA,
        XORG,
        AMD,
        OTHER;


        private static GLVendor of(String glVendor) {
            if ((glVendor = glVendor.toLowerCase(Locale.ROOT)).startsWith("ati")) {
                return ATI;
            }
            if (glVendor.startsWith("intel")) {
                return INTEL;
            }
            if (glVendor.startsWith("nvidia")) {
                return NVIDIA;
            }
            if (glVendor.startsWith("amd")) {
                return AMD;
            }
            if (glVendor.startsWith("x.org")) {
                return XORG;
            }
            return OTHER;
        }

        static /* synthetic */ GLVendor access$100(String x0) {
            return GLVendor.of(x0);
        }
    }

    public static enum GLRenderer {
        RADEON,
        GALLIUM,
        INTEL,
        GEFORCE,
        QUADRO,
        MESA,
        OTHER;


        private static GLRenderer of(String glRenderer) {
            if ((glRenderer = glRenderer.toLowerCase(Locale.ROOT)).startsWith("amd") || glRenderer.startsWith("ati") || glRenderer.startsWith("radeon")) {
                return RADEON;
            }
            if (glRenderer.startsWith("gallium")) {
                return GALLIUM;
            }
            if (glRenderer.startsWith("intel")) {
                return INTEL;
            }
            if (glRenderer.startsWith("geforce") || glRenderer.startsWith("nvidia")) {
                return GEFORCE;
            }
            if (glRenderer.startsWith("quadro") || glRenderer.startsWith("nvs")) {
                return QUADRO;
            }
            if (glRenderer.startsWith("mesa")) {
                return MESA;
            }
            return OTHER;
        }

        static /* synthetic */ GLRenderer access$200(String x0) {
            return GLRenderer.of(x0);
        }
    }
}

