/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.internal;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.event.EnderStorageStoredEvent;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.enderstorage.storage.liquid.TileEnderTank;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class EnderStorageCPH
implements PacketCustom.IClientPacketHandler {
    public static final String channel = "ES";

    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
        switch (packet.getType()) {
            case 1: {
                this.handleTilePacket(mc.field_71441_e, packet, packet.readCoord());
                break;
            }
            case 2: {
                short windowID = packet.readUByte();
                ((EnderItemStorage)EnderStorageManager.instance(true).getStorage(packet.readString(), packet.readUShort(), "item")).openClientGui(windowID, mc.field_71439_g.field_71071_by, packet.readString(), packet.readUByte());
                break;
            }
            case 3: {
                ((EnderItemStorage)EnderStorageManager.instance(true).getStorage(packet.readString(), packet.readUShort(), "item")).setClientOpen(packet.readBoolean() ? 1 : 0);
                break;
            }
            case 4: {
                TankSynchroniser.syncClient(packet.readUShort(), packet.readString(), packet.readFluidStack());
                break;
            }
            case 5: 
            case 6: {
                this.handleTankTilePacket(mc.field_71441_e, packet.readCoord(), packet);
                break;
            }
            case 7: {
                boolean global = packet.readBoolean();
                int type = packet.readInt();
                NBTTagCompound nbtTagCompound = packet.readNBTTagCompound();
                Map<Integer, NBTTagCompound> compoundMap = Arrays.stream(nbtTagCompound.func_74759_k("freqs")).boxed().collect(Collectors.toMap(freq -> freq, freq -> nbtTagCompound.func_74775_l(freq.toString())));
                if (compoundMap.isEmpty()) {
                    return;
                }
                this.updateStorage(global, type, compoundMap);
                MinecraftForge.EVENT_BUS.post((Event)new EnderStorageStoredEvent(global, type));
            }
        }
    }

    private void handleTankTilePacket(WorldClient world, BlockCoord pos, PacketCustom packet) {
        TileEntity tile = world.func_147438_o(pos.x, pos.y, pos.z);
        if (tile instanceof TileEnderTank) {
            ((TileEnderTank)tile).sync(packet);
        }
    }

    private void handleTilePacket(WorldClient world, PacketCustom packet, BlockCoord pos) {
        TileEntity tile = world.func_147438_o(pos.x, pos.y, pos.z);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).handleDescriptionPacket(packet);
        }
    }

    private void updateStorage(boolean global, int type, Map<Integer, NBTTagCompound> compoundMap) {
        String typeStr;
        EnderStorageManager storageManager = EnderStorageManager.instance(true);
        String owner = global ? "global" : Minecraft.func_71410_x().field_71439_g.getDisplayName();
        switch (type) {
            case 1: {
                typeStr = "item";
                break;
            }
            case 2: {
                typeStr = "liquid";
                break;
            }
            default: {
                EnderStorage.LOGGER.error("EnderStorageCPH:Unknown EnderStorageStoredEvent TYPE,no information is returned.");
                return;
            }
        }
        for (Map.Entry<Integer, NBTTagCompound> entryMap : compoundMap.entrySet()) {
            storageManager.setStorage(owner, entryMap.getKey(), typeStr, entryMap.getValue());
        }
    }
}

