/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizon.gtnhlib.compat.Mods;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;

public enum MobSpawnerHeaderProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawnerTile = (TileEntityMobSpawner)tileEntity;
            String spawnerName = DisplayUtil.itemDisplayNameShortFormatted(accessor.getItemForm());
            String mobName = spawnerTile.func_145881_a().func_98276_e();
            mobName = FormatUtil.formatNameByPixelCount(mobName);
            ThemeHelper.INSTANCE.overrideTooltipTitle(tooltip, String.format("%s (%s)", spawnerName, mobName));
            if (Mods.NEI) {
                Object entityID = EntityList.field_75622_f.get(mobName);
                if (entityID == null) {
                    return;
                }
                ItemStack newStack = new ItemStack(Blocks.field_150474_ac, 1, ((Integer)entityID).intValue());
                ThemeHelper.INSTANCE.overrideTooltipIcon(tooltip, newStack, false);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.MOB_SPAWNER_HEADER;
    }

    @Override
    public int getDefaultPriority() {
        return -5001;
    }
}

