/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.ITimeFormatConfigurable;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.impl.format.TimeFormattingPattern;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum MinecartFurnaceProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>,
ITimeFormatConfigurable
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        int fuel = accessor.getServerData().func_74762_e("Fuel");
        if (fuel > 0) {
            TimeFormattingPattern timePattern = WDMlaConfig.instance().getTimeFormatter(this);
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.remaining.time"), timePattern.tickFormatter.apply(fuel)));
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityMinecartFurnace) {
            EntityMinecartFurnace furnaceCart = (EntityMinecartFurnace)entity;
            data.func_74768_a("Fuel", furnaceCart.field_94110_c);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.MINECART_FURNACE;
    }

    @Override
    public TimeFormattingPattern getDefaultTimeFormatter() {
        return TimeFormattingPattern.ALWAYS_SECOND;
    }
}

