/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum HorseProvider implements IEntityComponentProvider
{
    INSTANCE;

    public static final double SPEED_UNIT_TO_BLOCKS_PER_SECOND_RATE = 42.16;

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            double jumpStrength = horse.func_110215_cj();
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.jumpStrength"), FormatUtil.STANDARD.format(HorseProvider.getJumpHeight(jumpStrength)) + " " + StatCollector.func_74838_a((String)"hud.msg.wdmla.blocks")));
            if (accessor.showDetails()) {
                tooltip.text("(" + FormatUtil.STANDARD.format(jumpStrength) + ")");
            }
            double movementSpeed = horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.speed"), FormatUtil.STANDARD.format(movementSpeed * 42.16) + " " + StatCollector.func_74838_a((String)"hud.msg.wdmla.blockspersecond")));
            if (accessor.showDetails()) {
                tooltip.text("(" + FormatUtil.STANDARD.format(movementSpeed) + ")");
            }
        }
    }

    private static double getJumpHeight(double jumpStrength) {
        return -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.HORSE;
    }
}

