/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.StatusHelper;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum BeaconProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        int secondary;
        if (!accessor.getServerData().func_74764_b("Formed")) {
            return;
        }
        if (!accessor.getServerData().func_74767_n("Formed")) {
            tooltip.child(StatusHelper.INSTANCE.structureIncomplete());
            return;
        }
        int levels = accessor.getServerData().func_74762_e("Levels");
        tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.level"), String.valueOf(levels)));
        int primary = accessor.getServerData().func_74762_e("Primary");
        if (primary > 0) {
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.primary"), StatCollector.func_74838_a((String)Potion.field_76425_a[primary].func_76393_a())));
        }
        if ((secondary = accessor.getServerData().func_74762_e("Secondary")) > 0) {
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.secondary"), StatCollector.func_74838_a((String)Potion.field_76425_a[secondary].func_76393_a())));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.BEACON;
    }

    @Override
    public void appendServerData(NBTTagCompound data, BlockAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileEntityBeacon) {
            TileEntityBeacon beacon = (TileEntityBeacon)tileEntity;
            data.func_74757_a("Formed", beacon.func_146002_i() > 0.0f);
            data.func_74768_a("Levels", beacon.func_145998_l());
            data.func_74768_a("Primary", beacon.func_146007_j());
            data.func_74768_a("Secondary", beacon.func_146006_k());
        }
    }
}

