/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability.proxy;

import com.gtnewhorizons.wdmla.api.Mods;
import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestLevel;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.plugin.harvestability.BaseHarvestLogicHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.DualHarvestTool;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.util.HarvestLevels;
import tconstruct.tools.TinkerTools;

public class ProxyTinkersConstruct {
    private static Method getHarvestType = null;
    private static Method getSecondHarvestType = null;
    public static final List<ItemStack> defaultPickaxes = new ArrayList<ItemStack>();
    public static EffectiveTool pickaxe;

    public static void init() {
        try {
            getHarvestType = HarvestTool.class.getDeclaredMethod("getHarvestType", new Class[0]);
            getSecondHarvestType = DualHarvestTool.class.getDeclaredMethod("getSecondHarvestType", new Class[0]);
            getHarvestType.setAccessible(true);
            getSecondHarvestType.setAccessible(true);
            Iterator iterator = TConstructRegistry.toolMaterials.keySet().iterator();
            while (iterator.hasNext()) {
                int materialID = (Integer)iterator.next();
                defaultPickaxes.add(ProxyTinkersConstruct.buildDefaultPickaxe(materialID));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProxyTinkersConstruct.initPickaxeTool();
    }

    public static void initPickaxeTool() {
        PluginsConfig.Harvestability.TinkersConstruct tiCConfig = PluginsConfig.harvestability.tinkersConstruct;
        pickaxe = new EffectiveTool("pickaxe", Arrays.asList(defaultPickaxes.get(tiCConfig.harvestLevel0), defaultPickaxes.get(tiCConfig.harvestLevel1), defaultPickaxes.get(tiCConfig.harvestLevel2), defaultPickaxes.get(tiCConfig.harvestLevel3), defaultPickaxes.get(tiCConfig.harvestLevel4), defaultPickaxes.get(tiCConfig.harvestLevel5)));
    }

    public static boolean hasToolTag(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("InfiTool");
    }

    public static NBTTagCompound getToolTag(ItemStack tool) {
        NBTTagCompound tag = null;
        if (tool.func_77942_o()) {
            tag = tool.func_77978_p().func_74775_l("InfiTool");
        }
        return tag;
    }

    public static HarvestLevel getPrimaryHarvestLevel(NBTTagCompound toolTag) {
        return new HarvestLevel(toolTag.func_74762_e("HarvestLevel"));
    }

    public static HarvestLevel getSecondaryHarvestLevel(NBTTagCompound toolTag) {
        return new HarvestLevel(toolTag.func_74762_e("HarvestLevel2"));
    }

    public static boolean isToolEffectiveAgainst(ItemStack tool, Block block, int metadata, EffectiveTool effectiveTool) {
        Item item;
        if (Mods.TCONSTUCT.isLoaded() && (item = tool.func_77973_b()) instanceof HarvestTool) {
            HarvestTool harvestTool = (HarvestTool)item;
            EffectiveTool firstType = null;
            try {
                firstType = new EffectiveTool((String)getHarvestType.invoke((Object)harvestTool, new Object[0]), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            EffectiveTool secondType = null;
            if (harvestTool instanceof DualHarvestTool) {
                try {
                    secondType = new EffectiveTool((String)getSecondHarvestType.invoke((Object)harvestTool, new Object[0]), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return firstType != null && effectiveTool.isSameTool(firstType) || secondType != null && effectiveTool.isSameTool(secondType);
        }
        return BaseHarvestLogicHandler.isToolEffectiveAgainst(tool, block, metadata, effectiveTool);
    }

    public static boolean canToolHarvestLevel(ItemStack tool, Block block, int metadata, HarvestLevel harvestLevel) {
        boolean canTinkersToolHarvestBlock = false;
        NBTTagCompound toolTag = ProxyTinkersConstruct.getToolTag(tool);
        if (toolTag != null) {
            canTinkersToolHarvestBlock = ProxyTinkersConstruct.getPrimaryHarvestLevel(toolTag).doesSatisfy(harvestLevel) || ProxyTinkersConstruct.getSecondaryHarvestLevel(toolTag).doesSatisfy(harvestLevel);
        }
        return canTinkersToolHarvestBlock || ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)tool);
    }

    public static ItemStack buildDefaultPickaxe(int materialID) {
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.pickaxeHead, 1, materialID), new ItemStack(TinkerTools.toolRod, 1, 0), new ItemStack(TinkerTools.binding, 1, materialID), null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
        }
        return tool;
    }

    public static class TiCHarvestLevel
    extends HarvestLevel {
        public TiCHarvestLevel(HarvestLevel vanillaLevel) {
            super(vanillaLevel);
        }

        @Override
        public String getName() {
            return HarvestLevels.getHarvestLevelName((int)this.value);
        }
    }
}

