/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfoImpl;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityTestPhase;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.ObjectDataCenter;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ItemComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.plugin.harvestability.BlockHelper;
import com.gtnewhorizons.wdmla.plugin.harvestability.HarvestabilityIdentifiers;
import com.gtnewhorizons.wdmla.plugin.harvestability.proxy.ProxyCreativeBlocks;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HarvestToolProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public ResourceLocation getUid() {
        return HarvestabilityIdentifiers.HARVESTABILITY;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    @Override
    public boolean isPriorityFixed() {
        return true;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        if (General.forceLegacy) {
            tooltip.text("The legacy harvestability support").text("will come back in the next version!");
            return;
        }
        if (ProxyCreativeBlocks.isCreativeBlock(accessor.getBlock(), accessor.getMetadata())) {
            ObjectDataCenter.setHarvestabilityInfo(null);
            return;
        }
        List<HarvestHandler> handlers = WDMlaClientRegistration.instance().getHarvestHandlers(accessor.getBlock(), interactionHandler -> true);
        Block effectiveBlock = handlers.stream().map(handler -> handler.getEffectiveBlock(accessor.getPlayer(), accessor.getBlock(), accessor.getItemForm(), accessor.getMetadata(), accessor.getHitResult())).filter(Objects::nonNull).findFirst().orElse(accessor.getBlock());
        int effectiveMeta = handlers.stream().map(handler -> handler.getEffectiveMeta(accessor.getPlayer(), accessor.getBlock(), accessor.getItemForm(), accessor.getMetadata(), accessor.getHitResult())).filter(Objects::nonNull).findFirst().orElse(accessor.getMetadata());
        HarvestabilityInfo info = this.getHarvestability(accessor.getPlayer(), effectiveBlock, effectiveMeta, accessor.getHitResult(), handlers);
        ObjectDataCenter.setHarvestabilityInfo(info);
        if (PluginsConfig.harvestability.condition.oresOnly && !BlockHelper.isBlockAnOre(effectiveBlock, effectiveMeta)) {
            return;
        }
        if (PluginsConfig.harvestability.condition.unHarvestableOnly && info.isCurrentlyHarvestable() || PluginsConfig.harvestability.condition.toolRequiredOnly && !info.getEffectiveTool().isValid()) {
            return;
        }
        IComponent itemNameRow = tooltip.getChildWithTag(Identifiers.TARGET_NAME_ROW);
        if (!(itemNameRow instanceof ITooltip)) {
            return;
        }
        ITooltip harvestabilityIcon = HarvestToolProvider.assembleHarvestabilityIcon(info);
        IComponent harvestabilityText = null;
        if (!PluginsConfig.harvestability.condition.textDetailsOnly || accessor.showDetails()) {
            harvestabilityText = HarvestToolProvider.assembleHarvestabilityText(info);
        }
        ((ITooltip)itemNameRow).child(harvestabilityIcon);
        if (harvestabilityText != null) {
            tooltip.child(harvestabilityText);
        }
    }

    public HarvestabilityInfo getHarvestability(EntityPlayer player, Block block, int meta, MovingObjectPosition position, List<HarvestHandler> handlers) {
        HarvestabilityInfoImpl info;
        if (meta >= 16) {
            meta = 0;
        }
        if (!HarvestToolProvider.fireHarvestTest(HarvestabilityTestPhase.EFFECTIVE_TOOL_NAME, player, block, meta, position, handlers, info = new HarvestabilityInfoImpl())) {
            return info;
        }
        if (!HarvestToolProvider.fireHarvestTest(HarvestabilityTestPhase.HARVEST_LEVEL, player, block, meta, position, handlers, info)) {
            return info;
        }
        if (!HarvestToolProvider.fireHarvestTest(HarvestabilityTestPhase.ADDITIONAL_TOOLS_ICON, player, block, meta, position, handlers, info)) {
            return info;
        }
        if (!HarvestToolProvider.fireHarvestTest(HarvestabilityTestPhase.CURRENTLY_HARVESTABLE, player, block, meta, position, handlers, info)) {
            return info;
        }
        HarvestToolProvider.fireHarvestTest(HarvestabilityTestPhase.IS_HELD_TOOL_EFFECTIVE, player, block, meta, position, handlers, info);
        return info;
    }

    private static boolean fireHarvestTest(HarvestabilityTestPhase phase, EntityPlayer player, Block block, int meta, MovingObjectPosition position, List<HarvestHandler> handlers, HarvestabilityInfo info) {
        for (HarvestHandler handler : handlers) {
            if (handler.testHarvest(info, phase, player, block, meta, position)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static ITooltip assembleHarvestabilityIcon(HarvestabilityInfo info) {
        ITooltip harvestabilityComponent = new HPanelComponent().tag(HarvestabilityIdentifiers.HARVESTABILITY_ICON);
        if (!PluginsConfig.harvestability.icon.currentlyHarvestableIcon) {
            return harvestabilityComponent;
        }
        IComponent currentlyHarvestableIcon = info.isCurrentlyHarvestable() ? (!PluginsConfig.harvestability.icon.colorIconWithEffectiveness || info.isHeldToolEffective() || !info.getEffectiveTool().isValid() ? ThemeHelper.INSTANCE.success(PluginsConfig.harvestability.icon.currentlyHarvestableString) : ThemeHelper.INSTANCE.info(PluginsConfig.harvestability.icon.currentlyHarvestableString)) : ThemeHelper.INSTANCE.failure(PluginsConfig.harvestability.icon.notCurrentlyHarvestableString);
        ItemStack effectiveToolIcon = info.getEffectiveTool().getIcon(info.getHarvestLevel());
        if (effectiveToolIcon != null) {
            TooltipComponent effectiveToolIconComponent = new ItemComponent(effectiveToolIcon).doDrawOverlay(false).size(new Size(10, 10));
            if (PluginsConfig.harvestability.icon.effectiveToolIcon) {
                effectiveToolIconComponent.child(new HPanelComponent().padding(new Padding().left(5).top(6)).child(currentlyHarvestableIcon));
                harvestabilityComponent.child(effectiveToolIconComponent);
            } else {
                harvestabilityComponent.child(currentlyHarvestableIcon);
            }
        } else {
            harvestabilityComponent.child(currentlyHarvestableIcon);
        }
        for (HarvestabilityInfo.AdditionalToolInfo additionalTool : info.getAdditionalToolsInfo()) {
            if (!additionalTool.isHolding && !PluginsConfig.harvestability.icon.alwaysShowAdditionalTools) continue;
            harvestabilityComponent.child(new ItemComponent(additionalTool.icon).doDrawOverlay(false).size(new Size(10, 10)));
        }
        return harvestabilityComponent;
    }

    @Nullable
    private static IComponent assembleHarvestabilityText(HarvestabilityInfo info) {
        VPanelComponent lines = new VPanelComponent();
        if (info.getHarvestLevel().isToolRequired() && (PluginsConfig.harvestability.text.harvestLevelNum || PluginsConfig.harvestability.text.harvestLevelName)) {
            String harvestLevelString = PluginsConfig.harvestability.text.harvestLevelName ? DisplayUtil.stripSymbols(info.getHarvestLevel().getName()) : String.valueOf(info.getHarvestLevel().getDisplayNum());
            ITooltip harvestLevelText = new HPanelComponent().tag(HarvestabilityIdentifiers.HARVESTABILITY_TEXT).text(String.format("%s: ", StatCollector.func_74838_a((String)"hud.msg.wdmla.harvestlevel"))).child(info.isCurrentlyHarvestable() ? ThemeHelper.INSTANCE.success(harvestLevelString) : ThemeHelper.INSTANCE.failure(harvestLevelString));
            lines.child(harvestLevelText);
        }
        if (PluginsConfig.harvestability.text.effectiveToolLine && info.getEffectiveTool().isValid()) {
            HPanelComponent effectiveToolPanel = new HPanelComponent();
            effectiveToolPanel.text(StatCollector.func_74838_a((String)"hud.msg.wdmla.effectivetool") + ": ");
            if (info.isHeldToolEffective()) {
                effectiveToolPanel.child(ThemeHelper.INSTANCE.success(info.getEffectiveTool().getLocalizedName()));
            } else {
                effectiveToolPanel.child(ThemeHelper.INSTANCE.failure(info.getEffectiveTool().getLocalizedName()));
            }
            lines.child(effectiveToolPanel);
        }
        if (PluginsConfig.harvestability.text.currentlyHarvestableLine) {
            String icon;
            HPanelComponent currentlyHarvestable = new HPanelComponent();
            if (info.isCurrentlyHarvestable()) {
                icon = PluginsConfig.harvestability.icon.currentlyHarvestableString;
                currentlyHarvestable.child(ThemeHelper.INSTANCE.success(icon));
            } else {
                icon = PluginsConfig.harvestability.icon.notCurrentlyHarvestableString;
                currentlyHarvestable.child(ThemeHelper.INSTANCE.failure(icon));
            }
            String suffix = StatCollector.func_74838_a((String)"hud.msg.wdmla.currentlyharvestable");
            lines.child(currentlyHarvestable.text(suffix));
        }
        return lines.childrenSize() > 0 ? lines : null;
    }
}

