/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.core;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.Theme;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.MessageType;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.BlockComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ItemComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.style.TextStyle;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import com.gtnewhorizons.wdmla.wailacompat.RayTracingCompat;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public enum DefaultBlockInfoProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public ResourceLocation getUid() {
        return Identifiers.DEFAULT_BLOCK;
    }

    @Override
    public int getDefaultPriority() {
        return -10000;
    }

    @Override
    public void appendTooltip(final ITooltip tooltip, BlockAccessor accessor) {
        ItemStack itemStack;
        ItemStack overrideStack = RayTracingCompat.INSTANCE.getWailaStack(accessor.getHitResult());
        final ITooltip row = tooltip.horizontal();
        ItemStack itemStack2 = itemStack = overrideStack != null ? overrideStack : accessor.getItemForm();
        if (PluginsConfig.core.defaultBlock.showIcon) {
            if (PluginsConfig.core.defaultBlock.fancyRenderer == PluginsConfig.Core.fancyRendererMode.ALL || PluginsConfig.core.defaultBlock.fancyRenderer == PluginsConfig.Core.fancyRendererMode.FALLBACK && itemStack.func_77973_b() == null) {
                row.child(new BlockComponent(accessor.getHitResult().field_72311_b, accessor.getHitResult().field_72312_c, accessor.getHitResult().field_72309_d).tag(Identifiers.ITEM_ICON));
            } else {
                row.child(new ItemComponent(itemStack).doDrawOverlay(false).tag(Identifiers.ITEM_ICON));
            }
        }
        ITooltip row_vertical = row.vertical();
        if (PluginsConfig.core.defaultBlock.showBlockName) {
            String itemName;
            if (accessor.getServerData().func_74764_b("CustomName")) {
                String rawName = accessor.getServerData().func_74779_i("CustomName");
                itemName = EnumChatFormatting.ITALIC + FormatUtil.formatNameByPixelCount(rawName);
            } else {
                itemName = DisplayUtil.itemDisplayNameShortFormatted(itemStack);
            }
            final ITooltip title = row_vertical.horizontal();
            IComponent nameComponent = ThemeHelper.INSTANCE.title(itemName).tag(Identifiers.ITEM_NAME);
            title.child(nameComponent).child(new HPanelComponent(){

                @Override
                public void tick(float x, float y) {
                    if (General.alignIconRightTop) {
                        IComponent icon = row.getChildWithTag(Identifiers.ITEM_ICON);
                        IComponent name = title.getChildWithTag(Identifiers.ITEM_NAME);
                        x += Math.max(tooltip.getWidth() - (icon != null ? icon.getWidth() : 0.0f) - (name != null ? name.getWidth() : 0.0f) - this.getWidth() - General.currentTheme.get().panelStyle.getSpacing() * 2.0f, 0.0f);
                    }
                    super.tick(x, y);
                }
            }.tag(Identifiers.TARGET_NAME_ROW));
        }
        String modName = ModIdentification.nameFromStack(itemStack);
        if (PluginsConfig.core.defaultBlock.showModName) {
            Theme theme = General.currentTheme.get();
            if (modName != null) {
                row_vertical.child(new TextComponent(SpecialChars.ITALIC + modName).style(new TextStyle().color(theme.textColor(MessageType.MOD_NAME))).tag(Identifiers.MOD_NAME));
            } else {
                row_vertical.child(new TextComponent("").style(new TextStyle().color(theme.textColor(MessageType.MOD_NAME))).tag(Identifiers.MOD_NAME));
            }
        }
    }

    @Override
    public boolean isPriorityFixed() {
        return true;
    }
}

