/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.value;

import com.gtnewhorizons.wdmla.config.General;

public class Alpha {
    private final float value;
    private static long initMilliSecond;

    public Alpha(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be between 0 and 1");
        }
        initMilliSecond = System.currentTimeMillis();
        this.value = value;
    }

    public Alpha fade() {
        float elapsedSecond = (float)(System.currentTimeMillis() - initMilliSecond) / 1000.0f;
        float fadedAlpha = this.value - elapsedSecond * (float)General.breakProgress.fadeSpeed;
        if (fadedAlpha < 0.0f || !General.breakProgress.fadeAnimation) {
            fadedAlpha = 0.0f;
        }
        return new Alpha(fadedAlpha);
    }

    public boolean isTransparent() {
        return this.value <= 0.0f;
    }

    public int apply(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int appliedAlpha = (int)(this.value * 255.0f);
        return appliedAlpha << 24 | red << 16 | green << 8 | blue;
    }
}

