/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.style.IProgressStyle;
import com.gtnewhorizons.wdmla.api.ui.style.IRectStyle;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.drawable.ProgressDrawable;
import com.gtnewhorizons.wdmla.impl.ui.drawable.RectDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import com.gtnewhorizons.wdmla.impl.ui.value.FilledProgress;
import java.util.ArrayList;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import org.jetbrains.annotations.NotNull;

public class ProgressComponent
extends TooltipComponent {
    public static final int MINIMAL_W = 125;
    public static final int MINIMAL_H = 8;
    private final RectDrawable rectDrawable;
    private IRectStyle rectStyle;

    public ProgressComponent(float ratio) {
        this(Math.round(ratio * 1000.0f), 1000L);
    }

    public ProgressComponent(long current, long max) {
        super(new ArrayList<IComponent>(), new Padding(), new Size(125, 8), new ProgressDrawable(new FilledProgress(current, max)));
        this.rectStyle = new RectStyle().backgroundColor(General.progressColor.background).borderColor(General.progressColor.border);
        this.rectDrawable = new RectDrawable().style(this.rectStyle);
    }

    public ProgressComponent style(IProgressStyle style) {
        ((ProgressDrawable)this.foreground).style(style);
        return this;
    }

    public ProgressComponent rectStyle(IRectStyle style) {
        this.rectStyle = style;
        this.rectDrawable.style(style);
        return this;
    }

    @Override
    public void tick(float x, float y) {
        this.rectDrawable.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), this.size.getW(), this.size.getH()));
        float thickness = this.rectStyle.getBorderThickness();
        this.foreground.draw(new Area(x + this.padding.getLeft() + thickness, y + this.padding.getTop() + thickness, this.size.getW() - thickness * 2.0f, this.size.getH() - thickness * 2.0f));
        if (!this.children.isEmpty()) {
            ((IComponent)this.children.get(0)).tick(x + this.padding.getLeft() + thickness, y + this.padding.getTop() + thickness);
        }
    }

    @Override
    public ITooltip child(@NotNull IComponent child) {
        if (this.children.isEmpty()) {
            this.children.add(child);
        } else {
            WailaExceptionHandler.handleErr(new IllegalArgumentException("ProgressComponent only accepts one child! Consider appending PanelComponent if you want multiple."), this.getClass().getName(), null);
        }
        float width = Math.max(this.size.getW(), ((IComponent)this.children.get(0)).getWidth() + this.rectStyle.getBorderThickness() * 2.0f);
        float height = Math.max(this.size.getH(), ((IComponent)this.children.get(0)).getHeight() + this.rectStyle.getBorderThickness() * 2.0f);
        this.size(new Size(width, height));
        return this;
    }
}

